/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.kubernetes.helm.ChartsRenameHandler;
import com.intellij.kubernetes.helm.HelmUtilKt;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.model.ChartPointingObject;
import com.intellij.kubernetes.helm.model.HelmObject;
import com.intellij.kubernetes.helm.model.HelmResolveTarget;
import com.intellij.kubernetes.helm.model.HelmResolveTargetKt;
import com.intellij.kubernetes.helm.model.HelmResolver;
import com.intellij.kubernetes.helm.model.HelmResolverKt;
import com.intellij.kubernetes.helm.model.PathInChart;
import com.intellij.kubernetes.helm.references.HelmValueReference;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J/\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0096\u0002J0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00122\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0096\u0002\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0017\u001a\u0004\u0018\u00010\b*\u00020\u0006H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/kubernetes/helm/ChartsRenameHandler;", "Lcom/intellij/refactoring/rename/RenameHandler;", "()V", "getHelmValueReference", "Lcom/intellij/kubernetes/helm/references/HelmValueReference;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getResolveTargetFromElement", "Lcom/intellij/kubernetes/helm/model/HelmResolveTarget;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "isAvailableOnDataContext", "", "getResolveTarget", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nChartsRenameHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChartsRenameHandler.kt\ncom/intellij/kubernetes/helm/ChartsRenameHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 MiscUtil.kt\ncom/intellij/kubernetes/MiscUtilKt\n*L\n1#1,192:1\n1#2:193\n1#2:215\n800#3,11:194\n1360#3:205\n1446#3,5:206\n766#3:211\n857#3,2:212\n137#4:214\n*S KotlinDebug\n*F\n+ 1 ChartsRenameHandler.kt\ncom/intellij/kubernetes/helm/ChartsRenameHandler\n*L\n182#1:215\n72#1:194,11\n75#1:205\n75#1:206,5\n76#1:211\n76#1:212,2\n182#1:214\n*E\n"})
public final class ChartsRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Object object = this.getResolveTarget(dataContext);
        return object != null && (object = HelmResolveTargetKt.toPathsInChart((HelmResolveTarget)object)) != null && (object = (PathInChart)CollectionsKt.first((Iterable)((Iterable)object))) != null && (object = HelmResolverKt.resolveClosestObjects((PathInChart)object)) != null && (object = (HelmObject)CollectionsKt.firstOrNull((Iterable)((Iterable)object))) != null ? object.isRenameable() : false;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project2, @Nullable Editor editor, @Nullable PsiFile file2, @Nullable DataContext dataContext) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        HelmObject it;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        void $this$filterIsInstanceTo$iv$iv;
        HelmObject helmObject;
        Object resolveTarget;
        block10: {
            block9: {
                HelmObject helmObject2;
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Object object = dataContext;
                if (object == null || (object = this.getResolveTarget((DataContext)object)) == null) {
                    return;
                }
                resolveTarget = object;
                helmObject = (HelmObject)CollectionsKt.firstOrNull((Iterable)HelmResolverKt.resolveClosestObjects((PathInChart)CollectionsKt.first((Iterable)HelmResolveTargetKt.toPathsInChart((HelmResolveTarget)resolveTarget))));
                if (helmObject == null) break block9;
                HelmObject it2 = helmObject2 = helmObject;
                boolean bl = false;
                helmObject = it2.isRenameable() ? helmObject2 : null;
                if (helmObject != null) break block10;
            }
            return;
        }
        HelmObject modelObject = helmObject;
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull((Iterable)modelObject.getDefinitionElements());
        if (psiElement == null && (psiElement = (PsiElement)CollectionsKt.firstOrNull((Iterable)modelObject.getDeclarationElements())) == null) {
            return;
        }
        PsiElement mainElement = psiElement;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        GlobalSearchScope searchScope = globalSearchScope;
        Ref.ObjectRef hasUsages = new Ref.ObjectRef();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ChartsRenameHandler.invoke$lambda$1(hasUsages, (HelmResolveTarget)resolveTarget, searchScope), KubernetesBundle.message("ChartRenameHandler.preliminary.finding.usage.process.name", new Object[0]), true, project2)) {
            return;
        }
        Collection<HelmObject> allObjects = HelmResolverKt.resolveThisNamedObjectsInAllCharts((HelmResolveTarget)resolveTarget, true);
        Iterable $this$filterIsInstance$iv = allObjects;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ChartPointingObject)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ChartPointingObject chartPointingObject = (ChartPointingObject)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        Chart chartToRename = chartPointingObject != null ? chartPointingObject.getChart() : null;
        $this$filterIsInstance$iv = allObjects;
        boolean $i$f$flatMap = false;
        $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (HelmObject)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = CollectionsKt.plus((Collection)CollectionsKt.plus(it.getDefinitionElements(), (Iterable)it.getDeclarationElements()), (Iterable)it.getSecondaryElements());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PsiElement)element$iv$iv;
            boolean bl = false;
            if (!(!it.isEquivalentTo(mainElement))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List secondaryElements2 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        RenameDialog dialog2 = new RenameDialog(project2, mainElement, editor, (Ref.ObjectRef<Boolean>)hasUsages, chartToRename, secondaryElements2, modelObject, (HelmResolveTarget)resolveTarget, searchScope){
            final /* synthetic */ Project $project;
            final /* synthetic */ PsiElement $mainElement;
            final /* synthetic */ Ref.ObjectRef<Boolean> $hasUsages;
            final /* synthetic */ Chart $chartToRename;
            final /* synthetic */ List<PsiElement> $secondaryElements;
            final /* synthetic */ HelmObject $modelObject;
            final /* synthetic */ HelmResolveTarget $resolveTarget;
            final /* synthetic */ GlobalSearchScope $searchScope;
            {
                this.$project = $project;
                this.$mainElement = $mainElement;
                this.$hasUsages = $hasUsages;
                this.$chartToRename = $chartToRename;
                this.$secondaryElements = $secondaryElements;
                this.$modelObject = $modelObject;
                this.$resolveTarget = $resolveTarget;
                this.$searchScope = $searchScope;
                super($project, $mainElement, null, $editor);
            }

            protected void canRun() {
                super.canRun();
                String string = this.getNewName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNewName(...)");
                if (!Chart.Companion.isChartNameValid(string)) {
                    throw new ConfigurationException(KubernetesBundle.message("ChartRenameHandler.illegal.char.in.value", new Object[0]));
                }
                Object object = this.$hasUsages.element;
                Intrinsics.checkNotNull((Object)object);
                if (((Boolean)object).booleanValue()) {
                    String string2 = this.getNewName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNewName(...)");
                    if (!HelmUtilKt.isValidGoTemplateIdentifier(string2)) {
                        throw new ConfigurationException(KubernetesBundle.message("ChartRenameHandler.invalid.go.template.identifier", new Object[0]));
                    }
                }
                if (ChartsRenameHandler.access$invoke$isDirAlsoToRename(this.$secondaryElements)) {
                    VirtualFile parentDir;
                    Chart chart2 = this.$chartToRename;
                    Intrinsics.checkNotNull((Object)chart2);
                    VirtualFile virtualFile = parentDir = chart2.getBaseDir().getParent();
                    if ((virtualFile != null ? virtualFile.findChild(this.getNewName()) : null) != null) {
                        Object[] objectArray = new Object[]{parentDir.getPath()};
                        throw new ConfigurationException(KubernetesBundle.message("ChartRenameHandler.file.already.exists", objectArray));
                    }
                }
            }

            @NotNull
            protected String getLabelText() {
                String string;
                if (this.$modelObject instanceof ChartPointingObject) {
                    Object[] objectArray = new Object[]{this.$modelObject.getName()};
                    String string2 = KubernetesBundle.message("ChartRenameHandler.label.text.3", objectArray);
                    Intrinsics.checkNotNull((Object)string2);
                    string = string2;
                } else {
                    Object[] objectArray = new Object[]{this.$modelObject.getName()};
                    String string3 = KubernetesBundle.message("ChartRenameHandler.label.text.1", objectArray);
                    Intrinsics.checkNotNull((Object)string3);
                    string = string3;
                }
                return string;
            }

            protected void createCheckboxes(@Nullable JPanel panel2, @Nullable GridBagConstraints gbConstraints) {
                super.createCheckboxes(panel2, gbConstraints);
                this.getCbSearchInComments().setVisible(false);
            }

            protected boolean isToSearchForTextOccurrencesForRename() {
                return false;
            }

            protected boolean isToSearchInCommentsForRename() {
                return false;
            }

            public void performRename(@NotNull String newName) {
                Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
                this.invokeRefactoring(new BaseRefactoringProcessor(this.$modelObject, this.$project, this.$mainElement, this.$secondaryElements, this.$resolveTarget, this.$searchScope, newName){
                    @NotNull
                    private final String headerText;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ PsiElement $mainElement;
                    final /* synthetic */ List<PsiElement> $secondaryElements;
                    final /* synthetic */ HelmResolveTarget $resolveTarget;
                    final /* synthetic */ GlobalSearchScope $searchScope;
                    final /* synthetic */ String $newName;
                    {
                        this.$project = $project;
                        this.$mainElement = $mainElement;
                        this.$secondaryElements = $secondaryElements;
                        this.$resolveTarget = $resolveTarget;
                        this.$searchScope = $searchScope;
                        this.$newName = $newName;
                        super($project);
                        String string = $modelObject instanceof ChartPointingObject ? KubernetesBundle.message("ChartRenameHandler.processed.elements.header.2", new Object[0]) : KubernetesBundle.message("ChartRenameHandler.processed.elements.header.1", new Object[0]);
                        Intrinsics.checkNotNull((Object)string);
                        this.headerText = string;
                    }

                    @NotNull
                    public final String getHeaderText() {
                        return this.headerText;
                    }

                    @NotNull
                    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
                        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
                        return new UsageViewDescriptor(this.$mainElement, this.$secondaryElements, this){
                            final /* synthetic */ PsiElement $mainElement;
                            final /* synthetic */ List<PsiElement> $secondaryElements;
                            final /* synthetic */ invoke.dialog.performRename.1 this$0;
                            {
                                this.$mainElement = $mainElement;
                                this.$secondaryElements = $secondaryElements;
                                this.this$0 = $receiver;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @NotNull
                            public PsiElement[] getElements() {
                                PsiElement psiElement;
                                void condition$iv;
                                boolean bl = !(this.$mainElement instanceof PomTargetPsiElement) || this.$secondaryElements.isEmpty();
                                PsiElement psiElement2 = this.$mainElement;
                                boolean $i$f$doIf = false;
                                if (condition$iv == true) {
                                    boolean bl2 = false;
                                    psiElement = psiElement2;
                                } else {
                                    psiElement = null;
                                }
                                Collection $this$toTypedArray$iv = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(psiElement), (Iterable)this.$secondaryElements);
                                boolean $i$f$toTypedArray = false;
                                Collection thisCollection$iv = $this$toTypedArray$iv;
                                return thisCollection$iv.toArray(new PsiElement[0]);
                            }

                            @NotNull
                            public String getProcessedElementsHeader() {
                                return this.this$0.getHeaderText();
                            }

                            @NotNull
                            public String getCodeReferencesText(int usagesCount, int filesCount) {
                                Object[] objectArray = new Object[]{usagesCount, filesCount};
                                String string = KubernetesBundle.message("ChartRenameHandler.code.references.text", objectArray);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                return string;
                            }
                        };
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    protected UsageInfo[] findUsages() {
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv = HelmResolverKt.findUsages$default(this.$resolveTarget, (SearchScope)this.$searchScope, true, false, 4, null);
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            PsiElement psiElement = (PsiElement)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(new UsageInfo((PsiElement)it, false));
                        }
                        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        return thisCollection$iv.toArray(new UsageInfo[0]);
                    }

                    protected void performRefactoring(@NotNull UsageInfo[] usages) {
                        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
                        HelmResolver resolver = HelmResolver.Companion.getInstance(this.$project);
                        WriteCommandAction.runWriteCommandAction((Project)this.$project, (String)this.headerText, null, () -> invoke.dialog.performRename.1.performRefactoring$lambda$2(usages, resolver, this.$newName, this.$project, this.$mainElement, this.$secondaryElements), (PsiFile[])new PsiFile[0]);
                    }

                    @NotNull
                    protected String getCommandName() {
                        String string = KubernetesBundle.message("ChartRenameHandler.command.name", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        return string;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    private static final void performRefactoring$lambda$2(UsageInfo[] $usages, HelmResolver $resolver, String $newName, Project $project, PsiElement $mainElement, List $secondaryElements) {
                        void $this$mapNotNullTo$iv$iv;
                        Intrinsics.checkNotNullParameter((Object)$usages, (String)"$usages");
                        Intrinsics.checkNotNullParameter((Object)$resolver, (String)"$resolver");
                        Intrinsics.checkNotNullParameter((Object)$newName, (String)"$newName");
                        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                        Intrinsics.checkNotNullParameter((Object)$mainElement, (String)"$mainElement");
                        Intrinsics.checkNotNullParameter((Object)$secondaryElements, (String)"$secondaryElements");
                        UsageInfo[] $this$mapNotNull$iv = $usages;
                        boolean $i$f$mapNotNull = false;
                        UsageInfo[] usageInfoArray = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        int n = ((void)$this$forEach$iv$iv$iv).length;
                        for (int i = 0; i < n; ++i) {
                            PsiElement it$iv$iv;
                            void element$iv$iv$iv;
                            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                            boolean bl = false;
                            void it = element$iv$iv;
                            boolean bl2 = false;
                            if (it.getElement() == null) continue;
                            boolean bl3 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        for (PsiElement element : (List)destination$iv$iv) {
                            Intrinsics.checkNotNull((Object)element);
                            $resolver.renameUsage$intellij_clouds_kubernetes(element, $newName);
                        }
                        YAMLKeyValue yAMLKeyValue = YAMLElementGenerator.getInstance((Project)$project).createYamlKeyValue($newName, $newName);
                        Intrinsics.checkNotNullExpressionValue((Object)yAMLKeyValue, (String)"createYamlKeyValue(...)");
                        YAMLKeyValue newKeyVal = yAMLKeyValue;
                        for (PsiElement it : CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)$mainElement), (Iterable)$secondaryElements)) {
                            if (it instanceof PsiNamedElement) {
                                ((PsiNamedElement)it).setName($newName);
                                continue;
                            }
                            if (!(it instanceof YAMLValue)) continue;
                            YAMLValue yAMLValue = newKeyVal.getValue();
                            Intrinsics.checkNotNull((Object)yAMLValue);
                            it.replace((PsiElement)yAMLValue);
                        }
                    }
                });
                this.close(0);
            }
        };
        RenameDialog.showRenameDialog((DataContext)dataContext, (RenameDialog)dialog2);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        String string = "not implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    private final HelmResolveTarget getResolveTarget(DataContext $this$getResolveTarget) {
        Object object = this.getHelmValueReference($this$getResolveTarget);
        if (object == null || (object = object.getResolveTarget()) == null) {
            object = this.getResolveTargetFromElement($this$getResolveTarget);
        }
        return object;
    }

    private final HelmValueReference getHelmValueReference(DataContext dataContext) {
        HelmValueReference helmValueReference;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        PsiReference ref = TargetElementUtil.findReference((Editor)editor2);
        if (ref instanceof PsiMultiReference) {
            Object object;
            Object object2;
            block5: {
                PsiReference[] psiReferenceArray = ((PsiMultiReference)ref).getReferences();
                Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
                Object[] $this$findInstanceOf$iv = psiReferenceArray;
                boolean $i$f$findInstanceOf = false;
                Object[] objectArray = $this$findInstanceOf$iv;
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object object3;
                    Object it$iv = object3 = objectArray[i];
                    boolean bl = false;
                    if (!(it$iv instanceof HelmValueReference)) continue;
                    object2 = object3;
                    break block5;
                }
                object2 = object = null;
            }
            if (!(object2 instanceof HelmValueReference)) {
                object = null;
            }
            helmValueReference = (HelmValueReference)object;
        } else {
            helmValueReference = ref instanceof HelmValueReference ? (HelmValueReference)ref : null;
        }
        return helmValueReference;
    }

    private final HelmResolveTarget getResolveTargetFromElement(DataContext dataContext) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        PsiElement psiElement = TargetElementUtil.findTargetElement((Editor)editor2, (int)2);
        YAMLKeyValue yAMLKeyValue = psiElement instanceof YAMLKeyValue ? (YAMLKeyValue)psiElement : null;
        if (yAMLKeyValue == null) {
            return null;
        }
        YAMLKeyValue element = yAMLKeyValue;
        Project project2 = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        PathInChart pathInChart = HelmResolver.Companion.getInstance(project2).getPathInChartByDefinitionElement((PsiElement)element);
        return pathInChart != null ? HelmResolverKt.resolveTarget(pathInChart) : null;
    }

    private static final void invoke$lambda$1(Ref.ObjectRef $hasUsages, HelmResolveTarget $resolveTarget, GlobalSearchScope $searchScope) {
        Intrinsics.checkNotNullParameter((Object)$hasUsages, (String)"$hasUsages");
        Intrinsics.checkNotNullParameter((Object)$resolveTarget, (String)"$resolveTarget");
        Intrinsics.checkNotNullParameter((Object)$searchScope, (String)"$searchScope");
        $hasUsages.element = ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>($resolveTarget, $searchScope){
            final /* synthetic */ HelmResolveTarget $resolveTarget;
            final /* synthetic */ GlobalSearchScope $searchScope;
            {
                this.$resolveTarget = $resolveTarget;
                this.$searchScope = $searchScope;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return !((Collection)HelmResolverKt.findUsages(this.$resolveTarget, (SearchScope)this.$searchScope, true, true)).isEmpty();
            }
        }));
    }

    private static final boolean invoke$isDirAlsoToRename(List<? extends PsiElement> secondaryElements2) {
        Object v0;
        block1: {
            Iterable iterable = secondaryElements2;
            for (Object t : iterable) {
                PsiElement it = (PsiElement)t;
                boolean bl = false;
                if (!(it instanceof PsiDirectory)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    public static final /* synthetic */ boolean access$invoke$isDirAlsoToRename(List secondaryElements2) {
        return ChartsRenameHandler.invoke$isDirAlsoToRename(secondaryElements2);
    }
}

