/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.config;

import com.intellij.kubernetes.MiscUtilKt;
import com.intellij.kubernetes.config.ConfigScope;
import com.intellij.kubernetes.config.KubernetesIdeSettings;
import com.intellij.kubernetes.config.KubernetesOptions;
import com.intellij.kubernetes.config.KubernetesProjectOptions;
import com.intellij.kubernetes.config.KubernetesProjectSettings;
import com.intellij.kubernetes.config.KubernetesSettingsKt;
import com.intellij.kubernetes.config.SpecSource;
import com.intellij.kubernetes.config.SpecSourceItem;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u001a,\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"STATE_NAME", "", "readEffectiveCrdSpecPathsOrUrls", "", "project", "Lcom/intellij/openapi/project/Project;", "readEffectiveSpecSources", "Lcom/intellij/kubernetes/config/SpecSourceItem;", "saveSpecSources", "", "sourceCollection", "ideSettingsState", "Lcom/intellij/kubernetes/config/KubernetesOptions;", "projectSettingsState", "Lcom/intellij/kubernetes/config/KubernetesProjectOptions;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesSettings.kt\ncom/intellij/kubernetes/config/KubernetesSettingsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,214:1\n1549#2:215\n1620#2,3:216\n1549#2:219\n1620#2,3:220\n1155#3,3:223\n*S KotlinDebug\n*F\n+ 1 KubernetesSettings.kt\ncom/intellij/kubernetes/config/KubernetesSettingsKt\n*L\n126#1:215\n126#1:216,3\n133#1:219\n133#1:220,3\n155#1:223,3\n*E\n"})
public final class KubernetesSettingsKt {
    @NotNull
    private static final String STATE_NAME = "KubernetesSettings";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> readEffectiveCrdSpecPathsOrUrls(@NotNull Project project2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Iterable $this$map$iv = KubernetesSettingsKt.readEffectiveSpecSources(project2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SpecSourceItem specSourceItem = (SpecSourceItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getSpecSource().getPathOrUrl();
            Intrinsics.checkNotNull((Object)string);
            collection.add(string);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public static final List<SpecSourceItem> readEffectiveSpecSources(@NotNull Project project2) {
        SpecSource it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        List<SpecSource> ideSpecs = KubernetesIdeSettings.Companion.getInstance().getEffectiveCrdSpecSources();
        List<SpecSource> projectSpecs = KubernetesProjectSettings.Companion.getInstance(project2).getEffectiveCrdSpecSources();
        Iterable $this$map$iv = ideSpecs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SpecSource specSource = (SpecSource)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SpecSourceItem(it, ConfigScope.IDE));
        }
        $this$map$iv = projectSpecs;
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SpecSource)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(new SpecSourceItem(it, ConfigScope.PROJECT));
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    public static final void saveSpecSources(@NotNull Project project2, @NotNull List<SpecSourceItem> sourceCollection) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(sourceCollection, (String)"sourceCollection");
        KubernetesSettingsKt.saveSpecSources(project2, sourceCollection, (KubernetesOptions)KubernetesIdeSettings.Companion.getInstance().getState(), (KubernetesProjectOptions)KubernetesProjectSettings.Companion.getInstance(project2).getState());
    }

    public static final void saveSpecSources(@NotNull Project project2, @NotNull List<SpecSourceItem> sourceCollection, @NotNull KubernetesOptions ideSettingsState, @NotNull KubernetesProjectOptions projectSettingsState) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(sourceCollection, (String)"sourceCollection");
        Intrinsics.checkNotNullParameter((Object)((Object)ideSettingsState), (String)"ideSettingsState");
        Intrinsics.checkNotNullParameter((Object)((Object)projectSettingsState), (String)"projectSettingsState");
        KubernetesSettingsKt.saveSpecSources$save(ideSettingsState.getSpecSources(), sourceCollection, ConfigScope.IDE, null);
        KubernetesSettingsKt.saveSpecSources$save(projectSettingsState.getSpecSources(), sourceCollection, ConfigScope.PROJECT, project2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void saveSpecSources$save(List<SpecSource> specSources, List<SpecSourceItem> sources, ConfigScope configScope, Project project2) {
        void $this$mapTo$iv;
        specSources.clear();
        Sequence sequence2 = SequencesKt.distinctBy((Sequence)SequencesKt.filter((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)sources), (Function1)saveSpecSources.save.1.INSTANCE), (Function1)((Function1)new Function1<SpecSourceItem, Boolean>(configScope){
            final /* synthetic */ ConfigScope $configScope;
            {
                this.$configScope = $configScope;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull SpecSourceItem it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getScope() == this.$configScope;
            }
        })), (Function1)saveSpecSources.save.3.INSTANCE);
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            SpecSourceItem specSourceItem = (SpecSourceItem)item$iv;
            Collection collection = specSources;
            boolean bl = false;
            Project project3 = project2;
            collection.add(new SpecSource(MiscUtilKt.toAbsolutePathOrUrl(project3 != null ? project3.getBasePath() : null, it.getSpecSource().getPathOrUrl(), true)));
        }
    }
}

