/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.config;

import com.intellij.kubernetes.MiscUtilKt;
import com.intellij.kubernetes.config.HelmParameters;
import com.intellij.kubernetes.config.KubernetesProjectOptions;
import com.intellij.kubernetes.config.KubernetesProjectSettings;
import com.intellij.kubernetes.config.SpecSource;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.model.ConstantsKt;
import com.intellij.kubernetes.model.EmbeddedKustomizeVersion;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.Topic;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="KubernetesSettings", storages={@Storage(value="kubernetes-settings.xml", deprecated=true), @Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001c\u001dB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aR2\u0010\t\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b2\r\u0010\u0006\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/kubernetes/config/KubernetesProjectSettings;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lcom/intellij/kubernetes/config/KubernetesProjectOptions;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "value", "", "Lcom/intellij/openapi/util/NlsSafe;", "contextName", "getContextName", "()Ljava/lang/String;", "setContextName", "(Ljava/lang/String;)V", "effectiveApiVersion", "getEffectiveApiVersion", "effectiveKustomizeVersion", "Lcom/intellij/kubernetes/model/EmbeddedKustomizeVersion;", "getEffectiveKustomizeVersion", "()Lcom/intellij/kubernetes/model/EmbeddedKustomizeVersion;", "getEffectiveCrdSpecSources", "", "Lcom/intellij/kubernetes/config/SpecSource;", "getHelmParameters", "Lcom/intellij/kubernetes/config/HelmParameters;", "chart", "Lcom/intellij/kubernetes/helm/chart/Chart;", "getOrCreateHelmParameters", "Companion", "Listener", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesSettings.kt\ncom/intellij/kubernetes/config/KubernetesProjectSettings\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 MiscUtil.kt\ncom/intellij/kubernetes/MiscUtilKt\n+ 4 MessageBusUtilities.kt\ncom/intellij/kubernetes/util/MessageBusUtilitiesKt\n*L\n1#1,214:1\n1#2:215\n121#3,5:216\n6#4,4:221\n*S KotlinDebug\n*F\n+ 1 KubernetesSettings.kt\ncom/intellij/kubernetes/config/KubernetesProjectSettings\n*L\n99#1:216,5\n76#1:221,4\n*E\n"})
public final class KubernetesProjectSettings
extends SimplePersistentStateComponent<KubernetesProjectOptions> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Topic.ProjectLevel
    @JvmField
    @NotNull
    public static final Topic<Listener> TOPIC;

    public KubernetesProjectSettings(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super((BaseState)new KubernetesProjectOptions());
        this.project = project2;
    }

    @Nullable
    public final String getContextName() {
        return ((KubernetesProjectOptions)this.getState()).getContextName();
    }

    public final void setContextName(@Nullable String value2) {
        String oldValue = ((KubernetesProjectOptions)this.getState()).getContextName();
        if (Intrinsics.areEqual((Object)oldValue, (Object)value2)) {
            return;
        }
        ((KubernetesProjectOptions)this.getState()).setContextName(value2);
        ((Listener)this.project.getMessageBus().syncPublisher(TOPIC)).onContextNameChanged(oldValue, value2);
    }

    @NotNull
    public final String getEffectiveApiVersion() {
        String string = ((KubernetesProjectOptions)this.getState()).getApiVersion();
        if (string == null) {
            string = ConstantsKt.getDEFAULT_K8S_VERSION();
        }
        return string;
    }

    @NotNull
    public final EmbeddedKustomizeVersion getEffectiveKustomizeVersion() {
        Object object;
        block5: {
            block4: {
                EmbeddedKustomizeVersion embeddedKustomizeVersion;
                object = ((KubernetesProjectOptions)this.getState()).getKustomizeVersion();
                if (object == null) break block4;
                String it = object;
                boolean bl = false;
                boolean $i$f$unexceptionize = false;
                try {
                    boolean bl2 = false;
                    embeddedKustomizeVersion = EmbeddedKustomizeVersion.valueOf(it);
                }
                catch (Exception e$iv) {
                    embeddedKustomizeVersion = null;
                }
                EmbeddedKustomizeVersion embeddedKustomizeVersion2 = embeddedKustomizeVersion;
                object = embeddedKustomizeVersion2;
                if (embeddedKustomizeVersion2 != null) break block5;
            }
            object = ConstantsKt.getDEFAULT_KUSTOMIZE_VERSION();
        }
        return object;
    }

    @NotNull
    public final List<SpecSource> getEffectiveCrdSpecSources() {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.distinct((Sequence)CollectionsKt.asSequence((Iterable)((KubernetesProjectOptions)this.getState()).getSpecSources())), (Function1)getEffectiveCrdSpecSources.1.INSTANCE), (Function1)((Function1)new Function1<SpecSource, SpecSource>(this){
            final /* synthetic */ KubernetesProjectSettings this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final SpecSource invoke(@NotNull SpecSource it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = KubernetesProjectSettings.access$getProject$p(this.this$0).getBasePath();
                Intrinsics.checkNotNull((Object)string);
                String string2 = MiscUtilKt.toAbsolutePathOrUrl(string, it.getPathOrUrl(), true);
                Intrinsics.checkNotNull((Object)string2);
                return new SpecSource(string2);
            }
        })));
    }

    @Nullable
    public final HelmParameters getHelmParameters(@NotNull Chart chart2) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)chart2, (String)"chart");
            Iterable iterable = ((KubernetesProjectOptions)this.getState()).getHelmParameters();
            for (Object t : iterable) {
                HelmParameters it = (HelmParameters)((Object)t);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getChartPath(), (Object)chart2.getBaseDir().getPath())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final HelmParameters getOrCreateHelmParameters(@NotNull Chart chart2) {
        HelmParameters helmParameters;
        Object v0;
        List<HelmParameters> $this$getOrCreateHelmParameters_u24lambda_u246;
        block2: {
            Intrinsics.checkNotNullParameter((Object)chart2, (String)"chart");
            $this$getOrCreateHelmParameters_u24lambda_u246 = ((KubernetesProjectOptions)this.getState()).getHelmParameters();
            boolean bl = false;
            Iterable iterable = $this$getOrCreateHelmParameters_u24lambda_u246;
            for (Object t : iterable) {
                HelmParameters it = (HelmParameters)((Object)t);
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getChartPath(), (Object)chart2.getBaseDir().getPath())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((helmParameters = (HelmParameters)v0) == null) {
            HelmParameters helmParameters2;
            HelmParameters $this$getOrCreateHelmParameters_u24lambda_u246_u24lambda_u244 = helmParameters2 = new HelmParameters();
            boolean bl = false;
            $this$getOrCreateHelmParameters_u24lambda_u246_u24lambda_u244.setChartPath(chart2.getBaseDir().getPath());
            HelmParameters it = helmParameters2;
            boolean bl3 = false;
            $this$getOrCreateHelmParameters_u24lambda_u246.add(it);
            helmParameters = helmParameters2;
        }
        return helmParameters;
    }

    public static final /* synthetic */ Project access$getProject$p(KubernetesProjectSettings $this) {
        return $this.project;
    }

    static {
        String displayName$iv = "K8s model settings changes";
        Topic.BroadcastDirection direction$iv = Topic.BroadcastDirection.TO_CHILDREN;
        boolean $i$f$createTopic = false;
        Topic topic = Topic.create((String)displayName$iv, Listener.class, (Topic.BroadcastDirection)direction$iv);
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"create(...)");
        TOPIC = topic;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\u000bR\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/kubernetes/config/KubernetesProjectSettings$Companion;", "", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/kubernetes/config/KubernetesProjectSettings$Listener;", "getInstance", "Lcom/intellij/kubernetes/config/KubernetesProjectSettings;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceAsync", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nKubernetesSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesSettings.kt\ncom/intellij/kubernetes/config/KubernetesProjectSettings$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,214:1\n31#2,2:215\n72#2:217\n*S KotlinDebug\n*F\n+ 1 KubernetesSettings.kt\ncom/intellij/kubernetes/config/KubernetesProjectSettings$Companion\n*L\n78#1:215,2\n80#1:217\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KubernetesProjectSettings getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<KubernetesProjectSettings> serviceClass$iv = KubernetesProjectSettings.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (KubernetesProjectSettings)((Object)object);
        }

        @Nullable
        public final Object getInstanceAsync(@NotNull Project project2, @NotNull Continuation<? super KubernetesProjectSettings> $completion) {
            ComponentManager $this$serviceAsync$iv = (ComponentManager)project2;
            boolean $i$f$serviceAsync = false;
            Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
            return ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(KubernetesProjectSettings.class, $completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J&\u0010\u0002\u001a\u00020\u00032\r\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\r\u0010\u0007\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/kubernetes/config/KubernetesProjectSettings$Listener;", "", "onContextNameChanged", "", "oldValue", "", "Lcom/intellij/openapi/util/NlsSafe;", "newValue", "intellij.clouds.kubernetes"})
    public static interface Listener {
        default public void onContextNameChanged(@Nullable String oldValue, @Nullable String newValue) {
        }
    }
}

