/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.config;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.kubernetes.KubernetesModelAccessor;
import com.intellij.kubernetes.KubernetesSpecManager;
import com.intellij.kubernetes.api.Context;
import com.intellij.kubernetes.api.KubernetesApiProvider;
import com.intellij.kubernetes.config.KubernetesConfigurable;
import com.intellij.kubernetes.config.KubernetesConfigurableKt;
import com.intellij.kubernetes.config.KubernetesIdeSettings;
import com.intellij.kubernetes.config.KubernetesOptions;
import com.intellij.kubernetes.config.KubernetesProjectOptions;
import com.intellij.kubernetes.config.KubernetesProjectSettings;
import com.intellij.kubernetes.config.KubernetesSettingsKt;
import com.intellij.kubernetes.config.SpecSourceItem;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.model.ConstantsKt;
import com.intellij.kubernetes.model.EmbeddedKustomizeVersion;
import com.intellij.kubernetes.ui.SpecSourceTableView;
import com.intellij.kubernetes.view.ui.settings.KubernetesViewConfigurable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.popup.ActionPopupOptions;
import com.intellij.ui.popup.PopupFactoryImpl;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001DB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000204H\u0002J\b\u00105\u001a\u000200H\u0016J\r\u00106\u001a\u00070\u0007\u00a2\u0006\u0002\b7H\u0016J\b\u00108\u001a\u00020\u0007H\u0016J\b\u00109\u001a\u00020:H\u0016J\u0018\u0010;\u001a\u0002002\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0002J\b\u0010@\u001a\u000200H\u0016J\b\u0010A\u001a\u000200H\u0002J\f\u0010B\u001a\u000200*\u00020CH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\fX\u0082.\u00a2\u0006\u0002\n\u0000R(\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u00138B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u0010\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u00130\u00130\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u00060\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u00020*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/intellij/kubernetes/config/KubernetesConfigurable;", "Lcom/intellij/openapi/options/Configurable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "apiVersionComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "", "checkSpecsPromise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lcom/intellij/kubernetes/KubernetesSpecManager$SpecResults;", "clusterSpecAvailabilityIndicatorLabel", "Lcom/intellij/ui/dsl/builder/Cell;", "Ljavax/swing/JLabel;", "componentCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "configureClusterLink", "Lcom/intellij/ui/components/ActionLink;", "value", "Lcom/intellij/kubernetes/api/Context;", "context", "getContext", "()Lcom/intellij/kubernetes/api/Context;", "setContext", "(Lcom/intellij/kubernetes/api/Context;)V", "contextComboBox", "contextComboBoxModel", "Lcom/intellij/ui/SortedComboBoxModel;", "kotlin.jvm.PlatformType", "getSpecFromClusterCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "ideSettings", "Lcom/intellij/kubernetes/config/KubernetesIdeSettings;", "getIdeSettings", "()Lcom/intellij/kubernetes/config/KubernetesIdeSettings;", "kustomizeVersionComboBox", "Lcom/intellij/kubernetes/model/EmbeddedKustomizeVersion;", "modelAccessor", "Lcom/intellij/kubernetes/KubernetesModelAccessor;", "getModelAccessor", "()Lcom/intellij/kubernetes/KubernetesModelAccessor;", "projectSettings", "Lcom/intellij/kubernetes/config/KubernetesProjectSettings;", "getProjectSettings", "()Lcom/intellij/kubernetes/config/KubernetesProjectSettings;", "specTable", "Lcom/intellij/kubernetes/ui/SpecSourceTableView;", "apply", "", "createComponent", "Ljavax/swing/JComponent;", "createSpecTableDecorator", "Ljavax/swing/JPanel;", "disposeUIResources", "getDisplayName", "Lorg/jetbrains/annotations/Nls;", "getHelpTopic", "isModified", "", "populate", "ideSettingsState", "Lcom/intellij/kubernetes/config/KubernetesOptions;", "projectSettingsState", "Lcom/intellij/kubernetes/config/KubernetesProjectOptions;", "reset", "updateClusterSpecAvailabilityIndicatorPanel", "buildButtons", "Lcom/intellij/ui/dsl/builder/Panel;", "CoroutineScopeProviderService", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesConfigurable.kt\ncom/intellij/kubernetes/config/KubernetesConfigurable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,323:1\n1#2:324\n31#3,2:325\n*S KotlinDebug\n*F\n+ 1 KubernetesConfigurable.kt\ncom/intellij/kubernetes/config/KubernetesConfigurable\n*L\n75#1:325,2\n*E\n"})
public final class KubernetesConfigurable
implements Configurable {
    @NotNull
    private final Project project;
    @NotNull
    private final SortedComboBoxModel<Context> contextComboBoxModel;
    private ComboBox<Context> contextComboBox;
    private ComboBox<String> apiVersionComboBox;
    private Cell<? extends JBCheckBox> getSpecFromClusterCheckBox;
    private Cell<? extends JLabel> clusterSpecAvailabilityIndicatorLabel;
    private Cell<? extends ActionLink> configureClusterLink;
    private Cell<? extends ComboBox<EmbeddedKustomizeVersion>> kustomizeVersionComboBox;
    @NotNull
    private final SpecSourceTableView specTable;
    @NotNull
    private CoroutineScope componentCoroutineScope;
    @Nullable
    private AsyncPromise<KubernetesSpecManager.SpecResults> checkSpecsPromise;

    /*
     * WARNING - void declaration
     */
    public KubernetesConfigurable(@NotNull Project project2) {
        void it;
        SpecSourceTableView specSourceTableView;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.contextComboBoxModel = new SortedComboBoxModel(((Comparator)KubernetesConfigurable::contextComboBoxModel$lambda$0).thenComparing(arg_0 -> KubernetesConfigurable.contextComboBoxModel$lambda$1((Function1)contextComboBoxModel.2.INSTANCE, arg_0)));
        SpecSourceTableView specSourceTableView2 = specSourceTableView = new SpecSourceTableView(this.project);
        KubernetesConfigurable kubernetesConfigurable = this;
        boolean bl = false;
        it.setVisibleRowCount(15);
        kubernetesConfigurable.specTable = specSourceTableView;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<CoroutineScopeProviderService> serviceClass$iv = CoroutineScopeProviderService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.componentCoroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)((CoroutineScopeProviderService)object).getCoroutineScope(), null, (boolean)false, (int)3, null);
    }

    private final KubernetesProjectSettings getProjectSettings() {
        return KubernetesProjectSettings.Companion.getInstance(this.project);
    }

    private final KubernetesIdeSettings getIdeSettings() {
        return KubernetesIdeSettings.Companion.getInstance();
    }

    private final KubernetesModelAccessor getModelAccessor() {
        return KubernetesModelAccessor.Companion.getInstance(this.project);
    }

    private final void updateClusterSpecAvailabilityIndicatorPanel() {
        Cell<? extends ActionLink> cell;
        KubernetesSpecManager.AvailabilityInfo specAvailabilityInfo = this.getModelAccessor().getSpecManager().getClusterSpecAvailabilityInfo();
        Cell<? extends JLabel> cell2 = this.clusterSpecAvailabilityIndicatorLabel;
        if (cell2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clusterSpecAvailabilityIndicatorLabel");
            cell2 = null;
        }
        cell2.visible(specAvailabilityInfo != null);
        if (specAvailabilityInfo != null) {
            Pair pair = switch (WhenMappings.$EnumSwitchMapping$0[specAvailabilityInfo.getStatus().ordinal()]) {
                case 1 -> new Pair((Object)AllIcons.General.BalloonWarning, (Object)specAvailabilityInfo.getErrorMessage());
                case 2 -> new Pair((Object)AllIcons.General.InspectionsOK, (Object)KubernetesBundle.message("KubernetesConfigurable.spec.status.available", new Object[0]));
                default -> throw new NoWhenBranchMatchedException();
            };
            Icon icon = (Icon)pair.component1();
            String tooltipText = (String)pair.component2();
            Cell<? extends JLabel> cell3 = this.clusterSpecAvailabilityIndicatorLabel;
            if (cell3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"clusterSpecAvailabilityIndicatorLabel");
                cell3 = null;
            }
            Cell<? extends JLabel> $this$updateClusterSpecAvailabilityIndicatorPanel_u24lambda_u243 = cell3;
            boolean bl = false;
            ((JLabel)$this$updateClusterSpecAvailabilityIndicatorPanel_u24lambda_u243.getComponent()).setIcon(icon);
            ((JLabel)$this$updateClusterSpecAvailabilityIndicatorPanel_u24lambda_u243.getComponent()).setToolTipText(tooltipText);
        }
        if ((cell = this.configureClusterLink) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configureClusterLink");
            cell = null;
        }
        KubernetesSpecManager.AvailabilityInfo availabilityInfo = specAvailabilityInfo;
        cell.visible((availabilityInfo != null ? availabilityInfo.getStatus() : null) == KubernetesSpecManager.AvailabilityStatus.UNAVAILABLE);
    }

    @NotNull
    public JComponent createComponent() {
        this.specTable.setShowGrid(false);
        DialogPanel result2 = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ KubernetesConfigurable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                $this$panel.row(KubernetesBundle.message("KubernetesConfigurable.context.to.use.title", new Object[0]) + ":", (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ KubernetesConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        KubernetesConfigurable.access$setContextComboBox$p(this.this$0, (ComboBox)Row.comboBox$default((Row)$this$row, (ComboBoxModel)((ComboBoxModel)KubernetesConfigurable.access$getContextComboBoxModel$p(this.this$0)), null, (int)2, null).align((Align)AlignX.FILL.INSTANCE).getComponent());
                        ComboBox comboBox = KubernetesConfigurable.access$getContextComboBox$p(this.this$0);
                        if (comboBox == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"contextComboBox");
                            comboBox = null;
                        }
                        comboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)KubernetesBundle.message("KubernetesConfigurable.context.not.configured", new Object[0]), arg_0 -> createComponent.result.1.invoke$lambda$0(createComponent.result.1.INSTANCE, arg_0)));
                        BuildersKt.launch$default((CoroutineScope)KubernetesConfigurable.access$getComponentCoroutineScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            Object L$0;
                            int label;
                            final /* synthetic */ KubernetesConfigurable this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        this.label = 1;
                                        v0 = KubernetesApiProvider.Companion.getInstanceAsync(KubernetesConfigurable.access$getProject$p(this.this$0), (Continuation<? super KubernetesApiProvider>)((Continuation)this));
                                        if (v0 == var3_2) {
                                            return var3_2;
                                        }
                                        ** GOTO lbl13
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl13:
                                        // 2 sources

                                        apiProvider = (KubernetesApiProvider)v0;
                                        this.L$0 = apiProvider;
                                        this.label = 2;
                                        v1 = apiProvider.initIfNecessary$intellij_clouds_kubernetes((Continuation<? super KubernetesApiProvider.State>)((Continuation)this));
                                        if (v1 == var3_2) {
                                            return var3_2;
                                        }
                                        ** GOTO lbl24
                                    }
                                    case 2: {
                                        apiProvider = (KubernetesApiProvider)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl24:
                                        // 2 sources

                                        v2 = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
                                        v3 = ModalityState.any();
                                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"any(...)");
                                        this.L$0 = null;
                                        this.label = 3;
                                        v4 = BuildersKt.withContext((CoroutineContext)v2.plus(ModalityKt.asContextElement((ModalityState)v3)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(apiProvider, this.this$0, null){
                                            int label;
                                            final /* synthetic */ KubernetesApiProvider $apiProvider;
                                            final /* synthetic */ KubernetesConfigurable this$0;
                                            {
                                                this.$apiProvider = $apiProvider;
                                                this.this$0 = $receiver;
                                                super(2, $completion);
                                            }

                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object object) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        Object object2;
                                                        ResultKt.throwOnFailure((Object)object);
                                                        Set<Context> existingContexts = this.$apiProvider.getExistingContexts();
                                                        KubernetesConfigurable.access$getContextComboBoxModel$p(this.this$0).setAll((Collection)existingContexts);
                                                        KubernetesConfigurable.access$getContextComboBoxModel$p(this.this$0).add(null);
                                                        Object object3 = this.$apiProvider;
                                                        KubernetesConfigurable kubernetesConfigurable = this.this$0;
                                                        KubernetesApiProvider $this$invokeSuspend_u24lambda_u240 = object3;
                                                        KubernetesConfigurable kubernetesConfigurable2 = this.this$0;
                                                        boolean bl = false;
                                                        Context context = $this$invokeSuspend_u24lambda_u240.getContext(KubernetesConfigurable.access$getProjectSettings(kubernetesConfigurable));
                                                        KubernetesConfigurable kubernetesConfigurable3 = kubernetesConfigurable2;
                                                        if (context != null) {
                                                            Object it = object3 = context;
                                                            kubernetesConfigurable2 = kubernetesConfigurable3;
                                                            boolean bl2 = false;
                                                            boolean bl3 = existingContexts.contains(it);
                                                            kubernetesConfigurable3 = kubernetesConfigurable2;
                                                            object2 = bl3 ? object3 : null;
                                                        } else {
                                                            object2 = null;
                                                        }
                                                        KubernetesConfigurable.access$setContext(kubernetesConfigurable3, object2);
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            @Nullable
                                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (v4 == var3_2) {
                                            return var3_2;
                                        }
                                        ** GOTO lbl36
                                    }
                                    case 3: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v4 = $result;
lbl36:
                                        // 2 sources

                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                    }

                    private static final String invoke$lambda$0(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        return (String)$tmp0.invoke(p0);
                    }
                });
                $this$panel.row(KubernetesBundle.message("KubernetesConfigurable.apiVersionTitle", new Object[0]) + ":", (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ KubernetesConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String[] stringArray = ConstantsKt.getEMBEDDED_SPEC_VERSIONS();
                        List apiVersions = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)KubernetesConfigurableKt.access$getLATEST_API_VERSION_ITEM$p()), (Iterable)CollectionsKt.reversed((Iterable)CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray, stringArray.length))));
                        KubernetesConfigurable.access$setApiVersionComboBox$p(this.this$0, (ComboBox)Row.comboBox$default((Row)$this$row, (Collection)apiVersions, null, (int)2, null).align((Align)AlignX.FILL.INSTANCE).getComponent());
                    }
                });
                $this$panel.row("", (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ KubernetesConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = KubernetesBundle.message("KubernetesConfigurable.get.spec.from.cluster.title", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        KubernetesConfigurable.access$setGetSpecFromClusterCheckBox$p(this.this$0, $this$row.checkBox(string).gap(RightGap.SMALL));
                        KubernetesConfigurable.access$setClusterSpecAvailabilityIndicatorLabel$p(this.this$0, $this$row.label(""));
                        String string2 = KubernetesBundle.message("KubernetesConfigurable.configure.cluster.link.title", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                        KubernetesConfigurable.access$setConfigureClusterLink$p(this.this$0, $this$row.link(string2, (Function1)new Function1<ActionEvent, Unit>(this.this$0){
                            final /* synthetic */ KubernetesConfigurable this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull ActionEvent it) {
                                block2: {
                                    Settings settings2;
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    DataManager dataManager = DataManager.getInstance();
                                    Cell cell = KubernetesConfigurable.access$getConfigureClusterLink$p(this.this$0);
                                    if (cell == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"configureClusterLink");
                                        cell = null;
                                    }
                                    DataContext dataContext = dataManager.getDataContext((Component)cell.getComponent());
                                    Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                                    DataContext dataContext2 = dataContext;
                                    Settings settings3 = (Settings)Settings.KEY.getData(dataContext2);
                                    if (settings3 == null) break block2;
                                    Settings $this$invoke_u24lambda_u241 = settings2 = settings3;
                                    boolean bl = false;
                                    KubernetesViewConfigurable kubernetesViewConfigurable = (KubernetesViewConfigurable)$this$invoke_u24lambda_u241.find(KubernetesViewConfigurable.class);
                                    if (kubernetesViewConfigurable != null) {
                                        KubernetesViewConfigurable it2 = kubernetesViewConfigurable;
                                        boolean bl2 = false;
                                        $this$invoke_u24lambda_u241.select((Configurable)it2);
                                    }
                                }
                            }
                        }));
                    }
                });
                $this$panel.row(KubernetesBundle.message("KubernetesConfigurable.kustomizeVersionTitle", new Object[0]) + ":", (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ KubernetesConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        KubernetesConfigurable.access$setKustomizeVersionComboBox$p(this.this$0, $this$row.comboBox((Collection)ArraysKt.reversed((Object[])EmbeddedKustomizeVersion.values()), (ListCellRenderer)SimpleListCellRenderer.create((String)"", createComponent.result.4::invoke$lambda$0)).align((Align)AlignX.FILL.INSTANCE));
                    }

                    private static final String invoke$lambda$0(EmbeddedKustomizeVersion it) {
                        EmbeddedKustomizeVersion embeddedKustomizeVersion = it;
                        return KubernetesBundle.message("EmbeddedKustomizeVersion." + (embeddedKustomizeVersion != null ? embeddedKustomizeVersion.name() : null) + ".title", new Object[0]);
                    }
                }).bottomGap(BottomGap.SMALL);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ KubernetesConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)KubernetesConfigurable.access$createSpecTableDecorator(this.this$0)).align((Align)AlignX.FILL.INSTANCE);
                    }
                }), (int)1, null);
                KubernetesConfigurable.access$buildButtons(this.this$0, $this$panel);
            }
        }));
        this.updateClusterSpecAvailabilityIndicatorPanel();
        this.reset();
        return (JComponent)result2;
    }

    private final JPanel createSpecTableDecorator() {
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)((JTable)((Object)this.specTable))).setAddIcon(LayeredIcon.ADD_WITH_DROPDOWN).setAddAction(arg_0 -> KubernetesConfigurable.createSpecTableDecorator$lambda$5(this, arg_0)).setRemoveAction(arg_0 -> KubernetesConfigurable.createSpecTableDecorator$lambda$6(this, arg_0)).createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        return jPanel;
    }

    private final void buildButtons(Panel $this$buildButtons) {
        Panel.row$default((Panel)$this$buildButtons, null, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ KubernetesConfigurable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                Ref.ObjectRef checkButton = new Ref.ObjectRef();
                Ref.ObjectRef checkResultLabel = new Ref.ObjectRef();
                String string = KubernetesBundle.message("KubernetesConfigurable.check.configuration.title", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                checkButton.element = $this$row.button(string, (Function1)new Function1<ActionEvent, Unit>((Ref.ObjectRef<JLabel>)checkResultLabel, (Ref.ObjectRef<Cell<JButton>>)checkButton, this.this$0){
                    final /* synthetic */ Ref.ObjectRef<JLabel> $checkResultLabel;
                    final /* synthetic */ Ref.ObjectRef<Cell<JButton>> $checkButton;
                    final /* synthetic */ KubernetesConfigurable this$0;
                    {
                        this.$checkResultLabel = $checkResultLabel;
                        this.$checkButton = $checkButton;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull ActionEvent it) {
                        void $this$mapNotNullTo$iv$iv;
                        void $this$mapNotNull$iv;
                        Cell cell;
                        JLabel jLabel;
                        JLabel jLabel2;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        if (this.$checkResultLabel.element == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"checkResultLabel");
                            jLabel2 = null;
                        } else {
                            jLabel2 = (JLabel)this.$checkResultLabel.element;
                        }
                        jLabel2.setText(KubernetesBundle.message("KubernetesConfigurable.check.configuration.inprogress.text", new Object[0]));
                        if (this.$checkResultLabel.element == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"checkResultLabel");
                            jLabel = null;
                        } else {
                            jLabel = (JLabel)this.$checkResultLabel.element;
                        }
                        jLabel.setIcon(AllIcons.Actions.BuildLoadChanges);
                        if (this.$checkButton.element == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"checkButton");
                            cell = null;
                        } else {
                            cell = (Cell)this.$checkButton.element;
                        }
                        cell.enabled(false);
                        KubernetesSpecManager kubernetesSpecManager = KubernetesConfigurable.access$getModelAccessor(this.this$0).getSpecManager();
                        Cell cell2 = KubernetesConfigurable.access$getGetSpecFromClusterCheckBox$p(this.this$0);
                        if (cell2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"getSpecFromClusterCheckBox");
                            cell2 = null;
                        }
                        boolean bl = ((JBCheckBox)cell2.getComponent()).isSelected();
                        List list2 = KubernetesConfigurable.access$getSpecTable$p(this.this$0).getItems();
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
                        Iterable iterable = list2;
                        boolean bl2 = bl;
                        KubernetesSpecManager kubernetesSpecManager2 = kubernetesSpecManager;
                        KubernetesConfigurable kubernetesConfigurable = this.this$0;
                        boolean $i$f$mapNotNull = false;
                        void var4_7 = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            String it$iv$iv;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl3 = false;
                            SpecSourceItem it2 = (SpecSourceItem)element$iv$iv;
                            boolean bl4 = false;
                            if (it2.getSpecSource().getPathOrUrl() == null) continue;
                            boolean bl5 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        List list3 = (List)destination$iv$iv;
                        KubernetesConfigurable.access$setCheckSpecsPromise$p(kubernetesConfigurable, kubernetesSpecManager2.prepareSpecs(bl2, CollectionsKt.distinct((Iterable)list3), false));
                        KubernetesConfigurable.access$updateClusterSpecAvailabilityIndicatorPanel(this.this$0);
                        AsyncPromise asyncPromise = KubernetesConfigurable.access$getCheckSpecsPromise$p(this.this$0);
                        Intrinsics.checkNotNull((Object)asyncPromise);
                        asyncPromise.onSuccess(arg_0 -> buildButtons.1.invoke$lambda$1((Function1)new Function1<KubernetesSpecManager.SpecResults, Unit>(this.$checkButton, this.$checkResultLabel, this.this$0){
                            final /* synthetic */ Ref.ObjectRef<Cell<JButton>> $checkButton;
                            final /* synthetic */ Ref.ObjectRef<JLabel> $checkResultLabel;
                            final /* synthetic */ KubernetesConfigurable this$0;
                            {
                                this.$checkButton = $checkButton;
                                this.$checkResultLabel = $checkResultLabel;
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull KubernetesSpecManager.SpecResults it) {
                                Cell cell;
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                if (this.$checkButton.element == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"checkButton");
                                    cell = null;
                                } else {
                                    cell = (Cell)this.$checkButton.element;
                                }
                                cell.enabled(true);
                                if (it.getWithErrors()) {
                                    JLabel jLabel;
                                    JLabel jLabel2;
                                    if (this.$checkResultLabel.element == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"checkResultLabel");
                                        jLabel2 = null;
                                    } else {
                                        jLabel2 = (JLabel)this.$checkResultLabel.element;
                                    }
                                    jLabel2.setText(KubernetesBundle.message("KubernetesConfigurable.check.configuration.problems.detected.details.text", new Object[0]));
                                    if (this.$checkResultLabel.element == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"checkResultLabel");
                                        jLabel = null;
                                    } else {
                                        jLabel = (JLabel)this.$checkResultLabel.element;
                                    }
                                    jLabel.setIcon(AllIcons.General.BalloonWarning);
                                } else {
                                    JLabel jLabel;
                                    JLabel jLabel3;
                                    if (this.$checkResultLabel.element == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"checkResultLabel");
                                        jLabel3 = null;
                                    } else {
                                        jLabel3 = (JLabel)this.$checkResultLabel.element;
                                    }
                                    jLabel3.setText(KubernetesBundle.message("KubernetesConfigurable.check.configuration.success.text", new Object[0]));
                                    if (this.$checkResultLabel.element == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"checkResultLabel");
                                        jLabel = null;
                                    } else {
                                        jLabel = (JLabel)this.$checkResultLabel.element;
                                    }
                                    jLabel.setIcon(AllIcons.General.InspectionsOK);
                                }
                                KubernetesConfigurable.access$getSpecTable$p(this.this$0).revalidate();
                                KubernetesConfigurable.access$getSpecTable$p(this.this$0).repaint();
                                KubernetesConfigurable.access$updateClusterSpecAvailabilityIndicatorPanel(this.this$0);
                            }
                        }, arg_0)).onError(arg_0 -> buildButtons.1.invoke$lambda$2((Function1)new Function1<Throwable, Unit>(this.$checkButton, this.$checkResultLabel){
                            final /* synthetic */ Ref.ObjectRef<Cell<JButton>> $checkButton;
                            final /* synthetic */ Ref.ObjectRef<JLabel> $checkResultLabel;
                            {
                                this.$checkButton = $checkButton;
                                this.$checkResultLabel = $checkResultLabel;
                                super(1);
                            }

                            public final void invoke(@NotNull Throwable it) {
                                JLabel jLabel;
                                JLabel jLabel2;
                                Cell cell;
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                if (this.$checkButton.element == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"checkButton");
                                    cell = null;
                                } else {
                                    cell = (Cell)this.$checkButton.element;
                                }
                                cell.enabled(true);
                                if (this.$checkResultLabel.element == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"checkResultLabel");
                                    jLabel2 = null;
                                } else {
                                    jLabel2 = (JLabel)this.$checkResultLabel.element;
                                }
                                jLabel2.setText(KubernetesBundle.message("KubernetesConfigurable.check.configuration.error.text", new Object[0]));
                                if (this.$checkResultLabel.element == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"checkResultLabel");
                                    jLabel = null;
                                } else {
                                    jLabel = (JLabel)this.$checkResultLabel.element;
                                }
                                jLabel.setIcon(AllIcons.General.BalloonError);
                            }
                        }, arg_0));
                    }

                    private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        $tmp0.invoke(p0);
                    }

                    private static final void invoke$lambda$2(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        $tmp0.invoke(p0);
                    }
                });
                checkResultLabel.element = $this$row.label("").getComponent();
            }
        }), (int)1, null);
        Panel.row$default((Panel)$this$buildButtons, null, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ KubernetesConfigurable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                Ref.ObjectRef doneLabel = new Ref.ObjectRef();
                String string = KubernetesBundle.message("KubernetesConfigurable.reset.schema.cache.title", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                $this$row.button(string, (Function1)new Function1<ActionEvent, Unit>(this.this$0, (Ref.ObjectRef<JLabel>)doneLabel){
                    final /* synthetic */ KubernetesConfigurable this$0;
                    final /* synthetic */ Ref.ObjectRef<JLabel> $doneLabel;
                    {
                        this.this$0 = $receiver;
                        this.$doneLabel = $doneLabel;
                        super(1);
                    }

                    public final void invoke(@NotNull ActionEvent it) {
                        JLabel jLabel;
                        JLabel jLabel2;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        KubernetesConfigurable.access$getModelAccessor(this.this$0).resetAndForceDownload();
                        if (this.$doneLabel.element == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"doneLabel");
                            jLabel2 = null;
                        } else {
                            jLabel2 = (JLabel)this.$doneLabel.element;
                        }
                        jLabel2.setText(KubernetesBundle.message("KubernetesConfigurable.reset.schema.cache.success.text", new Object[0]));
                        if (this.$doneLabel.element == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"doneLabel");
                            jLabel = null;
                        } else {
                            jLabel = (JLabel)this.$doneLabel.element;
                        }
                        jLabel.setIcon(AllIcons.General.InspectionsOK);
                    }
                }).applyToComponent((Function1)buildButtons.2.INSTANCE);
                doneLabel.element = $this$row.label("").getComponent();
            }
        }), (int)1, null);
    }

    public boolean isModified() {
        KubernetesOptions ideSettingsState = new KubernetesOptions();
        KubernetesProjectOptions projectSettingsState = new KubernetesProjectOptions();
        this.populate(ideSettingsState, projectSettingsState);
        return !Intrinsics.areEqual((Object)((Object)projectSettingsState), (Object)this.getProjectSettings().getState()) || !Intrinsics.areEqual((Object)((Object)ideSettingsState), (Object)this.getIdeSettings().getState());
    }

    public void apply() {
        KubernetesOptions ideSettingsState = new KubernetesOptions();
        this.populate(ideSettingsState, new KubernetesProjectOptions());
        boolean ideStateModified = !Intrinsics.areEqual((Object)((Object)ideSettingsState), (Object)this.getIdeSettings().getState());
        this.populate((KubernetesOptions)this.getIdeSettings().getState(), (KubernetesProjectOptions)this.getProjectSettings().getState());
        if (ideStateModified) {
            KubernetesModelAccessor.Companion.invalidateAllModels();
        } else {
            this.getModelAccessor().reset();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void populate(KubernetesOptions ideSettingsState, KubernetesProjectOptions projectSettingsState) {
        void it;
        void it2;
        Context context = this.getContext();
        projectSettingsState.setContextName(context != null ? context.getName() : null);
        ComboBox<String> comboBox = this.apiVersionComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apiVersionComboBox");
            comboBox = null;
        }
        Object object = comboBox.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String string = (String)object;
        Object object2 = string;
        KubernetesProjectOptions kubernetesProjectOptions = projectSettingsState;
        boolean $i$a$-takeIf-KubernetesConfigurable$populate$32 = false;
        boolean bl = !Intrinsics.areEqual((Object)it2, (Object)KubernetesConfigurableKt.access$getLATEST_API_VERSION_ITEM$p());
        kubernetesProjectOptions.setApiVersion(bl ? string : null);
        Cell<? extends JBCheckBox> cell = this.getSpecFromClusterCheckBox;
        if (cell == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"getSpecFromClusterCheckBox");
            cell = null;
        }
        projectSettingsState.setGetSpecFromCluster(((JBCheckBox)cell.getComponent()).isSelected());
        Cell<? extends ComboBox<EmbeddedKustomizeVersion>> cell2 = this.kustomizeVersionComboBox;
        if (cell2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"kustomizeVersionComboBox");
            cell2 = null;
        }
        Object object3 = ((ComboBox)cell2.getComponent()).getSelectedItem();
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type com.intellij.kubernetes.model.EmbeddedKustomizeVersion");
        Object $i$a$-takeIf-KubernetesConfigurable$populate$32 = object2 = (EmbeddedKustomizeVersion)((Object)object3);
        kubernetesProjectOptions = projectSettingsState;
        boolean bl2 = false;
        bl = it != ConstantsKt.getDEFAULT_KUSTOMIZE_VERSION();
        Object object4 = bl ? object2 : null;
        kubernetesProjectOptions.setKustomizeVersion(object4 != null ? ((Enum)object4).name() : null);
        List list2 = this.specTable.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
        KubernetesSettingsKt.saveSpecSources(this.project, list2, ideSettingsState, projectSettingsState);
    }

    public void reset() {
        String string;
        KubernetesApiProvider $this$reset_u24lambda_u249 = KubernetesApiProvider.Companion.getInstance(this.project);
        KubernetesConfigurable kubernetesConfigurable = this;
        boolean bl = false;
        kubernetesConfigurable.setContext($this$reset_u24lambda_u249.getContext(this.getProjectSettings()));
        ComboBox<String> comboBox = this.apiVersionComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apiVersionComboBox");
            comboBox = null;
        }
        if ((string = ((KubernetesProjectOptions)this.getProjectSettings().getState()).getApiVersion()) == null) {
            string = KubernetesConfigurableKt.access$getLATEST_API_VERSION_ITEM$p();
        }
        comboBox.setSelectedItem((Object)string);
        Cell<? extends JBCheckBox> cell = this.getSpecFromClusterCheckBox;
        if (cell == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"getSpecFromClusterCheckBox");
            cell = null;
        }
        ((JBCheckBox)cell.getComponent()).setSelected(((KubernetesProjectOptions)this.getProjectSettings().getState()).getGetSpecFromCluster());
        Cell<? extends ComboBox<EmbeddedKustomizeVersion>> cell2 = this.kustomizeVersionComboBox;
        if (cell2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"kustomizeVersionComboBox");
            cell2 = null;
        }
        ((ComboBox)cell2.getComponent()).setSelectedItem((Object)this.getProjectSettings().getEffectiveKustomizeVersion());
        this.specTable.getModel().setItems(KubernetesSettingsKt.readEffectiveSpecSources(this.project));
    }

    private final Context getContext() {
        Object object;
        ComboBox<Context> comboBox = this.contextComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contextComboBox");
            comboBox = null;
        }
        return (object = comboBox.getSelectedItem()) instanceof Context ? (Context)object : null;
    }

    private final void setContext(Context value2) {
        ComboBox<Context> comboBox = this.contextComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contextComboBox");
            comboBox = null;
        }
        comboBox.setSelectedItem((Object)value2);
    }

    @NotNull
    public String getHelpTopic() {
        return "Kubernetes";
    }

    @NotNull
    public String getDisplayName() {
        String string = KubernetesBundle.message("KubernetesConfigurable.displayName", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void disposeUIResources() {
        AsyncPromise<KubernetesSpecManager.SpecResults> asyncPromise = this.checkSpecsPromise;
        if (asyncPromise != null) {
            asyncPromise.cancel();
        }
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.componentCoroutineScope, null, (int)1, null);
    }

    private static final int contextComboBoxModel$lambda$0(Context o1, Context o2) {
        return o1 == null ? -1 : (o2 == null ? 1 : 0);
    }

    private static final String contextComboBoxModel$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final void createSpecTableDecorator$lambda$5(KubernetesConfigurable this$0, AnActionButton it) {
        DefaultActionGroup defaultActionGroup;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DefaultActionGroup $this$createSpecTableDecorator_u24lambda_u245_u24lambda_u244 = defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        String string = " " + KubernetesBundle.message("KubernetesConfigurable.crdSpec.add.files.title", new Object[0]) + " ";
        $this$createSpecTableDecorator_u24lambda_u245_u24lambda_u244.add(new AnAction(this$0, string){
            final /* synthetic */ KubernetesConfigurable this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                KubernetesConfigurable.access$getSpecTable$p(this.this$0).addLocalPaths();
            }
        });
        string = " " + KubernetesBundle.message("KubernetesConfigurable.crdSpec.add.url.title", new Object[0]) + " ";
        $this$createSpecTableDecorator_u24lambda_u245_u24lambda_u244.add(new AnAction(this$0, string){
            final /* synthetic */ KubernetesConfigurable this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                KubernetesConfigurable.access$getSpecTable$p(this.this$0).addUrl();
            }
        });
        DefaultActionGroup group2 = defaultActionGroup;
        PopupFactoryImpl.ActionGroupPopup popup2 = new PopupFactoryImpl.ActionGroupPopup(null, null, (ActionGroup)group2, it.getDataContext(), ActionPlaces.getPopupPlace((String)"KubernetesConfigurable"), new PresentationFactory(), ActionPopupOptions.empty(), null);
        popup2.show(it.getPreferredPopupPoint());
    }

    private static final void createSpecTableDecorator$lambda$6(KubernetesConfigurable this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        TableUtil.removeSelectedItems((JTable)((JTable)((Object)this$0.specTable)));
    }

    public static final /* synthetic */ void access$setContextComboBox$p(KubernetesConfigurable $this, ComboBox comboBox) {
        $this.contextComboBox = comboBox;
    }

    public static final /* synthetic */ SortedComboBoxModel access$getContextComboBoxModel$p(KubernetesConfigurable $this) {
        return $this.contextComboBoxModel;
    }

    public static final /* synthetic */ ComboBox access$getContextComboBox$p(KubernetesConfigurable $this) {
        return $this.contextComboBox;
    }

    public static final /* synthetic */ CoroutineScope access$getComponentCoroutineScope$p(KubernetesConfigurable $this) {
        return $this.componentCoroutineScope;
    }

    public static final /* synthetic */ Project access$getProject$p(KubernetesConfigurable $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$setContext(KubernetesConfigurable $this, Context value2) {
        $this.setContext(value2);
    }

    public static final /* synthetic */ KubernetesProjectSettings access$getProjectSettings(KubernetesConfigurable $this) {
        return $this.getProjectSettings();
    }

    public static final /* synthetic */ void access$setApiVersionComboBox$p(KubernetesConfigurable $this, ComboBox comboBox) {
        $this.apiVersionComboBox = comboBox;
    }

    public static final /* synthetic */ void access$setGetSpecFromClusterCheckBox$p(KubernetesConfigurable $this, Cell cell) {
        $this.getSpecFromClusterCheckBox = cell;
    }

    public static final /* synthetic */ void access$setClusterSpecAvailabilityIndicatorLabel$p(KubernetesConfigurable $this, Cell cell) {
        $this.clusterSpecAvailabilityIndicatorLabel = cell;
    }

    public static final /* synthetic */ void access$setConfigureClusterLink$p(KubernetesConfigurable $this, Cell cell) {
        $this.configureClusterLink = cell;
    }

    public static final /* synthetic */ Cell access$getConfigureClusterLink$p(KubernetesConfigurable $this) {
        return $this.configureClusterLink;
    }

    public static final /* synthetic */ void access$setKustomizeVersionComboBox$p(KubernetesConfigurable $this, Cell cell) {
        $this.kustomizeVersionComboBox = cell;
    }

    public static final /* synthetic */ JPanel access$createSpecTableDecorator(KubernetesConfigurable $this) {
        return $this.createSpecTableDecorator();
    }

    public static final /* synthetic */ void access$buildButtons(KubernetesConfigurable $this, Panel $receiver) {
        $this.buildButtons($receiver);
    }

    public static final /* synthetic */ void access$setCheckSpecsPromise$p(KubernetesConfigurable $this, AsyncPromise asyncPromise) {
        $this.checkSpecsPromise = asyncPromise;
    }

    public static final /* synthetic */ KubernetesModelAccessor access$getModelAccessor(KubernetesConfigurable $this) {
        return $this.getModelAccessor();
    }

    public static final /* synthetic */ Cell access$getGetSpecFromClusterCheckBox$p(KubernetesConfigurable $this) {
        return $this.getSpecFromClusterCheckBox;
    }

    public static final /* synthetic */ SpecSourceTableView access$getSpecTable$p(KubernetesConfigurable $this) {
        return $this.specTable;
    }

    public static final /* synthetic */ void access$updateClusterSpecAvailabilityIndicatorPanel(KubernetesConfigurable $this) {
        $this.updateClusterSpecAvailabilityIndicatorPanel();
    }

    public static final /* synthetic */ AsyncPromise access$getCheckSpecsPromise$p(KubernetesConfigurable $this) {
        return $this.checkSpecsPromise;
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/kubernetes/config/KubernetesConfigurable$CoroutineScopeProviderService;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "intellij.clouds.kubernetes"})
    private static final class CoroutineScopeProviderService {
        @NotNull
        private final CoroutineScope coroutineScope;

        public CoroutineScopeProviderService(@NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            this.coroutineScope = coroutineScope;
        }

        @NotNull
        public final CoroutineScope getCoroutineScope() {
            return this.coroutineScope;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KubernetesSpecManager.AvailabilityStatus.values().length];
            try {
                nArray[KubernetesSpecManager.AvailabilityStatus.UNAVAILABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KubernetesSpecManager.AvailabilityStatus.AVAILABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

