/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.api.settings;

import com.intellij.codeWithMe.ClientId;
import com.intellij.kubernetes.api.settings.KubernetesApiGlobalSettingsKt;
import com.intellij.kubernetes.api.settings.KubernetesApiSettings;
import com.intellij.kubernetes.wsl.WslOrNativePath;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="KubernetesApiSettings", storages={@Storage(value="kubernetes-settings.xml", roamingType=RoamingType.DISABLED)})
@Service(value={Service.Level.APP})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003&'(B\u0005\u00a2\u0006\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R(\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007R(\u0010\u0011\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\f\"\u0004\b\u0013\u0010\u000eR\u0014\u0010\u0014\u001a\u00020\u00158TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u00188F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R$\u0010#\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u00188F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010\u001b\"\u0004\b%\u0010\u001d\u00a8\u0006)"}, d2={"Lcom/intellij/kubernetes/api/settings/KubernetesApiGlobalSettings;", "Lcom/intellij/kubernetes/api/settings/KubernetesApiSettings;", "Lcom/intellij/kubernetes/api/settings/KubernetesApiGlobalSettings$GlobalState;", "()V", "helmPath", "Lcom/intellij/kubernetes/wsl/WslOrNativePath;", "getHelmPath$intellij_clouds_kubernetes", "()Lcom/intellij/kubernetes/wsl/WslOrNativePath;", "value", "", "helmPathString", "getHelmPathString", "()Ljava/lang/String;", "setHelmPathString", "(Ljava/lang/String;)V", "kubectlPath", "getKubectlPath$intellij_clouds_kubernetes", "kubectlPathString", "getKubectlPathString", "setKubectlPathString", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "getMessageBus", "()Lcom/intellij/util/messages/MessageBus;", "", "refreshResourcesAfterActionConfig", "getRefreshResourcesAfterActionConfig", "()Z", "setRefreshResourcesAfterActionConfig", "(Z)V", "topic", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/kubernetes/api/settings/KubernetesApiGlobalSettings$Listener;", "getTopic", "()Lcom/intellij/util/messages/Topic;", "watchKubeConfig", "getWatchKubeConfig", "setWatchKubeConfig", "Companion", "GlobalState", "Listener", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesApiGlobalSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesApiGlobalSettings.kt\ncom/intellij/kubernetes/api/settings/KubernetesApiGlobalSettings\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 MessageBusUtilities.kt\ncom/intellij/kubernetes/util/MessageBusUtilitiesKt\n*L\n1#1,133:1\n1#2:134\n6#3,4:135\n*S KotlinDebug\n*F\n+ 1 KubernetesApiGlobalSettings.kt\ncom/intellij/kubernetes/api/settings/KubernetesApiGlobalSettings\n*L\n24#1:135,4\n*E\n"})
public final class KubernetesApiGlobalSettings
extends KubernetesApiSettings<GlobalState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Topic.AppLevel
    @JvmField
    @NotNull
    public static final Topic<Listener> TOPIC;

    public KubernetesApiGlobalSettings() {
        super((KubernetesApiSettings.State)new GlobalState());
    }

    @Override
    @NotNull
    protected Topic<Listener> getTopic() {
        return TOPIC;
    }

    @Override
    @NotNull
    protected MessageBus getMessageBus() {
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        return messageBus;
    }

    @Nullable
    public final String getKubectlPathString() {
        return ((GlobalState)this.getState()).getKubectlPath();
    }

    public final void setKubectlPathString(@Nullable String value2) {
        String oldValue = ((GlobalState)this.getState()).getKubectlPath();
        if (Intrinsics.areEqual((Object)oldValue, (Object)value2)) {
            return;
        }
        ((GlobalState)this.getState()).setKubectlPath(value2);
        ((Listener)this.getMessageBus().syncPublisher(this.getTopic())).onKubectlPathChanged(oldValue, value2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final WslOrNativePath getKubectlPath$intellij_clouds_kubernetes() {
        void it;
        String string;
        String string2 = string = this.getKubectlPathString();
        WslOrNativePath.Companion companion = WslOrNativePath.Companion;
        boolean bl = false;
        CharSequence charSequence = (CharSequence)it;
        boolean bl2 = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
        String string3 = !bl2 ? string : null;
        if (string3 == null) {
            string3 = KubernetesApiGlobalSettingsKt.getDefaultKubectlPath();
        }
        return companion.create(string3);
    }

    @Nullable
    public final String getHelmPathString() {
        return ((GlobalState)this.getState()).getHelmPath();
    }

    public final void setHelmPathString(@Nullable String value2) {
        String oldValue = ((GlobalState)this.getState()).getHelmPath();
        if (Intrinsics.areEqual((Object)oldValue, (Object)value2)) {
            return;
        }
        ((GlobalState)this.getState()).setHelmPath(value2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final WslOrNativePath getHelmPath$intellij_clouds_kubernetes() {
        void it;
        String string;
        String string2 = string = this.getHelmPathString();
        WslOrNativePath.Companion companion = WslOrNativePath.Companion;
        boolean bl = false;
        CharSequence charSequence = (CharSequence)it;
        boolean bl2 = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
        String string3 = !bl2 ? string : null;
        if (string3 == null) {
            string3 = KubernetesApiGlobalSettingsKt.getDefaultHelmPath();
        }
        return companion.create(string3);
    }

    public final boolean getWatchKubeConfig() {
        return ((GlobalState)this.getState()).getWatchKubeConfig();
    }

    public final void setWatchKubeConfig(boolean value2) {
        boolean oldValue = ((GlobalState)this.getState()).getWatchKubeConfig();
        if (oldValue == value2) {
            return;
        }
        ((GlobalState)this.getState()).setWatchKubeConfig(value2);
        ((Listener)this.getMessageBus().syncPublisher(this.getTopic())).onWatchKubeConfigChanged(value2);
    }

    public final boolean getRefreshResourcesAfterActionConfig() {
        return ((GlobalState)this.getState()).getRefreshResourcesAfterAction();
    }

    public final void setRefreshResourcesAfterActionConfig(boolean value2) {
        boolean oldValue = ((GlobalState)this.getState()).getRefreshResourcesAfterAction();
        if (oldValue == value2) {
            return;
        }
        ((GlobalState)this.getState()).setRefreshResourcesAfterAction(value2);
        ((Listener)this.getMessageBus().syncPublisher(this.getTopic())).onWatchKubeConfigChanged(value2);
    }

    @JvmStatic
    @NotNull
    public static final KubernetesApiGlobalSettings getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @Nullable
    public static final Object getInstanceAsync(@NotNull Continuation<? super KubernetesApiGlobalSettings> $completion) {
        return Companion.getInstanceAsync($completion);
    }

    static {
        String displayName$iv = "K8s API global settings changes";
        Topic.BroadcastDirection direction$iv = Topic.BroadcastDirection.TO_CHILDREN;
        boolean $i$f$createTopic = false;
        Topic topic = Topic.create((String)displayName$iv, Listener.class, (Topic.BroadcastDirection)direction$iv);
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"create(...)");
        TOPIC = topic;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\u000e\u0010\b\u001a\u00020\u0007H\u0087@\u00a2\u0006\u0002\u0010\tR\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/kubernetes/api/settings/KubernetesApiGlobalSettings$Companion;", "", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/kubernetes/api/settings/KubernetesApiGlobalSettings$Listener;", "getInstance", "Lcom/intellij/kubernetes/api/settings/KubernetesApiGlobalSettings;", "getInstanceAsync", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nKubernetesApiGlobalSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesApiGlobalSettings.kt\ncom/intellij/kubernetes/api/settings/KubernetesApiGlobalSettings$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,133:1\n40#2,3:134\n78#3:137\n*S KotlinDebug\n*F\n+ 1 KubernetesApiGlobalSettings.kt\ncom/intellij/kubernetes/api/settings/KubernetesApiGlobalSettings$Companion\n*L\n27#1:134,3\n30#1:137\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final KubernetesApiGlobalSettings getInstance() {
            boolean $i$f$service = false;
            Class<KubernetesApiGlobalSettings> serviceClass$iv = KubernetesApiGlobalSettings.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (KubernetesApiGlobalSettings)((Object)object);
        }

        @JvmStatic
        @Nullable
        public final Object getInstanceAsync(@NotNull Continuation<? super KubernetesApiGlobalSettings> $completion) {
            boolean $i$f$serviceAsync = false;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
            return ((ComponentManagerEx)application).getServiceAsync(KubernetesApiGlobalSettings.class, $completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R/\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR/\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u000b\u001a\u0004\b\r\u0010\u0007\"\u0004\b\u000e\u0010\tR+\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00108F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u000b\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R+\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00108F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u000b\u001a\u0004\b\u0018\u0010\u0013\"\u0004\b\u0019\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lcom/intellij/kubernetes/api/settings/KubernetesApiGlobalSettings$GlobalState;", "Lcom/intellij/kubernetes/api/settings/KubernetesApiSettings$State;", "()V", "<set-?>", "", "helmPath", "getHelmPath", "()Ljava/lang/String;", "setHelmPath", "(Ljava/lang/String;)V", "helmPath$delegate", "Lkotlin/properties/ReadWriteProperty;", "kubectlPath", "getKubectlPath", "setKubectlPath", "kubectlPath$delegate", "", "refreshResourcesAfterAction", "getRefreshResourcesAfterAction", "()Z", "setRefreshResourcesAfterAction", "(Z)V", "refreshResourcesAfterAction$delegate", "watchKubeConfig", "getWatchKubeConfig", "setWatchKubeConfig", "watchKubeConfig$delegate", "intellij.clouds.kubernetes"})
    public static final class GlobalState
    extends KubernetesApiSettings.State {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty kubectlPath$delegate = BaseState.string$default((BaseState)this, null, (int)1, null).provideDelegate((Object)this, $$delegatedProperties[0]);
        @NotNull
        private final ReadWriteProperty helmPath$delegate = BaseState.string$default((BaseState)this, null, (int)1, null).provideDelegate((Object)this, $$delegatedProperties[1]);
        @NotNull
        private final ReadWriteProperty watchKubeConfig$delegate = this.property(true).provideDelegate((Object)this, $$delegatedProperties[2]);
        @NotNull
        private final ReadWriteProperty refreshResourcesAfterAction$delegate = this.property(true).provideDelegate((Object)this, $$delegatedProperties[3]);

        @Nullable
        public final String getKubectlPath() {
            return (String)this.kubectlPath$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setKubectlPath(@Nullable String string) {
            this.kubectlPath$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)string);
        }

        @Nullable
        public final String getHelmPath() {
            return (String)this.helmPath$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        public final void setHelmPath(@Nullable String string) {
            this.helmPath$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)string);
        }

        public final boolean getWatchKubeConfig() {
            return (Boolean)this.watchKubeConfig$delegate.getValue((Object)this, $$delegatedProperties[2]);
        }

        public final void setWatchKubeConfig(boolean bl) {
            this.watchKubeConfig$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)bl);
        }

        public final boolean getRefreshResourcesAfterAction() {
            return (Boolean)this.refreshResourcesAfterAction$delegate.getValue((Object)this, $$delegatedProperties[3]);
        }

        public final void setRefreshResourcesAfterAction(boolean bl) {
            this.refreshResourcesAfterAction$delegate.setValue((Object)this, $$delegatedProperties[3], (Object)bl);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(GlobalState.class, "kubectlPath", "getKubectlPath()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(GlobalState.class, "helmPath", "getHelmPath()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(GlobalState.class, "watchKubeConfig", "getWatchKubeConfig()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(GlobalState.class, "refreshResourcesAfterAction", "getRefreshResourcesAfterAction()Z", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/kubernetes/api/settings/KubernetesApiGlobalSettings$Listener;", "Lcom/intellij/kubernetes/api/settings/KubernetesApiSettings$Listener;", "onKubectlPathChanged", "", "oldPath", "", "newPath", "onWatchKubeConfigChanged", "value", "", "intellij.clouds.kubernetes"})
    public static interface Listener
    extends KubernetesApiSettings.Listener {
        default public void onKubectlPathChanged(@Nullable String oldPath, @Nullable String newPath) {
        }

        default public void onWatchKubeConfigChanged(boolean value2) {
        }
    }
}

