/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.api;

import com.google.gson.reflect.TypeToken;
import com.intellij.kubernetes.api.ApiClientTools;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.api.KubernetesEntity;
import com.intellij.kubernetes.api.KubernetesKtorWatch;
import com.intellij.kubernetes.api.KubernetesKtorWatchKt;
import com.intellij.kubernetes.api.KubernetesWatchFactory;
import io.ktor.client.HttpClient;
import io.ktor.client.plugins.HttpTimeoutKt;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.http.HttpMethod;
import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.util.Watch;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J@\u0010\r\u001a\u00020\f\"\b\b\u0000\u0010\u000e*\u00020\u000f\"\b\b\u0001\u0010\u0005*\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u000e0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J.\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u000e\u0010\u0010\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00112\u0006\u0010\t\u001a\u00020\nJM\u0010\u0015\u001a\u00020\f\"\b\b\u0000\u0010\u000e*\u00020\u000f\"\b\b\u0001\u0010\u0005*\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u000e0\u00112\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0017J\u001d\u0010\u0018\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ&\u0010\u001c\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0 0\u001dH\u0002\u00a8\u0006!"}, d2={"Lcom/intellij/kubernetes/api/KubernetesWatchFactory;", "", "()V", "createKtorWatch", "Lcom/intellij/kubernetes/api/KubernetesKtorWatch;", "T", "Lio/kubernetes/client/common/KubernetesObject;", "typeToken", "Lcom/google/gson/reflect/TypeToken;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "builder", "Lio/ktor/client/request/HttpRequestBuilder;", "createKubernetesHttpRequestBuilderWithProxy", "L", "Lio/kubernetes/client/common/KubernetesListObject;", "entity", "Lcom/intellij/kubernetes/api/KubernetesEntity;", "watch", "", "createResourceWatch", "getHttpRequestBuilder", "useProxy", "getHttpRequestBuilder$intellij_clouds_kubernetes", "getHttpRequestSelfSubjectAccessReviewBuilder", "resource", "", "getHttpRequestSelfSubjectAccessReviewBuilder$intellij_clouds_kubernetes", "prepareParams", "Lkotlin/Pair;", "", "Lio/kubernetes/client/openapi/Pair;", "", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesWatchFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesWatchFactory.kt\ncom/intellij/kubernetes/api/KubernetesWatchFactory\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,217:1\n125#2:218\n152#2,3:219\n26#3:222\n*S KotlinDebug\n*F\n+ 1 KubernetesWatchFactory.kt\ncom/intellij/kubernetes/api/KubernetesWatchFactory\n*L\n110#1:218\n110#1:219,3\n120#1:222\n*E\n"})
public final class KubernetesWatchFactory {
    @NotNull
    public static final KubernetesWatchFactory INSTANCE = new KubernetesWatchFactory();

    private KubernetesWatchFactory() {
    }

    @NotNull
    public final <L extends KubernetesListObject, T extends KubernetesObject> HttpRequestBuilder getHttpRequestBuilder$intellij_clouds_kubernetes(@NotNull KubernetesApiModel apiModel2, @NotNull KubernetesEntity<T, L> entity, boolean useProxy, boolean watch2) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        if (!useProxy) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        HttpRequestBuilder builder = this.createKubernetesHttpRequestBuilderWithProxy(apiModel2, entity, watch2);
        HttpTimeoutKt.timeout((HttpRequestBuilder)builder, (Function1)getHttpRequestBuilder.1.INSTANCE);
        return builder;
    }

    private final <L extends KubernetesListObject, T extends KubernetesObject> HttpRequestBuilder createKubernetesHttpRequestBuilderWithProxy(KubernetesApiModel apiModel2, KubernetesEntity<T, L> entity, boolean watch2) {
        KubernetesApiModel $this$createKubernetesHttpRequestBuilderWithProxy_u24lambda_u240 = apiModel2;
        boolean bl = false;
        Pair<List<io.kubernetes.client.openapi.Pair>, Map<String, String>> pair = INSTANCE.prepareParams();
        List queryParams = (List)pair.component1();
        Map headerParams = (Map)pair.component2();
        String string = SequencesKt.joinToString$default(entity.apiPathSegments($this$createKubernetesHttpRequestBuilderWithProxy_u24lambda_u240.getNamespaceForRequest(), watch2), (CharSequence)"/", (CharSequence)"/", (CharSequence)"/", (int)0, null, null, (int)56, null);
        HttpMethod httpMethod = HttpMethod.Companion.getGet();
        List list2 = CollectionsKt.toMutableList((Collection)queryParams);
        String string2 = "http://127.0.0.1:" + $this$createKubernetesHttpRequestBuilderWithProxy_u24lambda_u240.getProxy$intellij_clouds_kubernetes().getProxyPort();
        HttpRequestBuilder builder = KubernetesKtorWatchKt.buildKtorRequest$default(string, httpMethod, list2, headerParams, string2, null, 32, null);
        return builder;
    }

    @NotNull
    public final HttpRequestBuilder getHttpRequestSelfSubjectAccessReviewBuilder$intellij_clouds_kubernetes(@NotNull KubernetesApiModel apiModel2, @NotNull String resource) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        String postBody = StringsKt.trimIndent((String)("\n        {\n            \"apiVersion\": \"authorization.k8s.io/v1\",\n            \"kind\": \"SelfSubjectAccessReview\",\n            \"spec\": {\n                \"resourceAttributes\": {\n                    \"namespace\": \"" + apiModel2.getNamespaceForRequest() + "\",\n                    \"verb\": \"get\",\n                    \"resource\": \"" + resource + "\"\n                }\n            }\n        }\n    "));
        Pair[] pairArray = new Pair[2];
        String[] stringArray = new String[]{"application/json"};
        pairArray[0] = TuplesKt.to((Object)"Accept", (Object)ApiClientTools.INSTANCE.selectHeaderAccept(stringArray));
        pairArray[1] = TuplesKt.to((Object)"Content-Type", (Object)"application/json");
        Map headerParams = MapsKt.mapOf((Pair[])pairArray);
        stringArray = HttpMethod.Companion.getPost();
        String string = "http://127.0.0.1:" + apiModel2.getProxy$intellij_clouds_kubernetes().getProxyPort();
        List list2 = new ArrayList();
        HttpRequestBuilder builder = KubernetesKtorWatchKt.buildKtorRequest("/apis/authorization.k8s.io/v1/selfsubjectaccessreviews", (HttpMethod)stringArray, list2, headerParams, string, postBody);
        HttpTimeoutKt.timeout((HttpRequestBuilder)builder, (Function1)getHttpRequestSelfSubjectAccessReviewBuilder.1.INSTANCE);
        return builder;
    }

    @NotNull
    public final <T extends KubernetesObject> KubernetesKtorWatch<T> createResourceWatch(@NotNull KubernetesEntity<?, ?> entity, @NotNull KubernetesApiModel apiModel2) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Type[] typeArray = new Type[]{JvmClassMappingKt.getJavaClass(entity.getType())};
        TypeToken typeToken = TypeToken.getParameterized((Type)((Type)((Object)Watch.Response.class)), (Type[])typeArray);
        if (!apiModel2.getProxy$intellij_clouds_kubernetes().getProxyIsRunning()) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        HttpRequestBuilder builder = this.createKubernetesHttpRequestBuilderWithProxy(apiModel2, entity, true);
        Intrinsics.checkNotNull((Object)typeToken);
        return this.createKtorWatch(typeToken, apiModel2, builder);
    }

    private final <T extends KubernetesObject> KubernetesKtorWatch<T> createKtorWatch(TypeToken<?> typeToken, KubernetesApiModel apiModel2, HttpRequestBuilder builder) {
        HttpClient httpClient = apiModel2.getKtorClient();
        KubernetesKtorWatch watch2 = new KubernetesKtorWatch(apiModel2.getCoroutineScope(), httpClient, builder, typeToken);
        return watch2;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<io.kubernetes.client.openapi.Pair>, Map<String, String>> prepareParams() {
        void $this$mapTo$iv$iv;
        Pair[] $this$map$iv = MapsKt.mapOf((Pair)TuplesKt.to((Object)"timeoutSeconds", (Object)0));
        boolean $i$f$map22 = false;
        Pair[] pairArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String key2 = (String)entry.getKey();
            int value2 = ((Number)entry.getValue()).intValue();
            collection.add(new io.kubernetes.client.openapi.Pair(key2, ApiClientTools.INSTANCE.parameterToString(value2)));
        }
        List queryParams = (List)destination$iv$iv;
        String[] $i$f$map22 = new String[]{"application/json", "application/json;stream=watch"};
        String[] accepts = $i$f$map22;
        pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"Accept", (Object)ApiClientTools.INSTANCE.selectHeaderAccept(accepts));
        boolean $i$f$emptyArray = false;
        pairArray[1] = TuplesKt.to((Object)"Content-Type", (Object)ApiClientTools.INSTANCE.selectHeaderContentType(new String[0]));
        Map headerParams = MapsKt.mapOf((Pair[])pairArray);
        return new Pair((Object)queryParams, (Object)headerParams);
    }
}

