/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.api;

import com.intellij.kubernetes.api.KubernetesCustomResource;
import com.intellij.kubernetes.api.KubernetesCustomResourceList;
import com.intellij.kubernetes.api.KubernetesEntity;
import com.intellij.kubernetes.api.KubernetesEntityKt;
import com.intellij.kubernetes.telepresence.TelepresenceObject;
import com.intellij.kubernetes.telepresence.TelepresenceObjectList;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.openapi.util.text.Strings;
import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.CoreV1Event;
import io.kubernetes.client.openapi.models.CoreV1EventList;
import io.kubernetes.client.openapi.models.V1ClusterRole;
import io.kubernetes.client.openapi.models.V1ClusterRoleList;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1ConfigMapList;
import io.kubernetes.client.openapi.models.V1CronJob;
import io.kubernetes.client.openapi.models.V1CronJobList;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinition;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionList;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionNames;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionSpec;
import io.kubernetes.client.openapi.models.V1DaemonSet;
import io.kubernetes.client.openapi.models.V1DaemonSetList;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1DeploymentList;
import io.kubernetes.client.openapi.models.V1Ingress;
import io.kubernetes.client.openapi.models.V1IngressList;
import io.kubernetes.client.openapi.models.V1Job;
import io.kubernetes.client.openapi.models.V1JobList;
import io.kubernetes.client.openapi.models.V1Namespace;
import io.kubernetes.client.openapi.models.V1NamespaceList;
import io.kubernetes.client.openapi.models.V1Node;
import io.kubernetes.client.openapi.models.V1NodeList;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1PersistentVolume;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaim;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaimList;
import io.kubernetes.client.openapi.models.V1PersistentVolumeList;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodList;
import io.kubernetes.client.openapi.models.V1ReplicaSet;
import io.kubernetes.client.openapi.models.V1ReplicaSetList;
import io.kubernetes.client.openapi.models.V1ReplicationController;
import io.kubernetes.client.openapi.models.V1ReplicationControllerList;
import io.kubernetes.client.openapi.models.V1Role;
import io.kubernetes.client.openapi.models.V1RoleList;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1SecretList;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceList;
import io.kubernetes.client.openapi.models.V1StatefulSet;
import io.kubernetes.client.openapi.models.V1StatefulSetList;
import io.kubernetes.client.openapi.models.V1StorageClass;
import io.kubernetes.client.openapi.models.V1StorageClassList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 **\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0005:\u0001*B\u007f\b\u0002\u0012\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u0012\u000b\u0010\t\u001a\u00070\u0007\u00a2\u0006\u0002\b\n\u0012\u000b\u0010\u000b\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\u000b\u0010\u000e\u001a\u00070\u0007\u00a2\u0006\u0002\b\n\u0012\u000b\u0010\u000f\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\r\u0012\u0011\u0010\u0011\u001a\r\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b0\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J*\u0010\u0011\u001a\r\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b0\"2\r\u0010#\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\n2\b\b\u0002\u0010$\u001a\u00020\u0014J\u0013\u0010%\u001a\u00020\u00142\b\u0010&\u001a\u0004\u0018\u00010\u0005H\u0096\u0002J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0007H\u0016R\u001c\u0010\u0011\u001a\r\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\t\u001a\u00070\u0007\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u000e\u001a\u00070\u0007\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u001bR\u0016\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\u000b\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019R\u0016\u0010\u000f\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0019R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001e\u00a8\u0006+"}, d2={"Lcom/intellij/kubernetes/api/KubernetesEntity;", "T", "Lio/kubernetes/client/common/KubernetesObject;", "L", "Lio/kubernetes/client/common/KubernetesListObject;", "", "kind", "", "Lorg/jetbrains/annotations/NonNls;", "displayableKind", "Lcom/intellij/openapi/util/NlsSafe;", "resource", "type", "Lkotlin/reflect/KClass;", "displayableKinds", "resources", "listType", "apiPathSegments", "", "isNamespaced", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/reflect/KClass;Ljava/lang/String;Ljava/lang/String;Lkotlin/reflect/KClass;Ljava/util/List;Z)V", "getApiPathSegments", "()Ljava/util/List;", "getDisplayableKind", "()Ljava/lang/String;", "getDisplayableKinds", "()Z", "getKind", "getListType", "()Lkotlin/reflect/KClass;", "getResource", "getResources", "getType", "Lkotlin/sequences/Sequence;", "namespace", "watch", "equals", "other", "hashCode", "", "toString", "Companion", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesEntity.kt\ncom/intellij/kubernetes/api/KubernetesEntity\n+ 2 KubernetesEntity.kt\ncom/intellij/kubernetes/api/KubernetesEntity$Companion\n*L\n1#1,281:1\n264#2,15:282\n257#2,22:297\n257#2,22:319\n264#2,15:341\n257#2,22:356\n257#2,22:378\n257#2,22:400\n257#2,22:422\n257#2,22:444\n257#2,22:466\n257#2,22:488\n257#2,22:510\n257#2,22:532\n257#2,22:554\n257#2,22:576\n257#2,22:598\n257#2,22:620\n257#2,22:642\n257#2,22:664\n257#2,22:686\n264#2,15:708\n*S KotlinDebug\n*F\n+ 1 KubernetesEntity.kt\ncom/intellij/kubernetes/api/KubernetesEntity\n*L\n77#1:282,15\n85#1:297,22\n91#1:319,22\n98#1:341,15\n106#1:356,22\n113#1:378,22\n120#1:400,22\n126#1:422,22\n133#1:444,22\n140#1:466,22\n147#1:488,22\n154#1:510,22\n161#1:532,22\n167#1:554,22\n173#1:576,22\n179#1:598,22\n186#1:620,22\n193#1:642,22\n199#1:664,22\n205#1:686,22\n212#1:708,15\n*E\n"})
public final class KubernetesEntity<T extends KubernetesObject, L extends KubernetesListObject> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String kind;
    @NotNull
    private final String displayableKind;
    @NotNull
    private final String resource;
    @NotNull
    private final KClass<T> type;
    @NotNull
    private final String displayableKinds;
    @NotNull
    private final String resources;
    @NotNull
    private final KClass<L> listType;
    @NotNull
    private final List<String> apiPathSegments;
    private final boolean isNamespaced;
    @NotNull
    private static final Map<String, KubernetesEntity<?, ?>> entities;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1ClusterRole, V1ClusterRoleList> ClusterRole;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1ConfigMap, V1ConfigMapList> ConfigMap;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1CronJob, V1CronJobList> CronJob;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1CustomResourceDefinition, V1CustomResourceDefinitionList> CustomResourceDefinition;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1DaemonSet, V1DaemonSetList> DaemonSet;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1Deployment, V1DeploymentList> Deployment;
    @JvmField
    @NotNull
    public static final KubernetesEntity<CoreV1Event, CoreV1EventList> Event;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1Namespace, V1NamespaceList> Namespace;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1Ingress, V1IngressList> Ingress;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1Job, V1JobList> Job;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1Node, V1NodeList> Node;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1PersistentVolume, V1PersistentVolumeList> PersistentVolume;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1PersistentVolumeClaim, V1PersistentVolumeClaimList> PersistentVolumeClaim;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1Pod, V1PodList> Pod;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1ReplicationController, V1ReplicationControllerList> ReplicationController;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1ReplicaSet, V1ReplicaSetList> ReplicaSet;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1Role, V1RoleList> Role;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1Secret, V1SecretList> Secrets;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1Service, V1ServiceList> Service;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1StatefulSet, V1StatefulSetList> StatefulSet;
    @JvmField
    @NotNull
    public static final KubernetesEntity<V1StorageClass, V1StorageClassList> StorageClass;
    @JvmField
    @NotNull
    public static final KubernetesEntity<TelepresenceObject, TelepresenceObjectList> TelepresenceInterception;

    private KubernetesEntity(String kind, String displayableKind, String resource, KClass<T> type, String displayableKinds, String resources2, KClass<L> listType, List<String> apiPathSegments, boolean isNamespaced) {
        this.kind = kind;
        this.displayableKind = displayableKind;
        this.resource = resource;
        this.type = type;
        this.displayableKinds = displayableKinds;
        this.resources = resources2;
        this.listType = listType;
        this.apiPathSegments = apiPathSegments;
        this.isNamespaced = isNamespaced;
        entities.put(this.kind, this);
    }

    @NotNull
    public final String getKind() {
        return this.kind;
    }

    @NotNull
    public final String getDisplayableKind() {
        return this.displayableKind;
    }

    @NotNull
    public final String getResource() {
        return this.resource;
    }

    @NotNull
    public final KClass<T> getType() {
        return this.type;
    }

    @NotNull
    public final String getDisplayableKinds() {
        return this.displayableKinds;
    }

    @NotNull
    public final String getResources() {
        return this.resources;
    }

    @NotNull
    public final KClass<L> getListType() {
        return this.listType;
    }

    @NotNull
    public final List<String> getApiPathSegments() {
        return this.apiPathSegments;
    }

    public final boolean isNamespaced() {
        return this.isNamespaced;
    }

    @NotNull
    public final Sequence<String> apiPathSegments(@Nullable String namespace, boolean watch2) {
        Sequence sequence2;
        Sequence sequence3;
        Object[] objectArray;
        Sequence sequence4 = CollectionsKt.asSequence((Iterable)this.apiPathSegments);
        if (watch2) {
            objectArray = new String[]{"watch"};
            sequence3 = SequencesKt.sequenceOf((Object[])objectArray);
        } else {
            sequence3 = SequencesKt.emptySequence();
        }
        Sequence sequence5 = SequencesKt.plus((Sequence)sequence4, (Sequence)sequence3);
        if (this.isNamespaced && namespace != null) {
            objectArray = new String[]{"namespaces", namespace};
            sequence2 = SequencesKt.sequenceOf((Object[])objectArray);
        } else {
            sequence2 = SequencesKt.emptySequence();
        }
        return SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)sequence5, (Sequence)sequence2), (Object)this.resources);
    }

    public static /* synthetic */ Sequence apiPathSegments$default(KubernetesEntity kubernetesEntity, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return kubernetesEntity.apiPathSegments(string, bl);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.kubernetes.api.KubernetesEntity<*, *>");
        KubernetesEntity cfr_ignored_0 = (KubernetesEntity)other;
        return Intrinsics.areEqual((Object)this.kind, (Object)((KubernetesEntity)other).kind) && Intrinsics.areEqual(this.type, ((KubernetesEntity)other).type) && Intrinsics.areEqual((Object)this.resource, (Object)((KubernetesEntity)other).resource) && this.isNamespaced == ((KubernetesEntity)other).isNamespaced;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.kind, this.type, this.resource, this.isNamespaced};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        return StringsKt.trimMargin$default((String)("KubernetesEntity(kind='" + this.kind + "',\n    | displayableKind='" + this.displayableKind + "', \n    | resource='" + this.resource + "', \n    | type=" + this.type + ", \n    | displayableKinds='" + this.displayableKinds + "', \n    | resources='" + this.resources + "', \n    | listType=" + this.listType + ", \n    | isNamespaced=" + this.isNamespaced + ")"), null, (int)1, null);
    }

    @JvmStatic
    @NotNull
    public static final KubernetesEntity<KubernetesCustomResource, KubernetesCustomResourceList> createCustomResource(@NotNull V1CustomResourceDefinition definition, boolean isNamespaced) {
        return Companion.createCustomResource(definition, isNamespaced);
    }

    public /* synthetic */ KubernetesEntity(String kind, String displayableKind, String resource, KClass type, String displayableKinds, String resources2, KClass listType, List apiPathSegments, boolean isNamespaced, DefaultConstructorMarker $constructor_marker) {
        this(kind, displayableKind, resource, type, displayableKinds, resources2, listType, apiPathSegments, isNamespaced);
    }

    /*
     * WARNING - void declaration
     */
    static {
        String displayableKinds$iv;
        Object displayableKind$iv;
        boolean isNamespaced$iv;
        void displayableKinds$iv2;
        String displayableKind$iv2;
        Companion = new Companion(null);
        entities = new LinkedHashMap();
        KubernetesEntity kubernetesEntity = KubernetesEntityKt.access$getApisRbacAuthV1Segments$p();
        Companion companion = Companion;
        String string = "Cluster Role";
        String string2 = "Cluster Roles";
        boolean bl = false;
        Function0 lazyMapper$iv = Companion.ClusterRole.1.INSTANCE;
        boolean $i$f$createStandard = false;
        String kind$iv = StringsKt.replace$default((String)displayableKind$iv2, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string3 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        KClass kClass = Reflection.getOrCreateKotlinClass(V1ClusterRole.class);
        String string4 = StringsKt.replace$default((String)displayableKinds$iv2, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        KubernetesEntity entity$iv = new KubernetesEntity(kind$iv, displayableKind$iv2, string3, kClass, (String)displayableKinds$iv2, string4, Reflection.getOrCreateKotlinClass(V1ClusterRoleList.class), (List)((Object)kubernetesEntity), isNamespaced$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        ClusterRole = entity$iv;
        kubernetesEntity = Companion;
        String this_$iv = "Config Map";
        displayableKind$iv2 = "Config Maps";
        lazyMapper$iv = Companion.ConfigMap.1.INSTANCE;
        Object apiPathSegments$iv = KubernetesEntityKt.access$getApiV1PathSegments$p();
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string5 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
        KClass kClass2 = Reflection.getOrCreateKotlinClass(V1ConfigMap.class);
        String string6 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, (String)displayableKind$iv, string5, kClass2, displayableKinds$iv, string6, Reflection.getOrCreateKotlinClass(V1ConfigMapList.class), (List)apiPathSegments$iv, isNamespaced$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        ConfigMap = entity$iv;
        Companion $this$iv = Companion;
        displayableKind$iv = "Cron Job";
        displayableKinds$iv = "Cron Jobs";
        apiPathSegments$iv = KubernetesEntityKt.access$getApisBatchIOPathSegments$p();
        lazyMapper$iv = Companion.CronJob.1.INSTANCE;
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string7 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toLowerCase(...)");
        KClass kClass3 = Reflection.getOrCreateKotlinClass(V1CronJob.class);
        String string8 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, (String)displayableKind$iv, string7, kClass3, displayableKinds$iv, string8, Reflection.getOrCreateKotlinClass(V1CronJobList.class), (List)apiPathSegments$iv, isNamespaced$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        CronJob = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Custom Resource Definition";
        displayableKinds$iv = "Custom Resource Definitions";
        apiPathSegments$iv = KubernetesEntityKt.access$getApisExtensionsIOPathSegments$p();
        isNamespaced$iv = false;
        lazyMapper$iv = Companion.CustomResourceDefinition.1.INSTANCE;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string9 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toLowerCase(...)");
        KClass kClass4 = Reflection.getOrCreateKotlinClass(V1CustomResourceDefinition.class);
        String string10 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, (String)displayableKind$iv, string9, kClass4, displayableKinds$iv, string10, Reflection.getOrCreateKotlinClass(V1CustomResourceDefinitionList.class), (List)apiPathSegments$iv, isNamespaced$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        CustomResourceDefinition = entity$iv;
        Companion this_$iv2 = Companion;
        displayableKind$iv = "Daemon Set";
        displayableKinds$iv = "Daemon Sets";
        apiPathSegments$iv = KubernetesEntityKt.access$getApisAppsPathSegments$p();
        lazyMapper$iv = Companion.DaemonSet.1.INSTANCE;
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string11 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"toLowerCase(...)");
        KClass kClass5 = Reflection.getOrCreateKotlinClass(V1DaemonSet.class);
        String string12 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, (String)displayableKind$iv, string11, kClass5, displayableKinds$iv, string12, Reflection.getOrCreateKotlinClass(V1DaemonSetList.class), (List)apiPathSegments$iv, isNamespaced$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        DaemonSet = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Deployment";
        displayableKinds$iv = "Deployments";
        apiPathSegments$iv = KubernetesEntityKt.access$getApisAppsPathSegments$p();
        lazyMapper$iv = Companion.Deployment.1.INSTANCE;
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string13 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"toLowerCase(...)");
        KClass kClass6 = Reflection.getOrCreateKotlinClass(V1Deployment.class);
        String string14 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, (String)displayableKind$iv, string13, kClass6, displayableKinds$iv, string14, Reflection.getOrCreateKotlinClass(V1DeploymentList.class), (List)apiPathSegments$iv, isNamespaced$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        Deployment = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "event";
        displayableKinds$iv = "events";
        lazyMapper$iv = Companion.Event.1.INSTANCE;
        apiPathSegments$iv = KubernetesEntityKt.access$getApiV1PathSegments$p();
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string15 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"toLowerCase(...)");
        KClass kClass7 = Reflection.getOrCreateKotlinClass(CoreV1Event.class);
        String string16 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, (String)displayableKind$iv, string15, kClass7, displayableKinds$iv, string16, Reflection.getOrCreateKotlinClass(CoreV1EventList.class), (List)apiPathSegments$iv, isNamespaced$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        Event = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Namespace";
        displayableKinds$iv = "Namespaces";
        isNamespaced$iv = false;
        lazyMapper$iv = Companion.Namespace.1.INSTANCE;
        apiPathSegments$iv = KubernetesEntityKt.access$getApiV1PathSegments$p();
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string17 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"toLowerCase(...)");
        KClass kClass8 = Reflection.getOrCreateKotlinClass(V1Namespace.class);
        String string18 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, (String)displayableKind$iv, string17, kClass8, displayableKinds$iv, string18, Reflection.getOrCreateKotlinClass(V1NamespaceList.class), (List)apiPathSegments$iv, isNamespaced$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        Namespace = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Ingress";
        displayableKinds$iv = "Ingresses";
        apiPathSegments$iv = new String[]{"apis", "networking.k8s.io", "v1"};
        apiPathSegments$iv = CollectionsKt.listOf((Object[])apiPathSegments$iv);
        lazyMapper$iv = Companion.Ingress.1.INSTANCE;
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string19 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string19, (String)"toLowerCase(...)");
        KClass kClass9 = Reflection.getOrCreateKotlinClass(V1Ingress.class);
        String string20 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string20, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, (String)displayableKind$iv, string19, kClass9, displayableKinds$iv, string20, Reflection.getOrCreateKotlinClass(V1IngressList.class), (List)apiPathSegments$iv, isNamespaced$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        Ingress = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Job";
        displayableKinds$iv = "Jobs";
        apiPathSegments$iv = KubernetesEntityKt.access$getApisBatchIOPathSegments$p();
        lazyMapper$iv = Companion.Job.1.INSTANCE;
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string21 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string21, (String)"toLowerCase(...)");
        KClass kClass10 = Reflection.getOrCreateKotlinClass(V1Job.class);
        String string22 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string22, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, (String)displayableKind$iv, string21, kClass10, displayableKinds$iv, string22, Reflection.getOrCreateKotlinClass(V1JobList.class), (List)apiPathSegments$iv, isNamespaced$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        Job = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Node";
        displayableKinds$iv = "Nodes";
        isNamespaced$iv = false;
        lazyMapper$iv = Companion.Node.1.INSTANCE;
        apiPathSegments$iv = KubernetesEntityKt.access$getApiV1PathSegments$p();
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string23 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string23, (String)"toLowerCase(...)");
        KClass kClass11 = Reflection.getOrCreateKotlinClass(V1Node.class);
        String string24 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string24, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, (String)displayableKind$iv, string23, kClass11, displayableKinds$iv, string24, Reflection.getOrCreateKotlinClass(V1NodeList.class), (List)apiPathSegments$iv, isNamespaced$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        Node = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Persistent Volume";
        displayableKinds$iv = "Persistent Volumes";
        isNamespaced$iv = false;
        lazyMapper$iv = Companion.PersistentVolume.1.INSTANCE;
        apiPathSegments$iv = KubernetesEntityKt.access$getApiV1PathSegments$p();
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string25 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string25, (String)"toLowerCase(...)");
        KClass kClass12 = Reflection.getOrCreateKotlinClass(V1PersistentVolume.class);
        String string26 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string26, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, (String)displayableKind$iv, string25, kClass12, displayableKinds$iv, string26, Reflection.getOrCreateKotlinClass(V1PersistentVolumeList.class), (List)apiPathSegments$iv, isNamespaced$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        PersistentVolume = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Persistent Volume Claim";
        displayableKinds$iv = "Persistent Volume Claims";
        lazyMapper$iv = Companion.PersistentVolumeClaim.1.INSTANCE;
        apiPathSegments$iv = KubernetesEntityKt.access$getApiV1PathSegments$p();
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string27 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string27, (String)"toLowerCase(...)");
        KClass kClass13 = Reflection.getOrCreateKotlinClass(V1PersistentVolumeClaim.class);
        String string28 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string28, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, (String)displayableKind$iv, string27, kClass13, displayableKinds$iv, string28, Reflection.getOrCreateKotlinClass(V1PersistentVolumeClaimList.class), (List)apiPathSegments$iv, isNamespaced$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        PersistentVolumeClaim = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Pod";
        displayableKinds$iv = "Pods";
        lazyMapper$iv = Companion.Pod.1.INSTANCE;
        apiPathSegments$iv = KubernetesEntityKt.access$getApiV1PathSegments$p();
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string29 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string29, (String)"toLowerCase(...)");
        KClass kClass14 = Reflection.getOrCreateKotlinClass(V1Pod.class);
        String string30 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string30, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, (String)displayableKind$iv, string29, kClass14, displayableKinds$iv, string30, Reflection.getOrCreateKotlinClass(V1PodList.class), (List)apiPathSegments$iv, isNamespaced$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        Pod = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Replication Controller";
        displayableKinds$iv = "Replication Controllers";
        lazyMapper$iv = Companion.ReplicationController.1.INSTANCE;
        apiPathSegments$iv = KubernetesEntityKt.access$getApiV1PathSegments$p();
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string31 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string31, (String)"toLowerCase(...)");
        KClass kClass15 = Reflection.getOrCreateKotlinClass(V1ReplicationController.class);
        String string32 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string32, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, (String)displayableKind$iv, string31, kClass15, displayableKinds$iv, string32, Reflection.getOrCreateKotlinClass(V1ReplicationControllerList.class), (List)apiPathSegments$iv, isNamespaced$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        ReplicationController = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Replica Set";
        displayableKinds$iv = "Replica Sets";
        apiPathSegments$iv = KubernetesEntityKt.access$getApisAppsPathSegments$p();
        lazyMapper$iv = Companion.ReplicaSet.1.INSTANCE;
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string33 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string33, (String)"toLowerCase(...)");
        KClass kClass16 = Reflection.getOrCreateKotlinClass(V1ReplicaSet.class);
        String string34 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string34, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, (String)displayableKind$iv, string33, kClass16, displayableKinds$iv, string34, Reflection.getOrCreateKotlinClass(V1ReplicaSetList.class), (List)apiPathSegments$iv, isNamespaced$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        ReplicaSet = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Role";
        displayableKinds$iv = "Roles";
        apiPathSegments$iv = KubernetesEntityKt.access$getApisRbacAuthV1Segments$p();
        lazyMapper$iv = Companion.Role.1.INSTANCE;
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string35 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string35, (String)"toLowerCase(...)");
        KClass kClass17 = Reflection.getOrCreateKotlinClass(V1Role.class);
        String string36 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string36, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, (String)displayableKind$iv, string35, kClass17, displayableKinds$iv, string36, Reflection.getOrCreateKotlinClass(V1RoleList.class), (List)apiPathSegments$iv, isNamespaced$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        Role = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Secret";
        displayableKinds$iv = "Secrets";
        lazyMapper$iv = Companion.Secrets.1.INSTANCE;
        apiPathSegments$iv = KubernetesEntityKt.access$getApiV1PathSegments$p();
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string37 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string37, (String)"toLowerCase(...)");
        KClass kClass18 = Reflection.getOrCreateKotlinClass(V1Secret.class);
        String string38 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string38, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, (String)displayableKind$iv, string37, kClass18, displayableKinds$iv, string38, Reflection.getOrCreateKotlinClass(V1SecretList.class), (List)apiPathSegments$iv, isNamespaced$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        Secrets = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Service";
        displayableKinds$iv = "Services";
        lazyMapper$iv = Companion.Service.1.INSTANCE;
        apiPathSegments$iv = KubernetesEntityKt.access$getApiV1PathSegments$p();
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string39 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string39, (String)"toLowerCase(...)");
        KClass kClass19 = Reflection.getOrCreateKotlinClass(V1Service.class);
        String string40 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string40, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, (String)displayableKind$iv, string39, kClass19, displayableKinds$iv, string40, Reflection.getOrCreateKotlinClass(V1ServiceList.class), (List)apiPathSegments$iv, isNamespaced$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        Service = entity$iv;
        $this$iv = Companion;
        displayableKind$iv = "Stateful Set";
        displayableKinds$iv = "Stateful Sets";
        apiPathSegments$iv = KubernetesEntityKt.access$getApisAppsPathSegments$p();
        lazyMapper$iv = Companion.StatefulSet.1.INSTANCE;
        isNamespaced$iv = true;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string41 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string41, (String)"toLowerCase(...)");
        KClass kClass20 = Reflection.getOrCreateKotlinClass(V1StatefulSet.class);
        String string42 = StringsKt.replace$default((String)displayableKinds$iv, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string42, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, (String)displayableKind$iv, string41, kClass20, displayableKinds$iv, string42, Reflection.getOrCreateKotlinClass(V1StatefulSetList.class), (List)apiPathSegments$iv, isNamespaced$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        StatefulSet = entity$iv;
        kubernetesEntity = KubernetesEntityKt.access$getApisStorageV1Segments$p();
        displayableKind$iv = Companion;
        displayableKinds$iv = "Storage Class";
        apiPathSegments$iv = "Storage Classes";
        isNamespaced$iv = false;
        lazyMapper$iv = Companion.StorageClass.1.INSTANCE;
        $i$f$createStandard = false;
        kind$iv = StringsKt.replace$default((String)displayableKind$iv2, (String)" ", (String)"", (boolean)false, (int)4, null);
        String string43 = kind$iv.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string43, (String)"toLowerCase(...)");
        KClass kClass21 = Reflection.getOrCreateKotlinClass(V1StorageClass.class);
        String string44 = StringsKt.replace$default((String)displayableKinds$iv2, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string44, (String)"toLowerCase(...)");
        entity$iv = new KubernetesEntity(kind$iv, displayableKind$iv2, string43, kClass21, (String)displayableKinds$iv2, string44, Reflection.getOrCreateKotlinClass(V1StorageClassList.class), (List)((Object)kubernetesEntity), isNamespaced$iv, null);
        KubernetesResourceMapper.Companion.registerMapper(entity$iv, lazyMapper$iv);
        StorageClass = entity$iv;
        KubernetesEntity $this$TelepresenceInterception_u24lambda_u240 = kubernetesEntity = new KubernetesEntity("Telepresence.Interception", "Telepresence Interception", "Telepresence", Reflection.getOrCreateKotlinClass(TelepresenceObject.class), "Telepresence Interceptions", "Telepresence", Reflection.getOrCreateKotlinClass(TelepresenceObjectList.class), CollectionsKt.emptyList(), false);
        boolean bl2 = false;
        KubernetesResourceMapper.Companion.registerMapper($this$TelepresenceInterception_u24lambda_u240, Companion.TelepresenceInterception.1.1.INSTANCE);
        TelepresenceInterception = kubernetesEntity;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010J\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020L0\u00042\u0006\u0010M\u001a\u00020\u000e2\u0006\u0010N\u001a\u00020OH\u0007J\u0082\u0001\u0010P\u001a\u000e\u0012\u0004\u0012\u0002HQ\u0012\u0004\u0012\u0002HR0\u0004\"\n\b\u0002\u0010Q\u0018\u0001*\u00020S\"\n\b\u0003\u0010R\u0018\u0001*\u00020T2\u000b\u0010U\u001a\u00070H\u00a2\u0006\u0002\bV2\u000b\u0010W\u001a\u00070H\u00a2\u0006\u0002\bV2\u0013\b\u0002\u0010X\u001a\r\u0012\t\u0012\u00070H\u00a2\u0006\u0002\bI0Y2\b\b\u0002\u0010N\u001a\u00020O2\u001a\b\b\u0010Z\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002HQ\u0012\u0004\u0012\u0002HR0\\0[H\u0082\bJ\u001d\u0010]\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00042\u000b\u0010^\u001a\u00070H\u00a2\u0006\u0002\bIR\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010%\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010(\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010+\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020-0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010.\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002000\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00101\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u0002030\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00104\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u0002060\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00107\u001a\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u0002090\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010:\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020<0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010=\u001a\u000e\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020?0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010@\u001a\u000e\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020B0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010C\u001a\u000e\u0012\u0004\u0012\u00020D\u0012\u0004\u0012\u00020E0\u00048\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R'\u0010F\u001a\u001b\u0012\t\u0012\u00070H\u00a2\u0006\u0002\bI\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00040GX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006_"}, d2={"Lcom/intellij/kubernetes/api/KubernetesEntity$Companion;", "", "()V", "ClusterRole", "Lcom/intellij/kubernetes/api/KubernetesEntity;", "Lio/kubernetes/client/openapi/models/V1ClusterRole;", "Lio/kubernetes/client/openapi/models/V1ClusterRoleList;", "ConfigMap", "Lio/kubernetes/client/openapi/models/V1ConfigMap;", "Lio/kubernetes/client/openapi/models/V1ConfigMapList;", "CronJob", "Lio/kubernetes/client/openapi/models/V1CronJob;", "Lio/kubernetes/client/openapi/models/V1CronJobList;", "CustomResourceDefinition", "Lio/kubernetes/client/openapi/models/V1CustomResourceDefinition;", "Lio/kubernetes/client/openapi/models/V1CustomResourceDefinitionList;", "DaemonSet", "Lio/kubernetes/client/openapi/models/V1DaemonSet;", "Lio/kubernetes/client/openapi/models/V1DaemonSetList;", "Deployment", "Lio/kubernetes/client/openapi/models/V1Deployment;", "Lio/kubernetes/client/openapi/models/V1DeploymentList;", "Event", "Lio/kubernetes/client/openapi/models/CoreV1Event;", "Lio/kubernetes/client/openapi/models/CoreV1EventList;", "Ingress", "Lio/kubernetes/client/openapi/models/V1Ingress;", "Lio/kubernetes/client/openapi/models/V1IngressList;", "Job", "Lio/kubernetes/client/openapi/models/V1Job;", "Lio/kubernetes/client/openapi/models/V1JobList;", "Namespace", "Lio/kubernetes/client/openapi/models/V1Namespace;", "Lio/kubernetes/client/openapi/models/V1NamespaceList;", "Node", "Lio/kubernetes/client/openapi/models/V1Node;", "Lio/kubernetes/client/openapi/models/V1NodeList;", "PersistentVolume", "Lio/kubernetes/client/openapi/models/V1PersistentVolume;", "Lio/kubernetes/client/openapi/models/V1PersistentVolumeList;", "PersistentVolumeClaim", "Lio/kubernetes/client/openapi/models/V1PersistentVolumeClaim;", "Lio/kubernetes/client/openapi/models/V1PersistentVolumeClaimList;", "Pod", "Lio/kubernetes/client/openapi/models/V1Pod;", "Lio/kubernetes/client/openapi/models/V1PodList;", "ReplicaSet", "Lio/kubernetes/client/openapi/models/V1ReplicaSet;", "Lio/kubernetes/client/openapi/models/V1ReplicaSetList;", "ReplicationController", "Lio/kubernetes/client/openapi/models/V1ReplicationController;", "Lio/kubernetes/client/openapi/models/V1ReplicationControllerList;", "Role", "Lio/kubernetes/client/openapi/models/V1Role;", "Lio/kubernetes/client/openapi/models/V1RoleList;", "Secrets", "Lio/kubernetes/client/openapi/models/V1Secret;", "Lio/kubernetes/client/openapi/models/V1SecretList;", "Service", "Lio/kubernetes/client/openapi/models/V1Service;", "Lio/kubernetes/client/openapi/models/V1ServiceList;", "StatefulSet", "Lio/kubernetes/client/openapi/models/V1StatefulSet;", "Lio/kubernetes/client/openapi/models/V1StatefulSetList;", "StorageClass", "Lio/kubernetes/client/openapi/models/V1StorageClass;", "Lio/kubernetes/client/openapi/models/V1StorageClassList;", "TelepresenceInterception", "Lcom/intellij/kubernetes/telepresence/TelepresenceObject;", "Lcom/intellij/kubernetes/telepresence/TelepresenceObjectList;", "entities", "", "", "Lorg/jetbrains/annotations/NonNls;", "createCustomResource", "Lcom/intellij/kubernetes/api/KubernetesCustomResource;", "Lcom/intellij/kubernetes/api/KubernetesCustomResourceList;", "definition", "isNamespaced", "", "createStandard", "T", "L", "Lio/kubernetes/client/common/KubernetesObject;", "Lio/kubernetes/client/common/KubernetesListObject;", "displayableKind", "Lcom/intellij/openapi/util/NlsSafe;", "displayableKinds", "apiPathSegments", "", "lazyMapper", "Lkotlin/Function0;", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "findByKind", "kind", "intellij.clouds.kubernetes"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final KubernetesEntity<?, ?> findByKind(@NotNull String kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return (KubernetesEntity)entities.get(kind);
        }

        @JvmStatic
        @NotNull
        public final KubernetesEntity<KubernetesCustomResource, KubernetesCustomResourceList> createCustomResource(@NotNull V1CustomResourceDefinition definition, boolean isNamespaced) {
            Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
            V1CustomResourceDefinitionSpec spec = definition.getSpec();
            V1CustomResourceDefinitionNames names2 = spec.getNames();
            String kind = names2.getKind();
            String string = names2.getSingular();
            if (string == null) {
                Intrinsics.checkNotNull((Object)kind);
                String string2 = kind.toLowerCase(Locale.ROOT);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            }
            String resource = string + "." + spec.getGroup();
            Intrinsics.checkNotNull((Object)kind);
            KClass kClass = Reflection.getOrCreateKotlinClass(KubernetesCustomResource.class);
            String string3 = Strings.pluralize((String)kind);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"pluralize(...)");
            V1ObjectMeta v1ObjectMeta = definition.getMetadata();
            Intrinsics.checkNotNull((Object)v1ObjectMeta);
            String string4 = v1ObjectMeta.getName();
            Intrinsics.checkNotNull((Object)string4);
            return new KubernetesEntity<KubernetesCustomResource, KubernetesCustomResourceList>(kind, kind, resource, kClass, string3, string4, Reflection.getOrCreateKotlinClass(KubernetesCustomResourceList.class), KubernetesEntityKt.access$getApisExtensionsIOPathSegments$p(), isNamespaced, null);
        }

        private final /* synthetic */ <T extends KubernetesObject, L extends KubernetesListObject> KubernetesEntity<T, L> createStandard(String displayableKind, String displayableKinds, List<String> apiPathSegments, boolean isNamespaced, Function0<? extends KubernetesResourceMapper<T, L>> lazyMapper) {
            boolean $i$f$createStandard = false;
            String kind = StringsKt.replace$default((String)displayableKind, (String)" ", (String)"", (boolean)false, (int)4, null);
            String string = kind.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            KClass kClass = Reflection.getOrCreateKotlinClass(KubernetesObject.class);
            String string2 = StringsKt.replace$default((String)displayableKinds, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            Intrinsics.reifiedOperationMarker((int)4, (String)"L");
            KubernetesEntity entity = new KubernetesEntity(kind, displayableKind, string, kClass, displayableKinds, string2, Reflection.getOrCreateKotlinClass(KubernetesListObject.class), apiPathSegments, isNamespaced, null);
            KubernetesResourceMapper.Companion.registerMapper(entity, lazyMapper);
            return entity;
        }

        static /* synthetic */ KubernetesEntity createStandard$default(Companion $this, String displayableKind, String displayableKinds, List apiPathSegments, boolean isNamespaced, Function0 lazyMapper, int n, Object object) {
            if ((n & 4) != 0) {
                apiPathSegments = KubernetesEntityKt.access$getApiV1PathSegments$p();
            }
            if ((n & 8) != 0) {
                isNamespaced = true;
            }
            boolean $i$f$createStandard = false;
            String kind = StringsKt.replace$default((String)displayableKind, (String)" ", (String)"", (boolean)false, (int)4, null);
            String string = kind.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            KClass kClass = Reflection.getOrCreateKotlinClass(KubernetesObject.class);
            String string2 = StringsKt.replace$default((String)displayableKinds, (String)" ", (String)"", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            Intrinsics.reifiedOperationMarker((int)4, (String)"L");
            KubernetesEntity entity = new KubernetesEntity(kind, displayableKind, string, kClass, displayableKinds, string2, Reflection.getOrCreateKotlinClass(KubernetesListObject.class), apiPathSegments, isNamespaced, null);
            KubernetesResourceMapper.Companion.registerMapper(entity, lazyMapper);
            return entity;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

