/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.intellij.kubernetes.K8sYamlMappings;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.gist.GistAstMarker;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.AstUtilKt;
import org.jetbrains.yaml.YAMLFileType;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/kubernetes/KubernetesYamlDetector;", "", "()V", "K8S_GIST_MARKER", "Lcom/intellij/util/gist/GistAstMarker;", "detectKubernetesYaml", "", "tree", "Lcom/intellij/lang/LighterAST;", "looksLikeKubernetesYaml", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesFileIconProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesFileIconProvider.kt\ncom/intellij/kubernetes/KubernetesYamlDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n2624#2,3:143\n*S KotlinDebug\n*F\n+ 1 KubernetesFileIconProvider.kt\ncom/intellij/kubernetes/KubernetesYamlDetector\n*L\n133#1:143,3\n*E\n"})
public final class KubernetesYamlDetector {
    @NotNull
    private final GistAstMarker K8S_GIST_MARKER;

    public KubernetesYamlDetector() {
        YAMLFileType yAMLFileType = YAMLFileType.YML;
        Intrinsics.checkNotNullExpressionValue((Object)yAMLFileType, (String)"YML");
        this.K8S_GIST_MARKER = new GistAstMarker((FileType)yAMLFileType, "K8S_YAML", (Function1)new Function1<LighterAST, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull LighterAST p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return KubernetesYamlDetector.access$detectKubernetesYaml((KubernetesYamlDetector)this.receiver, p0);
            }
        });
    }

    public final boolean looksLikeKubernetesYaml(@NotNull Project project2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.K8S_GIST_MARKER.accepts(project2, file2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean detectKubernetesYaml(LighterAST tree) {
        boolean bl;
        LighterASTNode lighterASTNode = tree.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)lighterASTNode, (String)"getRoot(...)");
        LighterASTNode astRoot = lighterASTNode;
        Ref.BooleanRef hasApiVersion = new Ref.BooleanRef();
        Ref.BooleanRef hasKind = new Ref.BooleanRef();
        AstUtilKt.visitTopLevelKeyPairs((LighterAST)tree, (Function2)((Function2)new Function2<CharSequence, LighterASTNode, Boolean>(hasKind, hasApiVersion){
            final /* synthetic */ Ref.BooleanRef $hasKind;
            final /* synthetic */ Ref.BooleanRef $hasApiVersion;
            {
                this.$hasKind = $hasKind;
                this.$hasApiVersion = $hasApiVersion;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull CharSequence key2, @NotNull LighterASTNode lighterASTNode) {
                Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
                Intrinsics.checkNotNullParameter((Object)lighterASTNode, (String)"<anonymous parameter 1>");
                CharSequence charSequence = key2;
                if (Intrinsics.areEqual((Object)charSequence, (Object)"kind")) {
                    this.$hasKind.element = true;
                } else if (Intrinsics.areEqual((Object)charSequence, (Object)"apiVersion")) {
                    this.$hasApiVersion.element = true;
                }
                return !this.$hasKind.element || !this.$hasApiVersion.element;
            }
        }));
        if (!hasApiVersion.element) return false;
        if (!hasKind.element) return false;
        List list2 = tree.getChildren(astRoot);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildren(...)");
        Iterable $this$none$iv = list2;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            LighterASTNode child = (LighterASTNode)element$iv;
            boolean bl2 = false;
            if (child instanceof LighterASTTokenNode && CollectionsKt.contains((Iterable)K8sYamlMappings.INSTANCE.getNO_K8S_ANALYZED_TOKENS(), (Object)((LighterASTTokenNode)child).getTokenType())) {
                CharSequence charSequence;
                Intrinsics.checkNotNullExpressionValue((Object)((LighterASTTokenNode)child).getText(), (String)"getText(...)");
                if (K8sYamlMappings.INSTANCE.getNO_K8S_DIRECTIVE_REGEX().containsMatchIn(charSequence)) {
                    return false;
                }
            }
            bl = false;
        } while (!bl);
        return false;
    }

    public static final /* synthetic */ boolean access$detectKubernetesYaml(KubernetesYamlDetector $this, LighterAST tree) {
        return $this.detectKubernetesYaml(tree);
    }
}

