/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.ChartLocator;
import com.intellij.kubernetes.helm.tgz.TgzFileSystem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00052\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kubernetes/KubernetesTreeStructureProvider;", "Lcom/intellij/ide/projectView/TreeStructureProvider;", "()V", "modify", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "parent", "children", "settings", "Lcom/intellij/ide/projectView/ViewSettings;", "TgzDirectoryNode", "intellij.clouds.kubernetes"})
public final class KubernetesTreeStructureProvider
implements TreeStructureProvider {
    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<AbstractTreeNode<?>> children, @Nullable ViewSettings settings2) {
        block16: {
            block15: {
                VirtualFile parentFile;
                block14: {
                    block13: {
                        Intrinsics.checkNotNullParameter(parent, (String)"parent");
                        Intrinsics.checkNotNullParameter(children, (String)"children");
                        if (!(parent instanceof ProjectViewNode)) {
                            return children;
                        }
                        if (((ProjectViewNode)parent).getProject() == null) {
                            return children;
                        }
                        VirtualFile virtualFile = parentFile = ((ProjectViewNode)parent).getVirtualFile();
                        if (virtualFile != null ? !virtualFile.isDirectory() : false) break block13;
                        VirtualFile virtualFile2 = parentFile;
                        if (Chart.Companion.isChartsDirName(virtualFile2 != null ? virtualFile2.getNameSequence() : null)) break block14;
                    }
                    return children;
                }
                VirtualFile virtualFile = parentFile;
                if ((virtualFile != null ? virtualFile.getParent() : null) == null) break block15;
                ChartLocator chartLocator = ChartLocator.Companion.instance();
                VirtualFile virtualFile3 = parentFile.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getParent(...)");
                if (chartLocator.locateChartByChartDir(virtualFile3) != null) break block16;
            }
            return children;
        }
        ArrayList<TgzDirectoryNode> result2 = new ArrayList<TgzDirectoryNode>();
        for (AbstractTreeNode<?> it : children) {
            if (it instanceof PsiFileNode && Chart.Companion.isHelmDependency(((PsiFileNode)it).getVirtualFile())) {
                PsiDirectory root;
                VirtualFile virtualFile = ((PsiFileNode)it).getVirtualFile();
                Intrinsics.checkNotNull((Object)virtualFile);
                if (TgzFileSystem.Companion.findRootByLocalArchive(virtualFile) != null) {
                    VirtualFile it2;
                    boolean bl = false;
                    Project project2 = ((ProjectViewNode)parent).getProject();
                    Intrinsics.checkNotNull((Object)project2);
                    v7 = PsiManager.getInstance((Project)project2).findDirectory(it2);
                } else {
                    v7 = root = null;
                }
                if (root != null) {
                    Project project3 = ((ProjectViewNode)parent).getProject();
                    Intrinsics.checkNotNull((Object)project3);
                    result2.add(new TgzDirectoryNode(project3, root, settings2));
                    continue;
                }
                result2.add((TgzDirectoryNode)it);
                continue;
            }
            result2.add((TgzDirectoryNode)it);
        }
        return result2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/kubernetes/KubernetesTreeStructureProvider$TgzDirectoryNode;", "Lcom/intellij/ide/projectView/impl/nodes/PsiDirectoryNode;", "project", "Lcom/intellij/openapi/project/Project;", "dir", "Lcom/intellij/psi/PsiDirectory;", "settings", "Lcom/intellij/ide/projectView/ViewSettings;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiDirectory;Lcom/intellij/ide/projectView/ViewSettings;)V", "getChildrenImpl", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nKubernetesTreeStructureProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesTreeStructureProvider.kt\ncom/intellij/kubernetes/KubernetesTreeStructureProvider$TgzDirectoryNode\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,69:1\n11065#2:70\n11400#2,3:71\n*S KotlinDebug\n*F\n+ 1 KubernetesTreeStructureProvider.kt\ncom/intellij/kubernetes/KubernetesTreeStructureProvider$TgzDirectoryNode\n*L\n65#1:70\n65#1:71,3\n*E\n"})
    public static final class TgzDirectoryNode
    extends PsiDirectoryNode {
        @NotNull
        private final PsiDirectory dir;

        public TgzDirectoryNode(@NotNull Project project2, @NotNull PsiDirectory dir, @Nullable ViewSettings settings2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            super(project2, dir, settings2);
            this.dir = dir;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Collection<AbstractTreeNode<?>> getChildrenImpl() {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            PsiDirectory[] psiDirectoryArray = this.dir.getSubdirectories();
            Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"getSubdirectories(...)");
            Sequence sequence2 = SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])psiDirectoryArray), (Function1)((Function1)new Function1<PsiDirectory, TgzDirectoryNode>(this){
                final /* synthetic */ TgzDirectoryNode this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final TgzDirectoryNode invoke(PsiDirectory it) {
                    Project project2 = this.this$0.getProject();
                    Intrinsics.checkNotNull((Object)project2);
                    Intrinsics.checkNotNull((Object)it);
                    return new TgzDirectoryNode(project2, it, this.this$0.getSettings());
                }
            }));
            PsiFile[] psiFileArray = this.dir.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)psiFileArray, (String)"getFiles(...)");
            Object[] objectArray = psiFileArray;
            Sequence sequence3 = sequence2;
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PsiFile psiFile = (PsiFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((AbstractTreeNode)new PsiFileNode(this.getProject(), (PsiFile)it, this.getSettings()));
            }
            return SequencesKt.toList((Sequence)SequencesKt.plus((Sequence)sequence3, (Iterable)((List)destination$iv$iv)));
        }
    }
}

