/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeInspectionBase;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.impl.YamlMissingKeysInspectionBase;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0012\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/kubernetes/KubernetesMissingKeysInspection;", "Lorg/jetbrains/yaml/meta/impl/YamlMissingKeysInspectionBase;", "()V", "doBuildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "metaTypeProvider", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "getElementToHighlight", "Lcom/intellij/psi/PsiElement;", "mapping", "Lorg/jetbrains/yaml/psi/YAMLMapping;", "getMetaTypeProvider", "AddMetadataNameQuickFix", "intellij.clouds.kubernetes"})
public final class KubernetesMissingKeysInspection
extends YamlMissingKeysInspectionBase {
    @NotNull
    protected PsiElementVisitor doBuildVisitor(@NotNull ProblemsHolder holder, @NotNull YamlMetaTypeProvider metaTypeProvider) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)metaTypeProvider, (String)"metaTypeProvider");
        if (KubernetesUtilKt.isKustomizeStrategicMergePatch(holder.getFile())) {
            PsiElementVisitor psiElementVisitor;
            PsiFile psiFile = holder.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
            if (!(YamlUtilKt.getVfsFile((PsiElement)psiFile) instanceof VirtualFileWindow)) {
                psiElementVisitor = (PsiElementVisitor)new YamlMetaTypeInspectionBase.SimpleYamlPsiVisitor(holder){
                    final /* synthetic */ ProblemsHolder $holder;
                    {
                        this.$holder = $holder;
                    }

                    protected void visitYAMLDocument(@NotNull YAMLDocument document) {
                        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                        YAMLMapping yAMLMapping = YamlUtilKt.getTopLevelMapping((PsiElement)document);
                        if (yAMLMapping == null) {
                            return;
                        }
                        YAMLMapping topMapping = yAMLMapping;
                        PsiElement reportElement = null;
                        String[] stringArray = new String[]{"metadata"};
                        YAMLKeyValue metadataKeyVal = YamlUtilKt.findElement(topMapping, stringArray);
                        if (metadataKeyVal == null) {
                            reportElement = (PsiElement)topMapping;
                        } else {
                            String[] stringArray2 = metadataKeyVal.getValue();
                            YAMLKeyValue nameKeyVal = YamlUtilKt.findElement(stringArray2 instanceof YAMLMapping ? (YAMLMapping)stringArray2 : null, stringArray2 = new String[]{"name"});
                            if (nameKeyVal == null) {
                                reportElement = metadataKeyVal.getKey();
                            }
                        }
                        if (reportElement != null) {
                            stringArray = new LocalQuickFix[]{new AddMetadataNameQuickFix(document)};
                            this.$holder.registerProblem(reportElement, KubernetesBundle.message("KubernetesMissingKeysInspection.kustomize.missing.patch.name.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])stringArray);
                        }
                    }
                };
            } else {
                PsiElementVisitor psiElementVisitor2 = PsiElementVisitor.EMPTY_VISITOR;
                psiElementVisitor = psiElementVisitor2;
                Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor2, (String)"EMPTY_VISITOR");
            }
            return psiElementVisitor;
        }
        return (PsiElementVisitor)new YamlMissingKeysInspectionBase.StructureChecker(this, holder, metaTypeProvider){

            protected void visitYAMLMapping(@NotNull YAMLMapping mapping) {
                Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
                for (PsiElement child = mapping.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (!(child instanceof OuterLanguageElement)) continue;
                    return;
                }
                PsiElement next = YamlUtilKt.getNextElement((PsiElement)mapping);
                while (next != null) {
                    if (next instanceof OuterLanguageElement) {
                        return;
                    }
                    if (next instanceof YAMLPsiElement) break;
                    next = YamlUtilKt.getNextElement(next);
                }
                super.visitYAMLMapping(mapping);
            }
        };
    }

    @Nullable
    protected YamlMetaTypeProvider getMetaTypeProvider(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return KubernetesUtilKt.getMetaTypeProvider(holder);
    }

    @NotNull
    protected PsiElement getElementToHighlight(@NotNull YAMLMapping mapping) {
        YAMLKeyValue apiVersionKeyVal;
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        if (mapping.getParent() instanceof YAMLDocument && (apiVersionKeyVal = YamlUtilKt.getKeyValueByKeyIgnoreSpaces(mapping, "kind")) != null) {
            return (PsiElement)apiVersionKeyVal;
        }
        PsiElement psiElement = super.getElementToHighlight(mapping);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElementToHighlight(...)");
        return psiElement;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J3\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0096\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/kubernetes/KubernetesMissingKeysInspection$AddMetadataNameQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "document", "Lorg/jetbrains/yaml/psi/YAMLDocument;", "(Lorg/jetbrains/yaml/psi/YAMLDocument;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.clouds.kubernetes"})
    private static final class AddMetadataNameQuickFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        public AddMetadataNameQuickFix(@NotNull YAMLDocument document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            super((PsiElement)document);
        }

        @NotNull
        public String getText() {
            String string = KubernetesBundle.message("KubernetesMissingKeysInspection.kustomize.add.name.quick.fix.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            block3: {
                Editor editor2;
                YAMLKeyValue nameKeyVal;
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
                Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
                YAMLDocument yAMLDocument = startElement instanceof YAMLDocument ? (YAMLDocument)startElement : null;
                if (yAMLDocument == null) {
                    return;
                }
                YAMLDocument document = yAMLDocument;
                YAMLMapping yAMLMapping = YamlUtilKt.getTopLevelMapping((PsiElement)document);
                if (yAMLMapping == null) {
                    return;
                }
                YAMLMapping topMapping = yAMLMapping;
                String[] stringArray = new String[]{"metadata"};
                YAMLKeyValue metadataKeyVal = YamlUtilKt.findElement(topMapping, stringArray);
                YAMLKeyValue yAMLKeyValue = metadataKeyVal;
                if (yAMLKeyValue == null || (yAMLKeyValue = YamlUtilKt.appendKey$default((YAMLPsiElement)yAMLKeyValue, "name", null, 2, null)) == null) {
                    yAMLKeyValue = nameKeyVal = YamlUtilKt.appendKey$default((YAMLPsiElement)YamlUtilKt.appendKey$default((YAMLPsiElement)topMapping, "metadata", null, 2, null), "name", null, 2, null);
                }
                if ((editor2 = editor) == null || (editor2 = editor2.getCaretModel()) == null) break block3;
                editor2.moveToOffset(nameKeyVal.getTextOffset() + nameKeyVal.getTextLength());
            }
        }
    }
}

