/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.kubernetes.cron;

import com.cronutils.model.definition.CronDefinition;
import com.intellij.clouds.kubernetes.cron.KubernetesCronDocumentationTarget;
import com.intellij.clouds.kubernetes.cron.KubernetesCronExpressionProviderKt;
import com.intellij.cron.CronDefinitionExpressionProvider;
import com.intellij.cron.CronExpLanguage;
import com.intellij.cron.CronExpressionProvider;
import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.model.KubernetesInjectionHostMixin;
import com.intellij.lang.Language;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/clouds/kubernetes/cron/KubernetesCronExpressionProvider;", "Lcom/intellij/cron/CronDefinitionExpressionProvider;", "()V", "languages", "", "Lcom/intellij/lang/Language;", "getLanguages", "()Ljava/util/Collection;", "supportId", "", "getSupportId", "()Ljava/lang/String;", "createDocumentationTarget", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "element", "Lcom/intellij/psi/PsiElement;", "cronCompletionExamples", "", "getCronDefinition", "Lcom/cronutils/model/definition/CronDefinition;", "cronExpr", "getCronExpression", "isSuitableElement", "", "intellij.clouds.kubernetes.cron"})
public final class KubernetesCronExpressionProvider
implements CronDefinitionExpressionProvider {
    @NotNull
    private final Collection<Language> languages = CollectionsKt.listOf((Object)YAMLLanguage.INSTANCE);
    @NotNull
    private final String supportId;

    public KubernetesCronExpressionProvider() {
        this.supportId = "yaml";
    }

    @NotNull
    public Collection<Language> getLanguages() {
        return this.languages;
    }

    @NotNull
    public String getSupportId() {
        return this.supportId;
    }

    public boolean isSuitableElement(@NotNull PsiElement element) {
        KubernetesInjectionHostMixin injection;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof YAMLScalar)) {
            return false;
        }
        YamlMetaType yamlMetaType = KubernetesUtilKt.getK8sMetaType((YAMLPsiElement)element);
        KubernetesInjectionHostMixin kubernetesInjectionHostMixin = injection = yamlMetaType instanceof KubernetesInjectionHostMixin ? (KubernetesInjectionHostMixin)yamlMetaType : null;
        Language languageToInject = kubernetesInjectionHostMixin != null ? kubernetesInjectionHostMixin.getLanguage((YAMLScalar)element) : null;
        return languageToInject instanceof CronExpLanguage;
    }

    @NotNull
    public CronDefinition getCronDefinition(@NotNull String cronExpr, @Nullable PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)cronExpr, (String)"cronExpr");
        CronDefinition cronDefinition = KubernetesCronExpressionProviderKt.access$getKUBERNETES_CRON_DEFINITION$p();
        Intrinsics.checkNotNullExpressionValue((Object)cronDefinition, (String)"access$getKUBERNETES_CRON_DEFINITION$p(...)");
        return cronDefinition;
    }

    @NotNull
    public List<String> cronCompletionExamples(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return KubernetesCronExpressionProviderKt.access$getKUBERNETES_CRON_EXAMPLES$p();
    }

    @Nullable
    public String getCronExpression(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof YAMLScalar)) {
            return null;
        }
        return ((YAMLScalar)element).getTextValue();
    }

    @NotNull
    public DocumentationTarget createDocumentationTarget(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return (DocumentationTarget)new KubernetesCronDocumentationTarget(element, (CronExpressionProvider)this);
    }
}

