/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u001a*\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0001H\u0007\u001a\u001e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001\u00a8\u0006\n"}, d2={"getPresentation", "", "project", "Lcom/intellij/openapi/project/Project;", "mappings", "", "Lcom/intellij/util/PathMappingSettings$PathMapping;", "projectRootPlaceholder", "present", "mapping", "intellij.remoteRun"})
@JvmName(name="RemoteMappingsUIUtil")
public final class RemoteMappingsUIUtil {
    @NotNull
    public static final String present(@NotNull Project project, @NotNull PathMappingSettings.PathMapping mapping, @NotNull String projectRootPlaceholder) {
        String relativePath;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        Intrinsics.checkNotNullParameter((Object)projectRootPlaceholder, (String)"projectRootPlaceholder");
        String basePath = project.getBasePath();
        if (basePath == null) {
            return mapping.getLocalRoot() + UIUtil.rightArrow() + mapping.getRemoteRoot();
        }
        File projectBaseDir = new File(basePath);
        File localFile = new File(mapping.getLocalRoot());
        if (FileUtil.isAncestor((File)projectBaseDir, (File)localFile, (boolean)false) && (relativePath = FileUtil.getRelativePath((File)projectBaseDir, (File)localFile)) != null) {
            Object object;
            if (StringsKt.startsWith$default((String)relativePath, (String)"./", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)".", (Object)relativePath)) {
                String string = relativePath.substring(1);
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            } else {
                object = !StringsKt.startsWith$default((String)relativePath, (String)"/", (boolean)false, (int)2, null) ? "/" + relativePath : relativePath;
            }
            relativePath = object;
            return projectRootPlaceholder + relativePath + UIUtil.rightArrow() + mapping.getRemoteRoot();
        }
        return mapping.getLocalRoot() + UIUtil.rightArrow() + mapping.getRemoteRoot();
    }

    @JvmOverloads
    @Nullable
    public static final String getPresentation(@NotNull Project project, @NotNull List<? extends PathMappingSettings.PathMapping> mappings, @NotNull String projectRootPlaceholder) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        Intrinsics.checkNotNullParameter((Object)projectRootPlaceholder, (String)"projectRootPlaceholder");
        StringBuilder sb = new StringBuilder();
        for (PathMappingSettings.PathMapping pathMapping : mappings) {
            if (((CharSequence)sb).length() > 0) {
                sb.append("; ");
            }
            sb.append(RemoteMappingsUIUtil.present(project, pathMapping, projectRootPlaceholder));
        }
        return ((CharSequence)sb).length() > 0 ? sb.toString() : null;
    }

    public static /* synthetic */ String getPresentation$default(Project project, List list, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "<Project root>";
        }
        return RemoteMappingsUIUtil.getPresentation(project, list, string);
    }

    @JvmOverloads
    @Nullable
    public static final String getPresentation(@NotNull Project project, @NotNull List<? extends PathMappingSettings.PathMapping> mappings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        return RemoteMappingsUIUtil.getPresentation$default(project, mappings, null, 4, null);
    }
}

