/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.validity;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class FunctionWithInconsistentReturnsJSInspectionBase
extends JavaScriptInspection {
    protected static boolean missingReturnStatementProblem(JSFunction function2) {
        return function2.getReturnType() != null && DialectDetector.isActionScript(function2);
    }

    private static boolean functionHasReturnValues(JSFunction function2) {
        ReturnValuesVisitor visitor = new ReturnValuesVisitor(function2);
        function2.acceptChildren(visitor);
        return visitor.hasReturnValues();
    }

    private static boolean functionHasValuelessReturns(@NotNull JSFunction function2) {
        if (function2 == null) {
            FunctionWithInconsistentReturnsJSInspectionBase.$$$reportNull$$$0(0);
        }
        if (function2.isGenerator()) {
            return false;
        }
        PsiElement lastChild = function2.getLastChild();
        if (lastChild instanceof JSBlockStatement && ControlFlowUtils.statementMayCompleteNormally((JSStatement)lastChild)) {
            return true;
        }
        ValuelessReturnVisitor visitor = new ValuelessReturnVisitor();
        function2.acceptChildren(visitor);
        return visitor.hasValuelessReturns();
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @InspectionMessage
    @NotNull
    protected String buildErrorString(Object ... args) {
        JSFunction function2 = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)args[0]), JSFunction.class);
        assert (function2 != null);
        if (FunctionWithInconsistentReturnsJSInspectionBase.missingReturnStatementProblem(function2)) {
            String string = InspectionJSBundle.message("missing.return.statement.error.string", new Object[0]);
            if (string == null) {
                FunctionWithInconsistentReturnsJSInspectionBase.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (FunctionWithInconsistentReturnsJSInspectionBase.functionHasIdentifier(function2)) {
            String string = InspectionJSBundle.message("function.has.inconsistent.return.points.error.string", new Object[0]);
            if (string == null) {
                FunctionWithInconsistentReturnsJSInspectionBase.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = InspectionJSBundle.message("anonymous.function.has.inconsistent.return.points.error.string", new Object[0]);
        if (string == null) {
            FunctionWithInconsistentReturnsJSInspectionBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/sixrr/inspectjs/validity/FunctionWithInconsistentReturnsJSInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/sixrr/inspectjs/validity/FunctionWithInconsistentReturnsJSInspectionBase";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "functionHasValuelessReturns";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }

    private static class ReturnValuesVisitor
    extends JSRecursiveWalkingElementVisitor {
        private final JSFunction function;
        private boolean hasReturnValues = false;

        ReturnValuesVisitor(JSFunction function2) {
            this.function = function2;
        }

        @Override
        public void visitJSReturnStatement(@NotNull JSReturnStatement statement) {
            if (statement == null) {
                ReturnValuesVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSReturnStatement(statement);
            JSExpression expression = statement.getExpression();
            if (expression != null) {
                JSExpression methodExpression;
                if (expression instanceof JSNewExpression && (methodExpression = ((JSNewExpression)expression).getMethodExpression()) instanceof JSReferenceExpression && ((JSReferenceExpression)methodExpression).resolve() == this.function) {
                    return;
                }
                this.hasReturnValues = true;
            }
        }

        @Override
        public void visitJSFunctionDeclaration(@NotNull JSFunction function2) {
            if (function2 == null) {
                ReturnValuesVisitor.$$$reportNull$$$0(1);
            }
        }

        @Override
        public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
            if (node == null) {
                ReturnValuesVisitor.$$$reportNull$$$0(2);
            }
        }

        @Override
        public void visitJSFunctionProperty(@NotNull JSFunctionProperty functionProperty) {
            if (functionProperty == null) {
                ReturnValuesVisitor.$$$reportNull$$$0(3);
            }
        }

        public boolean hasReturnValues() {
            return this.hasReturnValues;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionProperty";
                    break;
                }
            }
            objectArray2[1] = "com/sixrr/inspectjs/validity/FunctionWithInconsistentReturnsJSInspectionBase$ReturnValuesVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSReturnStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSFunctionDeclaration";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSFunctionExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSFunctionProperty";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ValuelessReturnVisitor
    extends JSRecursiveWalkingElementVisitor {
        private boolean hasValuelessReturns = false;

        ValuelessReturnVisitor() {
        }

        @Override
        public void visitJSReturnStatement(@NotNull JSReturnStatement statement) {
            if (statement == null) {
                ValuelessReturnVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSReturnStatement(statement);
            if (statement.getExpression() == null) {
                this.hasValuelessReturns = true;
            }
        }

        @Override
        public void visitJSFunctionDeclaration(@NotNull JSFunction function2) {
            if (function2 == null) {
                ValuelessReturnVisitor.$$$reportNull$$$0(1);
            }
        }

        @Override
        public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
            if (node == null) {
                ValuelessReturnVisitor.$$$reportNull$$$0(2);
            }
        }

        public boolean hasValuelessReturns() {
            return this.hasValuelessReturns;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/sixrr/inspectjs/validity/FunctionWithInconsistentReturnsJSInspectionBase$ValuelessReturnVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSReturnStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSFunctionDeclaration";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSFunctionExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        protected ProblemHighlightType getProblemHighlightType(PsiElement location) {
            DialectOptionHolder dialect = DialectDetector.dialectOfElement(location);
            return dialect != null && dialect.isECMA4 ? ProblemHighlightType.GENERIC_ERROR : super.getProblemHighlightType(location);
        }

        @Override
        protected void registerFunctionError(JSFunction function2) {
            JSBlockStatement body2;
            if (FunctionWithInconsistentReturnsJSInspectionBase.missingReturnStatementProblem(function2) && (body2 = function2.getBlock()) != null) {
                this.registerError(Visitor.findValidEditorLocation(body2.getLastChild()));
                return;
            }
            super.registerFunctionError(function2);
        }

        @Override
        public void visitJSFunctionDeclaration(@NotNull JSFunction function2) {
            if (function2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (DialectDetector.isTypeScript(function2)) {
                return;
            }
            super.visitJSFunctionDeclaration(function2);
            if (Visitor.functionHasReturnsErrors(function2)) {
                this.registerFunctionError(function2);
            }
        }

        private static boolean functionHasReturnsErrors(JSFunction function2) {
            JSExpression qualifierQualifier;
            JSReferenceExpression referenceExpression;
            JSExpression qualifier;
            JSExpression expression;
            JSAssignmentExpression assignmentExpression;
            JSExpression lOperand;
            JSType type2;
            JSType jSType = type2 = function2.hasExplicitlyDeclaredReturnType() ? function2.getReturnType() : null;
            if (type2 == null && !FunctionWithInconsistentReturnsJSInspectionBase.functionHasReturnValues(function2)) {
                return false;
            }
            if (type2 != null && ValidateTypesUtil.emptyReturnIsAcceptable(function2, type2) || !FunctionWithInconsistentReturnsJSInspectionBase.functionHasValuelessReturns(function2)) {
                return false;
            }
            PsiElement parent = function2.getParent();
            return !(parent instanceof JSAssignmentExpression) || !((lOperand = (assignmentExpression = (JSAssignmentExpression)parent).getLOperand()) instanceof JSDefinitionExpression) || !((expression = ((JSDefinitionExpression)lOperand).getExpression()) instanceof JSReferenceExpression) || !((qualifier = (referenceExpression = (JSReferenceExpression)expression).getQualifier()) instanceof JSReferenceExpression) || !"prototype".equals(((JSReferenceExpression)qualifier).getReferencedName()) || !((qualifierQualifier = ((JSReferenceExpression)qualifier).getQualifier()) instanceof JSReferenceExpression) || !JSSymbolUtil.referencesInterface((JSReferenceExpression)qualifierQualifier);
        }

        @Override
        public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super.visitJSFunctionExpression(node);
            if (Visitor.functionHasReturnsErrors(node)) {
                this.registerFunctionError(node);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/sixrr/inspectjs/validity/FunctionWithInconsistentReturnsJSInspectionBase$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSFunctionDeclaration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSFunctionExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

