/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.config.JSConfigService;
import com.intellij.lang.javascript.config.graph.JSConfigGraphCache;
import com.intellij.lang.javascript.config.graph.JSImportGraph;
import com.intellij.lang.javascript.frameworks.modules.JSDirectorySearchProcessor;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsRegistry;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.modules.TypeScriptNodeSearchProcessor;
import com.intellij.lang.typescript.resolve.GlobalSearchScopeWithIdFilter;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigBase;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigFileType;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigLibraryUpdater;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigListener;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptConfigServiceImpl
implements TypeScriptConfigService,
JSConfigService {
    public static final VirtualFile NO_CONFIG = new StubVirtualFile(){

        public String toString() {
            return "NO_CONFIG";
        }
    };
    @NotNull
    private final Project myProject;
    @NotNull
    private final CachedValue<ConcurrentIntObjectMap<ConcurrentIntObjectMap<Boolean>>> myFilesMappings;
    private final SimpleModificationTracker myVirtualConfigFilesTracker;
    @Nullable
    private final TypeScriptConfigLibraryUpdater myUpdater;
    @NotNull
    private final JSConfigGraphCache myConfigGraphCache;
    private final Collection<TypeScriptConfigListener> myListeners;
    @NotNull
    private final PsiManager myManager;
    private final TypeScriptLibraryProvider myLibraryProvider;
    private final CachedValue<ConcurrentIntObjectMap<VirtualFile>> myFileToConfig;
    private static final Map<String, Integer> priority = MapsKt.toMap((Sequence)SequencesKt.mapIndexed((Sequence)SequencesKt.sequenceOf((Object[])new String[]{"tsconfig.editor.json", "tsconfig.app.json", "tsconfig.lib.json", "tsconfig.spec.json", "tsconfig.e2e.json", "tsconfig.test.json", "tsconfig.json", "tsconfig.base.json"}), (ind, config) -> new Pair(config, ind)));

    public TypeScriptConfigServiceImpl(@NotNull Project project) {
        if (project == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(0);
        }
        this.myVirtualConfigFilesTracker = new SimpleModificationTracker();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
        this.myUpdater = (TypeScriptConfigLibraryUpdater)project.getService(TypeScriptConfigLibraryUpdater.class);
        this.myConfigGraphCache = JSConfigGraphCache.getService(project);
        this.myManager = PsiManager.getInstance((Project)project);
        this.myLibraryProvider = TypeScriptLibraryProvider.getService(project);
        this.myFilesMappings = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> CachedValueProvider.Result.create((Object)ConcurrentCollectionFactory.createConcurrentIntObjectSoftValueMap(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency(), VirtualFileManager.getInstance()}), false);
        this.myFileToConfig = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> CachedValueProvider.Result.create((Object)ConcurrentCollectionFactory.createConcurrentIntObjectSoftValueMap(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency(), VirtualFileManager.getInstance()}), false);
    }

    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isAccessible(@NotNull VirtualFile scope2, @NotNull VirtualFile referenced) {
        int refId;
        Boolean value;
        ConcurrentIntObjectMap prevValue;
        int scopeId;
        if (scope2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(1);
        }
        if (referenced == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(2);
        }
        if (scope2 instanceof VirtualFileWindow) {
            scope2 = ((VirtualFileWindow)scope2).getDelegate();
        }
        if (scope2.equals(referenced)) {
            return true;
        }
        if (!this.isEnabled() || DumbService.isDumb((Project)this.myProject)) {
            return true;
        }
        if (!(scope2 instanceof VirtualFileWithId) || !(referenced instanceof VirtualFileWithId)) {
            return this.isAccessibleImpl(scope2, referenced);
        }
        ConcurrentIntObjectMap filesRefsMap = (ConcurrentIntObjectMap)this.myFilesMappings.getValue();
        ConcurrentIntObjectMap scopeFileMap = (ConcurrentIntObjectMap)filesRefsMap.get(scopeId = ((VirtualFileWithId)scope2).getId());
        if (scopeFileMap == null && (prevValue = (ConcurrentIntObjectMap)filesRefsMap.putIfAbsent(scopeId, (Object)(scopeFileMap = ConcurrentCollectionFactory.createConcurrentIntObjectMap()))) != null) {
            scopeFileMap = prevValue;
        }
        if ((value = (Boolean)scopeFileMap.get(refId = ((VirtualFileWithId)referenced).getId())) == null) {
            value = this.isAccessibleImpl(scope2, referenced);
            scopeFileMap.put(refId, (Object)value);
        }
        return value;
    }

    @Override
    @NotNull
    public Condition<VirtualFile> getAccessScope(@NotNull VirtualFile scope2) {
        if (scope2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (DumbService.isDumb((Project)this.myProject)) {
            Condition condition = Conditions.alwaysFalse();
            if (condition == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(4);
            }
            return condition;
        }
        TypeScriptConfigService.IntPredicate filterId = this.getFilterId(scope2);
        Condition condition = candidate -> filterId.contains(JSImportGraph.getFileId(candidate));
        if (condition == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(5);
        }
        return condition;
    }

    @Override
    @NotNull
    public TypeScriptConfigService.IntPredicate getFilterId(@NotNull VirtualFile scope2) {
        if (scope2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (DumbService.isDumb((Project)this.myProject)) {
            TypeScriptConfigService.IntPredicate intPredicate = el -> false;
            if (intPredicate == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(7);
            }
            return intPredicate;
        }
        int currentFileId = JSImportGraph.getFileId(scope2);
        IntSet ids = this.myLibraryProvider.getLibrariesIds(true);
        if (ids.contains(currentFileId)) {
            TypeScriptConfigService.IntPredicate intPredicate = arg_0 -> ((IntSet)ids).contains(arg_0);
            if (intPredicate == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(8);
            }
            return intPredicate;
        }
        IntSet customIds = this.myLibraryProvider.getLibrariesIds(false);
        if (customIds.contains(currentFileId)) {
            TypeScriptConfigService.IntPredicate intPredicate = arg_0 -> ((IntSet)customIds).contains(arg_0);
            if (intPredicate == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(9);
            }
            return intPredicate;
        }
        IntSet libraries = this.myLibraryProvider.getEffectiveLibrariesIds();
        JSImportGraph preferableGraph = this.getPreferableIncludeParentGraph(scope2);
        if (preferableGraph == null) {
            TypeScriptConfigService.IntPredicate typingsScope = TypeScriptExternalDefinitionsRegistry.Companion.getTypingsScope(scope2);
            if (typingsScope != null) {
                TypeScriptConfigService.IntPredicate intPredicate = typingsScope;
                if (intPredicate == null) {
                    TypeScriptConfigServiceImpl.$$$reportNull$$$0(10);
                }
                return intPredicate;
            }
            if (ProjectScope.getLibrariesScope((Project)this.myProject).accept(scope2)) {
                TypeScriptConfigService.IntPredicate intPredicate = el -> true;
                if (intPredicate == null) {
                    TypeScriptConfigServiceImpl.$$$reportNull$$$0(11);
                }
                return intPredicate;
            }
            preferableGraph = this.myConfigGraphCache.getGraph(scope2);
        }
        JSImportGraph graph = preferableGraph;
        graph.initialize();
        TypeScriptConfigService.IntPredicate intPredicate = id -> libraries.contains(id) || graph.containsId(id);
        if (intPredicate == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(12);
        }
        return intPredicate;
    }

    private boolean isAccessibleImpl(@NotNull VirtualFile scope2, @NotNull VirtualFile file) {
        if (scope2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(13);
        }
        if (file == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(14);
        }
        return this.getAccessScope(scope2).value((Object)file);
    }

    @Override
    @NotNull
    public Condition<VirtualFile> getIsInGraphCondition(@NotNull VirtualFile scope2) {
        JSImportGraph preferableGraph;
        if (scope2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(15);
        }
        JSImportGraph graph = (preferableGraph = this.getPreferableIncludeParentGraph(scope2)) != null ? preferableGraph : this.myConfigGraphCache.getGraph(scope2);
        Condition condition = graph::containsFile;
        if (condition == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(16);
        }
        return condition;
    }

    @Override
    @Nullable
    public TypeScriptConfig getPreferableConfig(@Nullable VirtualFile scopeFile) {
        int id;
        if (scopeFile == null || !scopeFile.isValid()) {
            return null;
        }
        ConcurrentIntObjectMap map = (ConcurrentIntObjectMap)this.myFileToConfig.getValue();
        VirtualFile file = (VirtualFile)map.get(id = JSImportGraph.getFileId(scopeFile));
        if (file != null) {
            return file == NO_CONFIG ? null : this.parseConfigFile(file);
        }
        TypeScriptConfig impl = this.getPreferableConfigImpl(scopeFile);
        map.put(id, (Object)(impl == null ? NO_CONFIG : impl.getConfigFile()));
        return impl;
    }

    @Nullable
    private TypeScriptConfig getPreferableConfigImpl(@NotNull VirtualFile scopeFile) {
        if (scopeFile == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(17);
        }
        Collection<? extends VirtualFile> preferableConfigs = TypeScriptConfigServiceImpl.getNearestParentTsConfigs(scopeFile, false);
        while (!preferableConfigs.isEmpty()) {
            ProgressManager.checkCanceled();
            for (VirtualFile virtualFile : preferableConfigs) {
                TypeScriptConfig el = this.parseConfigFile(virtualFile);
                if (el == null || !this.configGraphIncludesFile(scopeFile, el)) continue;
                return el;
            }
            VirtualFile anyConfig = (VirtualFile)ContainerUtil.getFirstItem(preferableConfigs);
            preferableConfigs = TypeScriptConfigServiceImpl.getNearestParentTsConfigs(anyConfig.getParent(), false);
        }
        return null;
    }

    @Override
    public boolean configGraphIncludesFile(@NotNull VirtualFile file, @NotNull TypeScriptConfig tsConfig) {
        if (file == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(18);
        }
        if (tsConfig == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(19);
        }
        return this.myConfigGraphCache.isConfigInclude(file, tsConfig);
    }

    @Nullable
    private JSImportGraph getPreferableIncludeParentGraph(@NotNull VirtualFile scopeFile) {
        TypeScriptConfig config;
        if (scopeFile == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(20);
        }
        return (config = this.getPreferableConfig(scopeFile)) != null ? this.getIncludeGraph(scopeFile, config) : null;
    }

    @Nullable
    private JSImportGraph getIncludeGraph(@NotNull VirtualFile scopeFile, @NotNull TypeScriptConfig config) {
        if (scopeFile == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(21);
        }
        if (config == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(22);
        }
        JSImportGraph graph = this.myConfigGraphCache.getGraph(config);
        graph.initialize(true);
        return TypeScriptConfigServiceImpl.isGraphIncludeFile(graph, scopeFile) ? graph : null;
    }

    @Override
    @Nullable
    public TypeScriptConfig getPreferableJSConfig(@NotNull VirtualFile scopeFile) {
        if (scopeFile == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(23);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        TypeScriptConfig tsConfig = this.getPreferableConfig(scopeFile);
        if (tsConfig != null) {
            return tsConfig;
        }
        VirtualFile parent = TypeScriptConfigUtil.getParentConfigWithName(scopeFile, "jsconfig.json");
        TypeScriptConfig config = this.parseConfigFile(parent);
        if (config == null) {
            return null;
        }
        return this.configGraphIncludesFile(scopeFile, config) ? config : null;
    }

    private static boolean isGraphIncludeFile(@NotNull JSImportGraph el, @NotNull VirtualFile scopeFile) {
        if (el == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(24);
        }
        if (scopeFile == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(25);
        }
        return el.containsFile(scopeFile);
    }

    @Override
    @Nullable
    public TypeScriptConfig parseConfigFile(@Nullable VirtualFile file) {
        return TypeScriptConfigBase.parseAndCacheConfig(file, this.myManager);
    }

    @Override
    @NotNull
    public ModificationTracker getTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myVirtualConfigFilesTracker;
        if (simpleModificationTracker == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(26);
        }
        return simpleModificationTracker;
    }

    @Override
    public boolean isImplicitIncludedNodeModulesFile(@NotNull Project project, @NotNull VirtualFile file, @NotNull VirtualFile topDirectory) {
        if (project == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(27);
        }
        if (file == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(28);
        }
        if (topDirectory == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(29);
        }
        return TypeScriptConfigServiceImpl.isImplicitIncludedNodeModulesFile(this.myManager, file, topDirectory);
    }

    public static boolean isImplicitIncludedNodeModulesFile(@NotNull PsiManager psiManager, @NotNull VirtualFile file, @NotNull VirtualFile topDirectory) {
        if (psiManager == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(30);
        }
        if (file == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(31);
        }
        if (topDirectory == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(32);
        }
        if (NodeModuleUtil.isTypesDir(topDirectory)) {
            return true;
        }
        PsiFile psiFile2 = psiManager.findFile(file);
        if (!(psiFile2 instanceof JSFile) || ((JSFile)psiFile2).isCommonJSModule() || TypeScriptConfigServiceImpl.hasExternalTypeScriptModule(psiFile2)) {
            return true;
        }
        VirtualFile result2 = JSExactFileReference.resolveForNpmPackages(topDirectory, (JSDirectorySearchProcessor)TypeScriptNodeSearchProcessor.TS_PROCESSOR);
        return file.equals(result2);
    }

    private static boolean hasExternalTypeScriptModule(@Nullable PsiFile psiFile2) {
        if (psiFile2 == null) {
            return false;
        }
        return JSStubBasedPsiTreeUtil.getFilteredFileOrModuleChildrenStream((PsiElement)psiFile2, JSExtendedLanguagesTokenSetProvider.TYPESCRIPT_MODULES, TypeScriptModule.class).anyMatch(TypeScriptModule::isExternal);
    }

    @Override
    @NotNull
    public Set<VirtualFile> getIncludedFiles(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(33);
        }
        JSImportGraph graph = this.myConfigGraphCache.getGraph(file);
        Collection collection = graph.getNodes();
        if (collection == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(34);
        }
        return collection;
    }

    @Override
    @Nullable
    public TypeScriptConfig getPreferableOrParentConfig(@Nullable VirtualFile scopeFile) {
        if (scopeFile == null) {
            return null;
        }
        TypeScriptConfig configForFile = this.getPreferableConfig(scopeFile);
        if (configForFile == null) {
            return this.parseConfigFile((VirtualFile)ContainerUtil.getFirstItem(TypeScriptConfigServiceImpl.getNearestParentTsConfigs(scopeFile, false)));
        }
        return configForFile;
    }

    @Override
    @Nullable
    public TypeScriptConfig getDirectIncludePreferableConfig(@Nullable VirtualFile scopeFile) {
        if (scopeFile == null) {
            return null;
        }
        Collection<? extends VirtualFile> configFiles = TypeScriptConfigServiceImpl.getNearestParentTsConfigs(scopeFile, false);
        for (VirtualFile virtualFile : configFiles) {
            TypeScriptConfig config = this.parseConfigFile(virtualFile);
            if (config == null || !config.getInclude().accept(scopeFile)) continue;
            return config;
        }
        return null;
    }

    @Override
    @NotNull
    public List<VirtualFile> getRootConfigFiles() {
        List list2 = StreamEx.of((Object[])ProjectRootManager.getInstance((Project)this.myProject).getContentRoots()).map(el -> TypeScriptConfigServiceImpl.getNearestParentTsConfigs(el, true)).flatMap(el -> el.stream()).toImmutableList();
        if (list2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(35);
        }
        return list2;
    }

    @Override
    @NotNull
    public GlobalSearchScope createConfigScope(@NotNull TypeScriptConfig config) {
        if (config == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(36);
        }
        final JSImportGraph graph = this.myConfigGraphCache.getGraph(config);
        GlobalSearchScope scope2 = new GlobalSearchScope(){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                return graph.containsId(JSImportGraph.getFileId(file));
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    2.$$$reportNull$$$0(1);
                }
                return true;
            }

            public boolean isSearchInLibraries() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aModule";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contains";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSearchInModuleContent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        return new GlobalSearchScopeWithIdFilter(scope2, graph::containsId);
    }

    @NotNull
    public static Collection<? extends VirtualFile> getNearestParentTsConfigs(@Nullable VirtualFile fileOrDirectory, boolean checkCurrentDirectoryOnly) {
        if (fileOrDirectory == null || !fileOrDirectory.isValid()) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                TypeScriptConfigServiceImpl.$$$reportNull$$$0(37);
            }
            return list2;
        }
        VirtualFile dirToCheck = !checkCurrentDirectoryOnly ? fileOrDirectory.getParent() : fileOrDirectory;
        Collection result2 = null;
        List matchers = FileTypeManagerEx.getInstanceEx().getAssociations((FileType)TypeScriptConfigFileType.INSTANCE);
        ArrayList<String> exactNames = new ArrayList<String>();
        ArrayList<FileNameMatcher> other = new ArrayList<FileNameMatcher>();
        for (FileNameMatcher matcher : matchers) {
            if (matcher instanceof ExactFileNameMatcher) {
                exactNames.add(((ExactFileNameMatcher)matcher).getFileName());
                continue;
            }
            other.add(matcher);
        }
        while (dirToCheck != null) {
            ProgressManager.checkCanceled();
            for (String name : exactNames) {
                VirtualFile candidate = dirToCheck.findChild(name);
                if (candidate == null) continue;
                if (result2 == null) {
                    result2 = new SmartList();
                }
                result2.add(candidate);
            }
            if (!other.isEmpty()) {
                for (VirtualFile candidate : dirToCheck.getChildren()) {
                    if (candidate.isDirectory()) continue;
                    for (FileNameMatcher matcher : other) {
                        if (!matcher.acceptsCharSequence((CharSequence)candidate.getName())) continue;
                        if (result2 == null) {
                            result2 = new SmartList();
                        }
                        result2.add(candidate);
                    }
                }
            }
            if (result2 != null) {
                return TypeScriptConfigServiceImpl.sortConfigFilesByNamePriority(result2);
            }
            if (checkCurrentDirectoryOnly) {
                List list3 = Collections.emptyList();
                if (list3 == null) {
                    TypeScriptConfigServiceImpl.$$$reportNull$$$0(38);
                }
                return list3;
            }
            dirToCheck = dirToCheck.getParent();
        }
        List list4 = ContainerUtil.emptyList();
        if (list4 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(39);
        }
        return list4;
    }

    public void afterUpdate(@NotNull Collection<VirtualFile> configs) {
        if (configs == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(40);
        }
        this.myVirtualConfigFilesTracker.incModificationCount();
        if (this.myUpdater != null) {
            this.myUpdater.queueToUpdate();
        }
        for (TypeScriptConfigListener listener2 : this.myListeners) {
            for (VirtualFile config : configs) {
                listener2.changed(config);
            }
        }
    }

    @Override
    public void addConfigListener(@NotNull TypeScriptConfigListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(41);
        }
        if (parent == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(42);
        }
        this.myListeners.add(listener2);
        Disposer.register((Disposable)parent, () -> this.myListeners.remove(listener2));
    }

    @NotNull
    private static List<VirtualFile> sortConfigFilesByNamePriority(@NotNull Collection<VirtualFile> virtualFiles) {
        if (virtualFiles == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(43);
        }
        List list2 = ((StreamEx)((StreamEx)StreamEx.of(virtualFiles).distinct()).sorted(Comparator.comparing(file -> priority.getOrDefault(file.getName(), priority.size())))).toList();
        if (list2 == null) {
            TypeScriptConfigServiceImpl.$$$reportNull$$$0(44);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 8, 9, 10, 11, 12, 16, 26, 34, 35, 37, 38, 39, 44 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenced";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 26: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl";
                break;
            }
            case 14: 
            case 18: 
            case 28: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsConfig";
                break;
            }
            case 22: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topDirectory";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessScope";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterId";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getIsInGraphCondition";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTracker";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedFiles";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootConfigFiles";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getNearestParentTsConfigs";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "sortConfigFilesByNamePriority";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAccessScope";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 26: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 44: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFilterId";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleImpl";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getIsInGraphCondition";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPreferableConfigImpl";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "configGraphIncludesFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPreferableIncludeParentGraph";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getIncludeGraph";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getPreferableJSConfig";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isGraphIncludeFile";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitIncludedNodeModulesFile";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getIncludedFiles";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createConfigScope";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "afterUpdate";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "addConfigListener";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "sortConfigFilesByNamePriority";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 8, 9, 10, 11, 12, 16, 26, 34, 35, 37, 38, 39, 44 -> new IllegalStateException(string);
        };
    }
}

