/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigFileReferenceSet;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigFileType;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiFilePattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class TypeScriptConfigJsonReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            TypeScriptConfigJsonReferenceContributor.$$$reportNull$$$0(0);
        }
        PsiReferenceProvider referenceProvider = JSFileReferencesUtil.getSimpleReferencesPathProvider(TypeScriptUtil.TYPESCRIPT_EXTENSIONS);
        registrar.registerReferenceProvider(StandardPatterns.or((ElementPattern[])new ElementPattern[]{Holder.PATTERN_FILES_ARRAY, Holder.PATTERN_OUT_FILE, Holder.PATTERN_OUT_DIR, Holder.PATTERN_OUT, Holder.PATTERN_EXCLUDE_ARRAY, Holder.PATTERN_INCLUDE_ARRAY, Holder.PATTERN_BASE_URL_FILE, Holder.PATTERN_TYPES_ROOT_ARRAY, Holder.PATTERN_DECLARATION_DIR, Holder.PATTERN_PATH_FILE, Holder.PATTERN_ROOT_DIRS_ARRAY}), referenceProvider, 100.0);
        PsiReferenceProvider configExtendsProvider = new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context2) {
                PsiReference[] psiReferenceArray;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!(element instanceof JsonStringLiteral)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                FileReference fileReference = TypeScriptConfigFileReferenceSet.getFileReferenceFromString((JsonStringLiteral)element);
                if (fileReference != null) {
                    FileReference[] fileReferenceArray = new FileReference[1];
                    psiReferenceArray = fileReferenceArray;
                    fileReferenceArray[0] = fileReference;
                } else {
                    psiReferenceArray = PsiReference.EMPTY_ARRAY;
                }
                if (psiReferenceArray == null) {
                    1.$$$reportNull$$$0(3);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigJsonReferenceContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigJsonReferenceContributor$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        };
        registrar.registerReferenceProvider(Holder.PATTERN_EXTENDS, configExtendsProvider, 100.0);
        registrar.registerReferenceProvider(Holder.PATTERN_EXTENDS_ARRAY, configExtendsProvider, 100.0);
        registrar.registerReferenceProvider(Holder.PATTERN_LIB_ARRAY, new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context2) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!(element instanceof JsonStringLiteral)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                JsonStringLiteral literal = (JsonStringLiteral)element;
                String value = literal.getValue();
                if (StringUtil.isEmptyOrSpaces((String)value)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                TypeScriptLibraryProvider service2 = TypeScriptLibraryProvider.getService(element.getProject());
                VirtualFile library = service2.findLibraryByShortName(TypeScriptConfigUtil.toLibraryName(value));
                if (library == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        2.$$$reportNull$$$0(4);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                TextRange newRange = new TextRange(1, value.length() + 1);
                TextRange range = element.getTextRange();
                if (newRange.getLength() > range.getLength()) {
                    Logger.getInstance(TypeScriptConfigJsonReferenceContributor.class).error("Wrong tsconfig range, " + element.getText());
                    if (PsiReference.EMPTY_ARRAY == null) {
                        2.$$$reportNull$$$0(5);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new JSExactFileReference(element, newRange, Collections.singleton(library.getPath()), ArrayUtilRt.EMPTY_STRING_ARRAY){

                    @Override
                    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return element;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigJsonReferenceContributor$2$1", "bindToElement"));
                    }
                }};
                if (psiReferenceArray == null) {
                    2.$$$reportNull$$$0(6);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3, 4, 5, 6 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigJsonReferenceContributor$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigJsonReferenceContributor$2";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
                };
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigJsonReferenceContributor", "registerReferenceProviders"));
    }

    private static final class Holder {
        private static final PsiFilePattern.Capture<JsonFile> TS_CONFIG_FILE_PATTERN = (PsiFilePattern.Capture)PlatformPatterns.psiFile(JsonFile.class).withFileType((ElementPattern)StandardPatterns.instanceOf(TypeScriptConfigFileType.class));
        private static final PsiFilePattern.Capture<JsonFile> JS_CONFIG_FILE_PATTERN = (PsiFilePattern.Capture)PlatformPatterns.psiFile(JsonFile.class).withName("jsconfig.json");
        private static final PsiFilePattern.Capture<JsonFile> TS_CONFIG_LIKE_FILE_PATTERN = (PsiFilePattern.Capture)PlatformPatterns.psiFile(JsonFile.class).with((PatternCondition)new PatternCondition<JsonFile>("TS:LIKE"){

            public boolean accepts(@NotNull JsonFile file, ProcessingContext context2) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                return TypeScriptConfigFileType.isTsConfigLike(file.getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigJsonReferenceContributor$Holder$1", "accepts"));
            }
        });
        public static final PsiElementPattern.Capture<JsonStringLiteral> STRING_LITERAL_IN_CONFIG = (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).inFile(StandardPatterns.or((ElementPattern[])new ElementPattern[]{TS_CONFIG_FILE_PATTERN, JS_CONFIG_FILE_PATTERN, TS_CONFIG_LIKE_FILE_PATTERN}));
        private static final ElementPattern<? extends PsiElement> PATTERN_FILES_ARRAY = STRING_LITERAL_IN_CONFIG.withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("files"));
        private static final ElementPattern<? extends PsiElement> PATTERN_EXCLUDE_ARRAY = STRING_LITERAL_IN_CONFIG.withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("exclude"));
        private static final ElementPattern<? extends PsiElement> PATTERN_INCLUDE_ARRAY = STRING_LITERAL_IN_CONFIG.withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("include"));
        private static final ElementPattern<? extends PsiElement> PATTERN_ROOT_DIRS_ARRAY = STRING_LITERAL_IN_CONFIG.withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("rootDirs"));
        private static final ElementPattern<? extends PsiElement> PATTERN_LIB_ARRAY = STRING_LITERAL_IN_CONFIG.withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("lib"));
        private static final ElementPattern<? extends PsiElement> PATTERN_TYPES_ROOT_ARRAY = STRING_LITERAL_IN_CONFIG.withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("typeRoots"));
        private static final ElementPattern<? extends PsiElement> PATTERN_OUT = STRING_LITERAL_IN_CONFIG.withSuperParent(1, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("out"));
        private static final ElementPattern<? extends PsiElement> PATTERN_OUT_FILE = STRING_LITERAL_IN_CONFIG.withSuperParent(1, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("outFile"));
        private static final ElementPattern<? extends PsiElement> PATTERN_BASE_URL_FILE = STRING_LITERAL_IN_CONFIG.withSuperParent(1, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("baseUrl"));
        private static final ElementPattern<? extends PsiElement> PATTERN_OUT_DIR = STRING_LITERAL_IN_CONFIG.withSuperParent(1, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("outDir"));
        private static final ElementPattern<? extends PsiElement> PATTERN_DECLARATION_DIR = STRING_LITERAL_IN_CONFIG.withSuperParent(1, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("declarationDir"));
        private static final ElementPattern<? extends PsiElement> PATTERN_EXTENDS = ((PsiElementPattern.Capture)STRING_LITERAL_IN_CONFIG.with((PatternCondition)new IsNotPropertyNameCondition())).withSuperParent(1, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("extends"));
        private static final ElementPattern<? extends PsiElement> PATTERN_EXTENDS_ARRAY = STRING_LITERAL_IN_CONFIG.withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("extends"));
        private static final ElementPattern<? extends PsiElement> PATTERN_PATH_FILE = STRING_LITERAL_IN_CONFIG.withSuperParent(1, (ElementPattern)PlatformPatterns.psiElement(JsonProperty.class).withName("path"));

        private Holder() {
        }
    }

    private static class IsNotPropertyNameCondition
    extends PatternCondition<JsonElement> {
        private IsNotPropertyNameCondition() {
            super("isNotPropertyNameCondition");
        }

        public boolean accepts(@NotNull JsonElement element, ProcessingContext context2) {
            PsiElement parent;
            if (element == null) {
                IsNotPropertyNameCondition.$$$reportNull$$$0(0);
            }
            if ((parent = element.getParent()) instanceof JsonProperty) {
                return ((JsonProperty)parent).getNameElement() != element;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigJsonReferenceContributor$IsNotPropertyNameCondition", "accepts"));
        }
    }
}

