/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.javascript.config.JSFileImports;
import com.intellij.lang.javascript.config.JSFileImportsImpl;
import com.intellij.lang.javascript.config.JSModuleResolution;
import com.intellij.lang.javascript.config.JSModuleTarget;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptExtendedConfigImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolver;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportConfigResolveContextImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportResolveContext;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportsResolverProvider;
import com.intellij.lang.typescript.tsconfig.checkers.TypeScriptConfigDirectoryInclude;
import com.intellij.lang.typescript.tsconfig.checkers.TypeScriptConfigFilesInclude;
import com.intellij.lang.typescript.tsconfig.checkers.TypeScriptConfigIncludeBase;
import com.intellij.lang.typescript.tsconfig.checkers.TypeScriptConfigPatternInclude;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class TypeScriptConfigBase
extends UserDataHolderBase
implements TypeScriptConfig {
    private static final Function<PsiFile, TypeScriptConfig> MAP_TO_CONFIG = file -> {
        if (JSLibraryUtil.isProbableLibraryFile(file.getVirtualFile())) {
            return null;
        }
        return TypeScriptConfigBase.getConfig(file);
    };
    private final NotNullLazyValue<JSFileImportsImpl> myImportStructure = NotNullLazyValue.createValue(() -> new JSFileImportsImpl(this.getProject(), this));
    private final NotNullLazyValue<TypeScriptConfigIncludeBase> myIncludeChecker = NotNullLazyValue.lazy(() -> {
        if (this.hasIncludesList()) {
            return new TypeScriptConfigPatternInclude(this);
        }
        if (this.hasFilesList()) {
            return new TypeScriptConfigFilesInclude(this);
        }
        return new TypeScriptConfigDirectoryInclude(this);
    });
    private final NotNullLazyValue<TypeScriptImportResolveContext> myResolveContext = NotNullLazyValue.lazy(() -> new TypeScriptImportConfigResolveContextImpl(this));
    private final NotNullLazyValue<TypeScriptFileImportsResolver> myImportResolver = NotNullLazyValue.lazy(() -> {
        Project project = this.getProject();
        TypeScriptConfigBase config = this;
        return TypeScriptImportsResolverProvider.getResolver(project, config);
    });

    TypeScriptConfigBase() {
    }

    @Nullable
    static TypeScriptConfig parseAndCacheConfig(@Nullable VirtualFile file, PsiManager manager) {
        if (file == null || !file.isValid()) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile psiFile2 = manager.findFile(file);
        if (psiFile2 == null) {
            return null;
        }
        return (TypeScriptConfig)CachedValuesManager.getCachedValue((PsiElement)psiFile2, () -> {
            TypeScriptConfig config = (TypeScriptConfig)MAP_TO_CONFIG.fun((Object)psiFile2);
            if (config == null) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{psiFile2});
            }
            SmartList deps = new SmartList((Object)psiFile2);
            TypeScriptConfigBase.addAdditionalDepsForConfig(config, (Collection<Object>)deps, manager);
            if (!deps.isEmpty()) {
                deps.add(VirtualFileManager.getInstance());
            }
            return CachedValueProvider.Result.create((Object)config, (Collection)deps);
        });
    }

    private static void addAdditionalDepsForConfig(@NotNull TypeScriptConfig config, @NotNull Collection<Object> depends, @NotNull PsiManager manager) {
        if (config == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(0);
        }
        if (depends == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(2);
        }
        VirtualFile virtualFile = config.getConfigFile();
        for (VirtualFile file : config.getDependencies()) {
            if (file.equals(virtualFile)) continue;
            PsiFile psiFile2 = manager.findFile(file);
            depends.add(psiFile2 != null ? psiFile2 : file);
        }
    }

    static TypeScriptConfig getConfig(@NotNull PsiFile rawFile) {
        VirtualFile file;
        if (rawFile == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(3);
        }
        VirtualFile parentDir = (file = rawFile.getVirtualFile()) != null ? file.getParent() : null;
        return TypeScriptConfigBase.getConfig(rawFile, parentDir, new HashSet());
    }

    @Nullable
    static TypeScriptConfig getConfig(@NotNull PsiFile rawFile, @Nullable VirtualFile configDirTemplateValue, @NotNull Collection<? super VirtualFile> visited) {
        if (rawFile == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(4);
        }
        if (visited == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!visited.add((VirtualFile)rawFile.getVirtualFile())) {
            return null;
        }
        TypeScriptConfigImpl simpleConfig = TypeScriptConfigImpl.getSimpleConfigImpl(rawFile, configDirTemplateValue);
        if (simpleConfig == null) {
            return null;
        }
        PsiManager manager = rawFile.getManager();
        List<TypeScriptConfig> parentConfigs = simpleConfig.getExtendsParents().stream().map(parentVirtualFile -> {
            PsiFile parentFile = manager.findFile(parentVirtualFile);
            if (parentFile != null) {
                return TypeScriptConfigBase.getConfig(parentFile, configDirTemplateValue, visited);
            }
            return null;
        }).filter(Objects::nonNull).toList();
        if (parentConfigs.isEmpty()) {
            return simpleConfig;
        }
        return new TypeScriptExtendedConfigImpl(simpleConfig, parentConfigs);
    }

    @Override
    @NotNull
    public final JSModuleResolution getEffectiveResolution() {
        JSModuleResolution resolution = this.getResolution();
        if (resolution != JSModuleResolution.UNKNOWN) {
            JSModuleResolution jSModuleResolution = resolution;
            if (jSModuleResolution == null) {
                TypeScriptConfigBase.$$$reportNull$$$0(6);
            }
            return jSModuleResolution;
        }
        JSModuleTarget module = this.getModule();
        JSModuleResolution jSModuleResolution = module == JSModuleTarget.NODENEXT ? JSModuleResolution.NODENEXT : JSModuleResolution.NODE;
        if (jSModuleResolution == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(7);
        }
        return jSModuleResolution;
    }

    @Override
    @NotNull
    public final TypeScriptConfigIncludeBase getInclude() {
        TypeScriptConfigIncludeBase typeScriptConfigIncludeBase = (TypeScriptConfigIncludeBase)this.myIncludeChecker.getValue();
        if (typeScriptConfigIncludeBase == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(8);
        }
        return typeScriptConfigIncludeBase;
    }

    @Override
    @NotNull
    public final TypeScriptImportResolveContext getResolveContext() {
        TypeScriptImportResolveContext typeScriptImportResolveContext = (TypeScriptImportResolveContext)this.myResolveContext.getValue();
        if (typeScriptImportResolveContext == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(9);
        }
        return typeScriptImportResolveContext;
    }

    @Override
    @NotNull
    public final TypeScriptFileImportsResolver getImportResolver() {
        TypeScriptFileImportsResolver typeScriptFileImportsResolver = (TypeScriptFileImportsResolver)this.myImportResolver.getValue();
        if (typeScriptFileImportsResolver == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(10);
        }
        return typeScriptFileImportsResolver;
    }

    @Override
    @NotNull
    public final JSFileImports getConfigImportResolveStructure() {
        JSFileImports jSFileImports = (JSFileImports)this.myImportStructure.getValue();
        if (jSFileImports == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(11);
        }
        return jSFileImports;
    }

    @Override
    public final boolean allowSyntheticDefaultImports() {
        return this.esModuleInterop() || this.declaredAllowSyntheticDefaultImports();
    }

    protected abstract boolean declaredAllowSyntheticDefaultImports();

    @NotNull
    protected abstract Project getProject();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depends";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigBase";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveResolution";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInclude";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveContext";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportResolver";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigImportResolveStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalDepsForConfig";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConfig";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

