/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.javascript.integration.JSAnnotationRangeError;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.DiagnosticMessageItem;
import com.intellij.lang.typescript.compiler.languageService.DiagnosticMessageWithConcatenatedItemsParser;
import com.intellij.lang.typescript.compiler.languageService.LanguageServiceInfo;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceAnnotationResult;
import com.intellij.lang.typescript.library.TypeScriptServiceDirectoryWatcher;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.lsp.impl.highlighting.DiagnosticAndQuickFixes;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\n\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\u0016\u001a\u00020\u0007H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0007H\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0016J\b\u0010\u001b\u001a\u00020\u0018H\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0018H\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0007H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/lang/typescript/lsp/LspAnnotationError;", "Lcom/intellij/lang/javascript/integration/JSAnnotationRangeError;", "project", "Lcom/intellij/openapi/project/Project;", "diagnosticAndQuickFixes", "Lcom/intellij/platform/lsp/impl/highlighting/DiagnosticAndQuickFixes;", "path", "", "source", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/platform/lsp/impl/highlighting/DiagnosticAndQuickFixes;Ljava/lang/String;Ljava/lang/String;)V", "diagnostic", "Lorg/eclipse/lsp4j/Diagnostic;", "quickFixes", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "getQuickFixes", "()Ljava/util/List;", "showSuggestions", "", "simpleError", "tooltip", "getAbsoluteFilePath", "getCategory", "getColumn", "", "getDescription", "getEndColumn", "getEndLine", "getHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "getLine", "getTooltipText", "intellij.javascript.impl"})
public class LspAnnotationError
implements JSAnnotationRangeError {
    @Nullable
    private final String path;
    @Nullable
    private final String source;
    @NotNull
    private final Diagnostic diagnostic;
    @NotNull
    private final List<IntentionAction> quickFixes;
    private final boolean showSuggestions;
    @NlsSafe
    @Nullable
    private final String tooltip;
    @NlsSafe
    @NotNull
    private final String simpleError;

    public LspAnnotationError(@NotNull Project project, @NotNull DiagnosticAndQuickFixes diagnosticAndQuickFixes, @NlsSafe @Nullable String path2, @NlsSafe @Nullable String source) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)diagnosticAndQuickFixes, (String)"diagnosticAndQuickFixes");
        this.path = path2;
        this.source = source;
        this.diagnostic = diagnosticAndQuickFixes.getDiagnostic();
        this.quickFixes = diagnosticAndQuickFixes.getQuickFixes();
        this.showSuggestions = TypeScriptCompilerSettings.getSettings(project).isShowSuggestions();
        TypeScriptServiceDirectoryWatcher typeScriptServiceDirectoryWatcher = TypeScriptServiceDirectoryWatcher.getService(project);
        Intrinsics.checkNotNullExpressionValue((Object)typeScriptServiceDirectoryWatcher, (String)"getService(...)");
        TypeScriptServiceDirectoryWatcher service2 = typeScriptServiceDirectoryWatcher;
        String string = service2.getDefaultServicePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDefaultServicePath(...)");
        LanguageServiceInfo defaultInfo = new LanguageServiceInfo(string, "5.4.3", null);
        String string2 = StringUtil.notNullize((String)this.diagnostic.getMessage(), (String)"error");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"notNullize(...)");
        this.simpleError = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        Either either2 = this.diagnostic.getCode();
        Integer n = either2 != null ? (Integer)either2.getRight() : null;
        List<DiagnosticMessageItem> parsedItems = DiagnosticMessageWithConcatenatedItemsParser.INSTANCE.parse(this.simpleError, n == null ? -1 : n, project, defaultInfo);
        String prefix = this.source != null ? this.source + ": " : "";
        this.tooltip = DiagnosticMessageWithConcatenatedItemsParser.INSTANCE.messageItemsToHtml(parsedItems, prefix, project);
    }

    @NotNull
    public final List<IntentionAction> getQuickFixes() {
        return this.quickFixes;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.source != null ? this.source + ": " + this.simpleError : this.simpleError;
    }

    @Override
    @Nullable
    public String getTooltipText() {
        return this.tooltip;
    }

    @Override
    @Nullable
    public ProblemHighlightType getHighlightType() {
        Either either2 = this.diagnostic.getCode();
        Integer n = either2 != null ? (Integer)either2.getRight() : null;
        return TypeScriptLanguageServiceAnnotationResult.getHighlightingTypeByCode(this.getDescription(), n == null ? -1 : n, this.getCategory());
    }

    @Override
    public int getLine() {
        return this.diagnostic.getRange().getStart().getLine();
    }

    @Override
    public int getColumn() {
        return this.diagnostic.getRange().getStart().getCharacter();
    }

    @Override
    public int getEndLine() {
        return this.diagnostic.getRange().getEnd().getLine();
    }

    @Override
    public int getEndColumn() {
        return this.diagnostic.getRange().getEnd().getCharacter();
    }

    @Override
    @Nullable
    public String getAbsoluteFilePath() {
        return this.path;
    }

    @Override
    @NotNull
    public String getCategory() {
        DiagnosticSeverity diagnosticSeverity = this.diagnostic.getSeverity();
        return switch (diagnosticSeverity == null ? -1 : WhenMappings.$EnumSwitchMapping$0[diagnosticSeverity.ordinal()]) {
            case 1 -> "error";
            case 2 -> "warning";
            case 3 -> {
                if (this.showSuggestions) {
                    yield "suggestion";
                }
                yield "info";
            }
            default -> "info";
        };
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DiagnosticSeverity.values().length];
            try {
                nArray[DiagnosticSeverity.Error.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiagnosticSeverity.Warning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiagnosticSeverity.Hint.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

