/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.editing;

import com.intellij.codeInsight.hints.declarative.CollapseState;
import com.intellij.codeInsight.hints.declarative.CollapsiblePresentationTreeBuilder;
import com.intellij.codeInsight.hints.declarative.DeclarativeInlayHintsSettings;
import com.intellij.codeInsight.hints.declarative.HintColorKind;
import com.intellij.codeInsight.hints.declarative.HintFontSize;
import com.intellij.codeInsight.hints.declarative.HintFormat;
import com.intellij.codeInsight.hints.declarative.HintMarginPadding;
import com.intellij.codeInsight.hints.declarative.InlayActionData;
import com.intellij.codeInsight.hints.declarative.InlayActionPayload;
import com.intellij.codeInsight.hints.declarative.InlayPosition;
import com.intellij.codeInsight.hints.declarative.InlayTreeSink;
import com.intellij.codeInsight.hints.declarative.InlineInlayPosition;
import com.intellij.codeInsight.hints.declarative.PresentationTreeBuilder;
import com.intellij.codeInsight.hints.declarative.PsiPointerInlayActionPayload;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.impl.JSimportUtilKt;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParameter;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.InlayHintItem;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.InlayHintItemDisplayPart;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.InlayHintKind;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptResponseCommon;
import com.intellij.lang.typescript.editing.TypeScriptInlayHintsBuilderKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\u001a \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a(\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0001\u001a\u001b\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0016\u001a\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a3\u0010\"\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060$\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060$0#2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015H\u0002\u00a2\u0006\u0002\u0010&\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"otherHintFormat", "Lcom/intellij/codeInsight/hints/declarative/HintFormat;", "parameterHintFormat", "buildHintFromDisplayPart", "", "part", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/InlayHintItemDisplayPart;", "project", "Lcom/intellij/openapi/project/Project;", "builder", "Lcom/intellij/codeInsight/hints/declarative/PresentationTreeBuilder;", "buildHintFromServiceItem", "hintItem", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/InlayHintItem;", "document", "Lcom/intellij/openapi/editor/Document;", "file", "Lcom/intellij/psi/PsiFile;", "sink", "Lcom/intellij/codeInsight/hints/declarative/InlayTreeSink;", "getParts", "", "(Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/InlayHintItem;)[Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/InlayHintItemDisplayPart;", "getSimpleTypeScriptParameter", "Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptParameter;", "element", "Lcom/intellij/psi/PsiElement;", "getTargetElement", "isFilterOutFunctionParamType", "", "offset", "", "isParenthesizedParameter", "isSingleNonParenthesizedParam", "splitPartsToVisibleAndCollapsed", "Lkotlin/Pair;", "", "parts", "([Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/InlayHintItemDisplayPart;)Lkotlin/Pair;", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nTypeScriptInlayHintsBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptInlayHintsBuilder.kt\ncom/intellij/lang/typescript/editing/TypeScriptInlayHintsBuilderKt\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,184:1\n26#2:185\n1#3:186\n*S KotlinDebug\n*F\n+ 1 TypeScriptInlayHintsBuilder.kt\ncom/intellij/lang/typescript/editing/TypeScriptInlayHintsBuilderKt\n*L\n69#1:185\n*E\n"})
public final class TypeScriptInlayHintsBuilderKt {
    @NotNull
    private static final HintFormat parameterHintFormat = HintFormat.Companion.getDefault().withFontSize(HintFontSize.ABitSmallerThanInEditor).withHorizontalMargin(HintMarginPadding.MarginAndSmallerPadding).withColorKind(HintColorKind.Parameter);
    @NotNull
    private static final HintFormat otherHintFormat = HintFormat.Companion.getDefault().withFontSize(HintFontSize.ABitSmallerThanInEditor).withHorizontalMargin(HintMarginPadding.MarginAndSmallerPadding);

    @RequiresReadLock
    public static final void buildHintFromServiceItem(@NotNull InlayHintItem hintItem, @NotNull Document document2, @NotNull PsiFile file, @NotNull InlayTreeSink sink) {
        Intrinsics.checkNotNullParameter((Object)hintItem, (String)"hintItem");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        InlayHintItemDisplayPart[] parts = TypeScriptInlayHintsBuilderKt.getParts(hintItem);
        if (parts.length == 0) {
            return;
        }
        Pair<List<InlayHintItemDisplayPart>, List<InlayHintItemDisplayPart>> pair = TypeScriptInlayHintsBuilderKt.splitPartsToVisibleAndCollapsed(parts);
        List visibleParts = (List)pair.component1();
        List collapsedParts = (List)pair.component2();
        TypeScriptResponseCommon.Location location = hintItem.position;
        if (location == null) {
            return;
        }
        TypeScriptResponseCommon.Location position = location;
        int offset = document2.getLineStartOffset(position.line - 1) + position.offset - 1;
        if (hintItem.kind == InlayHintKind.Type && TypeScriptInlayHintsBuilderKt.isFilterOutFunctionParamType(file, offset)) {
            return;
        }
        boolean relatedToPrevious = hintItem.kind != InlayHintKind.Parameter;
        InlayHintKind inlayHintKind = hintItem.kind;
        HintFormat hintFormat = (inlayHintKind == null ? -1 : WhenMappings.$EnumSwitchMapping$0[inlayHintKind.ordinal()]) == 1 ? parameterHintFormat : otherHintFormat;
        InlayTreeSink.addPresentation$default((InlayTreeSink)sink, (InlayPosition)((InlayPosition)new InlineInlayPosition(offset, relatedToPrevious, 0, 4, null)), null, null, (HintFormat)hintFormat, (Function1)((Function1)new Function1<PresentationTreeBuilder, Unit>((List<InlayHintItemDisplayPart>)visibleParts, (List<InlayHintItemDisplayPart>)collapsedParts, file){
            final /* synthetic */ List<InlayHintItemDisplayPart> $visibleParts;
            final /* synthetic */ List<InlayHintItemDisplayPart> $collapsedParts;
            final /* synthetic */ PsiFile $file;
            {
                this.$visibleParts = $visibleParts;
                this.$collapsedParts = $collapsedParts;
                this.$file = $file;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull PresentationTreeBuilder $this$addPresentation) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)$this$addPresentation, (String)"$this$addPresentation");
                Iterable iterable = this.$visibleParts;
                PsiFile psiFile2 = this.$file;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    InlayHintItemDisplayPart it = (InlayHintItemDisplayPart)element$iv;
                    boolean bl = false;
                    Project project = psiFile2.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    TypeScriptInlayHintsBuilderKt.access$buildHintFromDisplayPart(it, project, $this$addPresentation);
                }
                if (!((Collection)this.$collapsedParts).isEmpty()) {
                    $this$addPresentation.collapsibleList(CollapseState.Collapsed, (Function1)new Function1<CollapsiblePresentationTreeBuilder, Unit>(this.$collapsedParts, this.$file){
                        final /* synthetic */ List<InlayHintItemDisplayPart> $collapsedParts;
                        final /* synthetic */ PsiFile $file;
                        {
                            this.$collapsedParts = $collapsedParts;
                            this.$file = $file;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull CollapsiblePresentationTreeBuilder $this$collapsibleList) {
                            void $this$forEach$iv;
                            Intrinsics.checkNotNullParameter((Object)$this$collapsibleList, (String)"$this$collapsibleList");
                            Iterable iterable = this.$collapsedParts;
                            PsiFile psiFile2 = this.$file;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                InlayHintItemDisplayPart it = (InlayHintItemDisplayPart)element$iv;
                                boolean bl = false;
                                Project project = psiFile2.getProject();
                                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                                TypeScriptInlayHintsBuilderKt.access$buildHintFromDisplayPart(it, project, (PresentationTreeBuilder)$this$collapsibleList);
                            }
                        }
                    }, (Function1)buildHintFromServiceItem.3.INSTANCE);
                }
            }
        }), (int)6, null);
    }

    private static final InlayHintItemDisplayPart[] getParts(InlayHintItem hintItem) {
        InlayHintItemDisplayPart[] parts;
        boolean bl = parts != null ? !((parts = hintItem.displayParts).length == 0) : false;
        if (bl) {
            return parts;
        }
        String plainText = hintItem.text;
        CharSequence charSequence = plainText;
        if (charSequence == null || charSequence.length() == 0) {
            boolean $i$f$emptyArray = false;
            return new InlayHintItemDisplayPart[0];
        }
        InlayHintItemDisplayPart single = new InlayHintItemDisplayPart();
        single.text = plainText;
        InlayHintItemDisplayPart[] inlayHintItemDisplayPartArray = new InlayHintItemDisplayPart[]{single};
        return inlayHintItemDisplayPartArray;
    }

    private static final Pair<List<InlayHintItemDisplayPart>, List<InlayHintItemDisplayPart>> splitPartsToVisibleAndCollapsed(InlayHintItemDisplayPart[] parts) {
        String string = Registry.stringValue((String)"typescript.service.provideInlayHints.maxLength");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringValue(...)");
        int quota = Integer.parseInt(string);
        List visibleParts = new ArrayList();
        List collapsedParts = new ArrayList();
        for (InlayHintItemDisplayPart part : parts) {
            String string2 = part.text;
            if (string2 == null) {
                string2 = "";
            }
            String currentText = string2;
            int visibleLength = RangesKt.coerceAtMost((int)RangesKt.coerceAtMost((int)quota, (int)currentText.length()), (int)30);
            String string3 = currentText.substring(0, visibleLength);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            TypeScriptInlayHintsBuilderKt.splitPartsToVisibleAndCollapsed$addFragmentIfNotEmpty(part, string3, visibleParts);
            String string4 = currentText.substring(visibleLength);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            TypeScriptInlayHintsBuilderKt.splitPartsToVisibleAndCollapsed$addFragmentIfNotEmpty(part, string4, collapsedParts);
            quota = visibleLength == currentText.length() ? quota - visibleLength : 0;
        }
        return TuplesKt.to((Object)visibleParts, (Object)collapsedParts);
    }

    private static final boolean isFilterOutFunctionParamType(PsiFile file, int offset) {
        PsiElement psiElement = file.findElementAt(offset - 1);
        if (psiElement == null) {
            return false;
        }
        PsiElement element = psiElement;
        if (!Intrinsics.areEqual((Object)DeclarativeInlayHintsSettings.Companion.getInstance().isOptionEnabled("non.paren.single.param", "ts.type.hints"), (Object)true) && TypeScriptInlayHintsBuilderKt.isSingleNonParenthesizedParam(element)) {
            return true;
        }
        return !Intrinsics.areEqual((Object)DeclarativeInlayHintsSettings.Companion.getInstance().isOptionEnabled("parameters.in.parens", "ts.type.hints"), (Object)true) && TypeScriptInlayHintsBuilderKt.isParenthesizedParameter(element);
    }

    public static final boolean isSingleNonParenthesizedParam(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TypeScriptParameter typeScriptParameter = TypeScriptInlayHintsBuilderKt.getSimpleTypeScriptParameter(element);
        if (typeScriptParameter == null) {
            return false;
        }
        TypeScriptParameter parameter = typeScriptParameter;
        PsiElement psiElement = parameter.getParent();
        JSParameterList jSParameterList = psiElement instanceof JSParameterList ? (JSParameterList)psiElement : null;
        if (jSParameterList == null) {
            return false;
        }
        JSParameterList parameterList = jSParameterList;
        return parameterList.getParameters().length == 1 && Intrinsics.areEqual((Object)parameterList.getFirstChild(), (Object)parameter);
    }

    private static final boolean isParenthesizedParameter(PsiElement element) {
        TypeScriptParameter typeScriptParameter = TypeScriptInlayHintsBuilderKt.getSimpleTypeScriptParameter(element);
        if (typeScriptParameter == null) {
            return false;
        }
        TypeScriptParameter parameter = typeScriptParameter;
        PsiElement psiElement = parameter.getParent();
        JSParameterList jSParameterList = psiElement instanceof JSParameterList ? (JSParameterList)psiElement : null;
        if (jSParameterList == null) {
            return false;
        }
        JSParameterList parameterList = jSParameterList;
        JSParameterListElement[] jSParameterListElementArray = parameterList.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)jSParameterListElementArray, (String)"getParameters(...)");
        JSParameterListElement jSParameterListElement = (JSParameterListElement)ArraysKt.firstOrNull((Object[])jSParameterListElementArray);
        if (jSParameterListElement == null) {
            return false;
        }
        JSParameterListElement firstParam = jSParameterListElement;
        ASTNode aSTNode = parameterList.getNode().findChildByType(JSTokenTypes.LPAR);
        if (aSTNode == null) {
            return false;
        }
        ASTNode lp = aSTNode;
        return lp.getStartOffset() < PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)firstParam));
    }

    @Nullable
    public static final TypeScriptParameter getSimpleTypeScriptParameter(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TypeScriptParameter typeScriptParameter = element instanceof TypeScriptParameter ? (TypeScriptParameter)element : null;
        if (typeScriptParameter == null) {
            PsiElement psiElement = element.getParent();
            typeScriptParameter = psiElement instanceof TypeScriptParameter ? (TypeScriptParameter)psiElement : null;
        }
        return typeScriptParameter;
    }

    private static final void buildHintFromDisplayPart(InlayHintItemDisplayPart part, Project project, PresentationTreeBuilder builder2) {
        String string = part.text;
        if (string == null) {
            return;
        }
        String text2 = string;
        PsiElement targetElement = TypeScriptInlayHintsBuilderKt.getTargetElement(project, part);
        if (targetElement != null) {
            SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)targetElement);
            Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
            SmartPsiElementPointer pointer2 = smartPsiElementPointer;
            builder2.text(text2, new InlayActionData((InlayActionPayload)new PsiPointerInlayActionPayload(pointer2), "psi.pointer.navigation.handler"));
        } else {
            PresentationTreeBuilder.text$default((PresentationTreeBuilder)builder2, (String)text2, null, (int)2, null);
        }
    }

    private static final PsiElement getTargetElement(Project project, InlayHintItemDisplayPart part) {
        VirtualFile virtualFile;
        block8: {
            block7: {
                TypeScriptResponseCommon.FileSpan fileSpan = part.span;
                LocalFilePath it = fileSpan != null ? fileSpan.file : null;
                boolean bl = false;
                Path path2 = LocalFilePath.getNioPath(it);
                if (path2 == null) break block7;
                Path it2 = path2;
                boolean bl2 = false;
                virtualFile = VirtualFileManager.getInstance().findFileByNioPath(it2);
                if (virtualFile != null) break block8;
            }
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        PsiFile psiFile2 = PsiManager.getInstance((Project)project).findFile(virtualFile2);
        if (psiFile2 == null) {
            return null;
        }
        PsiFile psiFile3 = psiFile2;
        Document document2 = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile3);
        if (document2 == null) {
            return null;
        }
        Document document3 = document2;
        TypeScriptResponseCommon.FileSpan fileSpan = part.span;
        TypeScriptResponseCommon.Location location = fileSpan != null ? fileSpan.start : null;
        if (location == null) {
            return null;
        }
        TypeScriptResponseCommon.Location startLocation = location;
        TypeScriptResponseCommon.FileSpan fileSpan2 = part.span;
        TypeScriptResponseCommon.Location location2 = fileSpan2 != null ? fileSpan2.end : null;
        if (location2 == null) {
            return null;
        }
        TypeScriptResponseCommon.Location endLocation = location2;
        int startOffset = document3.getLineStartOffset(startLocation.line - 1) + startLocation.offset - 1;
        int endOffset = document3.getLineStartOffset(endLocation.line - 1) + endLocation.offset - 1;
        return JSimportUtilKt.getParentOfLine(psiFile3, new TextRange(startOffset, endOffset));
    }

    private static final void splitPartsToVisibleAndCollapsed$addFragmentIfNotEmpty(InlayHintItemDisplayPart part, String fragmentText, List<InlayHintItemDisplayPart> dest) {
        if (((CharSequence)fragmentText).length() > 0) {
            InlayHintItemDisplayPart inlayHintItemDisplayPart;
            Collection collection = dest;
            InlayHintItemDisplayPart $this$splitPartsToVisibleAndCollapsed_u24addFragmentIfNotEmpty_u24lambda_u240 = inlayHintItemDisplayPart = new InlayHintItemDisplayPart();
            boolean bl = false;
            $this$splitPartsToVisibleAndCollapsed_u24addFragmentIfNotEmpty_u24lambda_u240.text = fragmentText;
            $this$splitPartsToVisibleAndCollapsed_u24addFragmentIfNotEmpty_u24lambda_u240.span = part.span;
            collection.add(inlayHintItemDisplayPart);
        }
    }

    public static final /* synthetic */ void access$buildHintFromDisplayPart(InlayHintItemDisplayPart part, Project project, PresentationTreeBuilder builder2) {
        TypeScriptInlayHintsBuilderKt.buildHintFromDisplayPart(part, project, builder2);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InlayHintKind.values().length];
            try {
                nArray[InlayHintKind.Parameter.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

