/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.documentation;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.lang.javascript.documentation.JSDocBuilderSimpleInfo;
import com.intellij.lang.javascript.documentation.JSDocParameterInfoPrinter;
import com.intellij.lang.javascript.documentation.JSHtmlHighlightingUtil;
import com.intellij.lang.javascript.documentation.JSTypeHighlightingHelper;
import com.intellij.lang.javascript.documentation.JavaScriptQuickNavigateBuilder;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptThisType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.typescript.documentation.TypeScriptServiceQuickInfoFetcher;
import com.intellij.lang.typescript.documentation.TypeScriptServiceQuickInfoParser;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptQuickNavigateBuilder
extends JavaScriptQuickNavigateBuilder {
    private final TypeScriptServiceQuickInfoFetcher fetcher = new TypeScriptServiceQuickInfoFetcher();

    private static boolean isShownOwnType() {
        return Registry.is((String)"typescript.show.own.type");
    }

    @Override
    @Nullable
    @NlsSafe
    public String getQuickNavigateInfoForNavigationElement(@NotNull PsiElement element, @NotNull PsiElement originalElement, boolean jsDoc) {
        if (element == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(0);
        }
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(1);
        }
        String serviceResult = null;
        if (!(TypeScriptQuickNavigateBuilder.isWhitelisted(originalElement) || jsDoc || StringUtil.isEmpty((String)(serviceResult = this.fetcher.getServiceResult(originalElement))))) {
            Object s = TypeScriptServiceQuickInfoParser.parseServiceText(element, serviceResult);
            if (TypeScriptQuickNavigateBuilder.isShownOwnType()) {
                s = (String)s + "<br/>[ide]<br/>" + super.getQuickNavigateInfoForNavigationElement(element, originalElement, false);
            }
            return s;
        }
        if (element instanceof JSElement) {
            JSElement jsElement = (JSElement)element;
            if (!(element instanceof JSFunction) && LookupManager.getInstance((Project)element.getProject()).getActiveLookup() == null) {
                String invocationStr;
                TypeScriptServiceQuickInfoParser.ParsedInfo info2;
                if (serviceResult == null) {
                    serviceResult = this.fetcher.getServiceResult(originalElement);
                }
                if (StringUtil.isNotEmpty((String)serviceResult) && (info2 = TypeScriptServiceQuickInfoParser.parseServiceTextAsInfo(serviceResult)) != null && info2.myRestPartWithPlaceHolders != null && info2.myRestPartWithPlaceHolders.startsWith("(") && (invocationStr = this.createForFunctionInvocation(jsElement, originalElement, info2)) != null) {
                    return invocationStr;
                }
            }
        }
        return super.getQuickNavigateInfoForNavigationElement(element, originalElement, jsDoc);
    }

    private String createForFunctionInvocation(JSElement element, PsiElement originalElement, TypeScriptServiceQuickInfoParser.ParsedInfo info2) {
        JSCallExpression callExpr = TypeScriptQuickNavigateBuilder.parseFunctionCall(info2.myQName, originalElement);
        JSFunction restFunctionItem = TypeScriptQuickNavigateBuilder.parseFunctionText(info2.myRestPartWithPlaceHolders, originalElement);
        if (callExpr != null && restFunctionItem != null) {
            String escapedNameWithGenerics = this.getFunctionNameGenericsHtml(callExpr);
            List<JSDocParameterInfoPrinter> parametersInfo = this.mapParametersToInfos(restFunctionItem);
            JSDocBuilderSimpleInfo returnInfo = this.mapReturnTypeToInfo(restFunctionItem);
            CharSequence functionDef = this.getServiceFunctionDefinition(restFunctionItem, escapedNameWithGenerics, this.getTypeSubstitutor(element, originalElement), parametersInfo, returnInfo, originalElement, info2);
            if (functionDef != null) {
                return functionDef.toString();
            }
        }
        return null;
    }

    private static JSCallExpression parseFunctionCall(@NotNull String qNameWithGenerics, @NotNull PsiElement originalElement) {
        JSExpression expression;
        if (qNameWithGenerics == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(2);
        }
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(3);
        }
        if ((expression = JSPsiElementFactory.createJSExpression(qNameWithGenerics + "()", originalElement)) instanceof JSCallExpression) {
            JSCallExpression callExpression = (JSCallExpression)expression;
            return callExpression;
        }
        return null;
    }

    protected String getFunctionNameGenericsHtml(@NotNull JSCallExpression callExpression) {
        JSReferenceExpression reference;
        if (callExpression == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(4);
        }
        String referenceName = (reference = (JSReferenceExpression)PsiTreeUtil.findChildOfType((PsiElement)callExpression, JSReferenceExpression.class)) != null ? reference.getReferenceName() : "";
        TypeScriptTypeArgumentList argumentList = (TypeScriptTypeArgumentList)PsiTreeUtil.findChildOfType((PsiElement)callExpression, TypeScriptTypeArgumentList.class);
        String genericArgs = argumentList != null ? argumentList.getText() : "";
        return StringUtil.escapeXmlEntities((String)(referenceName + genericArgs));
    }

    @Override
    @NotNull
    protected String getFunctionNameWithHtml(@NotNull JSFunctionItem functionItem, @NotNull JSTypeSubstitutor substitutor) {
        if (functionItem == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(5);
        }
        if (substitutor == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(6);
        }
        String name = super.getFunctionNameWithHtml(functionItem, substitutor);
        String generics = TypeScriptQuickNavigateBuilder.getGenerics(functionItem, substitutor);
        String string = name + StringUtil.escapeXmlEntities((String)StringUtil.notNullize((String)generics));
        if (string == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static boolean isWhitelisted(@NotNull PsiElement originalElement) {
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(8);
        }
        return originalElement instanceof JSThisExpression || originalElement instanceof TypeScriptThisType;
    }

    @Override
    @NotNull
    public CharSequence getFunctionDefinition(@NotNull JSFunctionItem functionItem, @NotNull String escapedName, @NotNull JSTypeSubstitutor substitutor, @NotNull Collection<? extends JSDocParameterInfoPrinter> parameters, @NotNull JSDocBuilderSimpleInfo returnInfo, @NotNull PsiElement originalElement, boolean jsDoc) {
        TypeScriptServiceQuickInfoParser.ParsedInfo info2;
        CharSequence highlighting;
        if (functionItem == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(9);
        }
        if (escapedName == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(10);
        }
        if (substitutor == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(11);
        }
        if (parameters == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(12);
        }
        if (returnInfo == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(13);
        }
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(14);
        }
        if (jsDoc && (highlighting = this.getServiceFunctionDefinition(functionItem, escapedName, substitutor, parameters, returnInfo, originalElement, info2 = this.fetcher.getParsedServiceInfo(originalElement))) != null) {
            CharSequence charSequence = highlighting;
            if (charSequence == null) {
                TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(15);
            }
            return charSequence;
        }
        CharSequence charSequence = super.getFunctionDefinition(functionItem, escapedName, substitutor, parameters, returnInfo, originalElement, jsDoc);
        if (charSequence == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(16);
        }
        return charSequence;
    }

    @Nullable
    private CharSequence getServiceFunctionDefinition(@NotNull JSFunctionItem functionItem, @NotNull String escapedName, @NotNull JSTypeSubstitutor substitutor, @NotNull Collection<? extends JSDocParameterInfoPrinter> parameters, @NotNull JSDocBuilderSimpleInfo returnInfo, @NotNull PsiElement originalElement, @Nullable TypeScriptServiceQuickInfoParser.ParsedInfo info2) {
        if (functionItem == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(17);
        }
        if (escapedName == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(18);
        }
        if (substitutor == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(19);
        }
        if (parameters == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(20);
        }
        if (returnInfo == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(21);
        }
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(22);
        }
        if (info2 == null) {
            return null;
        }
        String rest = StringUtil.trimStart((String)info2.myRestPartWithPlaceHolders, (String)"?");
        String rawNewName = info2.myQName;
        if (!rest.startsWith("(")) {
            JSType type2;
            if (rest.startsWith(":") && functionItem.isGetProperty() && (type2 = JSHtmlHighlightingUtil.parseType(StringUtil.trimStart((String)rest, (String)":").trim(), (PsiElement)functionItem)) != null) {
                JSDocBuilderSimpleInfo newReturnInfo = new JSDocBuilderSimpleInfo();
                newReturnInfo.setJSType(type2);
                return this.buildForFunctionFromService(functionItem, escapedName, substitutor, parameters, returnInfo, originalElement, info2, rawNewName, ContainerUtil.emptyList(), newReturnInfo);
            }
            return null;
        }
        JSFunction parsedFunction = TypeScriptQuickNavigateBuilder.parseFunctionText(rest, (PsiElement)functionItem);
        if (parsedFunction != null) {
            List<JSDocParameterInfoPrinter> newParameters = this.mapParametersToInfos(parsedFunction);
            JSDocBuilderSimpleInfo newReturnInfo = this.mapReturnTypeToInfo(parsedFunction);
            return this.buildForFunctionFromService(functionItem, escapedName, substitutor, parameters, returnInfo, originalElement, info2, rawNewName, newParameters, newReturnInfo);
        }
        return null;
    }

    @NotNull
    private CharSequence buildForFunctionFromService(@NotNull JSFunctionItem functionItem, @NotNull String escapedName, @NotNull JSTypeSubstitutor substitutor, @NotNull Collection<? extends JSDocParameterInfoPrinter> parameters, @NotNull JSDocBuilderSimpleInfo returnInfo, @NotNull PsiElement originalElement, @NotNull TypeScriptServiceQuickInfoParser.ParsedInfo info2, String rawNewName, List<JSDocParameterInfoPrinter> newParameters, JSDocBuilderSimpleInfo newReturnInfo) {
        CharSequence highlighting;
        CharSequence combined;
        if (functionItem == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(23);
        }
        if (escapedName == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(24);
        }
        if (substitutor == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(25);
        }
        if (parameters == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(26);
        }
        if (returnInfo == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(27);
        }
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(28);
        }
        if (info2 == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(29);
        }
        if ((combined = this.appendOwnSignature(functionItem, escapedName, substitutor, parameters, returnInfo, originalElement, highlighting = TypeScriptQuickNavigateBuilder.restoreHolders(info2, super.getFunctionDefinition(functionItem, StringUtil.escapeXmlEntities((String)rawNewName), JSTypeSubstitutor.EMPTY, newParameters, newReturnInfo, originalElement, true)))) != null) {
            CharSequence charSequence = combined;
            if (charSequence == null) {
                TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(30);
            }
            return charSequence;
        }
        CharSequence charSequence = highlighting;
        if (charSequence == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(31);
        }
        return charSequence;
    }

    @Nullable
    private CharSequence appendOwnSignature(@NotNull JSFunctionItem functionItem, @NotNull String escapedName, @NotNull JSTypeSubstitutor substitutor, @NotNull Collection<? extends JSDocParameterInfoPrinter> parameters, @NotNull JSDocBuilderSimpleInfo returnInfo, @NotNull PsiElement originalElement, CharSequence highlighting) {
        if (functionItem == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(32);
        }
        if (escapedName == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(33);
        }
        if (substitutor == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(34);
        }
        if (parameters == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(35);
        }
        if (returnInfo == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(36);
        }
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(37);
        }
        if (TypeScriptQuickNavigateBuilder.isShownOwnType()) {
            CharSequence ownSignature = super.getFunctionDefinition(functionItem, escapedName, substitutor, parameters, returnInfo, originalElement, true);
            return highlighting + "\n[ide]\n" + ownSignature;
        }
        return null;
    }

    @NotNull
    private static CharSequence restoreHolders(@NotNull TypeScriptServiceQuickInfoParser.ParsedInfo info2, @NotNull CharSequence highlighting) {
        if (info2 == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(38);
        }
        if (highlighting == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(39);
        }
        if (!info2.myPlaceholders.isEmpty()) {
            for (JSHtmlHighlightingUtil.TextPlaceholder placeholder : info2.myPlaceholders) {
                highlighting = placeholder.restoreText(highlighting);
            }
        }
        CharSequence charSequence = highlighting;
        if (charSequence == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(40);
        }
        return charSequence;
    }

    @Nullable
    private static JSFunction parseFunctionText(@NotNull String text2, @NotNull PsiElement originalElement) {
        if (text2 == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(41);
        }
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(42);
        }
        try {
            String prefix = "function test";
            String suffix = " {}";
            JSExpression candidate = JSPsiElementFactory.createJSExpression(prefix + text2 + suffix, originalElement);
            if (PsiUtilCore.hasErrorElementChild((PsiElement)candidate) || !(candidate instanceof JSFunction) || candidate.getTextLength() != prefix.length() + suffix.length() + text2.length()) {
                return null;
            }
            return (JSFunction)((Object)candidate);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.getInstance(TypeScriptQuickNavigateBuilder.class).warn((Throwable)e);
            return null;
        }
    }

    @Override
    protected JSType appendOptionality(@NotNull JSElement variableOrField, @Nullable JSType declaredType, @Nullable JSType narrowedType, @NotNull StringBuilder builder2, @NotNull PsiElement originalElement) {
        TypeScriptConfig config;
        if (variableOrField == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(43);
        }
        if (builder2 == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(44);
        }
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(45);
        }
        if ((config = TypeScriptConfigUtil.getConfigForPsiFile(originalElement.getContainingFile())) != null && config.strictNullChecks() && narrowedType != null && !TypeScriptTypeRelations.isUnionWithUndefinedType(narrowedType)) {
            return narrowedType;
        }
        return super.appendOptionality(variableOrField, declaredType, narrowedType, builder2, originalElement);
    }

    @Override
    protected void appendTypeWithSeparatorForOwner(@NotNull JSElement typeOwner, @Nullable JSType toUse, @NotNull JSTypeSubstitutor substitutor, @NotNull StringBuilder builder2, @NotNull PsiElement originalElement, boolean jsDoc) {
        if (typeOwner == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(46);
        }
        if (substitutor == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(47);
        }
        if (builder2 == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(48);
        }
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(49);
        }
        if (!jsDoc) {
            super.appendTypeWithSeparatorForOwner(typeOwner, toUse, substitutor, builder2, originalElement, false);
            return;
        }
        if (this.appendServiceType(typeOwner, builder2, originalElement)) {
            if (TypeScriptQuickNavigateBuilder.isShownOwnType()) {
                builder2.append("\n<span>[ide type]</span>");
                super.appendTypeWithSeparatorForOwner(typeOwner, toUse, substitutor, builder2, originalElement, true);
            }
            return;
        }
        super.appendTypeWithSeparatorForOwner(typeOwner, toUse, substitutor, builder2, originalElement, true);
    }

    private boolean appendServiceType(@NotNull JSElement typeOwner, @NotNull StringBuilder builder2, @NotNull PsiElement originalElement) {
        TypeScriptServiceQuickInfoParser.ParsedInfo info2;
        if (typeOwner == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(50);
        }
        if (builder2 == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(51);
        }
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(52);
        }
        if ((info2 = this.fetcher.getParsedServiceInfo(originalElement)) == null) {
            return false;
        }
        try {
            String part = info2.myRestPartWithPlaceHolders;
            if (!part.startsWith(":") && !part.startsWith("?:")) {
                return false;
            }
            String serviceTypeText = part.substring(part.startsWith(":") ? 1 : 2).trim();
            JSType parsedServiceType = JSHtmlHighlightingUtil.parseType(serviceTypeText, originalElement);
            if (parsedServiceType != null) {
                CharSequence highlighting = TypeScriptQuickNavigateBuilder.restoreHolders(info2, JSTypeHighlightingHelper.getTypeBody(parsedServiceType, (PsiElement)typeOwner, originalElement));
                this.appendType(originalElement, highlighting.toString(), builder2);
            } else {
                builder2.append(TypeScriptQuickNavigateBuilder.restoreHolders(info2, StringUtil.escapeXmlEntities((String)part)));
            }
            return true;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.getInstance(TypeScriptQuickNavigateBuilder.class).warn((Throwable)e);
            return false;
        }
    }

    @Override
    protected void appendVariableInitializer(@NotNull JSVariable variable, @NotNull StringBuilder result2) {
        if (variable == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(53);
        }
        if (result2 == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(54);
        }
        if (variable instanceof TypeScriptVariable && variable.isConst()) {
            return;
        }
        String text2 = variable.getLiteralOrReferenceInitializerText();
        if (text2 != null) {
            super.appendVariableInitializer(variable, result2);
        }
    }

    @Override
    @Nullable
    public String getDocumentationFromLanguageService(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(55);
        }
        return this.fetcher.getServiceDocumentation(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 15, 16, 30, 31, 40 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 14: 
            case 22: 
            case 28: 
            case 37: 
            case 42: 
            case 45: 
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qNameWithGenerics";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 5: 
            case 9: 
            case 17: 
            case 23: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionItem";
                break;
            }
            case 6: 
            case 11: 
            case 19: 
            case 25: 
            case 34: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 7: 
            case 15: 
            case 16: 
            case 30: 
            case 31: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/documentation/TypeScriptQuickNavigateBuilder";
                break;
            }
            case 10: 
            case 18: 
            case 24: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapedName";
                break;
            }
            case 12: 
            case 20: 
            case 26: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 13: 
            case 21: 
            case 27: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnInfo";
                break;
            }
            case 29: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighting";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableOrField";
                break;
            }
            case 44: 
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 46: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeOwner";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/documentation/TypeScriptQuickNavigateBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionNameWithHtml";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionDefinition";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "buildForFunctionFromService";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "restoreHolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickNavigateInfoForNavigationElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseFunctionCall";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionNameGenericsHtml";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionNameWithHtml";
                break;
            }
            case 7: 
            case 15: 
            case 16: 
            case 30: 
            case 31: 
            case 40: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isWhitelisted";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionDefinition";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getServiceFunctionDefinition";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "buildForFunctionFromService";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "appendOwnSignature";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "restoreHolders";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "parseFunctionText";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "appendOptionality";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "appendTypeWithSeparatorForOwner";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "appendServiceType";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "appendVariableInitializer";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationFromLanguageService";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 15, 16, 30, 31, 40 -> new IllegalStateException(string);
        };
    }
}

