/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.protocol;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.ProjectFileDirMacro;
import com.intellij.ide.macro.ProjectNameMacro;
import com.intellij.ide.macro.ProjectPathMacro;
import com.intellij.ide.macro.UnixSeparatorsMacro;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpNodePackage;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswerConsumer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceNodeStdProtocolBase;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCommandSetRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptServiceInitialStateObject;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptServiceStandardOutputProtocol
extends JSLanguageServiceNodeStdProtocolBase {
    private static final Set<Macro> PROJECT_LEVEL_MACRO = ContainerUtil.newHashSet((Object[])new Macro[]{new UnixSeparatorsMacro(), new ProjectFileDirMacro(), new ProjectNameMacro(), new ProjectPathMacro()});
    public static final String EVENT_TYPE = "event";
    public static final String EVENT_PROPERTY = "event";
    public static final String REQUEST_COMPLETED = "requestCompleted";
    public static final String BODY = "body";
    @NotNull
    private final LocalFilePath myServiceFilePath;
    @Nullable
    private final LocalFilePath myPackageJson;
    @NotNull
    private final TypeScriptCompilerSettings mySettings;
    @NotNull
    private final Consumer<? super JSLanguageServiceAnswer> myEventConsumer;

    public TypeScriptServiceStandardOutputProtocol(@NotNull Project project, @NotNull TypeScriptCompilerSettings settings2, @NotNull Consumer<?> readyConsumer, @NotNull Consumer<? super JSLanguageServiceAnswer> eventConsumer, @Nullable String serviceName, @NotNull String tsServicePath) {
        String packageJsonPath;
        if (project == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(0);
        }
        if (settings2 == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(1);
        }
        if (readyConsumer == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(2);
        }
        if (eventConsumer == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(3);
        }
        if (tsServicePath == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(4);
        }
        super(serviceName, project, readyConsumer);
        this.mySettings = settings2;
        this.myEventConsumer = eventConsumer;
        YarnPnpNodePackage yarnPnpNodePackage = YarnPnpNodePackage.createFromText(tsServicePath);
        String packageJson2 = null;
        if (yarnPnpNodePackage != null && (packageJsonPath = yarnPnpNodePackage.getPackageJsonPath(this.myProject)) != null) {
            packageJson2 = packageJsonPath;
            tsServicePath = yarnPnpNodePackage.getName();
        }
        this.myServiceFilePath = LocalFilePath.create(tsServicePath);
        this.myPackageJson = LocalFilePath.create(packageJson2);
    }

    @Override
    public TypeScriptServiceInitialStateObject createState() {
        TypeScriptServiceInitialStateObject state = new TypeScriptServiceInitialStateObject();
        this.fillState(state);
        return state;
    }

    protected void fillState(TypeScriptServiceInitialStateObject state) {
        state.pluginName = "typescript";
        state.pluginPath = LocalFilePath.create(this.getFilePath(new File(TypeScriptUtil.getTypeScriptCompilerFolderFile(), "typescript/ts-plugin").getAbsolutePath()));
        state.serverFolderPath = this.myServiceFilePath;
        state.packageJson = this.myPackageJson;
        state.sessionId = String.valueOf(this.mySessionId);
        state.isUseSingleInferredProject = this.mySettings.isUseSingleInferredProject();
        state.defaultConfig = LocalFilePath.create(this.getDefaultConfigPath());
        this.setManualOptions(state);
    }

    @Nullable
    private String getDefaultConfigPath() {
        return TypeScriptLanguageServiceUtil.getDefaultConfigPath(this.myProject);
    }

    @NotNull
    protected @NotNull LocalFilePath @NotNull [] getProbeLocations() {
        String path2;
        File nodeModulesParentFile;
        HashSet<LocalFilePath> pluginProbeLocations = new HashSet<LocalFilePath>();
        File tsserverFile = new File(LocalFilePath.getPath(this.myServiceFilePath));
        File typescriptPackageFile = tsserverFile.getParentFile();
        File nodeModulesFile = typescriptPackageFile != null ? typescriptPackageFile.getParentFile() : null;
        File file = nodeModulesParentFile = nodeModulesFile != null ? nodeModulesFile.getParentFile() : null;
        if (nodeModulesParentFile != null) {
            pluginProbeLocations.add(LocalFilePath.create(nodeModulesParentFile.getPath()));
        }
        pluginProbeLocations.add(LocalFilePath.create(this.getFilePath(new File(TypeScriptUtil.getTypeScriptCompilerFolderFile(), "typescript").getAbsolutePath())));
        VirtualFile dir = ProjectUtil.guessProjectDir((Project)this.myProject);
        if (dir != null && (path2 = this.getFilePath(dir)) != null) {
            pluginProbeLocations.add(LocalFilePath.create(path2));
        }
        LocalFilePath[] localFilePathArray = pluginProbeLocations.toArray(new LocalFilePath[0]);
        if (localFilePathArray == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(5);
        }
        return localFilePathArray;
    }

    @NotNull
    protected List<String> getGlobalPlugins() {
        List<String> list2 = Collections.singletonList("tsc-ide-plugin");
        if (list2 == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(6);
        }
        return list2;
    }

    protected void setManualOptions(@NotNull TypeScriptServiceInitialStateObject state) {
        if (state == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(7);
        }
        state.hasManualParams = this.mySettings.useDeprecatedSettings();
        String params = this.mySettings.getDefaultServiceOptions();
        boolean emptyOrSpaces = StringUtil.isEmptyOrSpaces((String)params);
        if (emptyOrSpaces && !state.hasManualParams) {
            return;
        }
        String[] parsedParams = emptyOrSpaces ? ArrayUtilRt.EMPTY_STRING_ARRAY : ParametersList.parse((String)params);
        ArrayList<String> paramList = new ArrayList<String>(Arrays.asList(parsedParams));
        if (!state.hasManualParams) {
            if (!paramList.isEmpty()) {
                state.commandLineArguments = (LocalFilePath[])ContainerUtil.map2Array(paramList, LocalFilePath.class, path2 -> LocalFilePath.create(path2));
            }
            return;
        }
        String outFile = null;
        boolean hasMainFile = this.hasMainFile();
        if (this.hasOutputDirectory()) {
            state.projectPath = LocalFilePath.create(this.getProjectPathString());
            Pair<String, String> pair = null;
            try {
                pair = this.getOutInformation(hasMainFile);
            }
            catch (Exception e) {
                JSLanguageServiceQueue.Holder.LOGGER.error(e.getMessage(), (Throwable)e);
            }
            if (pair != null) {
                outFile = (String)pair.first;
                String outDir = (String)pair.second;
                if (!StringUtil.isEmpty((String)outDir)) {
                    if (outFile == null && !outDir.contains("$")) {
                        paramList.add("--outDir");
                        paramList.add(FileUtilRt.toSystemDependentName((String)outDir));
                    } else {
                        state.outPath = LocalFilePath.create((String)pair.second);
                    }
                }
            }
        }
        boolean existsCommandLineOutParam = this.checkExistsCommandLineOut(parsedParams);
        if (!StringUtil.isEmpty(outFile) && !existsCommandLineOutParam) {
            paramList.add("--outFile");
            paramList.add(FileUtilRt.toSystemDependentName(outFile));
        }
        if (this.mySettings.isGenerateSourceMap()) {
            paramList.add("--sourceMap");
        }
        if (!paramList.isEmpty()) {
            state.commandLineArguments = (LocalFilePath[])ContainerUtil.map2Array(paramList, LocalFilePath.class, path2 -> LocalFilePath.create(path2));
        }
        if (hasMainFile) {
            state.mainFilePath = LocalFilePath.create(this.mySettings.getMainFilePath());
        }
    }

    @NotNull
    protected String expandOutputDirectoryMacro() throws Macro.ExecutionCancelledException {
        String outWithExpandedProjectMacro = FileUtil.toSystemIndependentName((String)this.mySettings.getOutDirectory());
        DataContext context2 = SimpleDataContext.getProjectContext((Project)this.myProject);
        for (Macro macro : PROJECT_LEVEL_MACRO) {
            String macroName = "$" + macro.getName() + "$";
            if (!outWithExpandedProjectMacro.contains(macroName)) continue;
            String expand = macro.expand(context2);
            if (expand == null) {
                expand = "";
            }
            outWithExpandedProjectMacro = StringUtil.replace((String)outWithExpandedProjectMacro, (String)macroName, (String)expand);
        }
        String string = outWithExpandedProjectMacro;
        if (string == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    protected void processAnswer(@NotNull JSLanguageServiceAnswer answer, @NotNull CharSequence text2) {
        if (answer == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(9);
        }
        if (text2 == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(10);
        }
        if ("event".equals(answer.getType())) {
            if (!this.processAsEventCompletion(answer)) {
                this.myEventConsumer.accept(answer);
            }
            return;
        }
        super.processAnswer(answer, text2);
    }

    @Override
    protected void prepareTargetRun(@NotNull NodeTargetRun targetRun) {
        List<String> plugins;
        if (targetRun == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(11);
        }
        super.prepareTargetRun(targetRun);
        LocalFilePath[] locations = this.getProbeLocations();
        List<TargetValue> targetLocations = Arrays.stream(locations).map(el -> el.getPath()).map(targetRun::path).toList();
        TargetedCommandLineBuilder builder2 = targetRun.getCommandLineBuilder();
        if (!targetLocations.isEmpty()) {
            builder2.addParameter("--pluginProbeLocations");
            builder2.addParameter(TargetValue.composite(targetLocations, targetPaths -> StringUtil.join((Collection)targetPaths, (String)",")));
        }
        if (!(plugins = this.getGlobalPlugins()).isEmpty()) {
            builder2.addParameter("--globalPlugins");
            builder2.addParameter(StringUtil.join(plugins, (String)","));
        }
    }

    private boolean processAsEventCompletion(@NotNull JSLanguageServiceAnswer answer) {
        String property;
        if (answer == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(12);
        }
        if (!REQUEST_COMPLETED.equals(property = answer.getProperty("event"))) {
            return false;
        }
        JsonObject element = answer.getElement();
        JsonElement body2 = element.get(BODY);
        if (body2 == null || !body2.isJsonObject()) {
            return false;
        }
        JsonObject object = body2.getAsJsonObject();
        JsonElement seq = object.get("request_seq");
        if (seq == null || !seq.isJsonPrimitive()) {
            return false;
        }
        int intSeq = seq.getAsInt();
        JSLanguageServiceAnswerConsumer callback = (JSLanguageServiceAnswerConsumer)this.myCallbacks.remove(intSeq);
        if (callback == null) {
            return false;
        }
        callback.consume(answer);
        return true;
    }

    @Override
    @Nullable
    protected NodeJsInterpreter getInterpreter() {
        return TypeScriptLanguageServiceUtil.getNodeInterpreter(this.myProject);
    }

    @Override
    @NotNull
    public final Object sendCommand(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceObject data, final @Nullable JSLanguageServiceAnswerConsumer resultConsumer) throws Exception {
        if (command == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(13);
        }
        if (data == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(14);
        }
        if (!(data instanceof TypeScriptCommandSetRequest)) {
            Object object = super.sendCommand(command, data, resultConsumer);
            if (object == null) {
                TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(15);
            }
            return object;
        }
        final LinkedHashMap<JSLanguageServiceObject, JSLanguageServiceCommand> requests = ((TypeScriptCommandSetRequest)data).nestedRequests;
        if (requests.size() == 1) {
            JSLanguageServiceObject item = (JSLanguageServiceObject)ContainerUtil.getFirstItem(requests.keySet());
            JSLanguageServiceCommand serviceCommand = requests.get(item);
            assert (item != null);
            Object object = super.sendCommand(serviceCommand, item, resultConsumer);
            if (object == null) {
                TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(16);
            }
            return object;
        }
        JSLanguageServiceAnswerConsumer mergedConsumer = resultConsumer == null ? null : new JSLanguageServiceAnswerConsumer(){
            final AtomicInteger requestsCount;
            {
                this.requestsCount = new AtomicInteger(requests.size());
            }

            @Override
            public void consume(JSLanguageServiceAnswer message) {
                if (this.requestsCount.decrementAndGet() == 0) {
                    resultConsumer.consume(message);
                }
            }
        };
        ArrayList ids = new ArrayList();
        try {
            requests.forEach((nestedObject, nestedCommand) -> {
                try {
                    ids.add(super.sendCommand((JSLanguageServiceCommand)nestedCommand, (JSLanguageServiceObject)nestedObject, mergedConsumer));
                }
                catch (IOException e) {
                    throw new IORuntimeException(e);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            });
        }
        catch (IORuntimeException e) {
            throw e.getCause();
        }
        ArrayList arrayList = ids;
        if (arrayList == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @Override
    protected void addNodeProcessAdditionalArguments(@NotNull NodeTargetRun targetRun) {
        if (targetRun == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(18);
        }
        super.addNodeProcessAdditionalArguments(targetRun);
        TargetedCommandLineBuilder commandLineBuilder = targetRun.getCommandLineBuilder();
        if (JSLanguageServiceQueue.Holder.LOGGER.isTraceEnabled()) {
            TargetValue<String> path2 = targetRun.path(this.myProject.getBasePath() + "/.log" + this.mySessionId);
            commandLineBuilder.addEnvironmentVariable("TSS_LOG", TargetValue.map(path2, targetPathValue -> "-level verbose -file \"" + targetPathValue + "\""));
        }
        commandLineBuilder.addEnvironmentVariable("TS_TSLINT_ENABLE_WORKSPACE_LIBRARY_EXECUTION", Boolean.TRUE.toString());
        if (this.myServiceName != null) {
            JSLanguageServiceUtil.addNodeProcessArgumentsFromRegistry(commandLineBuilder, this.myServiceName, this::getCommandLineArgsFromRegistry);
        }
        JSLanguageServiceUtil.addNodePathFromRegistry(commandLineBuilder, this::getNodePathFromRegistry);
        if (!(targetRun.getInterpreter() instanceof NodeJsLocalInterpreter)) {
            TypeScriptServiceStandardOutputProtocol.registerUploadVolumes(targetRun, (TypeScriptServiceInitialStateObject)ReadAction.compute(() -> this.createState()));
        }
    }

    private static void registerUploadVolumes(@NotNull NodeTargetRun targetRun, @NotNull TypeScriptServiceInitialStateObject initialState) {
        if (targetRun == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(19);
        }
        if (initialState == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(20);
        }
        targetRun.path(initialState.serverFolderPath.getPath());
        if (initialState.projectPath != null) {
            targetRun.path(initialState.projectPath.getPath());
        }
        if (initialState.defaultConfig != null) {
            targetRun.path(initialState.defaultConfig.getPath());
        }
        if (initialState.packageJson != null) {
            targetRun.path(initialState.packageJson.getPath());
        }
        targetRun.path(PathUtil.getParentPath((String)initialState.pluginPath.getPath()));
    }

    protected boolean hasMainFile() {
        return this.mySettings.useMainFile() && !StringUtil.isEmpty((String)this.mySettings.getMainFilePath());
    }

    protected boolean hasOutputDirectory() {
        return this.mySettings.isHasOutDirectory() && !StringUtil.isEmpty((String)this.mySettings.getOutDirectory());
    }

    @NotNull
    protected Pair<String, String> getOutInformation(boolean hasMainFile) throws Macro.ExecutionCancelledException {
        int indexOfSeparator;
        int indexOfDot;
        String outFile = null;
        String outWithExpandedProjectMacro = this.expandOutputDirectoryMacro();
        if (hasMainFile && (indexOfDot = outWithExpandedProjectMacro.lastIndexOf(46)) > 0 && indexOfDot > (indexOfSeparator = outWithExpandedProjectMacro.lastIndexOf(47))) {
            if (indexOfSeparator >= 0) {
                outFile = VfsUtil.extractFileName((String)outWithExpandedProjectMacro);
                outWithExpandedProjectMacro = VfsUtil.getParentDir((String)outWithExpandedProjectMacro);
            } else {
                outFile = outWithExpandedProjectMacro;
                outWithExpandedProjectMacro = null;
            }
        }
        if (!StringUtil.isEmpty((String)outWithExpandedProjectMacro)) {
            String path2 = FileUtil.toSystemDependentName((String)outWithExpandedProjectMacro);
            Pair pair = Pair.create(outFile, (Object)path2);
            if (pair == null) {
                TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(21);
            }
            return pair;
        }
        Pair pair = Pair.create(outFile, null);
        if (pair == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(22);
        }
        return pair;
    }

    @NotNull
    protected String getProjectPathString() {
        String path2 = this.myProject.getBasePath();
        String string = FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)path2));
        if (string == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(23);
        }
        return string;
    }

    protected boolean checkExistsCommandLineOut(String[] parse) {
        for (String s : parse) {
            if (!"-out".equals(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getWorkingDirectory() {
        if (this.myPackageJson != null) {
            return PathUtil.getParentPath((String)this.myPackageJson.getPath());
        }
        return super.getWorkingDirectory();
    }

    @Override
    @NotNull
    protected NodeCommandLineConfigurator.Options getNodeCommandLineConfiguratorOptions(@NotNull Project project) {
        YarnPnpNodePackage yarnPackage;
        if (project == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(24);
        }
        if ((yarnPackage = YarnPnpNodePackage.createFromText(this.myServiceFilePath.getPath())) != null) {
            NodeCommandLineConfigurator.Options options = NodeCommandLineConfigurator.defaultOptions(project).withRequiredNodePackage(yarnPackage);
            if (options == null) {
                TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(25);
            }
            return options;
        }
        NodeCommandLineConfigurator.Options options = super.getNodeCommandLineConfiguratorOptions(project);
        if (options == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(26);
        }
        return options;
    }

    public void dispose() {
    }

    @NotNull
    private String getCommandLineArgsFromRegistry() {
        String string = Registry.stringValue((String)"typescript.service.node.arguments");
        if (string == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    private String getNodePathFromRegistry() {
        String string = Registry.stringValue((String)"typescript.service.node.path");
        if (string == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(28);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 8, 15, 16, 17, 21, 22, 23, 25, 26, 27, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readyConsumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventConsumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsServicePath";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRun";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProbeLocations";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalPlugins";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "expandOutputDirectoryMacro";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "sendCommand";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutInformation";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectPathString";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeCommandLineConfiguratorOptions";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLineArgsFromRegistry";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodePathFromRegistry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setManualOptions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processAnswer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "prepareTargetRun";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processAsEventCompletion";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sendCommand";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addNodeProcessAdditionalArguments";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "registerUploadVolumes";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getNodeCommandLineConfiguratorOptions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 8, 15, 16, 17, 21, 22, 23, 25, 26, 27, 28 -> new IllegalStateException(string);
        };
    }

    private static class IORuntimeException
    extends RuntimeException {
        IORuntimeException(IOException cause) {
            super(cause);
        }

        @Override
        public synchronized IOException getCause() {
            return (IOException)super.getCause();
        }
    }
}

