/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSAnnotationErrorsFilter;
import com.intellij.lang.javascript.service.JSAsyncLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceProjectErrors;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceNodeStdProtocolBase;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.typescript.compiler.languageService.LanguageServiceInfo;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerServiceImpl;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptDiagnosticsResponse;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptServiceProjectErrors
extends JSLanguageServiceProjectErrors<JSLanguageServiceAnswer> {
    public static final Key<Boolean> TOOL_WINDOW_IS_SHOWN = Key.create((String)"problems.tool.window.open");
    public static final int MERGE_INTERVAL_MILLS = 200;
    @NotNull
    private final JSLanguageServiceProtocol myProtocol;
    @NotNull
    private final JSAsyncLanguageServiceBase.JSLanguageServiceInfoReporter myReporter;
    @NotNull
    private final MergingUpdateQueue myProjectErrorsQueue;

    public TypeScriptServiceProjectErrors(@NotNull Project project, @NotNull JSLanguageServiceProtocol protocol, @NotNull JSAsyncLanguageServiceBase.JSLanguageServiceInfoReporter reporter, @NotNull JSAnnotationErrorsFilter filter) {
        if (project == null) {
            TypeScriptServiceProjectErrors.$$$reportNull$$$0(0);
        }
        if (protocol == null) {
            TypeScriptServiceProjectErrors.$$$reportNull$$$0(1);
        }
        if (reporter == null) {
            TypeScriptServiceProjectErrors.$$$reportNull$$$0(2);
        }
        if (filter == null) {
            TypeScriptServiceProjectErrors.$$$reportNull$$$0(3);
        }
        super(project, filter);
        this.myProtocol = protocol;
        this.myReporter = reporter;
        this.myProjectErrorsQueue = new MergingUpdateQueue("TypeScript service project errors queue", 200, true, null, (Disposable)this.myDisposable, null, Alarm.ThreadToUse.POOLED_THREAD);
    }

    @Override
    @Nullable
    protected Pair<String, List<JSAnnotationError>> getPathAndErrors(@NotNull JSLanguageServiceAnswer answer, @Nullable LanguageServiceInfo languageServiceInfo) {
        JsonObject element;
        JsonElement body2;
        if (answer == null) {
            TypeScriptServiceProjectErrors.$$$reportNull$$$0(4);
        }
        if ((body2 = (element = answer.getElement()).get("body")) == null) {
            return null;
        }
        TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo responseInfo = (TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo)this.getGson().fromJson(body2, TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo.class);
        String path2 = LocalFilePath.getPath(responseInfo.file);
        List<JSAnnotationError> newElements = TypeScriptServerServiceImpl.parseDiagnosticsForFile(path2, responseInfo.diagnostics, this.getProject(), languageServiceInfo);
        return Pair.create((Object)path2, newElements);
    }

    private Gson getGson() {
        Gson gson;
        JSLanguageServiceProtocol jSLanguageServiceProtocol = this.myProtocol;
        if (jSLanguageServiceProtocol instanceof JSLanguageServiceNodeStdProtocolBase) {
            JSLanguageServiceNodeStdProtocolBase nodeProtocol = (JSLanguageServiceNodeStdProtocolBase)jSLanguageServiceProtocol;
            gson = nodeProtocol.getGson();
        } else {
            gson = JSLanguageServiceQueue.SharedGson.GSON;
        }
        return gson;
    }

    @Override
    protected void queueUpdate() {
        this.myProjectErrorsQueue.queue(new Update(this){

            public void run() {
                TypeScriptServiceProjectErrors.this.logCurrentErrors();
            }
        });
    }

    @Override
    protected void cancelAllUpdates() {
        this.myProjectErrorsQueue.cancelAllUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCurrentErrors() {
        List<JSAnnotationError> result2;
        TypeScriptServiceProjectErrors typeScriptServiceProjectErrors = this;
        synchronized (typeScriptServiceProjectErrors) {
            if (this.myDisposed) {
                return;
            }
            if (this.myProjectContext == null) {
                return;
            }
            result2 = this.getAllErrors();
        }
        this.myReporter.logCurrentErrors(null, result2);
    }

    @NotNull
    private synchronized List<JSAnnotationError> getAllErrors() {
        List<JSAnnotationError> list2 = Stream.concat(this.myGlobalErrors.stream(), this.myErrors.values().stream().flatMap(el -> el.stream())).collect(Collectors.toList());
        if (list2 == null) {
            TypeScriptServiceProjectErrors.$$$reportNull$$$0(5);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptServiceProjectErrors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptServiceProjectErrors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllErrors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPathAndErrors";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

