/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationStatisticsCollector;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceProvider;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceResultContainer;
import com.intellij.lang.javascript.service.JSLanguageServiceUpdateContext;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.typescript.compiler.InlayHintsPreferences;
import com.intellij.lang.typescript.compiler.PrioritySuspendingTaskQueue;
import com.intellij.lang.typescript.compiler.PrioritySuspendingTaskQueueFactory;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerServiceRequest;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptGetElementTypeRequest;
import com.intellij.lang.typescript.compiler.TypeScriptGetSymbolTypeRequest;
import com.intellij.lang.typescript.compiler.TypeScriptGetTypePropertiesRequest;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.lang.typescript.compiler.TypeScriptServiceEvaluationSupport;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceResponseParser;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerServiceCompletionEntry;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerServiceImpl;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.CompletionDetailsRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.ConfigureRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.ConfigureRequestArguments;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.QuickInfoCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompletionsCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompletionsRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptDefinitionAndBoundSpanCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileLocationRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetElementTypeRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetSymbolTypeRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetTypePropertiesRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptInlayHintsCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptInlayHintsRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptServiceCommandClean;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptSignatureHelpCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.UserPreferences;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.InlayHintItem;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptCompletionResponse;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptDefinitionAndBoundSpanResponse;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptQuickInfoResponse;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptResponseCommon;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptSignatureHelpResponse;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServerServiceSettings;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsc.TypeScriptServiceEvaluationSupportBase;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 h2\u00020\u00012\u00020\u0002:\u0003hijB\u0019\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0004J\u0018\u0010%\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010&2\u0006\u0010(\u001a\u00020)H\u0007J\u0018\u0010%\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010&2\u0006\u0010(\u001a\u00020$H\u0007J\"\u0010*\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010'\u0018\u00010&2\u0006\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020\u001eH&J\u0018\u0010-\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010&2\u0006\u0010(\u001a\u00020$H&J\u0012\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u00010$H&J\b\u00101\u001a\u00020\"H&J8\u00102\u001a\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u000204\u0018\u000103\u0018\u00010&2\u0006\u0010#\u001a\u00020$2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016J(\u0010;\u001a\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u00020=\u0018\u00010<\u0018\u00010&2\u0006\u0010>\u001a\u00020 2\u0006\u00105\u001a\u000206H\u0002J>\u0010?\u001a\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u000204\u0018\u000103\u0018\u00010&2\u0006\u0010#\u001a\u00020$2\f\u0010@\u001a\b\u0012\u0004\u0012\u000204032\u0006\u00105\u001a\u0002062\u0006\u0010A\u001a\u000208H\u0016J%\u0010B\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010<2\u0006\u00105\u001a\u0002062\u0006\u0010>\u001a\u00020 H\u0016\u00a2\u0006\u0002\u0010CJ-\u0010B\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010<2\u0006\u00105\u001a\u0002062\u0006\u0010>\u001a\u00020 2\u0006\u0010D\u001a\u00020\u001eH\u0002\u00a2\u0006\u0002\u0010EJ\b\u0010F\u001a\u00020GH\u0004J6\u0010H\u001a\u0018\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020I\u0018\u00010<j\u0004\u0018\u0001`J\u0018\u00010&2\u0006\u0010+\u001a\u00020K2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020OH\u0016J%\u0010P\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010<2\u0006\u00105\u001a\u0002062\u0006\u0010>\u001a\u00020 H\u0016\u00a2\u0006\u0002\u0010CJ\"\u0010Q\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010R\u0018\u00010&2\u0006\u0010S\u001a\u00020 2\u0006\u0010T\u001a\u00020$H\u0017J(\u0010U\u001a\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u00020W\u0018\u00010V\u0018\u00010&2\u0006\u0010+\u001a\u00020K2\u0006\u0010X\u001a\u00020YH\u0016J\u0010\u0010Z\u001a\u00020\t2\u0006\u00109\u001a\u00020OH\u0002J\u0010\u0010[\u001a\u00020\"2\u0006\u0010N\u001a\u00020OH\u0002J\u0016\u0010\\\u001a\u00020\"2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020_0^H$J\b\u0010`\u001a\u00020\"H\u0014J(\u0010a\u001a\u0004\u0018\u00010b2\u0006\u0010#\u001a\u00020$2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u0010c\u001a\u00020bJ\u0010\u0010d\u001a\u00020\"2\u0006\u0010e\u001a\u00020fH&J\u001a\u0010g\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001e\u0018\u00010&2\u0006\u0010X\u001a\u00020/H&R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\n\u001a\u00070\u0006\u00a2\u0006\u0002\b\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR&\u0010\u000e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u0004\u0012\u00020\u00120\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006k"}, d2={"Lcom/intellij/lang/typescript/compiler/TypeScriptCompilerService;", "Lcom/intellij/lang/javascript/service/JSLanguageServiceBase;", "Lcom/intellij/lang/typescript/compiler/TypeScriptService;", "project", "Lcom/intellij/openapi/project/Project;", "consoleId", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "myLastSentUserPreferences", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/UserPreferences;", "name", "Lcom/intellij/openapi/util/NlsSafe;", "getName", "()Ljava/lang/String;", "requestQueue", "Lcom/intellij/lang/typescript/compiler/PrioritySuspendingTaskQueue;", "Lcom/intellij/lang/typescript/compiler/TypeScriptCompilerServiceRequest;", "", "Lcom/google/gson/JsonObject;", "getRequestQueue", "()Lcom/intellij/lang/typescript/compiler/PrioritySuspendingTaskQueue;", "serviceSettings", "Lcom/intellij/lang/typescript/compiler/ui/TypeScriptServerServiceSettings;", "getServiceSettings", "()Lcom/intellij/lang/typescript/compiler/ui/TypeScriptServerServiceSettings;", "typeEvaluationSupport", "Lcom/intellij/lang/typescript/compiler/TypeScriptServiceEvaluationSupport;", "getTypeEvaluationSupport", "()Lcom/intellij/lang/typescript/compiler/TypeScriptServiceEvaluationSupport;", "canUseServiceForNavigation", "", "place", "Lcom/intellij/psi/PsiElement;", "commitDocumentsWithNBRA", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "compileConfigProjectAndGetErrors", "Ljava/util/concurrent/Future;", "Lcom/intellij/lang/javascript/service/JSLanguageServiceResultContainer;", "config", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptConfig;", "compileFile", "file", "explicit", "compileProject", "createUpdateContext", "Lcom/intellij/lang/javascript/service/JSLanguageServiceUpdateContext;", "contextFile", "flushCommandQueue", "getCompletionItems", "", "Lcom/intellij/lang/typescript/compiler/TypeScriptService$CompletionEntry;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "getDeclaration", "", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptResponseCommon$FileSpan;", "sourceElement", "getDetailedCompletionItems", "completionEntries", "positionInFileOffset", "getElementDefinitions", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiElement;", "withUpdate", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/psi/PsiElement;Z)[Lcom/intellij/psi/PsiElement;", "getGson", "Lcom/google/gson/Gson;", "getInlayHints", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/InlayHintItem;", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptInlayHintsResponse;", "Lcom/intellij/psi/PsiFile;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "hintsPreferences", "Lcom/intellij/lang/typescript/compiler/InlayHintsPreferences;", "getNavigationFor", "getQuickInfoAt", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptQuickInfoResponse;", "usageElement", "originalFile", "getSignatureHelp", "Ljava/util/stream/Stream;", "Lcom/intellij/lang/javascript/psi/JSFunctionType;", "context", "Lcom/intellij/lang/parameterInfo/CreateParameterInfoContext;", "getUserPreferences", "maybeReconfigure", "processVfsChangesForFiles", "contentChanged", "", "Lcom/intellij/lang/typescript/compiler/TypeScriptCompilerService$UpdateFileInfo;", "resetState", "resolveCompletionItem", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptCompletionResponse$CompletionEntryDetails;", "completionEntry", "sendCleanCommandToCompiler", "command", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptServiceCommandClean;", "update", "Companion", "TypeScriptCompilerServiceEvaluationSupport", "UpdateFileInfo", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nTypeScriptCompilerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptCompilerService.kt\ncom/intellij/lang/typescript/compiler/TypeScriptCompilerService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,537:1\n31#2,2:538\n37#3,2:540\n1549#4:542\n1620#4,3:543\n11065#5:546\n11400#5,3:547\n11065#5:550\n11400#5,3:551\n*S KotlinDebug\n*F\n+ 1 TypeScriptCompilerService.kt\ncom/intellij/lang/typescript/compiler/TypeScriptCompilerService\n*L\n62#1:538,2\n135#1:540,2\n203#1:542\n203#1:543,3\n173#1:546\n173#1:547,3\n208#1:550\n208#1:551,3\n*E\n"})
public abstract class TypeScriptCompilerService
extends JSLanguageServiceBase
implements TypeScriptService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PrioritySuspendingTaskQueue<TypeScriptCompilerServiceRequest<? extends Object>, JsonObject> requestQueue;
    @NotNull
    private final TypeScriptServiceEvaluationSupport typeEvaluationSupport;
    @Nullable
    private UserPreferences myLastSentUserPreferences;

    protected TypeScriptCompilerService(@NotNull Project project, @NotNull String consoleId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)consoleId, (String)"consoleId");
        super(project, consoleId);
        ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
        boolean $i$f$service = false;
        Class<PrioritySuspendingTaskQueueFactory> serviceClass$iv = PrioritySuspendingTaskQueueFactory.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.requestQueue = ((PrioritySuspendingTaskQueueFactory)object).createQueue();
        this.typeEvaluationSupport = new TypeScriptCompilerServiceEvaluationSupport(project);
    }

    public /* synthetic */ TypeScriptCompilerService(Project project, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "Console";
        }
        this(project, string);
    }

    @Override
    @NotNull
    public String getName() {
        String string = JavaScriptBundle.message("typescript.language.service.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    protected final PrioritySuspendingTaskQueue<TypeScriptCompilerServiceRequest<? extends Object>, JsonObject> getRequestQueue() {
        return this.requestQueue;
    }

    @Override
    @NotNull
    public TypeScriptServiceEvaluationSupport getTypeEvaluationSupport() {
        return this.typeEvaluationSupport;
    }

    public abstract void flushCommandQueue();

    @Nullable
    public abstract TypeScriptServerServiceSettings getServiceSettings();

    public abstract void sendCleanCommandToCompiler(@NotNull TypeScriptServiceCommandClean var1);

    @Nullable
    public abstract Future<JSLanguageServiceResultContainer> compileFile(@NotNull VirtualFile var1, boolean var2);

    @Nullable
    public abstract Future<JSLanguageServiceResultContainer> compileProject(@NotNull VirtualFile var1);

    protected abstract void processVfsChangesForFiles(@NotNull Collection<UpdateFileInfo> var1);

    @Nullable
    public abstract Future<Boolean> update(@NotNull JSLanguageServiceUpdateContext var1);

    @NotNull
    public abstract JSLanguageServiceUpdateContext createUpdateContext(@Nullable VirtualFile var1);

    protected boolean canUseServiceForNavigation(@NotNull PsiElement place) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        return TypeScriptLanguageServiceUtil.isServiceEnabled(place.getProject()) && this.checkCanUseService();
    }

    @Override
    @Nullable
    public PsiElement[] getElementDefinitions(@NotNull Document document2, @NotNull PsiElement sourceElement) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"sourceElement");
        return this.getElementDefinitions(document2, sourceElement, true);
    }

    @Override
    @Nullable
    public PsiElement[] getNavigationFor(@NotNull Document document2, @NotNull PsiElement sourceElement) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"sourceElement");
        if (!this.canUseServiceForNavigation(sourceElement)) {
            return null;
        }
        return this.getElementDefinitions(document2, sourceElement, false);
    }

    /*
     * WARNING - void declaration
     */
    private final PsiElement[] getElementDefinitions(Document document2, PsiElement sourceElement, boolean withUpdate) {
        void $this$toTypedArray$iv;
        if (!TypeScriptLanguageServiceUtil.isServiceEnabled(sourceElement.getProject()) || !this.checkCanUseService()) {
            return null;
        }
        if (withUpdate) {
            JSLanguageServiceQueue process = this.getProcess();
            if (process == null) {
                return null;
            }
            VirtualFile virtualFile = sourceElement.getContainingFile().getVirtualFile();
            JSLanguageServiceUpdateContext context2 = this.createUpdateContext(virtualFile);
            this.update(context2);
        }
        Future<TypeScriptResponseCommon.FileSpan[]> future = this.getDeclaration(sourceElement, document2);
        if (future == null) {
            return null;
        }
        Future<TypeScriptResponseCommon.FileSpan[]> future2 = future;
        Object[] objectArray = JSLanguageServiceUtil.awaitFuture(future2, 700L, 5L, null);
        if (objectArray == null) {
            return null;
        }
        Object[] spans = objectArray;
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)this.myProject);
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem lfs = localFileSystem;
        Collection collection = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])spans), (Function1)((Function1)new Function1<TypeScriptResponseCommon.FileSpan, PsiElement>(lfs, psiManager2, docManager){
            final /* synthetic */ LocalFileSystem $lfs;
            final /* synthetic */ PsiManager $psiManager;
            final /* synthetic */ PsiDocumentManager $docManager;
            {
                this.$lfs = $lfs;
                this.$psiManager = $psiManager;
                this.$docManager = $docManager;
                super(1);
            }

            @Nullable
            public final PsiElement invoke(@NotNull TypeScriptResponseCommon.FileSpan it) {
                TextRange range;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                VirtualFile virtualFile = this.$lfs.findFileByPath(it.file.getPath());
                if (virtualFile == null) {
                    return null;
                }
                VirtualFile file = virtualFile;
                PsiFile psiFile2 = this.$psiManager.findFile(file);
                if (psiFile2 == null) {
                    return null;
                }
                PsiFile psiFile3 = psiFile2;
                Document document2 = this.$docManager.getDocument(psiFile3);
                if (document2 == null) {
                    return null;
                }
                Document newDocument = document2;
                JSLanguageServiceUtil.PsiElementInfo psiElementInfo = TypeScriptLanguageServiceUtil.getPsiElementInfo(psiFile3, newDocument, it.start, it.end);
                if (psiElementInfo == null) {
                    return null;
                }
                JSLanguageServiceUtil.PsiElementInfo info2 = psiElementInfo;
                PsiElement element = info2.getElement();
                if (element != null) {
                    return element;
                }
                TextRange textRange2 = range = info2.getRange();
                return textRange2 != null ? TypeScriptPsiUtil.getPsiElementByRange(psiFile3, textRange2) : null;
            }
        }))), (Function1)getElementDefinitions.2.INSTANCE)), (Function1)getElementDefinitions.3.INSTANCE));
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiElement[0]);
    }

    private final Future<TypeScriptResponseCommon.FileSpan[]> getDeclaration(PsiElement sourceElement, Document document2) {
        VirtualFile file = sourceElement.getContainingFile().getVirtualFile();
        if (file == null || !this.isServiceCreated()) {
            return null;
        }
        TypeScriptFileLocationRequestArgs args = new TypeScriptFileLocationRequestArgs();
        int offset = sourceElement.getTextRange().getStartOffset();
        TypeScriptLanguageServiceUtil.fillFilePosition(args, file, document2, offset);
        return this.sendCommand(new TypeScriptDefinitionAndBoundSpanCommand(args), (arg_0, arg_1) -> TypeScriptCompilerService.getDeclaration$lambda$0(this, arg_0, arg_1));
    }

    @Override
    @Nullable
    public Future<List<TypeScriptService.CompletionEntry>> getCompletionItems(@NotNull VirtualFile virtualFile, @NotNull Document document2, int offset, @NotNull CompletionParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        JSLanguageServiceQueue jSLanguageServiceQueue = this.getProcess();
        if (jSLanguageServiceQueue == null) {
            return null;
        }
        JSLanguageServiceQueue process = jSLanguageServiceQueue;
        JSLanguageServiceUpdateContext context2 = this.createUpdateContext(virtualFile);
        TypeScriptCompletionsRequestArgs args = new TypeScriptCompletionsRequestArgs();
        TypeScriptLanguageServiceUtil.fillFilePosition(args, virtualFile, document2, offset);
        TypeScriptCompletionsCommand completionCommand = new TypeScriptCompletionsCommand(args);
        this.update(context2);
        return process.execute(completionCommand, (arg_0, arg_1) -> TypeScriptCompilerService.getCompletionItems$lambda$2(this, virtualFile, document2, offset, arg_0, arg_1));
    }

    @Nullable
    public final TypeScriptCompletionResponse.CompletionEntryDetails resolveCompletionItem(@NotNull VirtualFile virtualFile, @NotNull Document document2, int offset, @NotNull TypeScriptCompletionResponse.CompletionEntryDetails completionEntry) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter((Object)completionEntry, (String)"completionEntry");
        JSLanguageServiceQueue jSLanguageServiceQueue = this.getProcess();
        if (jSLanguageServiceQueue == null) {
            return null;
        }
        JSLanguageServiceQueue process = jSLanguageServiceQueue;
        CompletionDetailsRequest request2 = new CompletionDetailsRequest(CollectionsKt.listOf((Object)completionEntry.name));
        TypeScriptLanguageServiceUtil.fillFilePosition((TypeScriptFileLocationRequestArgs)request2.arguments, virtualFile, document2, offset);
        CompletableFuture<TypeScriptCompletionResponse.CompletionEntryDetails> future = process.execute(request2, (arg_0, arg_1) -> TypeScriptCompilerService.resolveCompletionItem$lambda$3(this, arg_0, arg_1));
        return (TypeScriptCompletionResponse.CompletionEntryDetails)JSLanguageServiceUtil.awaitFuture(future, 700L, 5L, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Future<List<TypeScriptService.CompletionEntry>> getDetailedCompletionItems(@NotNull VirtualFile virtualFile, @NotNull List<? extends TypeScriptService.CompletionEntry> completionEntries, @NotNull Document document2, int positionInFileOffset) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter(completionEntries, (String)"completionEntries");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        JSLanguageServiceQueue jSLanguageServiceQueue = this.getProcess();
        if (jSLanguageServiceQueue == null) {
            return null;
        }
        JSLanguageServiceQueue process = jSLanguageServiceQueue;
        Iterable $this$map$iv = completionEntries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeScriptService.CompletionEntry completionEntry = (TypeScriptService.CompletionEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        Collection collection = (List)destination$iv$iv;
        CompletionDetailsRequest request2 = new CompletionDetailsRequest(collection);
        TypeScriptLanguageServiceUtil.fillFilePosition((TypeScriptFileLocationRequestArgs)request2.arguments, virtualFile, document2, positionInFileOffset);
        return process.execute(request2, (arg_0, arg_1) -> TypeScriptCompilerService.getDetailedCompletionItems$lambda$6(this, virtualFile, document2, positionInFileOffset, arg_0, arg_1));
    }

    @Override
    @Nullable
    public Future<Stream<JSFunctionType>> getSignatureHelp(@NotNull PsiFile file, @NotNull CreateParameterInfoContext context2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        TypeScriptFileLocationRequestArgs args = new TypeScriptFileLocationRequestArgs();
        TypeScriptLanguageServiceUtil.fillFilePosition(args, file.getVirtualFile(), context2.getEditor().getDocument(), context2.getOffset());
        return this.sendCommand(new TypeScriptSignatureHelpCommand(args), (arg_0, arg_1) -> TypeScriptCompilerService.getSignatureHelp$lambda$8(this, file, arg_0, arg_1));
    }

    @Override
    @RequiresReadLock
    @Nullable
    public Future<TypeScriptQuickInfoResponse> getQuickInfoAt(@NotNull PsiElement usageElement, @NotNull VirtualFile originalFile) {
        Intrinsics.checkNotNullParameter((Object)usageElement, (String)"usageElement");
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        PsiElement originalElement = usageElement;
        if (!originalElement.isValid()) {
            return null;
        }
        Project project = originalElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        TypeScriptCompilerSettings settings2 = TypeScriptCompilerSettings.getSettings(project2);
        if (!settings2.useService() || !settings2.isUseServiceQuickNavigate()) {
            return null;
        }
        TextRange range = (originalElement = Companion.adjustIntoIdentifier(originalElement)).getTextRange();
        if (range == null) {
            return null;
        }
        int offset = range.getStartOffset();
        TypeScriptFileLocationRequestArgs location = new TypeScriptFileLocationRequestArgs();
        Document document2 = PsiDocumentManager.getInstance((Project)project2).getDocument(originalElement.getContainingFile());
        if (document2 == null || offset >= document2.getTextLength()) {
            return null;
        }
        TypeScriptLanguageServiceUtil.fillFilePosition(location, originalFile, document2, offset);
        return this.sendCommand(new QuickInfoCommand(location), (arg_0, arg_1) -> TypeScriptCompilerService.getQuickInfoAt$lambda$9(this, arg_0, arg_1));
    }

    @Override
    @Nullable
    public Future<InlayHintItem[]> getInlayHints(@NotNull PsiFile file, @NotNull TextRange textRange2, @NotNull InlayHintsPreferences hintsPreferences) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)textRange2, (String)"textRange");
        Intrinsics.checkNotNullParameter((Object)hintsPreferences, (String)"hintsPreferences");
        if (!hintsPreferences.getAnyEnabled()) {
            return null;
        }
        VirtualFile virtualFile = file.getContainingFile().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        this.commitDocumentsWithNBRA(virtualFile);
        this.maybeReconfigure(hintsPreferences);
        TypeScriptInlayHintsRequestArgs args = new TypeScriptInlayHintsRequestArgs();
        Document document2 = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file.getContainingFile());
        if (document2 == null) {
            return null;
        }
        Document document3 = document2;
        TypeScriptLanguageServiceUtil.fillFileStartLength(this.getProject(), args, file.getVirtualFile(), document3, textRange2);
        return this.sendCommand(new TypeScriptInlayHintsCommand(args), (arg_0, arg_1) -> TypeScriptCompilerService.getInlayHints$lambda$10(this, arg_0, arg_1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void maybeReconfigure(InlayHintsPreferences hintsPreferences) {
        boolean bl;
        UserPreferences userPreferences = this.getUserPreferences(hintsPreferences);
        TypeScriptCompilerService typeScriptCompilerService = this;
        synchronized (typeScriptCompilerService) {
            boolean bl2;
            boolean bl3 = false;
            if (!Intrinsics.areEqual((Object)userPreferences, (Object)this.myLastSentUserPreferences)) {
                this.myLastSentUserPreferences = userPreferences;
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        boolean send = bl;
        if (send) {
            ConfigureRequestArguments args = new ConfigureRequestArguments("IntelliJ");
            args.setPreferences(userPreferences);
            this.sendCommand(new ConfigureRequest(args));
        }
    }

    private final UserPreferences getUserPreferences(InlayHintsPreferences parameters) {
        UserPreferences preferences = new UserPreferences(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 65535, null);
        preferences.setIncludeInlayParameterNameHints(parameters.getParameterName() ? "all" : "none");
        preferences.setIncludeInlayParameterNameHintsWhenArgumentMatchesName(parameters.getParameterName());
        preferences.setIncludeInlayFunctionParameterTypeHints(parameters.getFunctionParameterType());
        preferences.setIncludeInlayVariableTypeHints(parameters.getVariableType());
        preferences.setIncludeInlayVariableTypeHintsWhenTypeMatchesName(parameters.getVariableType());
        preferences.setIncludeInlayPropertyDeclarationTypeHints(parameters.getVariableType());
        preferences.setIncludeInlayFunctionLikeReturnTypeHints(parameters.getFunctionLikeReturnType());
        preferences.setIncludeInlayEnumMemberValueHints(parameters.getEnumMemberValue());
        preferences.setInteractiveInlayHints(true);
        return preferences;
    }

    @Override
    protected void resetState() {
        super.resetState();
        this.myLastSentUserPreferences = null;
        this.getTypeEvaluationSupport().dropCaches();
    }

    protected final void commitDocumentsWithNBRA(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        JSLanguageServiceUpdateContext updateContext = JSLanguageServiceUtil.nonBlockingReadActionWithTimeout(() -> TypeScriptCompilerService.commitDocumentsWithNBRA$lambda$12(this, virtualFile));
        Intrinsics.checkNotNull((Object)updateContext);
        this.update(updateContext);
    }

    @NotNull
    protected final Gson getGson() {
        Gson gson = JSLanguageServiceUtil.getGson(this);
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"getGson(...)");
        return gson;
    }

    @Deprecated(message="api compatibility", replaceWith=@ReplaceWith(expression="compileProject(config.configFile)", imports={}))
    @Nullable
    public final Future<JSLanguageServiceResultContainer> compileConfigProjectAndGetErrors(@NotNull TypeScriptConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        VirtualFile virtualFile = config.getConfigFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getConfigFile(...)");
        return this.compileProject(virtualFile);
    }

    @Deprecated(message="api compatibility", replaceWith=@ReplaceWith(expression="compileProject(config)", imports={}))
    @Nullable
    public final Future<JSLanguageServiceResultContainer> compileConfigProjectAndGetErrors(@NotNull VirtualFile config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return this.compileProject(config);
    }

    private static final TypeScriptResponseCommon.FileSpan[] getDeclaration$lambda$0(TypeScriptCompilerService this$0, JSLanguageServiceObject jSLanguageServiceObject, JSLanguageServiceAnswer answer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)answer, (String)"answer");
        Gson gson = JSLanguageServiceUtil.getGson(this$0);
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"getGson(...)");
        Gson gson2 = gson;
        TypeScriptDefinitionAndBoundSpanResponse response = (TypeScriptDefinitionAndBoundSpanResponse)gson2.fromJson((JsonElement)answer.getElement(), TypeScriptDefinitionAndBoundSpanResponse.class);
        TypeScriptDefinitionAndBoundSpanResponse.TypeScriptDefinitionInfoAndBoundSpan typeScriptDefinitionInfoAndBoundSpan = response.body;
        return typeScriptDefinitionInfoAndBoundSpan != null ? typeScriptDefinitionInfoAndBoundSpan.definitions : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final List getCompletionItems$lambda$2(TypeScriptCompilerService this$0, VirtualFile $virtualFile, Document $document, int $offset, JSLanguageServiceObject jSLanguageServiceObject, JSLanguageServiceAnswer answer) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$virtualFile, (String)"$virtualFile");
        Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
        Intrinsics.checkNotNullParameter((Object)jSLanguageServiceObject, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)answer, (String)"answer");
        TypeScriptCompletionResponse response = (TypeScriptCompletionResponse)this$0.getGson().fromJson((JsonElement)answer.getElement(), TypeScriptCompletionResponse.class);
        if (response.body != null) {
            void $this$mapTo$iv$iv;
            TypeScriptCompletionResponse.CompletionEntryDetails[] $this$map$iv = response.body;
            boolean $i$f$map = false;
            TypeScriptCompletionResponse.CompletionEntryDetails[] completionEntryDetailsArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void entry;
                void item$iv$iv;
                void var15_15 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)entry);
                collection.add(new TypeScriptServerServiceCompletionEntry(this$0, $virtualFile, $document, $offset, (TypeScriptCompletionResponse.CompletionEntryDetails)entry));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private static final TypeScriptCompletionResponse.CompletionEntryDetails resolveCompletionItem$lambda$3(TypeScriptCompilerService this$0, JSLanguageServiceObject jSLanguageServiceObject, JSLanguageServiceAnswer answer) {
        TypeScriptCompletionResponse.CompletionEntryDetails completionEntryDetails;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)jSLanguageServiceObject, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)answer, (String)"answer");
        TypeScriptCompletionResponse response = (TypeScriptCompletionResponse)this$0.getGson().fromJson((JsonElement)answer.getElement(), TypeScriptCompletionResponse.class);
        if (response.body != null) {
            completionEntryDetails = (TypeScriptCompletionResponse.CompletionEntryDetails)ArraysKt.firstOrNull((Object[])response.body);
        } else {
            TypeScriptCompletionResponse.CompletionEntryDetails[] cfr_ignored_0 = response.body;
            completionEntryDetails = null;
        }
        return completionEntryDetails;
    }

    /*
     * WARNING - void declaration
     */
    private static final List getDetailedCompletionItems$lambda$6(TypeScriptCompilerService this$0, VirtualFile $virtualFile, Document $document, int $positionInFileOffset, JSLanguageServiceObject jSLanguageServiceObject, JSLanguageServiceAnswer answer) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$virtualFile, (String)"$virtualFile");
        Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
        Intrinsics.checkNotNullParameter((Object)jSLanguageServiceObject, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)answer, (String)"answer");
        TypeScriptCompletionResponse response = (TypeScriptCompletionResponse)this$0.getGson().fromJson((JsonElement)answer.getElement(), TypeScriptCompletionResponse.class);
        if (response.body != null) {
            void $this$mapTo$iv$iv;
            TypeScriptCompletionResponse.CompletionEntryDetails[] $this$map$iv = response.body;
            boolean $i$f$map = false;
            TypeScriptCompletionResponse.CompletionEntryDetails[] completionEntryDetailsArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void entry;
                void item$iv$iv;
                void var15_15 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)entry);
                collection.add(new TypeScriptServerServiceCompletionEntry(this$0, $virtualFile, $document, $positionInFileOffset, (TypeScriptCompletionResponse.CompletionEntryDetails)entry));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private static final JSFunctionType getSignatureHelp$lambda$8$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (JSFunctionType)$tmp0.invoke(p0);
    }

    private static final Stream getSignatureHelp$lambda$8(TypeScriptCompilerService this$0, PsiFile $file, JSLanguageServiceObject jSLanguageServiceObject, JSLanguageServiceAnswer answer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)answer, (String)"answer");
        JsonObject jsonObject = answer.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getElement(...)");
        JsonObject element = jsonObject;
        JsonObject body2 = element.getAsJsonObject("body");
        if (body2 == null) {
            return null;
        }
        Gson gson = JSLanguageServiceUtil.getGson(this$0);
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"getGson(...)");
        Gson gson2 = gson;
        TypeScriptSignatureHelpResponse response = (TypeScriptSignatureHelpResponse)gson2.fromJson((JsonElement)body2, TypeScriptSignatureHelpResponse.class);
        List<JSFunctionItem> items = TypeScriptLanguageServiceResponseParser.parseFunctions(response, $file);
        return items.stream().map(arg_0 -> TypeScriptCompilerService.getSignatureHelp$lambda$8$lambda$7(getSignatureHelp.1.1.INSTANCE, arg_0));
    }

    private static final TypeScriptQuickInfoResponse getQuickInfoAt$lambda$9(TypeScriptCompilerService this$0, JSLanguageServiceObject jSLanguageServiceObject, JSLanguageServiceAnswer answer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)answer, (String)"answer");
        Gson gson = JSLanguageServiceUtil.getGson(this$0);
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"getGson(...)");
        Gson gson2 = gson;
        return TypeScriptLanguageServiceUtil.deserialize(gson2, answer, TypeScriptQuickInfoResponse.class);
    }

    private static final InlayHintItem[] getInlayHints$lambda$10(TypeScriptCompilerService this$0, JSLanguageServiceObject jSLanguageServiceObject, JSLanguageServiceAnswer answer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)jSLanguageServiceObject, (String)"<anonymous parameter 0>");
        if (answer == null) {
            return null;
        }
        Gson gson = JSLanguageServiceUtil.getGson(this$0);
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"getGson(...)");
        Gson gson2 = gson;
        JsonElement jsonElement = answer.getElement().get("body");
        if (jsonElement == null) {
            return null;
        }
        JsonElement body2 = jsonElement;
        return (InlayHintItem[])gson2.fromJson(body2, InlayHintItem[].class);
    }

    private static final JSLanguageServiceUpdateContext commitDocumentsWithNBRA$lambda$12(TypeScriptCompilerService this$0, VirtualFile $virtualFile) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$virtualFile, (String)"$virtualFile");
        return this$0.createUpdateContext($virtualFile);
    }

    @JvmStatic
    @Deprecated(message="Use {@link TypeScriptService#getCompilerServiceForFile} instead", replaceWith=@ReplaceWith(expression="getCompilerServiceForFile(project, virtualFile)", imports={"com.intellij.lang.typescript.compiler.TypeScriptService.Companion.getCompilerServiceForFile"}))
    @NotNull
    public static final TypeScriptCompilerService getDefaultService(@NotNull Project project) {
        return Companion.getDefaultService(project);
    }

    @JvmStatic
    @Deprecated(message="Use {@link TypeScriptService#getCompilerServiceForFile} instead", replaceWith=@ReplaceWith(expression="getCompilerServiceForFile(project, virtualFile)", imports={"com.intellij.lang.typescript.compiler.TypeScriptService.Companion.getCompilerServiceForFile"}))
    @Nullable
    public static final TypeScriptCompilerService getServiceForFile(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        return Companion.getServiceForFile(project, virtualFile);
    }

    @JvmStatic
    @Deprecated(message="Use {@link TypeScriptService#restartServices(Project, boolean)} instead", replaceWith=@ReplaceWith(expression="TypeScriptService.restartServices(project!!, recreateToolWindow)", imports={}))
    public static final void restartServices(@Nullable Project project, boolean recreateToolWindow) {
        Companion.restartServices(project, recreateToolWindow);
    }

    @JvmStatic
    public static final void sendCleanCommandToCompiler(@NotNull Project project, @NotNull TypeScriptServiceCommandClean command) {
        Companion.sendCleanCommandToCompiler(project, command);
    }

    @JvmStatic
    public static final void processVfsChangesForFiles(@NotNull Project project, @NotNull List<UpdateFileInfo> files2) {
        Companion.processVfsChangesForFiles(project, files2);
    }

    @JvmStatic
    @NotNull
    public static final List<TypeScriptCompilerService> getAll(@NotNull Project project) {
        return Companion.getAll(project);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u001a\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0007J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u00020\b0\u0012H\u0002J\u001e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0007H\u0007J\u001a\u0010\u0016\u001a\u00020\u00102\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007\u00a8\u0006\u001c"}, d2={"Lcom/intellij/lang/typescript/compiler/TypeScriptCompilerService$Companion;", "", "()V", "adjustIntoIdentifier", "Lcom/intellij/psi/PsiElement;", "originalElement", "getAll", "", "Lcom/intellij/lang/typescript/compiler/TypeScriptCompilerService;", "project", "Lcom/intellij/openapi/project/Project;", "getDefaultService", "getServiceForFile", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "processForServices", "", "consumer", "Ljava/util/function/Consumer;", "processVfsChangesForFiles", "files", "Lcom/intellij/lang/typescript/compiler/TypeScriptCompilerService$UpdateFileInfo;", "restartServices", "recreateToolWindow", "", "sendCleanCommandToCompiler", "command", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptServiceCommandClean;", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nTypeScriptCompilerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptCompilerService.kt\ncom/intellij/lang/typescript/compiler/TypeScriptCompilerService$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,537:1\n800#2,11:538\n*S KotlinDebug\n*F\n+ 1 TypeScriptCompilerService.kt\ncom/intellij/lang/typescript/compiler/TypeScriptCompilerService$Companion\n*L\n432#1:538,11\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Deprecated(message="Use {@link TypeScriptService#getCompilerServiceForFile} instead", replaceWith=@ReplaceWith(expression="getCompilerServiceForFile(project, virtualFile)", imports={"com.intellij.lang.typescript.compiler.TypeScriptService.Companion.getCompilerServiceForFile"}))
        @NotNull
        public final TypeScriptCompilerService getDefaultService(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(TypeScriptServerServiceImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (TypeScriptCompilerService)object;
        }

        @JvmStatic
        @Deprecated(message="Use {@link TypeScriptService#getCompilerServiceForFile} instead", replaceWith=@ReplaceWith(expression="getCompilerServiceForFile(project, virtualFile)", imports={"com.intellij.lang.typescript.compiler.TypeScriptService.Companion.getCompilerServiceForFile"}))
        @Nullable
        public final TypeScriptCompilerService getServiceForFile(@NotNull Project project, @NotNull VirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            return TypeScriptService.Companion.getCompilerServiceForFile(project, virtualFile);
        }

        @JvmStatic
        @Deprecated(message="Use {@link TypeScriptService#restartServices(Project, boolean)} instead", replaceWith=@ReplaceWith(expression="TypeScriptService.restartServices(project!!, recreateToolWindow)", imports={}))
        public final void restartServices(@Nullable Project project, boolean recreateToolWindow) {
            Project project2 = project;
            Intrinsics.checkNotNull((Object)project2);
            TypeScriptService.Companion.restartServices(project2, recreateToolWindow);
        }

        @JvmStatic
        public final void sendCleanCommandToCompiler(@NotNull Project project, @NotNull TypeScriptServiceCommandClean command) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            this.processForServices(project, arg_0 -> Companion.sendCleanCommandToCompiler$lambda$0((Function1)new Function1<TypeScriptCompilerService, Unit>(command){
                final /* synthetic */ TypeScriptServiceCommandClean $command;
                {
                    this.$command = $command;
                    super(1);
                }

                public final void invoke(@NotNull TypeScriptCompilerService service2) {
                    Intrinsics.checkNotNullParameter((Object)service2, (String)"service");
                    if (service2.isServiceCreated()) {
                        service2.sendCleanCommandToCompiler(this.$command);
                    }
                }
            }, arg_0));
        }

        @JvmStatic
        public final void processVfsChangesForFiles(@NotNull Project project, @NotNull List<UpdateFileInfo> files2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (project.isDisposed() || files2.isEmpty()) {
                return;
            }
            MultiMap multiMap = MultiMap.create();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"create(...)");
            MultiMap map = multiMap;
            for (UpdateFileInfo update2 : files2) {
                TypeScriptCompilerService service2;
                VirtualFile file = update2.getFile();
                if (!file.isValid() || (service2 = TypeScriptService.Companion.getCompilerServiceForFile(project, file)) == null) continue;
                map.putValue((Object)service2, (Object)update2);
            }
            for (Map.Entry entry : map.entrySet()) {
                Intrinsics.checkNotNull((Object)entry);
                TypeScriptCompilerService service3 = (TypeScriptCompilerService)entry.getKey();
                Collection toProcess = (Collection)entry.getValue();
                Intrinsics.checkNotNull((Object)toProcess);
                service3.processVfsChangesForFiles(toProcess);
            }
        }

        private final void processForServices(Project project, Consumer<? super TypeScriptCompilerService> consumer) {
            if (project.isDisposed()) {
                return;
            }
            List<JSLanguageService> list2 = JSLanguageServiceProvider.getLanguageServices(project);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getLanguageServices(...)");
            List<JSLanguageService> services = list2;
            services.forEach(arg_0 -> Companion.processForServices$lambda$1(consumer, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<TypeScriptCompilerService> getAll(@NotNull Project project) {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            List<JSLanguageService> list2 = JSLanguageServiceProvider.getLanguageServices(project);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getLanguageServices(...)");
            Iterable $this$filterIsInstance$iv = list2;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof TypeScriptCompilerService)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final PsiElement adjustIntoIdentifier(@NotNull PsiElement originalElement) {
            ASTNode name;
            Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
            PsiElement originalElement2 = originalElement;
            if (originalElement2 instanceof JSImplicitElement) {
                Object object = ObjectUtils.coalesce((Object)originalElement2.getParent(), (Object)originalElement2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"coalesce(...)");
                originalElement2 = (PsiElement)object;
            }
            if (originalElement2 instanceof PsiNameIdentifierOwner) {
                PsiElement identifier = ((PsiNameIdentifierOwner)originalElement2).getNameIdentifier();
                Object object = ObjectUtils.coalesce((Object)identifier, (Object)originalElement2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"coalesce(...)");
                originalElement2 = (PsiElement)object;
            } else if (originalElement2 instanceof JSReferenceExpression) {
                Object object = ObjectUtils.coalesce((Object)((JSReferenceExpression)originalElement2).getReferenceNameElement(), (Object)originalElement2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"coalesce(...)");
                originalElement2 = (PsiElement)object;
            } else if (originalElement2 instanceof JSThisExpression) {
                Object object = ObjectUtils.coalesce((Object)((JSThisExpression)originalElement2).getFirstChild(), (Object)originalElement2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"coalesce(...)");
                originalElement2 = (PsiElement)object;
            } else if (originalElement2 instanceof XmlTag && (name = XmlChildRole.START_TAG_NAME_FINDER.findChild(originalElement2.getNode())) != null) {
                Object object = ObjectUtils.coalesce((Object)name.getPsi(), (Object)originalElement2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"coalesce(...)");
                originalElement2 = (PsiElement)object;
            }
            return originalElement2;
        }

        private static final void sendCleanCommandToCompiler$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static final void processForServices$lambda$1(Consumer $consumer, JSLanguageService service2) {
            Intrinsics.checkNotNullParameter((Object)$consumer, (String)"$consumer");
            if (service2 instanceof TypeScriptCompilerService) {
                $consumer.accept(service2);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0094\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0094@\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0017H\u0094@\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u001aH\u0094@\u00a2\u0006\u0002\u0010\u001bR\u0014\u0010\u0005\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/lang/typescript/compiler/TypeScriptCompilerService$TypeScriptCompilerServiceEvaluationSupport;", "Lcom/intellij/lang/typescript/tsc/TypeScriptServiceEvaluationSupportBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/lang/typescript/compiler/TypeScriptCompilerService;Lcom/intellij/openapi/project/Project;)V", "service", "Lcom/intellij/lang/typescript/compiler/TypeScriptService;", "getService", "()Lcom/intellij/lang/typescript/compiler/TypeScriptService;", "commitDocumentsBeforeGetElementType", "", "element", "Lcom/intellij/psi/PsiElement;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getElementType", "Lcom/google/gson/JsonObject;", "args", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptGetElementTypeRequestArgs;", "(Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptGetElementTypeRequestArgs;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFilePath", "", "getSymbolType", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptGetSymbolTypeRequestArgs;", "(Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptGetSymbolTypeRequestArgs;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getTypeProperties", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptGetTypePropertiesRequestArgs;", "(Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptGetTypePropertiesRequestArgs;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nTypeScriptCompilerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptCompilerService.kt\ncom/intellij/lang/typescript/compiler/TypeScriptCompilerService$TypeScriptCompilerServiceEvaluationSupport\n+ 2 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,537:1\n326#2:538\n326#2:541\n326#2:542\n31#3,2:539\n*S KotlinDebug\n*F\n+ 1 TypeScriptCompilerService.kt\ncom/intellij/lang/typescript/compiler/TypeScriptCompilerService$TypeScriptCompilerServiceEvaluationSupport\n*L\n336#1:538\n345#1:541\n351#1:542\n339#1:539,2\n*E\n"})
    protected class TypeScriptCompilerServiceEvaluationSupport
    extends TypeScriptServiceEvaluationSupportBase {
        public TypeScriptCompilerServiceEvaluationSupport(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(project);
        }

        @Override
        @NotNull
        protected TypeScriptService getService() {
            return TypeScriptCompilerService.this;
        }

        @Override
        protected void commitDocumentsBeforeGetElementType(@NotNull PsiElement element, @NotNull VirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            TypeScriptCompilerService.this.commitDocumentsWithNBRA(virtualFile);
        }

        @Override
        @Nullable
        protected String getFilePath(@NotNull VirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            return TypeScriptCompilerConfigUtil.normalizeNameAndPath(virtualFile);
        }

        @Override
        @Nullable
        protected Object getElementType(@NotNull TypeScriptGetElementTypeRequestArgs args, @NotNull Continuation<? super JsonObject> $completion) {
            return TypeScriptCompilerServiceEvaluationSupport.getElementType$suspendImpl(this, args, $completion);
        }

        /*
         * Unable to fully structure code
         */
        static /* synthetic */ Object getElementType$suspendImpl(TypeScriptCompilerServiceEvaluationSupport var0, TypeScriptGetElementTypeRequestArgs var1_1, Continuation<? super JsonObject> var2_2) {
            if (!(var2_2 instanceof getElementType.1)) ** GOTO lbl-1000
            var9_3 = var2_2;
            if ((var9_3.label & -2147483648) != 0) {
                var9_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(var0, var2_2){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ TypeScriptCompilerServiceEvaluationSupport this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return TypeScriptCompilerServiceEvaluationSupport.getElementType$suspendImpl(this.this$0, null, (Continuation<? super JsonObject>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $i$f$currentCoroutineContext = false;
                    task = new TypeScriptGetElementTypeRequest((TypeScriptGetElementTypeRequestArgs)args, $this.TypeScriptCompilerService.this, $continuation.getContext());
                    $continuation.L$0 = task;
                    $continuation.label = 1;
                    v0 = $this.TypeScriptCompilerService.this.getRequestQueue().request((TypeScriptCompilerServiceRequest<? extends Object>)((PrioritySuspendingTaskQueue.Task)task), (Continuation<JsonObject>)$continuation);
                    if (v0 == var10_5) {
                        return var10_5;
                    }
                    ** GOTO lbl25
                }
                case 1: {
                    task = (TypeScriptGetElementTypeRequest)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl25:
                    // 2 sources

                    response = (JsonObject)v0;
                    if (JSEvaluationStatisticsCollector.State.INSTANCE.isEnabled()) {
                        $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
                        $i$f$service = false;
                        serviceClass$iv = JSEvaluationStatisticsCollector.class;
                        v1 = $this$service$iv.getService(serviceClass$iv);
                        if (v1 == null) {
                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                        }
                        ((JSEvaluationStatisticsCollector)v1).responseReady(task.getWasExecuted() == false);
                    }
                    return response;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @Override
        @Nullable
        protected Object getSymbolType(@NotNull TypeScriptGetSymbolTypeRequestArgs args, @NotNull Continuation<? super JsonObject> $completion) {
            return TypeScriptCompilerServiceEvaluationSupport.getSymbolType$suspendImpl(this, args, $completion);
        }

        /*
         * Unable to fully structure code
         */
        static /* synthetic */ Object getSymbolType$suspendImpl(TypeScriptCompilerServiceEvaluationSupport var0, TypeScriptGetSymbolTypeRequestArgs var1_1, Continuation<? super JsonObject> var2_2) {
            if (!(var2_2 instanceof getSymbolType.1)) ** GOTO lbl-1000
            var6_3 = var2_2;
            if ((var6_3.label & -2147483648) != 0) {
                var6_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(var0, var2_2){
                    /* synthetic */ Object result;
                    final /* synthetic */ TypeScriptCompilerServiceEvaluationSupport this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return TypeScriptCompilerServiceEvaluationSupport.getSymbolType$suspendImpl(this.this$0, null, (Continuation<? super JsonObject>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $i$f$currentCoroutineContext = false;
                    task = new TypeScriptGetSymbolTypeRequest((TypeScriptGetSymbolTypeRequestArgs)args, $this.TypeScriptCompilerService.this, $continuation.getContext());
                    $continuation.label = 1;
                    v0 = $this.TypeScriptCompilerService.this.getRequestQueue().request((TypeScriptCompilerServiceRequest<? extends Object>)((PrioritySuspendingTaskQueue.Task)task), (Continuation<JsonObject>)$continuation);
                    if (v0 == var7_5) {
                        return var7_5;
                    }
                    ** GOTO lbl23
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl23:
                    // 2 sources

                    response = (JsonObject)v0;
                    return response;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @Override
        @Nullable
        protected Object getTypeProperties(@NotNull TypeScriptGetTypePropertiesRequestArgs args, @NotNull Continuation<? super JsonObject> $completion) {
            return TypeScriptCompilerServiceEvaluationSupport.getTypeProperties$suspendImpl(this, args, $completion);
        }

        /*
         * Unable to fully structure code
         */
        static /* synthetic */ Object getTypeProperties$suspendImpl(TypeScriptCompilerServiceEvaluationSupport var0, TypeScriptGetTypePropertiesRequestArgs var1_1, Continuation<? super JsonObject> var2_2) {
            if (!(var2_2 instanceof getTypeProperties.1)) ** GOTO lbl-1000
            var6_3 = var2_2;
            if ((var6_3.label & -2147483648) != 0) {
                var6_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(var0, var2_2){
                    /* synthetic */ Object result;
                    final /* synthetic */ TypeScriptCompilerServiceEvaluationSupport this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return TypeScriptCompilerServiceEvaluationSupport.getTypeProperties$suspendImpl(this.this$0, null, (Continuation<? super JsonObject>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $i$f$currentCoroutineContext = false;
                    task = new TypeScriptGetTypePropertiesRequest((TypeScriptGetTypePropertiesRequestArgs)args, $this.TypeScriptCompilerService.this, $continuation.getContext());
                    $continuation.label = 1;
                    v0 = $this.TypeScriptCompilerService.this.getRequestQueue().request((TypeScriptCompilerServiceRequest<? extends Object>)((PrioritySuspendingTaskQueue.Task)task), (Continuation<JsonObject>)$continuation);
                    if (v0 == var7_5) {
                        return var7_5;
                    }
                    ** GOTO lbl23
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl23:
                    // 2 sources

                    response = (JsonObject)v0;
                    return response;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/lang/typescript/compiler/TypeScriptCompilerService$UpdateFileInfo;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isVfsChange", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "()Z", "intellij.javascript.impl"})
    public static final class UpdateFileInfo {
        @NotNull
        private final VirtualFile file;
        private final boolean isVfsChange;

        public UpdateFileInfo(@NotNull VirtualFile file, boolean isVfsChange) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
            this.isVfsChange = isVfsChange;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        public final boolean isVfsChange() {
            return this.isVfsChange;
        }
    }
}

