/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.util.treeView.TreeAnchorizer;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.structureView.JSFrameworkSpecificNodeProvider;
import com.intellij.lang.javascript.structureView.JSFrameworkSpecificStructureExtension;
import com.intellij.lang.javascript.structureView.JSNodeFactory;
import com.intellij.lang.javascript.structureView.JSStructureItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSStructureViewElementBase
extends PsiTreeElementBase<PsiElement> {
    @NotNull
    protected final List<Object> myElements;
    protected final boolean myInherited;
    @NotNull
    private final ItemPresentation myPresentation;
    @Nullable
    protected JSFrameworkSpecificNodeProvider myNodeProvider;

    public JSStructureViewElementBase(@NotNull List<PsiElement> elements, @Nullable ItemPresentation presentation, boolean inherited) {
        if (elements == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(0);
        }
        super(elements.get(0));
        this.myElements = ContainerUtil.map(elements, arg_0 -> ((TreeAnchorizer)TreeAnchorizer.getService()).createAnchor(arg_0));
        this.myPresentation = presentation != null ? presentation : this.createPresentation();
        this.myInherited = inherited;
    }

    public JSStructureViewElementBase(@NotNull PsiElement element, @Nullable ItemPresentation presentation, boolean inherited) {
        if (element == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(1);
        }
        super(element);
        this.myElements = Collections.emptyList();
        this.myPresentation = presentation != null ? presentation : this.createPresentation();
        this.myInherited = inherited;
    }

    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        PsiElement element = this.getValue();
        if (!element.isValid()) {
            List<StructureViewTreeElement> list2 = Collections.emptyList();
            if (list2 == null) {
                JSStructureViewElementBase.$$$reportNull$$$0(2);
            }
            return list2;
        }
        ArrayList<StructureViewTreeElement> children = new ArrayList<StructureViewTreeElement>(this.getOwnChildren());
        children.sort(JSStructureViewElementBase.injectionAwareComparator(element.getProject()));
        ArrayList<StructureViewTreeElement> arrayList = children;
        if (arrayList == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public abstract List<StructureViewTreeElement> getOwnChildren();

    @NotNull
    public abstract List<StructureViewTreeElement> getInherited();

    @Nullable
    protected JSNodeFactory getNodeFactory() {
        return null;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        ItemPresentation itemPresentation = this.myPresentation;
        if (itemPresentation == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(4);
        }
        return itemPresentation;
    }

    @Nullable
    public String getPresentableText() {
        return this.getPresentation().getPresentableText();
    }

    @NotNull
    public List<PsiElement> getAllElements() {
        List list2 = this.myElements.isEmpty() ? ContainerUtil.createMaybeSingletonList((Object)this.getElement()) : this.myElements.stream().map(anchor -> {
            Object o = TreeAnchorizer.getService().retrieveElement(anchor);
            return o instanceof PsiElement ? (PsiElement)o : null;
        }).filter(el -> el != null).collect(Collectors.toList());
        if (list2 == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Nullable
    protected String getNameForVariableOrFunction(@NotNull PsiElement element, int count) {
        ES6ComputedName expr;
        String name;
        if (element == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(6);
        }
        if (element instanceof JSFunction && ((JSFunction)element).isAnonymousFunctionCall()) {
            return null;
        }
        if (element instanceof JSFunctionExpression && ((JSFunctionExpression)element).getName() == null && PsiTreeUtil.getContextOfType((PsiElement)element, JSAssignmentExpression.class, (boolean)true, (Class[])new Class[]{JSFunction.class}) != null) {
            return String.valueOf(count);
        }
        if (JSStructureViewElementBase.skipVariable(element)) {
            return null;
        }
        if (element instanceof JSImplicitElement && ((JSImplicitElement)element).hasMinorImportance()) {
            return null;
        }
        if (element instanceof TypeScriptCallSignature) {
            String name2 = JSPsiImplUtils.getNameOrComputedPropertyName((TypeScriptCallSignature)element, true);
            return name2 != null ? name2 : String.valueOf(count);
        }
        if (element instanceof TypeScriptIndexSignature) {
            return "Index Signature";
        }
        if (element instanceof JSQualifiedNamedElement && ((JSQualifiedNamedElement)element).getName() == null && element.getParent() instanceof ES6ExportDefaultAssignment) {
            return JSFormatUtil.getDefaultMemberName();
        }
        if (element instanceof JSNamedElementBase && (name = JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)element, true)) != null) {
            return name;
        }
        if (element instanceof JSComputedPropertyNameOwner && (expr = ((JSComputedPropertyNameOwner)element).getComputedPropertyName()) != null) {
            return expr.getText();
        }
        return null;
    }

    protected boolean fillChildrenElement(@NotNull List<? extends PsiElement> mainElements, @NotNull MultiMap<String, PsiElementWithNodeProvider> children, @NotNull Function<? super PsiElement, ? extends Collection<? extends PsiElement>> childrenProvider, @NotNull ChildElementProcessor childProcessor, boolean oneElementOnly) {
        if (mainElements == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(7);
        }
        if (children == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(8);
        }
        if (childrenProvider == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(9);
        }
        if (childProcessor == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(10);
        }
        LinkedList<JSImplicitElement> queue = new LinkedList<JSImplicitElement>();
        for (PsiElement psiElement : mainElements) {
            queue.addAll((Collection)childrenProvider.fun((Object)psiElement));
        }
        while (!queue.isEmpty()) {
            JSExpression[] expressions;
            PsiElementWithNodeProvider elementWithNodeProvider;
            boolean processed;
            JSFrameworkSpecificNodeProvider nodeProvider;
            PsiElement element = (PsiElement)queue.poll();
            List<JSImplicitElement> list2 = this.getImplicitChildren(element);
            queue.addAll(0, list2);
            if (this.shouldSkipProcess(element)) continue;
            JSFrameworkSpecificStructureExtension structureExtension = JSFrameworkSpecificStructureExtension.accept(element);
            if (structureExtension != null && (nodeProvider = structureExtension.findNodeProvider(element)) != null) {
                String name = nodeProvider.getName(element);
                childProcessor.process(new PsiElementWithNodeProvider(element, nodeProvider), name == null ? "" : name);
                continue;
            }
            String name = this.getName(element, children.size());
            if (StringUtil.isNotEmpty((String)name) && !(element instanceof JSDestructuringProperty) && (processed = childProcessor.process(elementWithNodeProvider = new PsiElementWithNodeProvider(element), name))) {
                if (!oneElementOnly || children.isEmpty()) continue;
                return true;
            }
            if (element instanceof JSArrayLiteralExpression && (expressions = ((JSArrayLiteralExpression)element).getExpressions()).length > 1) {
                for (int i = 0; i < expressions.length; ++i) {
                    JSExpression expression = expressions[i];
                    if (expression == null || !this.hasStructureElements((PsiElement)expression)) continue;
                    children.putValue((Object)("[" + i + "]"), (Object)new PsiElementWithNodeProvider((PsiElement)expression));
                }
                continue;
            }
            if (JSStructureViewElementBase.isScopeChangingElement(element)) continue;
            queue.addAll(list2.size(), (Collection)childrenProvider.fun((Object)element));
        }
        return false;
    }

    @Nullable
    protected String getName(@NotNull PsiElement element, int count) {
        if (element == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(11);
        }
        return this.getNameForVariableOrFunction(element, count);
    }

    @NotNull
    public static Comparator<StructureViewTreeElement> injectionAwareComparator(@NotNull Project project) {
        if (project == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(12);
        }
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)project);
        Map offsets = FactoryMap.create(element -> {
            PsiElement o = JSStructureViewElementBase.getPsiElement(element);
            StubElement stub = o instanceof StubBasedPsiElement ? ((StubBasedPsiElement)o).getStub() : null;
            return stub != null ? -((StubBase)stub).getStubId() - 1 : manager.injectedToHost(o, o.getTextOffset());
        });
        Comparator comparator = (o1, o2) -> {
            int off1 = (Integer)offsets.get(o1);
            int off2 = (Integer)offsets.get(o2);
            if (off1 < 0 && off2 > 0) {
                return -1;
            }
            if (off1 > 0 && off2 < 0) {
                return 1;
            }
            return Math.abs(off1) - Math.abs(off2);
        };
        if (comparator == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(13);
        }
        return comparator;
    }

    @NotNull
    public static PsiElement getPsiElement(@NotNull StructureViewTreeElement element) {
        if (element == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(14);
        }
        PsiElement psiElement = (PsiElement)element.getValue();
        if (psiElement == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(15);
        }
        return psiElement;
    }

    @NotNull
    public JSStructureItemPresentation createPresentation() {
        return new JSStructureItemPresentation(this);
    }

    @NotNull
    protected static Collection<PsiElement> getPsiOrStubChildren(@NotNull PsiElement element) {
        StubElement stub;
        if (element == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(16);
        }
        Object object = element instanceof StubBasedPsiElement ? ((StubBasedPsiElement)element).getStub() : (stub = element instanceof PsiFileImpl ? ((PsiFileImpl)element).getStub() : null);
        if (stub != null) {
            List list2 = ContainerUtil.map((Collection)stub.getChildrenStubs(), o -> o.getPsi());
            if (list2 == null) {
                JSStructureViewElementBase.$$$reportNull$$$0(17);
            }
            return list2;
        }
        List<PsiElement> list3 = Arrays.asList(element.getChildren());
        if (list3 == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(18);
        }
        return list3;
    }

    public static boolean isScopeChangingElement(@Nullable PsiElement element) {
        return element instanceof JSFunction && !(element instanceof JSFunctionExpression) || element instanceof JSCatchBlock;
    }

    public boolean isInherited() {
        return this.myInherited;
    }

    @NotNull
    protected final JSStructureViewElementBase copyWithInherited() {
        JSStructureViewElementBase element = this.copyWithInheritedImpl();
        if (((Object)((Object)this)).getClass() != ((Object)((Object)element)).getClass()) {
            Logger.getInstance(JSStructureViewElementBase.class).error("Incorrect copy instance");
        }
        JSStructureViewElementBase jSStructureViewElementBase = element;
        if (jSStructureViewElementBase == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(19);
        }
        return jSStructureViewElementBase;
    }

    @NotNull
    protected abstract JSStructureViewElementBase copyWithInheritedImpl();

    protected static boolean isVisible(@Nullable PsiElement namedElement, @Nullable PsiElement element) {
        JSAttributeListOwner attributeListOwner;
        JSAttributeList attributeList;
        if (namedElement instanceof JSElementBase) {
            JSAttributeList.AccessType type2 = ((JSElementBase)namedElement).getAccessType();
            if (type2 == JSAttributeList.AccessType.PRIVATE) {
                return false;
            }
            if (namedElement instanceof JSFunctionItem) {
                return true;
            }
        }
        if (namedElement instanceof JSAttributeListOwner && (attributeList = (attributeListOwner = (JSAttributeListOwner)namedElement).getAttributeList()) != null) {
            JSAttributeList.AccessType type3 = attributeList.getAccessType();
            if (type3 == JSAttributeList.AccessType.PACKAGE_LOCAL) {
                return ActionScriptResolveUtil.isAccessibleFromCurrentActionScriptPackage(namedElement, element);
            }
            return type3 != JSAttributeList.AccessType.PRIVATE;
        }
        return true;
    }

    protected static boolean skipVariable(PsiElement element) {
        if (element instanceof JSDestructuringParameter) {
            return true;
        }
        if (!(element instanceof JSVariable)) {
            return false;
        }
        if (element instanceof JSParameter) {
            return true;
        }
        JSFunction fun = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{JSFunction.class});
        if (fun == null) {
            return false;
        }
        JSExpression initializer = ((JSVariable)element).getInitializerOrStub();
        if (initializer instanceof JSThisExpression || initializer instanceof JSAssignmentExpression) {
            return true;
        }
        if (fun instanceof JSFunctionExpression && fun.isAnonymousFunctionCall()) {
            return false;
        }
        if (JSResolveUtil.findParent(fun) instanceof JSClass) {
            return true;
        }
        return !JSSymbolUtil.isMeaningfulLocalVariableInitializer(initializer);
    }

    @NotNull
    protected List<JSImplicitElement> getImplicitChildren(PsiElement element) {
        if (element instanceof JSImplicitElementProvider) {
            Collection<JSImplicitElement> elements;
            JSElementIndexingData data = ((JSImplicitElementProvider)element).getIndexingData();
            Collection<JSImplicitElement> collection = elements = data != null ? data.getImplicitElements() : null;
            if (elements != null) {
                List list2 = ContainerUtil.filter(elements, it -> it.getUserString() == null);
                if (list2 == null) {
                    JSStructureViewElementBase.$$$reportNull$$$0(20);
                }
                return list2;
            }
        }
        List<JSImplicitElement> list3 = Collections.emptyList();
        if (list3 == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(21);
        }
        return list3;
    }

    protected boolean hasStructureElements(@Nullable PsiElement element) {
        return false;
    }

    protected boolean shouldSkipProcess(@Nullable PsiElement element) {
        return element instanceof ES6ImportDeclaration || element instanceof TypeScriptTypeParameterList;
    }

    protected void addElement(MultiMap<String, PsiElementWithNodeProvider> children, PsiElementWithNodeProvider element, String name) {
        JSFunction function2 = JSPsiImplUtils.getPossibleFunction(element.getElement());
        String nameOfFunction = JSPsiImplUtils.getNameOrComputedPropertyName(function2, true);
        if (function2 != null && StringUtil.equals((CharSequence)name, (CharSequence)nameOfFunction)) {
            element.setElement(function2);
        }
        String key2 = name != null ? name : JSFormatUtil.getAnonymousElementPresentation();
        this.addKeyElement(children, element, key2);
    }

    protected void addKeyElement(@NotNull MultiMap<String, PsiElementWithNodeProvider> children, @NotNull PsiElementWithNodeProvider structureElement, String key2) {
        if (children == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(22);
        }
        if (structureElement == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(23);
        }
        if (!children.get((Object)key2).contains(structureElement)) {
            children.putValue((Object)key2, (Object)structureElement);
        }
    }

    protected void sortChildrenByImplicitElements(@NotNull List<PsiElement> value) {
        if (value == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(24);
        }
        value.sort((e1, e2) -> {
            if (e1 instanceof JSImplicitElement && !(e2 instanceof JSImplicitElement)) {
                return 1;
            }
            if (e2 instanceof JSImplicitElement && !(e1 instanceof JSImplicitElement)) {
                return -1;
            }
            return 0;
        });
    }

    @NotNull
    protected List<StructureViewTreeElement> getInheritedForClass(@NotNull JSClass parentClass, @NotNull Function<? super PsiElement, ? extends JSStructureViewElementBase> wrapper) {
        if (parentClass == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(25);
        }
        if (wrapper == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(26);
        }
        Project project = parentClass.getProject();
        List list2 = ((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(o -> JBIterable.of((Object[])o.getSuperClasses())).withRoots((Iterable)JBIterable.of((Object[])parentClass.getSuperClasses()))).unique()).traverse(TreeTraversal.PLAIN_BFS).map(wrapper).flatten(o -> JBIterable.from(o.getOwnChildren()).sort(JSStructureViewElementBase.injectionAwareComparator(project))).filter(o -> o instanceof JSStructureViewElementBase && JSStructureViewElementBase.isVisible(((JSStructureViewElementBase)((Object)o)).getValue(), parentClass)).map(o -> ((JSStructureViewElementBase)((Object)o)).copyWithInherited()).toList();
        if (list2 == null) {
            JSStructureViewElementBase.$$$reportNull$$$0(27);
        }
        return list2;
    }

    protected boolean collectExtensionElements(PsiElementWithNodeProvider elementWithNodeProvider, List<StructureViewTreeElement> result2) {
        JSFrameworkSpecificNodeProvider nodeProvider = elementWithNodeProvider.getNodeProvider();
        JSNodeFactory nodeFactory = this.getNodeFactory();
        List<StructureViewTreeElement> providerNodes = null;
        if (nodeProvider != null && nodeFactory != null) {
            providerNodes = nodeProvider.getNodes(elementWithNodeProvider.getElement(), nodeFactory);
        }
        if (providerNodes != null && !providerNodes.isEmpty()) {
            result2.addAll(providerNodes);
        }
        return nodeProvider != null;
    }

    public JSStructureViewElementBase withNodeProvider(JSFrameworkSpecificNodeProvider nodeProvider) {
        this.myNodeProvider = nodeProvider;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        JSStructureViewElementBase element = (JSStructureViewElementBase)((Object)o);
        if (this.myInherited != element.myInherited) {
            return false;
        }
        return this.getAllElements().equals(element.getAllElements());
    }

    public int hashCode() {
        int result2 = 31 * super.hashCode() + this.getAllElements().hashCode();
        result2 = 31 * result2 + (this.myInherited ? 1 : 0);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 13, 15, 17, 18, 19, 20, 21, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/structureView/JSStructureViewElementBase";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainElements";
                break;
            }
            case 8: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childProcessor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structureElement";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/structureView/JSStructureViewElementBase";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllElements";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "injectionAwareComparator";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElement";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiOrStubChildren";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithInherited";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitChildren";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getInheritedForClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 27: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNameForVariableOrFunction";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fillChildrenElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "injectionAwareComparator";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPsiOrStubChildren";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addKeyElement";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "sortChildrenByImplicitElements";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getInheritedForClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 13, 15, 17, 18, 19, 20, 21, 27 -> new IllegalStateException(string);
        };
    }

    public static class PsiElementWithNodeProvider {
        @NotNull
        private PsiElement myElement;
        @Nullable
        private JSFrameworkSpecificNodeProvider myNodeProvider;

        public PsiElementWithNodeProvider(@NotNull PsiElement element, @Nullable JSFrameworkSpecificNodeProvider nodeProvider) {
            if (element == null) {
                PsiElementWithNodeProvider.$$$reportNull$$$0(0);
            }
            this.myElement = element;
            this.myNodeProvider = nodeProvider;
        }

        public PsiElementWithNodeProvider(@NotNull PsiElement element) {
            if (element == null) {
                PsiElementWithNodeProvider.$$$reportNull$$$0(1);
            }
            this.myElement = element;
        }

        @Nullable
        public JSFrameworkSpecificNodeProvider getNodeProvider() {
            return this.myNodeProvider;
        }

        @NotNull
        public PsiElement getElement() {
            PsiElement psiElement = this.myElement;
            if (psiElement == null) {
                PsiElementWithNodeProvider.$$$reportNull$$$0(2);
            }
            return psiElement;
        }

        public void setElement(@NotNull PsiElement element) {
            if (element == null) {
                PsiElementWithNodeProvider.$$$reportNull$$$0(3);
            }
            this.myElement = element;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PsiElementWithNodeProvider that = (PsiElementWithNodeProvider)o;
            if (!Objects.equals(this.myElement, that.myElement)) {
                return false;
            }
            return Objects.equals(this.myNodeProvider, that.myNodeProvider);
        }

        public int hashCode() {
            int result2 = this.myElement.hashCode();
            result2 = 31 * result2 + (this.myNodeProvider != null ? this.myNodeProvider.hashCode() : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/structureView/JSStructureViewElementBase$PsiElementWithNodeProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/structureView/JSStructureViewElementBase$PsiElementWithNodeProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setElement";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static interface ChildElementProcessor {
        public boolean process(@NotNull PsiElementWithNodeProvider var1, @NotNull String var2);
    }
}

