/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSAsyncLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceToolWindowInfoReporter
implements JSAsyncLanguageServiceBase.JSLanguageServiceInfoReporter {
    private final Project myProject;
    private final String myName;
    @NotNull
    private final JSLanguageServiceToolWindowManager myManager;
    private final boolean myActive;

    public JSLanguageServiceToolWindowInfoReporter(Project project, @NotNull String name, @NotNull JSLanguageServiceToolWindowManager manager, boolean setActive) {
        if (name == null) {
            JSLanguageServiceToolWindowInfoReporter.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            JSLanguageServiceToolWindowInfoReporter.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myName = name;
        this.myManager = manager;
        this.myActive = setActive;
    }

    @Override
    @NotNull
    public String getPresentableServiceName() {
        String string = this.myName;
        if (string == null) {
            JSLanguageServiceToolWindowInfoReporter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void startingError(@NotNull String errorText) {
        if (errorText == null) {
            JSLanguageServiceToolWindowInfoReporter.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!this.myProject.isInitialized()) {
                return;
            }
            this.myManager.logCurrentErrors(JSLanguageServiceAnnotationResult.buildError(errorText), this.myActive);
        });
    }

    @Override
    public void setProcess(@Nullable String text2) {
        ApplicationManager.getApplication().invokeLater(() -> this.myManager.setProgressText(text2), this.myProject.getDisposed());
    }

    @Override
    public void logCurrentErrors(@Nullable VirtualFile virtualFile, @NotNull List<JSAnnotationError> rawResults) {
        if (rawResults == null) {
            JSLanguageServiceToolWindowInfoReporter.$$$reportNull$$$0(4);
        }
        ArrayList<JSAnnotationError> subSorted = new ArrayList<JSAnnotationError>(rawResults);
        ContainerUtil.sort(subSorted, Comparator.comparing(JSAnnotationError::getAbsoluteFilePath));
        ApplicationManager.getApplication().invokeLater(() -> {
            Editor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
            if (editor instanceof EditorEx) {
                VirtualFile editorFile = editor.getVirtualFile();
                if (virtualFile == null || virtualFile.equals(editorFile)) {
                    if (editorFile != null) {
                        String editorFilePath = JSLanguageServiceUtil.normalizeNameAndPath(editorFile);
                        ContainerUtil.sort((List)subSorted, Comparator.comparing(el -> Objects.equals(el.getAbsoluteFilePath(), editorFilePath) ? -1 : 0));
                    }
                    this.myManager.logCurrentErrors(subSorted, false);
                }
            }
        }, this.myProject.getDisposed());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/JSLanguageServiceToolWindowInfoReporter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/JSLanguageServiceToolWindowInfoReporter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableServiceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "startingError";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "logCurrentErrors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

