/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduce;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.refactoring.introduce.BaseIntroduceSettings;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceDialog;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSBaseInplaceIntroducer<S extends BaseIntroduceSettings>
extends AbstractInplaceIntroducer<JSVariable, JSExpression> {
    protected final JSBaseIntroduceHandler<? extends JSElement, S, ? extends JSBaseIntroduceDialog> myIntroduceHandler;
    protected JSBaseIntroduceHandler.BaseIntroduceContext<S> myContext;
    protected final S myInitialSettings;
    @Nullable
    private RangeMarker myVarMarker;
    @Nullable
    private PsiFile myVarFile;
    protected boolean myIsIntroduceFromExpressionStatement;
    @Nullable
    protected final TextRange myInnerRange;
    protected final SubstringKind myIntroducingForSubstring;

    public JSBaseInplaceIntroducer(Project project, Editor editor, JSExpression expr, JSExpression[] occurrences, FileType languageFileType, JSBaseIntroduceHandler<? extends JSElement, S, ? extends JSBaseIntroduceDialog> introduceHandler, JSBaseIntroduceHandler.BaseIntroduceContext<S> introduceContext) {
        super(project, editor, (PsiElement)expr, null, (PsiElement[])occurrences, RefactoringBundle.message((String)"introduce.variable.title"), languageFileType);
        this.myIntroduceHandler = introduceHandler;
        this.myContext = introduceContext;
        this.myInitialSettings = this.myContext.settings;
        this.myScope = this.myContext.scope;
        this.myInnerRange = introduceContext.expressionDescriptor.second == null ? null : ((TextRange)introduceContext.expressionDescriptor.second).shiftLeft(((JSExpression)introduceContext.expressionDescriptor.first).getTextOffset());
        this.myIntroducingForSubstring = this.isIntroducingForSubstring(introduceContext);
    }

    @NotNull
    private SubstringKind isIntroducingForSubstring(@NotNull JSBaseIntroduceHandler.BaseIntroduceContext<S> introduceContext) {
        JSExpression expression;
        if (introduceContext == null) {
            JSBaseInplaceIntroducer.$$$reportNull$$$0(0);
        }
        if (!((expression = (JSExpression)introduceContext.expressionDescriptor.first) instanceof JSLiteralExpression)) {
            SubstringKind substringKind = SubstringKind.None;
            if (substringKind == null) {
                JSBaseInplaceIntroducer.$$$reportNull$$$0(1);
            }
            return substringKind;
        }
        TextRange introducedRange = (TextRange)introduceContext.expressionDescriptor.second;
        if (introducedRange == null) {
            SubstringKind substringKind = SubstringKind.None;
            if (substringKind == null) {
                JSBaseInplaceIntroducer.$$$reportNull$$$0(2);
            }
            return substringKind;
        }
        TextRange expressionRange = expression.getTextRange();
        if (((JSLiteralExpression)expression).isQuotedLiteral() && expressionRange.getStartOffset() + 1 == introducedRange.getStartOffset() && expressionRange.getEndOffset() - 1 == introducedRange.getEndOffset()) {
            SubstringKind substringKind = SubstringKind.None;
            if (substringKind == null) {
                JSBaseInplaceIntroducer.$$$reportNull$$$0(3);
            }
            return substringKind;
        }
        if (expressionRange.equals((Object)introducedRange) || !expressionRange.contains(introducedRange)) {
            SubstringKind substringKind = SubstringKind.None;
            if (substringKind == null) {
                JSBaseInplaceIntroducer.$$$reportNull$$$0(4);
            }
            return substringKind;
        }
        if (expression instanceof JSStringTemplateExpression) {
            SubstringKind substringKind = SubstringKind.Template;
            if (substringKind == null) {
                JSBaseInplaceIntroducer.$$$reportNull$$$0(5);
            }
            return substringKind;
        }
        SubstringKind substringKind = expressionRange.getStartOffset() + 1 == introducedRange.getStartOffset() ? SubstringKind.Start : (expressionRange.getEndOffset() - 1 == introducedRange.getEndOffset() ? SubstringKind.End : SubstringKind.Middle);
        if (substringKind == null) {
            JSBaseInplaceIntroducer.$$$reportNull$$$0(6);
        }
        return substringKind;
    }

    protected String getActionName() {
        return this.myTitle;
    }

    protected String @NotNull [] suggestNames(boolean replaceAll, @Nullable JSVariable variable) {
        String[] stringArray;
        String[] names;
        String[] stringArray2 = names = this.myScope.isValid() ? new BasicIntroducedEntityInfoProvider((JSExpression)this.myExpr, (JSExpression[])this.myOccurrences, this.myScope).suggestCandidateNames() : ArrayUtil.EMPTY_STRING_ARRAY;
        if (names.length > 0) {
            stringArray = names;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = this.myInitialSettings.getVariableName();
        }
        if (stringArray == null) {
            JSBaseInplaceIntroducer.$$$reportNull$$$0(7);
        }
        return stringArray;
    }

    @Nullable
    protected JSVariable createFieldToStartTemplateOn(boolean replaceAll, String @NotNull [] names) {
        JSBaseIntroduceHandler.IntroduceInfo info2;
        if (names == null) {
            JSBaseInplaceIntroducer.$$$reportNull$$$0(8);
        }
        if (!((JSExpression)this.myContext.expressionDescriptor.first).isValid()) {
            this.fixContext();
        }
        if ((info2 = (JSBaseIntroduceHandler.IntroduceInfo)WriteAction.compute(() -> this.myIntroduceHandler.doRefactoring(this.myProject, this.myEditor, this.myContext, false))) == null || info2.createdVariable == null) {
            return null;
        }
        this.myIsIntroduceFromExpressionStatement = info2.isFromExpressionStatement;
        if (info2.expression != null) {
            this.myExpr = info2.expression;
            this.myExprMarker = this.createMarker((PsiElement)info2.expression);
        }
        this.myVarMarker = this.myEditor.getDocument().createRangeMarker(info2.createdVariable.getTextRange());
        this.myVarFile = info2.createdVariable.getContainingFile();
        this.myOccurrences = (PsiElement[])info2.occurrences.toArray(JSExpression.EMPTY_ARRAY);
        this.setOccurrenceMarkers(ContainerUtil.map((Object[])((JSExpression[])this.myOccurrences), x$0 -> this.createMarker((PsiElement)x$0)));
        return info2.createdVariable;
    }

    protected abstract S getInplaceIntroduceSettings(String var1);

    protected void performCleanup() {
        JSVariable variable = this.getVariable();
        if (variable != null) {
            super.restoreState((PsiNameIdentifierOwner)variable);
        }
    }

    protected void performIntroduce() {
        Runnable runnable = () -> this.myIntroduceHandler.performIntroduce(this.myContext);
        ApplicationManager.getApplication().runWriteAction(runnable);
    }

    private void fixContext() {
        LOG.assertTrue(((JSExpression)this.myExpr).isValid());
        this.myContext = new JSBaseIntroduceHandler.BaseIntroduceContext<S>((Pair<JSExpression, TextRange>)Pair.create((Object)((JSExpression)this.myExpr), (Object)this.myExprMarker.getTextRange()), JSBaseInplaceIntroducer.ensureExpressionInArray((JSExpression[])this.getOccurrences(), (JSExpression)this.myExpr), this.myContext.scope, this.getInplaceIntroduceSettings(this.getInputName()));
    }

    protected void moveOffsetAfter(boolean success) {
        super.moveOffsetAfter(success);
        this.moveOffsetAfterVariable();
        String refactoringId = this.myIntroduceHandler.getRefactoringId();
        if (refactoringId != null) {
            RefactoringEventData afterData = new RefactoringEventData();
            afterData.addElement((PsiElement)this.getVariable());
            ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(refactoringId, afterData);
        }
    }

    protected void moveOffsetAfterVariable() {
        JSVarStatement varStatement;
        JSVariable variable = this.getVariable();
        if (variable != null && this.myIsIntroduceFromExpressionStatement && (varStatement = variable.getStatement()) != null) {
            this.myEditor.getCaretModel().moveToOffset(varStatement.getTextRange().getEndOffset());
        }
    }

    private static JSExpression[] ensureExpressionInArray(JSExpression[] array, JSExpression element) {
        for (JSExpression o : array) {
            if (element != o) continue;
            return array;
        }
        JSExpression[] newArray = new JSExpression[array.length + 1];
        newArray[0] = element;
        System.arraycopy(array, 0, newArray, 1, array.length);
        return newArray;
    }

    protected PsiElement checkLocalScope() {
        PsiElement element = super.checkLocalScope();
        return element == null || element instanceof PsiDirectory ? this.myElementToRename.getContainingFile() : element;
    }

    protected SearchScope getReferencesSearchScope(VirtualFile file) {
        return new LocalSearchScope((PsiElement)this.myElementToRename.getContainingFile());
    }

    public boolean isReplaceAllOccurrences() {
        return this.myInitialSettings.isReplaceAllOccurrences();
    }

    public void setReplaceAllOccurrences(boolean allOccurrences) {
    }

    protected void saveSettings(@NotNull JSVariable variable) {
        if (variable == null) {
            JSBaseInplaceIntroducer.$$$reportNull$$$0(9);
        }
    }

    protected JSVariable getVariable() {
        return this.myVarFile != null ? JSBaseInplaceIntroducer.restoreDeclarationFromMarker(this.myVarFile, this.myVarMarker, JSVariable.class) : null;
    }

    @Nullable
    public static <T extends JSNamedElement> T restoreDeclarationFromMarker(@NotNull PsiFile varFile, @Nullable RangeMarker varMarker, @NotNull Class<T> elementClass) {
        JSNamedElement variable;
        if (varFile == null) {
            JSBaseInplaceIntroducer.$$$reportNull$$$0(10);
        }
        if (elementClass == null) {
            JSBaseInplaceIntroducer.$$$reportNull$$$0(11);
        }
        if (varMarker == null || !varFile.isValid()) {
            return null;
        }
        PsiElement element = varFile.getContainingFile().findElementAt(varMarker.getStartOffset());
        if (element instanceof PsiWhiteSpace) {
            element = PsiTreeUtil.skipWhitespacesForward((PsiElement)element);
        }
        if ((variable = (JSNamedElement)PsiTreeUtil.getParentOfType((PsiElement)element, elementClass, (boolean)false)) != null) {
            return (T)variable;
        }
        element = PsiTreeUtil.skipWhitespacesBackward((PsiElement)element);
        return (T)((JSNamedElement)PsiTreeUtil.getParentOfType((PsiElement)element, elementClass, (boolean)false));
    }

    public JSExpression restoreExpression(@NotNull PsiFile containingFile2, @NotNull JSVariable variable, @NotNull RangeMarker marker, String exprText) {
        if (containingFile2 == null) {
            JSBaseInplaceIntroducer.$$$reportNull$$$0(12);
        }
        if (variable == null) {
            JSBaseInplaceIntroducer.$$$reportNull$$$0(13);
        }
        if (marker == null) {
            JSBaseInplaceIntroducer.$$$reportNull$$$0(14);
        }
        if (exprText == null) {
            return null;
        }
        PsiElement elementAt = containingFile2.findElementAt(marker.getStartOffset());
        if (elementAt == null) {
            return null;
        }
        PsiElement parent = elementAt.getParent();
        JSExpression candidateExpression = null;
        if (parent instanceof JSVarStatement) {
            JSVariable[] variables = ((JSVarStatement)parent).getVariables();
            if (variables.length == 1) {
                candidateExpression = variables[0].getInitializer();
            }
        } else if (parent instanceof JSExpression) {
            candidateExpression = (JSExpression)parent;
        }
        JSExpression result2 = null;
        if (candidateExpression instanceof JSReferenceExpression) {
            JSReferenceExpression refExpr = (JSReferenceExpression)candidateExpression;
            String referenceName = refExpr.getReferenceName();
            if (Comparing.strEqual((String)exprText, (String)referenceName)) {
                result2 = refExpr;
            } else if (refExpr.resolve() == variable || Comparing.strEqual((String)variable.getName(), (String)referenceName)) {
                JSExpression newExpression = (JSExpression)JSInheritedLanguagesHelper.createExpressionFromText(exprText, (PsiElement)variable);
                result2 = refExpr.replace(newExpression);
            }
        }
        LOG.assertTrue(result2 == null || result2.isValid());
        return result2;
    }

    protected void restoreState(@NotNull JSVariable psiField) {
        if (psiField == null) {
            JSBaseInplaceIntroducer.$$$reportNull$$$0(15);
        }
    }

    protected boolean ensureValid() {
        return true;
    }

    protected void restoreRangesForSubexpression() {
        if (this.isSubexpression()) {
            JSExpression finalExpression = (JSExpression)this.myExpr;
            while (finalExpression instanceof JSParenthesizedExpression && !this.myExprText.equals(finalExpression.getText())) {
                finalExpression = ((JSParenthesizedExpression)finalExpression).getInnerExpression();
            }
            String text2 = ((JSExpression)ObjectUtils.coalesce((Object)finalExpression, (Object)((JSExpression)this.myExpr))).getText();
            assert (text2.length() >= this.myInnerRange.getEndOffset());
            if (this.myIntroducingForSubstring == SubstringKind.None) {
                PsiElement psiElement = ((JSExpression)this.myExpr).getParent();
                if (psiElement instanceof JSExpression) {
                    JSExpression parent = (JSExpression)psiElement;
                    String substring = this.myInnerRange.substring(text2);
                    this.myExpr = ((JSExpression)this.myExpr).replace(JSPsiElementFactory.createJSExpression(substring, this.myExpr));
                    TextRange rangeInParent = ((JSExpression)this.myExpr).getTextRangeInParent();
                    PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myEditor.getDocument());
                    this.myExpr = parent;
                    this.myExprMarker = this.myEditor.getDocument().createRangeMarker(rangeInParent.shiftRight(parent.getTextOffset()));
                } else {
                    TextRange range = ((JSExpression)this.myExpr).getTextRange();
                    TextRange textRange2 = this.myInnerRange.shiftRight(range.getStartOffset());
                    this.myExprMarker = this.myEditor.getDocument().createRangeMarker(textRange2);
                }
            } else {
                PsiElement expressionParent = ((JSExpression)this.myExpr).getParent();
                if (expressionParent instanceof JSExpression) {
                    JSExpression parent = (JSExpression)expressionParent;
                    if (this.myIntroducingForSubstring == SubstringKind.Middle) {
                        parent = (JSExpression)parent.getParent();
                    }
                    this.myExpr = parent.replace(JSPsiElementFactory.createJSExpression(text2, (PsiElement)parent));
                    this.myExprMarker = this.myEditor.getDocument().createRangeMarker(this.myInnerRange.shiftRight(((JSExpression)this.myExpr).getTextOffset()));
                }
            }
            LOG.assertTrue(((JSExpression)this.myExpr).isValid());
        } else {
            this.myExprMarker = this.myEditor.getDocument().createRangeMarker(((JSExpression)this.myExpr).getTextRange());
        }
    }

    private boolean isSubexpression() {
        if (this.myInnerRange == null) {
            return false;
        }
        return !(this.myExpr instanceof JSLiteralExpression) || !((JSLiteralExpression)this.myExpr).isQuotedLiteral() || this.myInnerRange.getStartOffset() != 1 || this.myInnerRange.getEndOffset() != ((JSExpression)this.myExpr).getTextLength() - 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introduceContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/introduce/JSBaseInplaceIntroducer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduce/JSBaseInplaceIntroducer";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "isIntroducingForSubstring";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isIntroducingForSubstring";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createFieldToStartTemplateOn";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "saveSettings";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "restoreDeclarationFromMarker";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "restoreExpression";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "restoreState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }

    protected static enum SubstringKind {
        None,
        Start,
        Middle,
        End,
        Template;

    }
}

