/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.inline;

import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import java.util.HashSet;
import java.util.Set;

class InjectionQuoteHandler {
    private final boolean inDoubleQuotedContext;
    private final Set<RangeMarker> literalExpressionsToFix;

    InjectionQuoteHandler(PsiElement context2) {
        PsiElement injectionPlace = context2.getContainingFile().getContext();
        if (injectionPlace != null) {
            String injectionText = injectionPlace.getText();
            this.inDoubleQuotedContext = StringUtil.startsWith((CharSequence)injectionText, (CharSequence)"\"");
            boolean inQuotedContext = StringUtil.startsWith((CharSequence)injectionText, (CharSequence)"'");
            this.literalExpressionsToFix = this.inDoubleQuotedContext || inQuotedContext ? new HashSet<RangeMarker>() : null;
        } else {
            this.inDoubleQuotedContext = false;
            this.literalExpressionsToFix = null;
        }
    }

    void fixQuotes(PsiElement element, int offset, Document document2) {
        if (this.literalExpressionsToFix != null) {
            SyntaxTraverser.psiTraverser((PsiElement)element).filter(JSLiteralExpression.class).map(lit -> InjectionQuoteHandler.rangeMarker((PsiElement)lit, document2, offset)).addAllTo(this.literalExpressionsToFix);
            char outerBound = this.inDoubleQuotedContext ? (char)'\"' : '\'';
            String outerBoundReplacement = this.inDoubleQuotedContext ? "&quot;" : "&apos;";
            char newBound = this.inDoubleQuotedContext ? (char)'\'' : '\"';
            for (RangeMarker marker : this.literalExpressionsToFix) {
                int endStart = marker.getEndOffset() - 1;
                int startEnd = marker.getStartOffset() + 1;
                CharSequence sequence = document2.getCharsSequence();
                boolean escaped = false;
                char literalStart = sequence.charAt(startEnd - 1);
                boolean changeLiteralBounds = literalStart == outerBound;
                for (int i = startEnd; i < endStart; ++i) {
                    sequence = document2.getCharsSequence();
                    char ch = sequence.charAt(i);
                    if (escaped) {
                        if (ch == outerBound) {
                            document2.replaceString(i - 1, i + 1, (CharSequence)outerBoundReplacement);
                            i += outerBoundReplacement.length() - 2;
                            endStart += outerBoundReplacement.length() - 2;
                        }
                        escaped = false;
                        continue;
                    }
                    if (ch == '\\') {
                        escaped = true;
                        continue;
                    }
                    if (ch == outerBound) {
                        document2.replaceString(i, i + 1, (CharSequence)outerBoundReplacement);
                        i += outerBoundReplacement.length() - 1;
                        endStart += outerBoundReplacement.length() - 1;
                        continue;
                    }
                    if (ch != newBound || !changeLiteralBounds) continue;
                    document2.insertString(i, (CharSequence)"\\");
                    ++i;
                    ++endStart;
                }
                if (!changeLiteralBounds) continue;
                document2.replaceString(marker.getStartOffset(), startEnd, (CharSequence)Character.toString(newBound));
                document2.replaceString(endStart, marker.getEndOffset(), (CharSequence)Character.toString(newBound));
            }
        }
    }

    private static RangeMarker rangeMarker(PsiElement node, Document document2, int funOffset) {
        return document2.createRangeMarker(node.getTextRange().shiftRight(funOffset));
    }
}

