/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.ecmascript6.psi.impl.ES6FieldStatementImpl;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.util.SideEffectChecker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegate;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptVariableSafeDeleteProcessor
implements SafeDeleteProcessorDelegate {
    public boolean handlesElement(PsiElement element) {
        return element instanceof JSVariable && ((JSVariable)element).getStatement() != null;
    }

    @Nullable
    public NonCodeUsageSearchInfo findUsages(@NotNull PsiElement element, PsiElement @NotNull [] allElementsToDelete, @NotNull List<? super UsageInfo> result2) {
        if (element == null) {
            JavaScriptVariableSafeDeleteProcessor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JavaScriptVariableSafeDeleteProcessor.$$$reportNull$$$0(1);
        }
        if (allElementsToDelete == null) {
            JavaScriptVariableSafeDeleteProcessor.$$$reportNull$$$0(2);
        }
        SafeDeleteProcessor.findGenericElementUsages((PsiElement)element, result2, (PsiElement[])allElementsToDelete);
        return new NonCodeUsageSearchInfo(SafeDeleteProcessor.getDefaultInsideDeletedCondition((PsiElement[])allElementsToDelete), element);
    }

    @Nullable
    public Collection<? extends PsiElement> getElementsToSearch(@NotNull PsiElement element, @NotNull Collection<? extends PsiElement> allElementsToDelete) {
        if (element == null) {
            JavaScriptVariableSafeDeleteProcessor.$$$reportNull$$$0(3);
        }
        if (allElementsToDelete == null) {
            JavaScriptVariableSafeDeleteProcessor.$$$reportNull$$$0(4);
        }
        return Collections.singletonList(element);
    }

    @Nullable
    public Collection<PsiElement> getAdditionalElementsToDelete(@NotNull PsiElement element, @NotNull Collection<? extends PsiElement> allElementsToDelete, boolean askUser) {
        if (element == null) {
            JavaScriptVariableSafeDeleteProcessor.$$$reportNull$$$0(5);
        }
        if (allElementsToDelete == null) {
            JavaScriptVariableSafeDeleteProcessor.$$$reportNull$$$0(6);
        }
        return null;
    }

    @Nullable
    public Collection<String> findConflicts(@NotNull PsiElement element, PsiElement @NotNull [] allElementsToDelete) {
        if (element == null) {
            JavaScriptVariableSafeDeleteProcessor.$$$reportNull$$$0(7);
        }
        if (allElementsToDelete == null) {
            JavaScriptVariableSafeDeleteProcessor.$$$reportNull$$$0(8);
        }
        return null;
    }

    public UsageInfo @Nullable [] preprocessUsages(@NotNull Project project, UsageInfo @NotNull [] usages) {
        if (project == null) {
            JavaScriptVariableSafeDeleteProcessor.$$$reportNull$$$0(9);
        }
        if (usages == null) {
            JavaScriptVariableSafeDeleteProcessor.$$$reportNull$$$0(10);
        }
        return usages;
    }

    public void prepareForDeletion(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JavaScriptVariableSafeDeleteProcessor.$$$reportNull$$$0(11);
        }
        if (element instanceof JSVariable) {
            JSVarStatement statement = ((JSVariable)element).getStatement();
            if (statement == null || statement instanceof ES6FieldStatementImpl) {
                return;
            }
            JSExpression initializer = ((JSVariable)element).getInitializer();
            if (initializer != null && SideEffectChecker.mayHaveSideEffects(initializer)) {
                ArrayList<JSExpression> allSideEffects = new ArrayList<JSExpression>();
                JavaScriptVariableSafeDeleteProcessor.collectSideEffects(allSideEffects, initializer);
                for (JSExpression sideEffect : allSideEffects) {
                    JSStatement replacementStatement;
                    if (!SideEffectChecker.mayHaveSideEffects(sideEffect) || (replacementStatement = JavaScriptVariableSafeDeleteProcessor.createReplacementStatement(element, sideEffect)) == null) continue;
                    statement.getParent().addBefore((PsiElement)replacementStatement, (PsiElement)statement);
                }
            }
        }
    }

    @Nullable
    private static JSStatement createReplacementStatement(PsiElement element, JSExpression sideEffect) {
        if (sideEffect instanceof JSSpreadExpression) {
            JSExpression expression = ((JSSpreadExpression)sideEffect).getExpression();
            if (expression == null) {
                return null;
            }
            return JavaScriptVariableSafeDeleteProcessor.createStatement(element, "for (let _ of " + expression.getText() + ") {}");
        }
        JSExpressionStatement expressionStatement = (JSExpressionStatement)JavaScriptVariableSafeDeleteProcessor.createStatement(element, "a");
        JSExpression expression = Objects.requireNonNull(expressionStatement.getExpression());
        expression.replace(sideEffect);
        return expressionStatement;
    }

    private static JSStatement createStatement(PsiElement element, String text2) {
        return JSPsiElementFactory.createJSStatement(text2 + JSCodeStyleSettings.getSemicolon(element), element);
    }

    private static void collectSideEffects(List<JSExpression> allSideEffects, @Nullable JSExpression initializer) {
        if (initializer == null) {
            return;
        }
        if (initializer instanceof JSObjectLiteralExpression) {
            for (JSProperty property : ((JSObjectLiteralExpression)initializer).getProperties()) {
                JavaScriptVariableSafeDeleteProcessor.collectSideEffects(allSideEffects, property.getValue());
            }
            return;
        }
        if (initializer instanceof JSArrayLiteralExpression) {
            for (JSExpression expression : ((JSArrayLiteralExpression)initializer).getExpressions()) {
                JavaScriptVariableSafeDeleteProcessor.collectSideEffects(allSideEffects, expression);
            }
            return;
        }
        allSideEffects.add(initializer);
    }

    public boolean isToSearchInComments(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS;
    }

    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA;
    }

    public void setToSearchInComments(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS = enabled;
    }

    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA = enabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allElementsToDelete";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/JavaScriptVariableSafeDeleteProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findUsages";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementsToSearch";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getAdditionalElementsToDelete";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findConflicts";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessUsages";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareForDeletion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

