/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard.operations;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.operations.JSApplyTypeOperationContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSCacheableTypeOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSDeclaredTypeOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSEmptyOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSTypeOperation;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JSCompositeOperation
extends JSCacheableTypeOperation {
    private static boolean shouldUseDeclaredType(@NotNull Collection<JSTypeOperation> operations) {
        if (operations == null) {
            JSCompositeOperation.$$$reportNull$$$0(0);
        }
        for (JSTypeOperation operation : operations) {
            if (!JSDeclaredTypeOperation.isDeclaredTypeOperation(operation)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<JSType> getTypeFromOperations(@NotNull JSApplyTypeOperationContext context2, @NotNull Collection<JSTypeOperation> operations, @NotNull JSType type2) {
        boolean autoVariableWithoutRealType;
        if (context2 == null) {
            JSCompositeOperation.$$$reportNull$$$0(1);
        }
        if (operations == null) {
            JSCompositeOperation.$$$reportNull$$$0(2);
        }
        if (type2 == null) {
            JSCompositeOperation.$$$reportNull$$$0(3);
        }
        boolean bl = autoVariableWithoutRealType = context2.isAutoVariableType() && context2.getRealType() == null;
        if (!autoVariableWithoutRealType && JSCompositeOperation.shouldUseDeclaredType(operations)) {
            List<JSType> list2 = Collections.singletonList(context2.getDeclaredType());
            if (list2 == null) {
                JSCompositeOperation.$$$reportNull$$$0(4);
            }
            return list2;
        }
        ArrayList<JSType> types2 = new ArrayList<JSType>(operations.size());
        boolean declaredWasSkipped = false;
        boolean addExplicitOptionality = false;
        boolean requiresTypesDefinedAtEachBranch = context2.isAutoVariableType() && JSTypeGuardUtil.isPossibleAutoTypeDeclaration(context2.getContextElement()) && context2.strictNullChecks();
        for (JSTypeOperation operation : operations) {
            JSType jsType = operation.apply(context2, type2);
            if (jsType == context2.getDeclaredType()) {
                if (autoVariableWithoutRealType) {
                    declaredWasSkipped = true;
                    if (!requiresTypesDefinedAtEachBranch) continue;
                    addExplicitOptionality = true;
                    continue;
                }
                List<JSType> list3 = Collections.singletonList(context2.getDeclaredType());
                if (list3 == null) {
                    JSCompositeOperation.$$$reportNull$$$0(5);
                }
                return list3;
            }
            types2.add(jsType);
        }
        if (types2.isEmpty() && declaredWasSkipped) {
            List<JSType> list4 = Collections.singletonList(context2.getDeclaredType());
            if (list4 == null) {
                JSCompositeOperation.$$$reportNull$$$0(6);
            }
            return list4;
        }
        if (!types2.isEmpty() && addExplicitOptionality) {
            types2.add(JSNamedTypeFactory.createUndefinedType(context2.getDefaultTypeSource()));
        }
        ArrayList<JSType> arrayList = types2;
        if (arrayList == null) {
            JSCompositeOperation.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    abstract Collection<JSTypeOperation> getOperations();

    public static <T extends JSCompositeOperation> void addFlat(@NotNull Collection<JSTypeOperation> results, @NotNull JSTypeOperation currentOp, @NotNull Class<T> compositeClass) {
        if (results == null) {
            JSCompositeOperation.$$$reportNull$$$0(8);
        }
        if (currentOp == null) {
            JSCompositeOperation.$$$reportNull$$$0(9);
        }
        if (compositeClass == null) {
            JSCompositeOperation.$$$reportNull$$$0(10);
        }
        if (compositeClass.isInstance(currentOp)) {
            results.addAll(((JSCompositeOperation)currentOp).getOperations());
        } else if (currentOp != JSEmptyOperation.NO_OPERATION) {
            results.add(currentOp);
        }
    }

    @Override
    public String toString() {
        String name = this.getName();
        return name + "(" + StringUtil.join(this.getOperations(), (String)", ") + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operations";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/operations/JSCompositeOperation";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentOp";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compositeClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/operations/JSCompositeOperation";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFromOperations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseDeclaredType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromOperations";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addFlat";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

