/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve.queue;

import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.queue.JSResolveQueue;
import com.intellij.lang.javascript.psi.util.SoftlyCachedValue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class JSResolveQueueService {
    private final ConcurrentMap<PsiFile, JSResolveQueueHolder> myQueues = ContainerUtil.createConcurrentSoftMap();
    private static final ThreadLocal<Boolean> USE_RESOLVE_QUEUE = ThreadLocal.withInitial(() -> false);

    public void initQueue(@NotNull PsiFile file, @NotNull TextRange range) {
        if (file == null) {
            JSResolveQueueService.$$$reportNull$$$0(0);
        }
        if (range == null) {
            JSResolveQueueService.$$$reportNull$$$0(1);
        }
        JSResolveQueueHolder queue = new JSResolveQueueHolder(range);
        this.myQueues.putIfAbsent(file, queue);
    }

    @Nullable
    public static JSResolveQueueService getInstance(@NotNull Project project) {
        boolean isEnabled2;
        if (project == null) {
            JSResolveQueueService.$$$reportNull$$$0(2);
        }
        return (isEnabled2 = Registry.is((String)"js.balance.tasks.for.inspection.pass", (boolean)false)) ? (JSResolveQueueService)project.getService(JSResolveQueueService.class) : null;
    }

    public void setUseResolveQueue(boolean value) {
        USE_RESOLVE_QUEUE.set(value);
    }

    @Nullable
    public JSResolveQueue findQueue(@NotNull JSReferenceExpression ref) {
        if (ref == null) {
            JSResolveQueueService.$$$reportNull$$$0(3);
        }
        if (!USE_RESOLVE_QUEUE.get().booleanValue() || ApplicationManager.getApplication().isDispatchThread()) {
            return null;
        }
        PsiFile containingFile2 = ref.getContainingFile();
        JSResolveQueueHolder queue = (JSResolveQueueHolder)this.myQueues.get(containingFile2);
        if (queue == null || containingFile2 == null) {
            return null;
        }
        return queue.getQueue(ref, containingFile2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/queue/JSResolveQueueService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "initQueue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findQueue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class JSResolveQueueHolder {
        @Nullable
        private final TextRange myPriorityRange;
        @NotNull
        private final AtomicReference<SoftlyCachedValue<JSResolveQueue>> myQueue = new AtomicReference();

        public JSResolveQueueHolder(@Nullable TextRange priorityRange) {
            this.myPriorityRange = priorityRange;
        }

        @Nullable
        public JSResolveQueue getQueue(@NotNull JSReferenceExpression ref, @NotNull PsiFile containingFile2) {
            SoftlyCachedValue<JSResolveQueue> value;
            if (ref == null) {
                JSResolveQueueHolder.$$$reportNull$$$0(0);
            }
            if (containingFile2 == null) {
                JSResolveQueueHolder.$$$reportNull$$$0(1);
            }
            if ((value = this.myQueue.get()) == null && !this.myQueue.compareAndSet(null, value = this.calculateQueue(ref, containingFile2)) && (value = this.myQueue.get()) == null) {
                Logger.getInstance(JSResolveQueueHolder.class).error("Can't be null, check AtomicReference usage");
                return null;
            }
            JSResolveQueue queue = value.getUpToDateOrNull();
            if (queue == null) {
                SoftlyCachedValue<JSResolveQueue> newValue = this.calculateQueue(ref, containingFile2);
                if (!this.myQueue.compareAndSet(value, newValue)) {
                    value = this.myQueue.get();
                    if (value == null) {
                        Logger.getInstance(JSResolveQueueHolder.class).error("Can't be null, check AtomicReference usage");
                        return null;
                    }
                } else {
                    value = newValue;
                }
                queue = value.getUpToDateOrNull();
            }
            return queue;
        }

        @NotNull
        private SoftlyCachedValue<JSResolveQueue> calculateQueue(@NotNull JSReferenceExpression ref, @NotNull PsiFile containingFile2) {
            if (ref == null) {
                JSResolveQueueHolder.$$$reportNull$$$0(2);
            }
            if (containingFile2 == null) {
                JSResolveQueueHolder.$$$reportNull$$$0(3);
            }
            PsiFile file = ref.getContainingFile();
            ArrayList<JSReferenceExpression> highPriorityQueue = new ArrayList<JSReferenceExpression>();
            ArrayList<JSReferenceExpressionImpl> lowPriorityQueue = new ArrayList<JSReferenceExpressionImpl>();
            for (JSReferenceExpressionImpl expression : SyntaxTraverser.psiTraverser((PsiElement)file).filter(JSReferenceExpressionImpl.class)) {
                if (this.myPriorityRange != null && this.myPriorityRange.intersects(expression.getTextRange())) {
                    highPriorityQueue.add(expression);
                    continue;
                }
                lowPriorityQueue.add(expression);
            }
            highPriorityQueue.addAll(lowPriorityQueue);
            return new SoftlyCachedValue<JSResolveQueue>(new JSResolveQueue(highPriorityQueue), new PsiFileModificationTracker(containingFile2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingFile";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/queue/JSResolveQueueService$JSResolveQueueHolder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getQueue";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calculateQueue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PsiFileModificationTracker
    implements ModificationTracker {
        private final PsiFile myFile;

        private PsiFileModificationTracker(@NotNull PsiFile file) {
            if (file == null) {
                PsiFileModificationTracker.$$$reportNull$$$0(0);
            }
            this.myFile = file;
        }

        public long getModificationCount() {
            return this.myFile.getModificationStamp();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/psi/resolve/queue/JSResolveQueueService$PsiFileModificationTracker", "<init>"));
        }
    }
}

