/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSVariantsProcessorMerger;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.evaluation.JSUsageBasedEvaluator;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagType;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSCompletionPlaceFilter;
import com.intellij.lang.javascript.psi.resolve.JSCompletionProcessor;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluatorBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSVariantRecordTypeConverter;
import com.intellij.lang.javascript.psi.resolve.accessibility.JSPropertyAccessorChecker;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeWithOuterGenerics;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSNamesValidation;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMemberUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariantsProcessor
extends BaseJSSymbolProcessor
implements JSCompletionProcessor {
    private final Set<JSQualifiedName> myNeighbourReferences;
    private final Set<String> myPopulatedResultsNames;
    private final boolean hasSomeSmartnessAvailable;
    private final boolean myProcessOnlyProperties;
    private final boolean myProcessOnlyTypes;
    private final JSCompletionPlaceFilter myPlaceFilter;
    @Nullable
    private final String myReferencedParameterName;
    @Nullable
    private final PsiElement myOriginalElement;
    private final PrefixMatcher myPrefixMatcher;
    @NotNull
    private final JSVariantsProcessorMerger myVariantsProcessorMerger;

    public VariantsProcessor(@NotNull PsiFile targetFile, @NotNull PsiElement context2, boolean forcedOnlyTypeBased, @NotNull CompletionParameters parameters, @NotNull CompletionResultSet resultSet) {
        if (targetFile == null) {
            VariantsProcessor.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            VariantsProcessor.$$$reportNull$$$0(1);
        }
        if (parameters == null) {
            VariantsProcessor.$$$reportNull$$$0(2);
        }
        if (resultSet == null) {
            VariantsProcessor.$$$reportNull$$$0(3);
        }
        super(targetFile.getOriginalFile(), context2);
        this.myNeighbourReferences = new HashSet<JSQualifiedName>();
        this.myPopulatedResultsNames = new HashSet<String>();
        this.myPrefixMatcher = resultSet.getPrefixMatcher();
        int limit = JSCompletionUtil.getCompletionLimit();
        boolean isExtendedCompletion = parameters.isExtendedCompletion();
        this.myVariantsProcessorMerger = new JSVariantsProcessorMerger(context2, (element, priority) -> {
            if (!JSLookupUtilImpl.willCreateLookupElement(priority)) {
                return false;
            }
            return JSLookupUtilImpl.matchElementWithContext(element, this.myContext);
        }, limit, !isExtendedCompletion, parameters);
        boolean processOnlyTypes = false;
        this.myCurrentFile = targetFile.getOriginalFile() == targetFile ? null : targetFile.getOriginalFile().getVirtualFile();
        JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)context2, JSClass.class);
        if (forcedOnlyTypeBased || JSApplicationSettings.getInstance().isOnlyTypeBasedCompletion() && !isExtendedCompletion) {
            this.forceSetAddOnlyCompleteMatches();
        }
        String referencedParameterName = null;
        if (context2 instanceof JSReferenceExpression) {
            JSExpression qualifier;
            JSParameterItem parameter;
            JSReferenceExpression refExpr = (JSReferenceExpression)context2;
            PsiElement parent = refExpr.getParent();
            if (parent instanceof JSArgumentList && (parameter = JSResolveUtil.findParameterForUsedArgument(refExpr, (JSArgumentList)parent)) != null) {
                referencedParameterName = parameter.getName();
            }
            if ((qualifier = refExpr.getQualifier()) != null) {
                if (qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression) {
                    if (qualifier instanceof JSThisExpression) {
                        JSNamespace ns = JSContextResolver.resolveContext((PsiElement)qualifier);
                        this.updateTypeInfoFromThis(ns);
                    }
                    if (jsClass != null) {
                        this.forceSetAddOnlyCompleteMatches();
                        this.updateCanUseOnlyCompleteMatches(jsClass);
                    } else if (JSResolveUtil.getTypeFromTagNameInMxml(this.myTargetFile.getContext()) != null) {
                        this.forceSetAddOnlyCompleteMatches();
                    }
                }
                JSExpression originalQualifier = VariantsProcessor.getOriginalQualifier(qualifier);
                CompletionTypeProcessor processor = new CompletionTypeProcessor();
                processor.evaluateQualifier(qualifier, originalQualifier);
                if (!processor.myNonAdditionalTypeProcessed) {
                    JSUsageBasedEvaluator.processUsageBasedTypes(originalQualifier, processor);
                }
            } else if (JSResolveUtil.isExprInTypeContext(refExpr) || this.ecmal4 && JSResolveUtil.isInPlaceWhereTypeCanBeDuringCompletion((PsiElement)refExpr)) {
                this.forceSetAddOnlyCompleteMatches();
                processOnlyTypes = true;
                this.addPackageScope(jsClass, (PsiElement)refExpr);
            } else if (JSPsiImplUtils.getWithStatementContexts(refExpr).isEmpty()) {
                this.forceSetAddOnlyCompleteMatches();
            }
        } else if (context2 instanceof JSProperty) {
            JSObjectLiteralExpression objLiteral = (JSObjectLiteralExpression)CompletionUtilCoreImpl.getOriginalOrSelf((PsiElement)((JSObjectLiteralExpression)context2.getParent()));
            JSType expectedType = TypeScriptImplementMemberUtil.filterExpectedTypeForImplement(JSDialectSpecificHandlersFactory.findExpectedType(objLiteral), (PsiElement)objLiteral);
            JSRecordType recordType = JSVariantRecordTypeConverter.getTypeAsRecord(expectedType, context2);
            if (recordType != null) {
                this.myTypeInfo.addRecordType(recordType);
                this.forceSetAddOnlyCompleteMatches();
            } else if (expectedType instanceof JSNamedType) {
                new CompletionTypeProcessor().process(expectedType, new JSEvaluateContext(null));
            }
        } else if (context2 instanceof JSDocTagType) {
            processOnlyTypes = true;
        } else if (context2 instanceof JSDestructuringProperty) {
            PsiElement parent = context2.getParent();
            JSTypeEvaluator.evaluateExpressionOrElementTypes(this.myTargetFile, new CompletionTypeProcessor(), parent);
        }
        this.myProcessOnlyTypes = processOnlyTypes;
        this.myPlaceFilter = JSCompletionPlaceFilter.forPlace(context2);
        boolean bl = this.myProcessOnlyProperties = context2 instanceof JSProperty || context2 instanceof JSDestructuringProperty;
        if (this.myTypeInfo.typeWasProcessed() && !this.myProcessOnlyProperties && !this.myTypeInfo.isGlobalContext()) {
            this.myTypeInfo.addBaseObjectType();
        }
        this.hasSomeSmartnessAvailable = this.myTypeInfo.hasExplicitNamespace();
        this.myOriginalElement = CompletionUtil.getOriginalElement((PsiElement)context2);
        this.myReferencedParameterName = referencedParameterName;
        this.initCheckFileLevelAccess();
    }

    private void updateCanUseOnlyCompleteMatches(JSClass jsClass) {
        JSAttributeList attributeList;
        JSAttributeList jSAttributeList = attributeList = jsClass != null ? jsClass.getAttributeList() : null;
        if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.DYNAMIC)) {
            this.allowPartialResults();
        }
    }

    public void addPushedVariants(@NotNull Set<String> pushedVariants) {
        if (pushedVariants == null) {
            VariantsProcessor.$$$reportNull$$$0(4);
        }
        this.myPopulatedResultsNames.addAll(pushedVariants);
    }

    public void populateCompletionList(Collection<? extends LookupElement> resultsAsObjects, boolean keepOverloads, @NotNull CompletionResultSet resultSet) {
        if (resultSet == null) {
            VariantsProcessor.$$$reportNull$$$0(5);
        }
        if (resultsAsObjects == null) {
            return;
        }
        Set<Object> visited = keepOverloads ? new HashSet() : this.myPopulatedResultsNames;
        ArrayList<LookupElement> batch = new ArrayList<LookupElement>(resultsAsObjects.size());
        for (LookupElement lookupElement : resultsAsObjects) {
            String text2 = lookupElement.getLookupString();
            if (this.myPopulatedResultsNames.contains(text2)) continue;
            visited.add(text2);
            batch.add(lookupElement);
        }
        resultSet.addAllElements(batch);
        if (keepOverloads) {
            this.myPopulatedResultsNames.addAll(visited);
        }
    }

    public void collectReferencesUsedInCurrentScope(final PsiElement reference, final boolean qualified) {
        if (reference instanceof JSReferenceExpression && !((JSReferenceExpression)reference).allowRecordingAsNeighborElement()) {
            return;
        }
        JSExecutionScope scope2 = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)reference, JSExecutionScope.class);
        assert (scope2 != null) : reference.getContainingFile().getName();
        new JSRecursiveElementVisitor(){

            @Override
            public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                JSQualifiedName name;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (node != reference && node.getQualifier() != null == qualified && (name = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)node)) != null) {
                    VariantsProcessor.this.myNeighbourReferences.add(name);
                }
                super.visitJSReferenceExpression(node);
            }

            @Override
            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            @Override
            public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/VariantsProcessor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionDeclaration";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.visitElement(scope2);
    }

    @Override
    @NotNull
    protected List<JSNamespace> addGenericArgumentsForParentClasses(@NotNull JSNamespace namespace, @NotNull List<JSNamespace> parentClasses) {
        JSTypeSubstitutor genericArguments;
        if (namespace == null) {
            VariantsProcessor.$$$reportNull$$$0(6);
        }
        if (parentClasses == null) {
            VariantsProcessor.$$$reportNull$$$0(7);
        }
        if ((genericArguments = JSTypeWithOuterGenerics.getGenericArguments(namespace)) == null || genericArguments.isEmpty()) {
            List<JSNamespace> list2 = parentClasses;
            if (list2 == null) {
                VariantsProcessor.$$$reportNull$$$0(8);
            }
            return list2;
        }
        List list3 = ContainerUtil.map(parentClasses, parentClass -> {
            if (parentClass instanceof JSTypeWithOuterGenerics) {
                boolean isStrict = namespace.isSourceStrict();
                parentClass = (JSNamespace)parentClass.copyWithStrict((parentClass = (JSNamespace)((JSTypeWithOuterGenerics)parentClass).getType()).isSourceStrict() && isStrict);
            }
            JSQualifiedName parentClassQName = parentClass.getQualifiedName();
            assert (parentClassQName != null);
            JSQualifiedName namespaceQName = namespace.getQualifiedName();
            assert (namespaceQName != null);
            JSTypeSubstitutor parentClassTypeSubstitutor = JSGenericTypesEvaluatorBase.applyTypeSubstitutorUpToParentClass(namespaceQName.getQualifiedName(), parentClassQName.getQualifiedName(), this.myContext, genericArguments);
            return new JSTypeWithOuterGenerics((JSType)parentClass, parentClassTypeSubstitutor);
        });
        if (list3 == null) {
            VariantsProcessor.$$$reportNull$$$0(9);
        }
        return list3;
    }

    public void addNeighbourReferences(boolean onlyApplyPriority) {
        for (JSQualifiedName neighbourReference : this.myNeighbourReferences) {
            if (!this.myTypeInfo.hasMatchedNamespace(neighbourReference.getParent(), JSContext.STATIC)) continue;
            this.myVariantsProcessorMerger.addNeighbourReference(neighbourReference, onlyApplyPriority);
        }
    }

    @NotNull
    public Collection<LookupElement> getCurrentResults() {
        this.postProcessElements(true);
        List<LookupElement> list2 = this.myVariantsProcessorMerger.values();
        if (list2 == null) {
            VariantsProcessor.$$$reportNull$$$0(10);
        }
        return list2;
    }

    public void postProcessElements(boolean onlyApplyPriority) {
        this.addNeighbourReferences(onlyApplyPriority);
    }

    @NotNull
    public Collection<LookupElement> getFinalResults() {
        this.addElementsFromRecordTypes();
        this.postProcessElements(false);
        List<LookupElement> list2 = this.myVariantsProcessorMerger.values();
        if (list2 == null) {
            VariantsProcessor.$$$reportNull$$$0(11);
        }
        return list2;
    }

    private void addElementsFromRecordTypes() {
        if (this.myTypeInfo.getRecordTypes().isEmpty()) {
            return;
        }
        for (JSRecordType recordType : this.myTypeInfo.getRecordTypes()) {
            this.myVariantsProcessorMerger.addRecordTypeElements(recordType, this.myTargetFile, this.myContext);
        }
    }

    @Override
    public String getRequiredName() {
        return null;
    }

    @Override
    public boolean doAdd(@NotNull JSPsiElementBase element) {
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(12);
        }
        return this.doAdd(element, null);
    }

    public boolean doAdd(@NotNull JSPsiElementBase element, @Nullable JSTypeSubstitutor typeSubstitutor) {
        JSDocComment comment;
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(13);
        }
        ProgressManager.checkCanceled();
        String name = element.getName();
        if (!(name != null && JSNamesValidation.isUnqualifiedType(name) && this.myPrefixMatcher.prefixMatches(name) && this.myPlaceFilter.isAcceptable(element))) {
            return true;
        }
        JSAttributeList.AccessType accessType = element.getAccessType();
        if (this.isOriginalElement(element)) {
            return true;
        }
        if (this.myPopulatedResultsNames.contains(name)) {
            return true;
        }
        if (this.isAcceptable(element) != null) {
            return true;
        }
        if (JSPropertyAccessorChecker.getPropertyAccessError(this.myOriginalElement, (PsiElement)element, true) != null) {
            return true;
        }
        boolean isClassMember = element.getContext() instanceof JSClass;
        if (isClassMember && JSResolveUtil.isConstructorFunction((PsiElement)element)) {
            return true;
        }
        if (element instanceof JSProperty && (comment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)element)) != null && comment.hasConstructsTag()) {
            return true;
        }
        if (isClassMember && accessType == JSAttributeList.AccessType.PRIVATE) {
            return true;
        }
        if (this.myProcessOnlyProperties && !this.isPropertyCandidate(element)) {
            return true;
        }
        IntRef typeHierarchyLevel = new IntRef(-1);
        Ref isAccessible = Ref.create((Object)true);
        BaseJSSymbolProcessor.MatchType matchType = this.calcMatchType(element, accessType, typeHierarchyLevel, (Ref<Boolean>)isAccessible);
        if (element instanceof JSClass && !((Boolean)isAccessible.get()).booleanValue()) {
            return true;
        }
        if (matchType == BaseJSSymbolProcessor.MatchType.PARTIAL || !((Boolean)isAccessible.get()).booleanValue() && VariantsProcessor.isCompleteOrWithContextMatchType(matchType)) {
            if (this.myPrivateSharpFieldAccess || !JSUtils.isPrivateSharpItem((PsiElement)element)) {
                return this.addPartialMatch((PsiElement)element, name);
            }
        } else if (VariantsProcessor.isCompleteOrWithContextMatchType(matchType)) {
            return this.addCompleteMatch((PsiElement)element, name, matchType, typeHierarchyLevel.get(), typeSubstitutor);
        }
        return true;
    }

    protected boolean isOriginalElement(@NotNull JSPsiElementBase element) {
        PsiElement parent;
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(14);
        }
        if (element.isEquivalentTo(this.myOriginalElement)) {
            return true;
        }
        return this.myOriginalElement instanceof JSReferenceExpression && (parent = this.myOriginalElement.getParent()) instanceof JSDefinitionExpression && element.isEquivalentTo(parent);
    }

    public boolean isPropertyCandidate(@NotNull JSPsiElementBase element) {
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(15);
        }
        if (element instanceof JSImplicitElement && ((JSImplicitElement)element).getType() == JSImplicitElement.Type.Property) {
            return true;
        }
        if (element instanceof JSDefinitionExpression) {
            return true;
        }
        return element instanceof JSProperty || element instanceof TypeScriptTypeMember && JSUtils.getMemberContainingClass((PsiElement)element) instanceof TypeScriptInterface;
    }

    @NotNull
    private BaseJSSymbolProcessor.MatchType calcMatchType(@NotNull JSPsiElementBase element, @NotNull JSAttributeList.AccessType accessType, @NotNull IntRef typeHierarchyLevel, @NotNull Ref<Boolean> isAccessible) {
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(16);
        }
        if (accessType == null) {
            VariantsProcessor.$$$reportNull$$$0(17);
        }
        if (typeHierarchyLevel == null) {
            VariantsProcessor.$$$reportNull$$$0(18);
        }
        if (isAccessible == null) {
            VariantsProcessor.$$$reportNull$$$0(19);
        }
        BaseJSSymbolProcessor.MatchType matchType = this.isAcceptableQualifiedItem(element, typeHierarchyLevel, isAccessible);
        if (accessType == JSAttributeList.AccessType.PRIVATE && this.myProcessOnlyTypes) {
            matchType = BaseJSSymbolProcessor.MatchType.PARTIAL;
        }
        if (VariantsProcessor.isCompleteOrWithContextMatchType(matchType) && this.myPlaceFilter.isPartialResult(element)) {
            matchType = BaseJSSymbolProcessor.MatchType.PARTIAL;
        }
        if (matchType == BaseJSSymbolProcessor.MatchType.COMPLETE && typeHierarchyLevel.get() > 0 && !((Boolean)isAccessible.get()).booleanValue()) {
            matchType = BaseJSSymbolProcessor.MatchType.PARTIAL;
        }
        BaseJSSymbolProcessor.MatchType matchType2 = matchType;
        if (matchType2 == null) {
            VariantsProcessor.$$$reportNull$$$0(20);
        }
        return matchType2;
    }

    @Override
    @NotNull
    protected JSAttributeList.AccessType getElementAccessType(@NotNull JSPsiElementBase element) {
        boolean seemsToBePrivateSymbol;
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(21);
        }
        if ((seemsToBePrivateSymbol = JSVisibilityUtil.seemsToBePrivateSymbol(element.getName())) && element.getAccessType() == JSAttributeList.AccessType.PACKAGE_LOCAL) {
            JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PROTECTED;
            if (accessType == null) {
                VariantsProcessor.$$$reportNull$$$0(22);
            }
            return accessType;
        }
        JSAttributeList.AccessType accessType = super.getElementAccessType(element);
        if (accessType == null) {
            VariantsProcessor.$$$reportNull$$$0(23);
        }
        return accessType;
    }

    private boolean addCompleteMatch(@NotNull PsiElement element, @Nullable String name, @NotNull BaseJSSymbolProcessor.MatchType matchType, int nestingLevel, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(24);
        }
        if (matchType == null) {
            VariantsProcessor.$$$reportNull$$$0(25);
        }
        if (name == null) {
            return true;
        }
        if (element instanceof JSPsiElementBase && this.myPlaceFilter.isLoweredPriority((JSPsiElementBase)element)) {
            ++nestingLevel;
        }
        JSLookupPriority priority = this.getPriority(name, matchType, nestingLevel);
        return this.myVariantsProcessorMerger.addResult(element, name, priority, matchType, typeSubstitutor);
    }

    private JSLookupPriority getPriority(@NotNull String name, @NotNull BaseJSSymbolProcessor.MatchType matchType, int nestingLevel) {
        if (name == null) {
            VariantsProcessor.$$$reportNull$$$0(26);
        }
        if (matchType == null) {
            VariantsProcessor.$$$reportNull$$$0(27);
        }
        if (this.myTypeInfo.isGlobalContext()) {
            nestingLevel += 5;
        }
        return this.myTypeInfo.isGlobalContext() && !this.myProcessOnlyTypes ? JSLookupPriority.getLookupPriority(BaseJSSymbolProcessor.MatchType.PARTIAL, false, false) : JSLookupPriority.getSameTypeValue(name.equals(this.myReferencedParameterName), matchType, nestingLevel);
    }

    private boolean addPartialMatch(@NotNull PsiElement element, @Nullable String name) {
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(28);
        }
        if (name == null || this.addOnlyCompleteMatches()) {
            return true;
        }
        boolean fromRelevantFileOrDirectory = this.isFromRelevantFileOrDirectory();
        JSLookupPriority priority = JSLookupPriority.getLookupPriority(null, fromRelevantFileOrDirectory, this.hasSomeSmartnessAvailable);
        return this.myVariantsProcessorMerger.addResult(element, name, priority, BaseJSSymbolProcessor.MatchType.PARTIAL, null);
    }

    @Override
    @NotNull
    public PsiFile getTargetFile() {
        PsiFile psiFile2 = this.myTargetFile;
        if (psiFile2 == null) {
            VariantsProcessor.$$$reportNull$$$0(29);
        }
        return psiFile2;
    }

    @Override
    @NotNull
    public PrefixMatcher getPrefixMatcher() {
        PrefixMatcher prefixMatcher = this.myPrefixMatcher;
        if (prefixMatcher == null) {
            VariantsProcessor.$$$reportNull$$$0(30);
        }
        return prefixMatcher;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 20, 22, 23, 29, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushedVariants";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClasses";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 22: 
            case 23: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/VariantsProcessor";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeHierarchyLevel";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isAccessible";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/VariantsProcessor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "addGenericArgumentsForParentClasses";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentResults";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFinalResults";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "calcMatchType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementAccessType";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetFile";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefixMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addPushedVariants";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "populateCompletionList";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addGenericArgumentsForParentClasses";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 22: 
            case 23: 
            case 29: 
            case 30: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doAdd";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isOriginalElement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyCandidate";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "calcMatchType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getElementAccessType";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addCompleteMatch";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getPriority";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addPartialMatch";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 20, 22, 23, 29, 30 -> new IllegalStateException(string);
        };
    }

    private class CompletionTypeProcessor
    extends BaseJSSymbolProcessor.JSTypeProcessorBase {
        private boolean myNonAdditionalTypeProcessed = false;

        private CompletionTypeProcessor() {
        }

        @Override
        public void process(@NotNull JSType type2, @NotNull JSEvaluateContext evaluateContext) {
            if (type2 == null) {
                CompletionTypeProcessor.$$$reportNull$$$0(0);
            }
            if (evaluateContext == null) {
                CompletionTypeProcessor.$$$reportNull$$$0(1);
            }
            JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)candidate -> {
                this.processCandidate((JSType)candidate, evaluateContext);
                return true;
            }), type2, false, true, false);
            this.processCandidate(type2, evaluateContext);
            this.myNonAdditionalTypeProcessed = true;
        }

        @Override
        protected boolean isMakeAddedNamespaceStrict() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "evaluateContext";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/resolve/VariantsProcessor$CompletionTypeProcessor";
            objectArray[2] = "process";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

