/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.javascript.JSModuleCompletionOnlyReference;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathConfiguration;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.frameworks.modules.JSParentReference;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexImpl;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSModuleReferenceContributor {
    public static final ExtensionPointName<JSModuleReferenceContributor> EP_NAME = ExtensionPointName.create((String)"JavaScript.moduleReferenceContributor");
    @NotNull
    public static final Logger LOG = Logger.getInstance(JSModuleReferenceContributor.class);

    @NotNull
    public @NotNull PsiReference @NotNull [] getAllReferences(@NotNull String var1, @NotNull PsiElement var2, int var3, @Nullable PsiReferenceProvider var4);

    public boolean isApplicable(@NotNull PsiElement var1);

    default public int getDefaultWeight() {
        return JSModuleBaseReference.ModuleTypes.DEFAULT.weight();
    }

    @NotNull
    default public Collection<LookupElement> getLookupElements(@NotNull String unquotedEscapedText, @NotNull PsiElement host) {
        if (unquotedEscapedText == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(0);
        }
        if (host == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(1);
        }
        List<LookupElement> list2 = Collections.emptyList();
        if (list2 == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    default public Collection<PsiElement> resolveReferences(@NotNull PsiElement context2, @NotNull String path2) {
        PsiReference[] references;
        if (context2 == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(3);
        }
        if (path2 == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(4);
        }
        if ((references = this.getAllReferences(path2, context2, 0, null)).length == 0) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSModuleReferenceContributor.$$$reportNull$$$0(5);
            }
            return list2;
        }
        SmartList result2 = new SmartList();
        int maxWeight = Integer.MIN_VALUE;
        for (PsiReference reference : references) {
            int weight;
            Collection<PsiElement> current = JSModuleReferenceContributor.resolveModuleReference(reference);
            if (current.isEmpty()) continue;
            int n = weight = reference instanceof JSModuleBaseReference ? ((JSModuleBaseReference)reference).getWeight() : this.getDefaultWeight();
            if (weight < maxWeight) continue;
            if (weight > maxWeight) {
                result2.clear();
                maxWeight = weight;
            }
            result2.addAll(current);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(6);
        }
        return smartList;
    }

    @NotNull
    default public List<JSImportDescriptor> getAdditionalDescriptors(@NotNull JSImportPathConfiguration configuration, @NotNull JSImportDescriptor baseDescriptor) {
        if (configuration == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(7);
        }
        if (baseDescriptor == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(8);
        }
        List<JSImportDescriptor> list2 = Collections.emptyList();
        if (list2 == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Deprecated(forRemoval=true)
    default public PsiReference @NotNull [] getCommonJSModuleReferences(@NotNull String unquotedEscapedText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquotedEscapedText == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(10);
        }
        if (host == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(11);
        }
        PsiReference[] psiReferenceArray = this.getAllReferences(unquotedEscapedText, host, offset, provider);
        if (psiReferenceArray == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(12);
        }
        return psiReferenceArray;
    }

    public static PsiReference @NotNull [] getReferences(@NotNull String unquoted, @NotNull PsiElement context2, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquoted == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(13);
        }
        if (context2 == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(14);
        }
        return JSModuleReferenceContributor.getReferences(unquoted, context2, offset, provider, JSModuleReferenceContributor.getSortedExtensions());
    }

    public static PsiReference @NotNull [] getReferences(@NotNull String unquoted, @NotNull PsiElement context2, int offset, @Nullable PsiReferenceProvider provider, @NotNull Collection<? extends JSModuleReferenceContributor> extensions) {
        if (unquoted == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(15);
        }
        if (context2 == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(16);
        }
        if (extensions == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(17);
        }
        return JSModuleReferenceContributor.getReferences(unquoted, context2, offset, provider, extensions, true);
    }

    public static PsiReference @NotNull [] getReferences(@NotNull String unquoted, @NotNull PsiElement context2, int offset, @Nullable PsiReferenceProvider provider, @NotNull Collection<? extends JSModuleReferenceContributor> extensions, boolean addCompletionReference) {
        List contributors;
        if (unquoted == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(18);
        }
        if (context2 == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(19);
        }
        if (extensions == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(20);
        }
        if ((contributors = ContainerUtil.filter(extensions, el -> el.isApplicable(context2))).isEmpty()) {
            if (PsiReference.EMPTY_ARRAY == null) {
                JSModuleReferenceContributor.$$$reportNull$$$0(21);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        SmartList result2 = new SmartList();
        for (JSModuleReferenceContributor contributor : contributors) {
            Object[] references = contributor.getAllReferences(unquoted, context2, offset, provider);
            ContainerUtil.addAll((Collection)result2, (Object[])references);
        }
        JSModuleReferenceContributor.checkReferencesAreHard((List<PsiReference>)result2);
        if (addCompletionReference) {
            result2.add(new JSModuleCompletionOnlyReference(unquoted, context2, offset, contributors, result2.isEmpty()));
        }
        PsiReference[] psiReferenceArray = result2.isEmpty() ? PsiReference.EMPTY_ARRAY : (PsiReference[])result2.toArray(PsiReference[]::new);
        if (psiReferenceArray == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(22);
        }
        return psiReferenceArray;
    }

    private static void checkReferencesAreHard(@NotNull List<PsiReference> refs) {
        if (refs == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(23);
        }
        if (refs.isEmpty() || !ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        for (PsiReference ref : refs) {
            if (!ref.isSoft()) continue;
            LOG.error("All references from module contributors must be hard (isSoft=false). Incorrect reference: " + ref.getClass());
        }
    }

    public static PsiReference[] getReferencesForStringLiteral(@Nullable JSLiteralExpression literalExpression, @Nullable PsiReferenceProvider provider) {
        if (literalExpression == null || !literalExpression.isQuotedLiteral()) {
            return PsiReference.EMPTY_ARRAY;
        }
        String unquotedEscapedText = JSStringUtil.unquoteStringLiteralValue(literalExpression.getText());
        return JSModuleReferenceContributor.getReferences(unquotedEscapedText, (PsiElement)literalExpression, 1, provider);
    }

    @NotNull
    public static Collection<PsiElement> resolveModuleReference(@Nullable PsiReference reference) {
        ProgressManager.checkCanceled();
        if (reference instanceof JSParentReference || reference == null || reference instanceof FileReference && !((FileReference)reference).isLast()) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSModuleReferenceContributor.$$$reportNull$$$0(24);
            }
            return list2;
        }
        if (reference instanceof PsiPolyVariantReference) {
            ResolveResult[] results = ((PsiPolyVariantReference)reference).multiResolve(false);
            List<PsiElement> toReturn = JSResolveResult.toElements(results);
            List<PsiElement> list3 = !toReturn.isEmpty() || results.length == 0 ? toReturn : JSResolveResult.toElements(results, false);
            if (list3 == null) {
                JSModuleReferenceContributor.$$$reportNull$$$0(25);
            }
            return list3;
        }
        List list4 = ContainerUtil.createMaybeSingletonList((Object)reference.resolve());
        if (list4 == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(26);
        }
        return list4;
    }

    @NotNull
    public static Collection<JSModuleReferenceContributor> getSortedExtensions() {
        Collection collection = (Collection)EP_NAME.computeIfAbsent(JSModuleReferenceContributor.class, () -> ContainerUtil.sorted((Collection)EP_NAME.getExtensionList(), Comparator.comparing(el -> el instanceof JSModuleReferenceMergeContributor).thenComparing(el -> -el.getDefaultWeight())));
        if (collection == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(27);
        }
        return collection;
    }

    @NotNull
    default public Collection<?> getDependencies(@NotNull String unquoted, @NotNull PsiElement host) {
        if (unquoted == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(28);
        }
        if (host == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(29);
        }
        List list2 = Collections.emptyList();
        if (list2 == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(30);
        }
        return list2;
    }

    @NotNull
    public static Collection<?> getAllDependencies(@NotNull String unquoted, @NotNull PsiElement host) {
        if (unquoted == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(31);
        }
        if (host == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(32);
        }
        HashSet<Object> deps = new HashSet<Object>();
        Project project = host.getProject();
        for (JSModuleReferenceContributor contributor : EP_NAME.getExtensionList()) {
            if (!contributor.isApplicable(host)) continue;
            ContainerUtil.addAll(deps, contributor.getDependencies(unquoted, host));
        }
        deps.add(VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS);
        deps.add(ProjectRootManager.getInstance((Project)host.getProject()));
        deps.add(() -> DumbService.isDumb((Project)project) ? 1L : 0L);
        deps.add(new ApplicableExtensionsModificationTracker(host));
        HashSet<Object> hashSet = deps;
        if (hashSet == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(33);
        }
        return hashSet;
    }

    @NotNull
    public static Object getIndexModificationTracker(@NotNull PsiElement host, @NotNull StubIndexKey<?, ?> indexId) {
        StubIndex instance;
        if (host == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(34);
        }
        if (indexId == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(35);
        }
        if (!((instance = StubIndex.getInstance()) instanceof StubIndexImpl) || DumbService.isDumb((Project)host.getProject())) {
            ModificationTracker modificationTracker = ModificationTracker.NEVER_CHANGED;
            if (modificationTracker == null) {
                JSModuleReferenceContributor.$$$reportNull$$$0(36);
            }
            return modificationTracker;
        }
        ModificationTracker modificationTracker = ((StubIndexImpl)instance).getIndexModificationTracker(indexId, host.getProject());
        if (modificationTracker == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(37);
        }
        return modificationTracker;
    }

    @NotNull
    public static Object getFileBasedIndexModificationTracker(@NotNull PsiElement host, @NotNull ID<?, ?> indexId) {
        if (host == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(38);
        }
        if (indexId == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(39);
        }
        if (DumbService.isDumb((Project)host.getProject())) {
            ModificationTracker modificationTracker = ModificationTracker.NEVER_CHANGED;
            if (modificationTracker == null) {
                JSModuleReferenceContributor.$$$reportNull$$$0(40);
            }
            return modificationTracker;
        }
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        ModificationTracker modificationTracker = () -> fileBasedIndex.getIndexModificationStamp(indexId, host.getProject());
        if (modificationTracker == null) {
            JSModuleReferenceContributor.$$$reportNull$$$0(41);
        }
        return modificationTracker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 9, 12, 21, 22, 24, 25, 26, 27, 30, 33, 36, 37, 40, 41 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedEscapedText";
                break;
            }
            case 1: 
            case 11: 
            case 29: 
            case 32: 
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 12: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 37: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSModuleReferenceContributor";
                break;
            }
            case 3: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDescriptor";
                break;
            }
            case 13: 
            case 15: 
            case 18: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquoted";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSModuleReferenceContributor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupElements";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveReferences";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalDescriptors";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonJSModuleReferences";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModuleReference";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedExtensions";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependencies";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexModificationTracker";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileBasedIndexModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLookupElements";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 12: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 37: 
            case 40: 
            case 41: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferences";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalDescriptors";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCommonJSModuleReferences";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkReferencesAreHard";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getAllDependencies";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getIndexModificationTracker";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getFileBasedIndexModificationTracker";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 9, 12, 21, 22, 24, 25, 26, 27, 30, 33, 36, 37, 40, 41 -> new IllegalStateException(string);
        };
    }

    public static final class ApplicableExtensionsModificationTracker
    implements ModificationTracker {
        @NotNull
        private final PsiElement myHost;

        ApplicableExtensionsModificationTracker(@NotNull PsiElement host) {
            if (host == null) {
                ApplicableExtensionsModificationTracker.$$$reportNull$$$0(0);
            }
            this.myHost = host;
        }

        public long getModificationCount() {
            if (!this.myHost.isValid()) {
                return -1L;
            }
            int result2 = 0;
            int index = -1;
            for (JSModuleReferenceContributor extension : JSModuleReferenceContributor.getSortedExtensions()) {
                ++index;
                if (!extension.isApplicable(this.myHost)) continue;
                result2 += 1 << index;
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/psi/resolve/JSModuleReferenceContributor$ApplicableExtensionsModificationTracker", "<init>"));
        }
    }

    public static interface JSModuleReferenceMergeContributor
    extends JSModuleReferenceContributor {
        @NotNull
        public Collection<PsiElement> resolveReferences(@NotNull PsiElement var1, @NotNull String var2, @NotNull Collection<PsiElement> var3);
    }
}

