/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.JSItemPresentation;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSControlFlowScope;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.controlflow.JSControlFlowService;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSIconProvider;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSStubElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSQualifiedObjectStubBase;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.BitUtil;
import com.intellij.util.IncorrectOperationException;
import icons.JavaScriptPsiIcons;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStubElementImpl<T extends JSStubElement<?>>
extends StubBasedPsiElementBase<T>
implements JSElement,
StubBasedPsiElement<T> {
    @NonNls
    private static final String IMPL = "Impl";
    private Language myLanguage;
    private static final ThreadLocal<Long> myStubBuildId = new ThreadLocal();
    private static final AtomicLong ourStubBuildIdCounter = new AtomicLong();

    public JSStubElementImpl(@NotNull ASTNode node) {
        if (node == null) {
            JSStubElementImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public JSStubElementImpl(@NotNull T t, @NotNull IStubElementType type2) {
        if (t == null) {
            JSStubElementImpl.$$$reportNull$$$0(1);
        }
        if (type2 == null) {
            JSStubElementImpl.$$$reportNull$$$0(2);
        }
        super(t, type2);
    }

    @NotNull
    public Language getLanguage() {
        if (this.myLanguage == null) {
            this.myLanguage = DialectDetector.calculateJSLanguage((PsiElement)this);
        }
        Language language = this.myLanguage;
        if (language == null) {
            JSStubElementImpl.$$$reportNull$$$0(3);
        }
        return language;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSStubElementImpl.$$$reportNull$$$0(4);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSElement(this);
        } else {
            super.accept(visitor);
        }
    }

    @NotNull
    public final SearchScope getDefaultUseScope() {
        PsiFile file = this.getContainingFile();
        SearchScope searchScope = InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file).getUseScope();
        if (searchScope == null) {
            JSStubElementImpl.$$$reportNull$$$0(5);
        }
        return searchScope;
    }

    public String toString() {
        return JSElementImpl.toStringImpl(this);
    }

    public ItemPresentation getPresentation() {
        if (this instanceof JSPsiElementBase) {
            return new JSItemPresentation((JSPsiElementBase)((Object)this));
        }
        return null;
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            JSStubElementImpl.$$$reportNull$$$0(6);
        }
        if (JSChangeUtil.isSourceElementOrComment(element)) {
            if (JSChangeUtil.isStatementContainer((PsiElement)this)) {
                return JSChangeUtil.doAddBefore((PsiElement)this, element, anchor);
            }
            if (JSChangeUtil.isBlockStatementContainer(this) && anchor != null) {
                return JSChangeUtil.blockDoAddBefore(element, anchor);
            }
        }
        return super.addBefore(element, anchor);
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            JSStubElementImpl.$$$reportNull$$$0(7);
        }
        if (JSChangeUtil.isSourceElementOrComment(element)) {
            if (JSChangeUtil.isStatementContainer((PsiElement)this)) {
                return JSChangeUtil.doAddAfter((PsiElement)this, element, anchor);
            }
            if (JSChangeUtil.isBlockStatementContainer(this) && anchor != null) {
                return JSChangeUtil.blockDoAddAfter(element, anchor);
            }
        }
        return super.addAfter(element, anchor);
    }

    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            JSStubElementImpl.$$$reportNull$$$0(8);
        }
        if (last == null) {
            JSStubElementImpl.$$$reportNull$$$0(9);
        }
        if (JSChangeUtil.isSourceElementOrComment(first)) {
            if (JSChangeUtil.isStatementContainer((PsiElement)this)) {
                return (PsiElement)JSChangeUtil.doAddRangeBefore((PsiElement)this, (PsiElement)first, (PsiElement)last, (PsiElement)anchor).first;
            }
            if (JSChangeUtil.isBlockStatementContainer(this) && anchor != null) {
                return JSChangeUtil.blockDoAddRangeBefore(first, last, anchor);
            }
        }
        return super.addRangeBefore(first, last, anchor);
    }

    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (JSChangeUtil.isSourceElementOrComment(first)) {
            if (JSChangeUtil.isStatementContainer((PsiElement)this)) {
                return (PsiElement)JSChangeUtil.doAddRangeAfter((PsiElement)this, (PsiElement)first, (PsiElement)last, (PsiElement)anchor).first;
            }
            if (JSChangeUtil.isBlockStatementContainer(this) && anchor != null) {
                return JSChangeUtil.blockDoAddRangeAfter(first, last, anchor);
            }
        }
        return super.addRangeAfter(first, last, anchor);
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSStubElementImpl.$$$reportNull$$$0(10);
        }
        return this.addAfter(element, null);
    }

    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return this.addRangeAfter(first, last, null);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            JSStubElementImpl.$$$reportNull$$$0(11);
        }
        return JSElementImpl.replaceInParent((PsiElement)this, newElement);
    }

    @NotNull
    protected static Icon getIcon(@NotNull JSPsiElementBase element, @NotNull Icon defaultBaseIcon, int flags) {
        if (element == null) {
            JSStubElementImpl.$$$reportNull$$$0(12);
        }
        if (defaultBaseIcon == null) {
            JSStubElementImpl.$$$reportNull$$$0(13);
        }
        Icon icon = defaultBaseIcon;
        JSDocComment docComment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)element);
        if (docComment != null && docComment.isClassExplicitly()) {
            icon = JSIconProvider.DEFAULT_INSTANCE.getClassIcon();
        }
        boolean blendStatic = element.getJSContext() == JSContext.STATIC;
        boolean blendFinal = false;
        if (element instanceof JSAttributeListOwner) {
            JSAttributeList attributeList = ((JSAttributeListOwner)((Object)element)).getAttributeList();
            boolean bl = blendFinal = attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.FINAL);
        }
        if (element instanceof JSVariable && ((JSVariable)element).isConst() || element instanceof JSField && ((JSField)element).isConst()) {
            blendFinal = true;
        }
        icon = BitUtil.isSet((int)flags, (int)2) ? JSStubElementImpl.blendFlags(icon, blendStatic, blendFinal) : icon;
        JSVisibilityUtil.PresentableAccessModifier accessType = JSVisibilityUtil.getPresentableAccessModifier(element);
        if (accessType != null) {
            icon = JSStubElementImpl.iconWithVisibilityIfNeeded((int)flags, (Icon)icon, (Icon)accessType.getIcon());
        }
        Icon icon2 = icon;
        if (icon2 == null) {
            JSStubElementImpl.$$$reportNull$$$0(14);
        }
        return icon2;
    }

    @Contract(value="!null,_,_,_->!null")
    protected static Icon blendModifierFlags(@Nullable Icon baseIcon, JSAttributeList attrList, boolean blendStatic, int flags) {
        if (!BitUtil.isSet((int)flags, (int)2)) {
            return baseIcon;
        }
        if (attrList == null) {
            return baseIcon;
        }
        boolean isStatic = blendStatic && JSStubElementImpl.isStatic(attrList);
        return JSStubElementImpl.blendFlags(baseIcon, isStatic || attrList.hasModifier(JSAttributeList.ModifierType.DYNAMIC), attrList.hasModifier(JSAttributeList.ModifierType.FINAL));
    }

    private static boolean isStatic(@NotNull JSAttributeList attrList) {
        PsiElement superParent;
        if (attrList == null) {
            JSStubElementImpl.$$$reportNull$$$0(15);
        }
        if (attrList.hasModifier(JSAttributeList.ModifierType.STATIC)) {
            return true;
        }
        if (!DialectDetector.isActionScript((PsiElement)attrList)) {
            return false;
        }
        PsiElement grandParent = attrList.getParent().getParent();
        return grandParent instanceof JSBlockStatement && ((superParent = grandParent.getParent()) instanceof JSClass || superParent instanceof JSFile && superParent.getContext() != null);
    }

    public static Icon blendFlags(Icon baseIcon, boolean blendStatic, boolean blendFinal) {
        if (blendStatic) {
            baseIcon = IconManager.getInstance().createLayered(new Icon[]{baseIcon, IconManager.getInstance().getPlatformIcon(PlatformIcons.StaticMark)});
        }
        if (blendFinal) {
            baseIcon = IconManager.getInstance().createLayered(new Icon[]{baseIcon, JavaScriptPsiIcons.Nodes.ReadonlyMark});
        }
        return baseIcon;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = JSResolveUtil.getResolveScope((PsiElement)this);
        if (globalSearchScope == null) {
            JSStubElementImpl.$$$reportNull$$$0(16);
        }
        return globalSearchScope;
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.clearCaches();
    }

    public void clearCaches() {
        JSStubElementImpl jSStubElementImpl = this;
        if (jSStubElementImpl instanceof JSControlFlowScope) {
            JSControlFlowScope scope2 = (JSControlFlowScope)((Object)jSStubElementImpl);
            JSControlFlowService.getService(this.getProject()).resetControlFlow(scope2);
        }
    }

    @NotNull
    public JSElementBase.ClassOrInterface isClassOrInterface() {
        if (this instanceof JSQualifiedNamedElement) {
            JSStubElement stub = (JSStubElement)this.getGreenStub();
            if (stub instanceof JSQualifiedObjectStubBase) {
                JSElementBase.ClassOrInterface classOrInterface = ((JSQualifiedObjectStubBase)stub).isClassOrInterface();
                if (classOrInterface == null) {
                    JSStubElementImpl.$$$reportNull$$$0(17);
                }
                return classOrInterface;
            }
            JSElementBase.ClassOrInterface classOrInterface = JSDocumentationUtils.isClassOrInterface((JSQualifiedNamedElement)((Object)this));
            if (classOrInterface == null) {
                JSStubElementImpl.$$$reportNull$$$0(18);
            }
            return classOrInterface;
        }
        JSElementBase.ClassOrInterface classOrInterface = JSElementBase.ClassOrInterface.NONE;
        if (classOrInterface == null) {
            JSStubElementImpl.$$$reportNull$$$0(19);
        }
        return classOrInterface;
    }

    public static void startBuildingStubs() {
        myStubBuildId.set(ourStubBuildIdCounter.getAndIncrement());
    }

    public static void finishBuildingStubs() {
        myStubBuildId.remove();
    }

    public static boolean isBuildingStubs() {
        return myStubBuildId.get() != null;
    }

    @Nullable
    private static Long getStubBuildId() {
        return myStubBuildId.get();
    }

    @ApiStatus.Internal
    public static <T, P> T getCachedValueIfBuildingStubs(@NotNull PsiElement dataHolder, @NotNull Key<StubBuildCachedValue<T>> stubBuildingKey, @NotNull P parameter, @NotNull Function<P, T> provider) {
        Long stubBuildId;
        if (dataHolder == null) {
            JSStubElementImpl.$$$reportNull$$$0(20);
        }
        if (stubBuildingKey == null) {
            JSStubElementImpl.$$$reportNull$$$0(21);
        }
        if (parameter == null) {
            JSStubElementImpl.$$$reportNull$$$0(22);
        }
        if (provider == null) {
            JSStubElementImpl.$$$reportNull$$$0(23);
        }
        if ((stubBuildId = JSStubElementImpl.getStubBuildId()) != null) {
            ASTNode node = dataHolder.getNode();
            StubBuildCachedValue<T> current = (StubBuildCachedValue<T>)node.getUserData(stubBuildingKey);
            if (current == null || current.buildId != stubBuildId) {
                current = new StubBuildCachedValue<T>(stubBuildId, provider.apply(parameter));
                node.putUserData(stubBuildingKey, current);
            }
            return current.value;
        }
        return provider.apply(parameter);
    }

    @ApiStatus.Internal
    public static <T, P> T getCachedValueStubBuildOptimized(@NotNull CompositeElement node, @NotNull Key<ParameterizedCachedValue<T, P>> key2, @NotNull Key<StubBuildCachedValue<T>> stubBuildingKey, @NotNull ParameterizedCachedValueProvider<T, P> provider, P parameter) {
        Long stubBuildId;
        if (node == null) {
            JSStubElementImpl.$$$reportNull$$$0(24);
        }
        if (key2 == null) {
            JSStubElementImpl.$$$reportNull$$$0(25);
        }
        if (stubBuildingKey == null) {
            JSStubElementImpl.$$$reportNull$$$0(26);
        }
        if (provider == null) {
            JSStubElementImpl.$$$reportNull$$$0(27);
        }
        if ((stubBuildId = JSStubElementImpl.getStubBuildId()) != null) {
            StubBuildCachedValue<Object> current = (StubBuildCachedValue<Object>)node.getUserData(stubBuildingKey);
            if (current == null || current.buildId != stubBuildId) {
                CachedValueProvider.Result value = provider.compute(parameter);
                current = new StubBuildCachedValue<Object>(stubBuildId, value != null ? value.getValue() : null);
                node.putUserData(stubBuildingKey, current);
            }
            return current.value;
        }
        return (T)CachedValuesManager.getManager((Project)node.getManager().getProject()).getParameterizedCachedValue((UserDataHolder)node, key2, provider, false, parameter);
    }

    @ApiStatus.Internal
    public static <T, P> T getCachedValueStubBuildOptimized(@NotNull PsiElement dataHolder, @NotNull Key<ParameterizedCachedValue<T, P>> key2, @NotNull Key<StubBuildCachedValue<T>> stubBuildingKey, @NotNull ParameterizedCachedValueProvider<T, P> provider, P parameter) {
        Long stubBuildId;
        if (dataHolder == null) {
            JSStubElementImpl.$$$reportNull$$$0(28);
        }
        if (key2 == null) {
            JSStubElementImpl.$$$reportNull$$$0(29);
        }
        if (stubBuildingKey == null) {
            JSStubElementImpl.$$$reportNull$$$0(30);
        }
        if (provider == null) {
            JSStubElementImpl.$$$reportNull$$$0(31);
        }
        if ((stubBuildId = JSStubElementImpl.getStubBuildId()) != null) {
            ASTNode node = dataHolder.getNode();
            StubBuildCachedValue<Object> current = (StubBuildCachedValue<Object>)node.getUserData(stubBuildingKey);
            if (current == null || current.buildId != stubBuildId) {
                CachedValueProvider.Result value = provider.compute(parameter);
                current = new StubBuildCachedValue<Object>(stubBuildId, value != null ? value.getValue() : null);
                node.putUserData(stubBuildingKey, current);
            }
            return current.value;
        }
        return (T)CachedValuesManager.getManager((Project)dataHolder.getProject()).getParameterizedCachedValue((UserDataHolder)dataHolder, key2, provider, false, parameter);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 14, 16, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 5: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSStubElementImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultBaseIcon";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrList";
                break;
            }
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 21: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubBuildingKey";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 23: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSStubElementImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultUseScope";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "isClassOrInterface";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addRangeBefore";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isStatic";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getCachedValueIfBuildingStubs";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getCachedValueStubBuildOptimized";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 14, 16, 17, 18, 19 -> new IllegalStateException(string);
        };
    }

    public record StubBuildCachedValue<T>(long buildId, T value) {
    }
}

