/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.FrameworkIndexingHandlers;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.gist.JSPropertyData;
import com.intellij.lang.javascript.index.gist.JSStubElementGist;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexingDataHolder;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSCachingTypeOwner;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSImplicitElementProviderImpl;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSQualifiedNamedElementBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSTypeHelper;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSPropertyStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.StubTreeUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSRequireCallExpressionType;
import com.intellij.lang.typescript.resolve.TypeScriptTypeHelper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPropertyImpl
extends JSQualifiedNamedElementBaseImpl<JSPropertyStub>
implements JSProperty,
JSInitializerOwner,
JSCachingTypeOwner,
JSIndexingDataHolder {
    private static final TokenSet STUB_SAFE_PROPERTY_INITIALIZERS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSElementTypes.FUNCTION_EXPRESSIONS, TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.OBJECT_LITERAL_EXPRESSION, JSStubElementTypes.LITERAL_EXPRESSION, JSStubElementTypes.TYPE_AS_EXPRESSION})});
    private static final String[] OBJECT_DEFINE_PROPERTIES = new String[]{"Object", "defineProperties"};
    private static final Key<ParameterizedCachedValue<JSPropertyCachedData, JSProperty>> CACHED_DATA_KEY = Key.create((String)"js.property.cachedData");
    private static final Key<JSStubElementImpl.StubBuildCachedValue<JSPropertyCachedData>> STUB_BUILDING_CACHED_DATA_KEY = Key.create((String)"js.stub.building.property.cachedData");
    @NonNls
    private static final Key<ParameterizedCachedValue<PsiReference[], JSPropertyImpl>> REFERENCES_KEY = new Key("js.property.references");
    private static final ParameterizedCachedValueProvider<PsiReference[], JSPropertyImpl> REFERENCES_PROVIDER = param -> CachedValueProvider.Result.create((Object)param.createRefs(), (Object[])new Object[]{param, PsiModificationTracker.MODIFICATION_COUNT});
    private static final TokenSet PROPERTY_NAME_SEARCH_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{JSKeywordSets.PROPERTY_NAMES, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.COLON})});

    public JSPropertyImpl(ASTNode node) {
        super(node);
    }

    public JSPropertyImpl(JSPropertyStub stub) {
        this(stub, (IStubElementType)JSStubElementTypes.PROPERTY);
    }

    protected JSPropertyImpl(JSPropertyStub stub, IStubElementType type2) {
        super(stub, type2);
    }

    public PsiReference getReference() {
        PsiReference[] refs = this.getReferences();
        return refs.length == 1 ? refs[0] : null;
    }

    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, REFERENCES_KEY, REFERENCES_PROVIDER, false, (Object)this);
        if (psiReferenceArray == null) {
            JSPropertyImpl.$$$reportNull$$$0(0);
        }
        return psiReferenceArray;
    }

    private PsiReference[] createRefs() {
        PsiReference[] psiReferenceArray;
        PsiReference[] result2;
        JSElementIndexingData indexingData = this.getIndexingData();
        if ((indexingData == null || ContainerUtil.isEmpty(indexingData.getImplicitElements())) && this.getNameIdentifier() != null && (result2 = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this)).length > 0) {
            return result2;
        }
        String name = this.getName();
        if (name != null) {
            PsiReference[] psiReferenceArray2 = new PsiReference[1];
            psiReferenceArray = psiReferenceArray2;
            psiReferenceArray2[0] = new JSPropertyNameReference(this, name);
        } else {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
        }
        return psiReferenceArray;
    }

    @Override
    @Nullable
    public PsiPolyVariantReference getPropertyNameReference() {
        return new PsiMultiReference(this.getReferences(), (PsiElement)this);
    }

    @Override
    public String getName() {
        JSPropertyStub stub = (JSPropertyStub)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        ASTNode node = this.findNameIdentifier();
        if (node != null) {
            return JSPsiImplUtils.getNameFromIdentifier(node);
        }
        return null;
    }

    @Override
    public String getQualifiedName() {
        return JSPsiImplUtils.buildQualifiedNameFromNamespaceAndName(this);
    }

    @Override
    @NotNull
    public JSNamespace getJSNamespace() {
        JSPropertyStub stub = (JSPropertyStub)this.getGreenStub();
        if (stub != null) {
            JSNamespace jSNamespace = stub.getNamespaceWithSource(this);
            if (jSNamespace == null) {
                JSPropertyImpl.$$$reportNull$$$0(1);
            }
            return jSNamespace;
        }
        JSNamespace jSNamespace = this.getCachedData().mySymbolNamespace;
        if (jSNamespace == null) {
            JSPropertyImpl.$$$reportNull$$$0(2);
        }
        return jSNamespace;
    }

    @Override
    @Nullable
    public JSQualifiedName getNamespace() {
        JSPropertyStub stub = (JSPropertyStub)this.getGreenStub();
        if (stub != null) {
            return stub.getNamespace();
        }
        JSNamespace symbolNamespace = this.getCachedData().mySymbolNamespace;
        return symbolNamespace.isLocal() ? null : symbolNamespace.getQualifiedName();
    }

    @Override
    public boolean isNamespaceExplicitlyDeclared() {
        JSPropertyStub stub = (JSPropertyStub)this.getGreenStub();
        if (stub != null) {
            return stub.isNamespaceExplicitlyDeclared();
        }
        return this.getCachedData().mySymbolNamespace.isSourceStrict();
    }

    private JSPropertyCachedData getCachedData() {
        return JSPropertyImpl.getCachedData(this);
    }

    public static JSPropertyCachedData getCachedData(@NotNull JSProperty property) {
        if (property == null) {
            JSPropertyImpl.$$$reportNull$$$0(3);
        }
        return JSPropertyImpl.getCachedValueStubBuildOptimized((PsiElement)property, CACHED_DATA_KEY, STUB_BUILDING_CACHED_DATA_KEY, it -> {
            JSPropertyCachedData data = JSPropertyImpl.calculateCachedData(it);
            return CachedValueProvider.Result.create((Object)data, (Object[])new Object[]{it.getContainingFile()});
        }, property);
    }

    @NotNull
    private static JSPropertyCachedData calculateCachedData(@NotNull JSProperty property) {
        if (property == null) {
            JSPropertyImpl.$$$reportNull$$$0(4);
        }
        JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PACKAGE_LOCAL;
        JSDocComment ownDocComment = JSDocumentationUtils.findOwnDocComment((PsiElement)property);
        JSNamespace symbolNamespace = null;
        if (ownDocComment != null) {
            JSAttributeList.AccessType docCommentAccessType;
            JSQualifiedName namespace = ownDocComment.getNamespace();
            boolean namespaceExplicitlyDeclared = ownDocComment.isNamespaceExplicitlyDeclared();
            JSContext jsContext = ownDocComment.getJSContext();
            if (namespaceExplicitlyDeclared || namespace != null) {
                symbolNamespace = JSNamedTypeFactory.createNamespace(namespace, jsContext, (PsiElement)property, namespaceExplicitlyDeclared);
            }
            if ((docCommentAccessType = ownDocComment.getAccessType()) != null) {
                accessType = docCommentAccessType;
            }
        }
        PsiElement parent = property.getParent();
        if (symbolNamespace == null && parent instanceof JSObjectLiteralExpression) {
            JSObjectLiteralExpression objectLiteral = (JSObjectLiteralExpression)parent;
            JSQualifiedName namespace = JSPropertyImpl.findNamespaceFromSpecialProperties(objectLiteral);
            symbolNamespace = namespace != null ? JSNamedTypeFactory.createNamespace(namespace, JSContext.UNKNOWN, (PsiElement)property, true) : JSSymbolUtil.findNamespace(objectLiteral);
        }
        if (symbolNamespace == null) {
            symbolNamespace = JSAnyType.get((PsiElement)property);
        }
        return new JSPropertyCachedData(symbolNamespace, accessType);
    }

    @Nullable
    public static JSQualifiedName findNamespaceFromSpecialProperties(JSObjectLiteralExpression expression) {
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getExtensions((PsiElement)expression)) {
            String context2 = handler.resolveContextFromProperty(expression, true);
            if (context2 == null) continue;
            return JSQualifiedNameImpl.fromQualifiedName(context2);
        }
        return null;
    }

    @Override
    public ASTNode findNameIdentifier() {
        return JSPropertyImpl.findNameIdentifier(this.getNode());
    }

    public static ASTNode findNameIdentifier(ASTNode myNode) {
        ASTNode funExprNode;
        ASTNode nameNode = myNode.findChildByType(PROPERTY_NAME_SEARCH_SET);
        if (nameNode == null && (funExprNode = myNode.findChildByType(JSElementTypes.FUNCTION_EXPRESSIONS)) != null) {
            ASTNode firstIdentifier = funExprNode.findChildByType(JSKeywordSets.IDENTIFIER_NAMES);
            if ((JSPropertyImpl.isGetIdentifier(firstIdentifier) || JSPropertyImpl.isSetIdentifier(firstIdentifier)) && firstIdentifier.getTreeNext() != null) {
                return funExprNode.findChildByType(JSKeywordSets.IDENTIFIER_NAMES, firstIdentifier.getTreeNext());
            }
            return firstIdentifier;
        }
        return nameNode != null && JSKeywordSets.PROPERTY_NAMES.contains(nameNode.getElementType()) ? nameNode : null;
    }

    @Override
    public boolean isGetProperty() {
        JSFunctionExpression functionExpression = this.tryGetFunctionInitializer();
        return functionExpression != null && functionExpression.isGetProperty();
    }

    @Nullable
    static ASTNode findAccessNodeAsIdentifier(IElementType accessType, ASTNode funExprNode) {
        ASTNode maybeAccessNode = funExprNode.findChildByType(JSTokenTypes.IDENTIFIER);
        if (maybeAccessNode != null) {
            return accessType == JSTokenTypes.GET_KEYWORD && JSPropertyImpl.isGetIdentifier(maybeAccessNode) || accessType == JSTokenTypes.SET_KEYWORD && JSPropertyImpl.isSetIdentifier(maybeAccessNode) ? maybeAccessNode : null;
        }
        return null;
    }

    private static boolean isGetIdentifier(ASTNode node) {
        return node != null && node.getElementType() == JSTokenTypes.GET_KEYWORD;
    }

    private static boolean isSetIdentifier(ASTNode node) {
        return node != null && node.getElementType() == JSTokenTypes.SET_KEYWORD;
    }

    @Override
    public boolean isSetProperty() {
        JSFunctionExpression functionExpression = this.tryGetFunctionInitializer();
        return functionExpression != null && functionExpression.isSetProperty();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            JSPropertyImpl.$$$reportNull$$$0(5);
        }
        ASTNode renamedNode = this.findNameIdentifier();
        assert (renamedNode != null);
        ASTNode nameElement = JSChangeUtil.createPropertyNameWithContext(name, renamedNode);
        if (nameElement == null) {
            throw new IncorrectOperationException("Can't create name element " + name);
        }
        renamedNode.getTreeParent().replaceChild(renamedNode, nameElement);
        return this;
    }

    @Override
    public JSExpression getValue() {
        ASTNode node = this.getNode().findChildByType(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
        return node != null ? (JSExpression)node.getPsi() : null;
    }

    @Override
    @Nullable
    public JSExpression getInitializer() {
        return this.getValue();
    }

    @Override
    public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSPropertyImpl.$$$reportNull$$$0(6);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSProperty(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            JSPropertyImpl.$$$reportNull$$$0(7);
        }
        if (state == null) {
            JSPropertyImpl.$$$reportNull$$$0(8);
        }
        if (place == null) {
            JSPropertyImpl.$$$reportNull$$$0(9);
        }
        if (JSPropertyImpl.shouldProcessProperty(lastParent, place)) {
            return processor.execute((PsiElement)this, state);
        }
        return true;
    }

    static boolean shouldProcessProperty(PsiElement lastParent, @NotNull PsiElement place) {
        if (place == null) {
            JSPropertyImpl.$$$reportNull$$$0(10);
        }
        return lastParent == null && place instanceof JSProperty || JSPropertyImpl.placeToProcessProperties(place);
    }

    static boolean placeToProcessProperties(PsiElement place) {
        return place instanceof JSReferenceExpression && ((JSReferenceExpression)place).getQualifier() instanceof JSThisExpression;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        JSFunctionExpression value = this.tryGetFunctionInitializer();
        if (value != null) {
            ((JSFunctionBaseImpl)((Object)value)).clearCaches();
        }
    }

    public Icon getIcon(int flags) {
        return JSPropertyImpl.getIcon(this, IconManager.getInstance().getPlatformIcon(this.tryGetFunctionInitializer() != null ? PlatformIcons.Method : PlatformIcons.Property), flags);
    }

    public void delete() throws IncorrectOperationException {
        PsiElement parent = this.getParent();
        if (parent instanceof JSObjectLiteralExpression) {
            JSChangeUtil.removeRangeWithRemovalOfCommas((PsiElement)this, (PsiElement[])((JSObjectLiteralExpression)parent).getPropertiesIncludingSpreads());
        }
    }

    public PsiElement getNameIdentifier() {
        ASTNode node = this.findNameIdentifier();
        return node != null ? node.getPsi() : null;
    }

    @Nullable
    private Collection<FrameworkIndexingHandler> getFrameworkHandlersForPropertyName(String name) {
        if (!FrameworkIndexingHandler.allowsHandlers(this)) {
            return null;
        }
        FrameworkIndexingHandlers frameworkHandlers = FrameworkIndexingHandlers.getInstance();
        return frameworkHandlers.getFrameworkHandlersForPropertyName(name);
    }

    @Override
    @Nullable
    public JSElementIndexingData calculateIndexingData() {
        String name = this.getName();
        boolean needProcessAnyProperties = true;
        Collection<FrameworkIndexingHandler> handlers = this.getFrameworkHandlersForPropertyName(name);
        JSElementIndexingData indexingData = null;
        if (name != null && handlers != null) {
            indexingData = new JSElementIndexingDataImpl();
            for (FrameworkIndexingHandler f : handlers) {
                if (f.processProperty(name, this, indexingData)) continue;
                needProcessAnyProperties = false;
            }
            if (!needProcessAnyProperties) {
                return indexingData;
            }
            indexingData = indexingData.isEmpty() ? null : indexingData;
        }
        for (FrameworkIndexingHandler indexingHandler : FrameworkIndexingHandler.getExtensions(this)) {
            indexingData = indexingHandler.processAnyProperty(this, indexingData);
        }
        return indexingData;
    }

    @Override
    @Nullable
    public JSElementIndexingData getIndexingData() {
        return JSImplicitElementProviderImpl.getIndexingData(this);
    }

    @Override
    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSPropertyStub stub = (JSPropertyStub)this.getGreenStub();
        if (stub != null) {
            JSAttributeList.AccessType accessType = stub.getAccessType();
            if (accessType == null) {
                JSPropertyImpl.$$$reportNull$$$0(11);
            }
            return accessType;
        }
        JSAttributeList.AccessType accessType = this.getCachedData().myAccessType;
        if (accessType == null) {
            JSPropertyImpl.$$$reportNull$$$0(12);
        }
        return accessType;
    }

    @Override
    @Nullable
    public JSFunctionExpression tryGetFunctionInitializer() {
        JSPropertyStub stub = (JSPropertyStub)this.getGreenStub();
        if (stub != null) {
            StubElement<?> childStub = StubTreeUtil.findChildStubByType(stub, JSElementTypes.FUNCTION_EXPRESSIONS, true);
            return childStub != null ? (JSFunctionExpression)childStub.getPsi() : null;
        }
        JSExpression value = this.getValue();
        return value instanceof JSFunctionExpression ? (JSFunctionExpression)value : null;
    }

    @Override
    @Nullable
    public JSObjectLiteralExpression getObjectLiteralExpressionInitializer() {
        return (JSObjectLiteralExpression)this.getStubOrPsiChild(JSStubElementTypes.OBJECT_LITERAL_EXPRESSION);
    }

    @Override
    @Nullable
    public JSLiteralExpression getLiteralExpressionInitializer() {
        return (JSLiteralExpression)this.getStubOrPsiChild(JSStubElementTypes.LITERAL_EXPRESSION);
    }

    @Override
    @NotNull
    public JSContext getJSContext() {
        JSPropertyStub stub = (JSPropertyStub)this.getGreenStub();
        if (stub != null) {
            JSContext jSContext = stub.getJSContext();
            if (jSContext == null) {
                JSPropertyImpl.$$$reportNull$$$0(13);
            }
            return jSContext;
        }
        JSContext jSContext = this.getCachedData().mySymbolNamespace.getJSContext();
        if (jSContext == null) {
            JSPropertyImpl.$$$reportNull$$$0(14);
        }
        return jSContext;
    }

    @Nullable
    private JSType findTypeFromJSDoc() {
        String typeName;
        JSQualifiedNamedElement element;
        PsiElement parent = this.getParent();
        String enumType = JSDocumentationUtils.findEnumType(parent);
        if (enumType != null && parent instanceof JSObjectLiteralExpression && (element = JSPsiImplUtils.getInitializedElement((JSExpression)parent)) != null && (typeName = element.getQualifiedName()) != null) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource(this, true);
            JSType enumNamespace = JSNamedTypeFactory.createType(typeName, source, JSContext.STATIC);
            JSType enumElementType = JSTypeParser.createType(this.getProject(), enumType, source);
            return enumElementType != null ? JSCompositeTypeFactory.createUnionType(source, enumNamespace, enumElementType) : enumNamespace;
        }
        String s = JSDocumentationUtils.findType(this);
        if (s != null) {
            return JSTypeParser.createType(this.getProject(), s, JSTypeSourceFactory.createTypeSource(this, true));
        }
        return null;
    }

    @Override
    @Nullable
    public JSType calculateType() {
        JSTypeHelper typeHelper;
        boolean useAccurateEvaluation = ContainerUtil.exists(FrameworkIndexingHandler.getIndexingHandlers(), handler -> handler.useMoreAccurateTypes(this));
        JSTypeHelper jSTypeHelper = typeHelper = useAccurateEvaluation ? TypeScriptTypeHelper.getInstance() : JSDialectSpecificHandlersFactory.forElement(this).getTypeHelper();
        if (DialectDetector.isJavaScript(this)) {
            return this.calculateTypeForJavaScript(typeHelper);
        }
        return typeHelper.getTypeForIndexing(this.getValue(), this);
    }

    @Nullable
    private JSType calculateTypeForJavaScript(@NotNull JSTypeHelper typeHelper) {
        JSType type2;
        JSProperty valueProp;
        PsiElement objectLiteral;
        JSType typeFromJSDoc;
        if (typeHelper == null) {
            JSPropertyImpl.$$$reportNull$$$0(15);
        }
        if ((typeFromJSDoc = this.findTypeFromJSDoc()) != null) {
            return typeFromJSDoc;
        }
        JSExpression value = this.getInitializer();
        if (value instanceof JSObjectLiteralExpression && (objectLiteral = this.getParent()) instanceof JSObjectLiteralExpression && JSPsiImplUtils.isArgumentOfCallWithName((JSObjectLiteralExpression)objectLiteral, 1, OBJECT_DEFINE_PROPERTIES) && (valueProp = ((JSObjectLiteralExpression)value).findProperty("value")) != null) {
            value = valueProp.getInitializer();
        }
        if ((type2 = typeHelper.getTypeForIndexing(value, this)) != null) {
            boolean isConstProperty;
            boolean bl = isConstProperty = this.isGetProperty() || type2 instanceof JSRequireCallExpressionType;
            if (!isConstProperty) {
                JSPropertyImpl parent = this;
                while ((parent = parent.getParent()) instanceof JSObjectLiteralExpression || parent instanceof JSProperty) {
                }
                isConstProperty = JSPropertyImpl.isDirectlyExported(parent);
            }
            if (!isConstProperty) {
                type2 = type2.copyWithStrict(false);
            }
        }
        return type2;
    }

    private static boolean isDirectlyExported(@NotNull PsiElement expressionParent) {
        JSQualifiedName name;
        JSExpression expression;
        JSExpression lOperand;
        JSAttributeList attributeList;
        if (expressionParent == null) {
            JSPropertyImpl.$$$reportNull$$$0(16);
        }
        if (expressionParent instanceof JSExportAssignment) {
            return true;
        }
        if (expressionParent instanceof JSAttributeListOwner && (attributeList = ((JSAttributeListOwner)expressionParent).getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.EXPORT)) {
            return true;
        }
        return expressionParent instanceof JSAssignmentExpression && (lOperand = ((JSAssignmentExpression)expressionParent).getLOperand()) instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)lOperand).getExpression()) instanceof JSReferenceExpression && (CommonJSUtil.isExportNamespace(name = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)((JSReferenceExpression)expression))) || name != null && CommonJSUtil.isExportNamespace(name.getParent()));
    }

    @Override
    public boolean canBeLocallyEvaluated() {
        return !this.isGetProperty() && !this.isSetProperty();
    }

    @Override
    @Nullable
    public JSExpression getInitializerOrStub() {
        JSPropertyStub stub = (JSPropertyStub)this.getStub();
        if (stub != null) {
            StubElement<?> type2 = StubTreeUtil.findChildStubByType(stub, STUB_SAFE_PROPERTY_INITIALIZERS, true);
            return type2 != null ? (JSExpression)ObjectUtils.tryCast((Object)type2.getPsi(), JSExpression.class) : null;
        }
        return this.getInitializer();
    }

    @Override
    public boolean requiresTypeChecking() {
        return this.getGistData().requiresTypeChecking();
    }

    public boolean calculateRequiresTypeChecking() {
        return !DialectDetector.isJavaScript(this) || this.findTypeFromJSDoc() != null;
    }

    @NotNull
    protected JSPropertyData getGistData() {
        JSPropertyData jSPropertyData = JSStubElementGist.getInstance(this.getProject()).getData(this);
        if (jSPropertyData == null) {
            JSPropertyImpl.$$$reportNull$$$0(17);
        }
        return jSPropertyData;
    }

    @Override
    public boolean isNumericKey() {
        JSPropertyStub stub = (JSPropertyStub)this.getGreenStub();
        if (stub != null) {
            return stub.isNumericKey();
        }
        ASTNode nameIdentifier = this.findNameIdentifier();
        return nameIdentifier != null && nameIdentifier.getElementType() == JSTokenTypes.NUMERIC_LITERAL;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8, 9, 10, 15, 16 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSPropertyImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeHelper";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSNamespace";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSPropertyImpl";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getGistData";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCachedData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calculateCachedData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcessProperty";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "calculateTypeForJavaScript";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyExported";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10, 15, 16 -> new IllegalArgumentException(string);
        };
    }

    public static final class JSPropertyCachedData {
        @NotNull
        public final JSNamespace mySymbolNamespace;
        @NotNull
        public final JSAttributeList.AccessType myAccessType;

        private JSPropertyCachedData(@NotNull JSNamespace symbolNamespace, @NotNull JSAttributeList.AccessType type2) {
            if (symbolNamespace == null) {
                JSPropertyCachedData.$$$reportNull$$$0(0);
            }
            if (type2 == null) {
                JSPropertyCachedData.$$$reportNull$$$0(1);
            }
            this.mySymbolNamespace = symbolNamespace;
            this.myAccessType = type2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "symbolNamespace";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/impl/JSPropertyImpl$JSPropertyCachedData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

