/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class JSQualifiedNameImpl
implements JSQualifiedName {
    private static final ConcurrentMap<String, JSQualifiedNameImpl> NAMESPACES = ContainerUtil.createConcurrentWeakMap();
    public static final JSQualifiedNameImpl EMPTY = JSQualifiedNameImpl.create("", null);
    @NotNull
    private final String myName;
    @Nullable
    private final JSQualifiedNameImpl myParent;

    private JSQualifiedNameImpl(@NotNull String name, @Nullable JSQualifiedName parent) {
        if (name == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(0);
        }
        this.myName = name;
        this.myParent = (JSQualifiedNameImpl)parent;
    }

    @NotNull
    public static JSQualifiedNameImpl create(@NotNull String name, @Nullable JSQualifiedName parent) {
        if (name == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(1);
        }
        StringBuilder builder2 = new StringBuilder(30);
        if (parent != null) {
            ((JSQualifiedNameImpl)parent).getQualifiedName(builder2);
            builder2.append(".");
        }
        JSStringUtil.appendWrappedQualifiedNameComponent(builder2, name);
        String fqn = builder2.toString();
        JSQualifiedNameImpl newName = new JSQualifiedNameImpl(name, parent);
        NAMESPACES.put(fqn, newName);
        JSQualifiedNameImpl jSQualifiedNameImpl = newName;
        if (jSQualifiedNameImpl == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(2);
        }
        return jSQualifiedNameImpl;
    }

    @Nullable
    public static JSQualifiedNameImpl fromComponents(@NotNull List<String> components) {
        if (components == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(3);
        }
        JSQualifiedNameImpl result2 = null;
        for (String component : components) {
            result2 = JSQualifiedNameImpl.create(component, result2);
        }
        return result2;
    }

    @Nullable
    public static JSQualifiedNameImpl fromComponents(String ... components) {
        JSQualifiedNameImpl result2 = null;
        for (String component : components) {
            result2 = JSQualifiedNameImpl.create(component, result2);
        }
        return result2;
    }

    @NotNull
    public static JSQualifiedNameImpl fromQualifiedName(@NotNull String qualifiedName) {
        JSQualifiedNameImpl cached;
        if (qualifiedName == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(4);
        }
        if ((cached = (JSQualifiedNameImpl)NAMESPACES.get(qualifiedName)) != null) {
            JSQualifiedNameImpl jSQualifiedNameImpl = cached;
            if (jSQualifiedNameImpl == null) {
                JSQualifiedNameImpl.$$$reportNull$$$0(5);
            }
            return jSQualifiedNameImpl;
        }
        return JSQualifiedNameImpl.splitHonorQuotes(qualifiedName, ".");
    }

    @NotNull
    private static JSQualifiedNameImpl splitHonorQuotes(@NotNull String qualifiedName, @NotNull String separators) {
        if (qualifiedName == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(6);
        }
        if (separators == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(7);
        }
        ArrayList<String> split = new ArrayList<String>();
        StringBuilder builder2 = new StringBuilder(qualifiedName.length());
        boolean inQuotes = false;
        for (int i = 0; i < qualifiedName.length(); ++i) {
            char c2 = qualifiedName.charAt(i);
            if (StringUtil.containsChar((String)separators, (char)c2) && !inQuotes) {
                if (builder2.isEmpty()) continue;
                split.add(builder2.toString());
                builder2.setLength(0);
                continue;
            }
            if (!(c2 != '\"' && c2 != '\'' || i > 0 && qualifiedName.charAt(i - 1) == '\\')) {
                inQuotes = !inQuotes;
            }
            builder2.append(c2);
        }
        if (!builder2.isEmpty()) {
            split.add(builder2.toString());
        }
        JSQualifiedNameImpl result2 = null;
        for (String component : split) {
            result2 = JSQualifiedNameImpl.create(JSStringUtil.unwrapQualifiedNameComponent(component), result2);
        }
        JSQualifiedNameImpl jSQualifiedNameImpl = result2 == null ? EMPTY : result2;
        if (jSQualifiedNameImpl == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(8);
        }
        return jSQualifiedNameImpl;
    }

    @Contract(value="null, null -> null; !null, _ -> !null; _, !null -> !null")
    @Nullable
    public static JSQualifiedName concat(@Nullable JSQualifiedName qualifier, @Nullable JSQualifiedName tail) {
        if (qualifier == null) {
            return tail;
        }
        if (tail == null) {
            return qualifier;
        }
        SmartList components = new SmartList();
        for (JSQualifiedName parent = tail; parent != null; parent = parent.getParent()) {
            components.add(parent.getName());
        }
        JSQualifiedName result2 = qualifier;
        for (int i = components.size() - 1; i >= 0; --i) {
            result2 = JSQualifiedNameImpl.create((String)components.get(i), result2);
        }
        return result2;
    }

    @NotNull
    public static JSQualifiedNameImpl fromNamepath(@NotNull String namepath) {
        if (namepath == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(9);
        }
        if (StringUtil.indexOfAny((String)namepath, (String)"#~") == -1) {
            return JSQualifiedNameImpl.fromQualifiedName(namepath);
        }
        return JSQualifiedNameImpl.splitHonorQuotes(namepath, ".#~");
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        if (this.getParent() == null) {
            String string = JSStringUtil.wrapQualifiedNameComponent(this.myName);
            if (string == null) {
                JSQualifiedNameImpl.$$$reportNull$$$0(11);
            }
            return string;
        }
        StringBuilder name = new StringBuilder(40);
        this.getQualifiedName(name);
        String string = name.toString();
        if (string == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    private void getQualifiedName(StringBuilder name) {
        if (this.myParent != null) {
            this.myParent.getQualifiedName(name);
            name.append(".");
        }
        JSStringUtil.appendWrappedQualifiedNameComponent(name, this.myName);
    }

    @Override
    @Nullable
    public JSQualifiedName getParent() {
        return this.myParent;
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JSQualifiedNameImpl)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.myName.equals(((JSQualifiedNameImpl)obj).myName) && Objects.equals(this.myParent, ((JSQualifiedNameImpl)obj).myParent);
    }

    public int hashCode() {
        int result2 = this.myParent == null ? 0 : this.myParent.hashCode();
        result2 = result2 * 31 + this.myName.hashCode();
        return result2;
    }

    @Nullable
    public static JSQualifiedNameImpl fromQualifiedNamedElement(@NotNull JSElementBase element) {
        String name;
        if (element == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(13);
        }
        if ((name = element.getName()) == null) {
            return null;
        }
        return JSQualifiedNameImpl.create(name, element.getNamespace());
    }

    @Nullable
    public static JSQualifiedName buildProvidedNamespace(@NotNull JSElementBase element) {
        JSNamespace namespace;
        if (element == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(14);
        }
        return (namespace = JSNamedTypeFactory.buildProvidedNamespace(element, true, null)) != null && !namespace.isLocal() ? namespace.getQualifiedName() : null;
    }

    public static void serialize(@Nullable JSQualifiedName qualifiedName, StubOutputStream dataStream) throws IOException {
        if (qualifiedName == null) {
            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)0);
            return;
        }
        List<String> components = qualifiedName.toComponents();
        DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)components.size());
        for (String component : components) {
            dataStream.writeName(component);
        }
    }

    @Nullable
    public static JSQualifiedNameImpl deserialize(StubInputStream dataStream) throws IOException {
        int componentsCount = DataInputOutputUtil.readINT((DataInput)dataStream);
        assert (componentsCount >= 0) : componentsCount;
        JSQualifiedNameImpl result2 = null;
        while (componentsCount-- > 0) {
            String ref = dataStream.readNameString();
            assert (ref != null) : result2;
            result2 = JSQualifiedNameImpl.create(ref, result2);
        }
        return result2;
    }

    public static void serialize(@Nullable JSQualifiedName qualifiedName, DataOutput dataStream) throws IOException {
        if (qualifiedName == null) {
            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)0);
            return;
        }
        List<String> components = qualifiedName.toComponents();
        DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)components.size());
        for (String component : components) {
            IOUtil.writeUTF((DataOutput)dataStream, (String)component);
        }
    }

    @Nullable
    public static JSQualifiedNameImpl deserialize(DataInput dataStream) throws IOException {
        int componentsCount = DataInputOutputUtil.readINT((DataInput)dataStream);
        assert (componentsCount >= 0) : componentsCount;
        JSQualifiedNameImpl result2 = null;
        while (componentsCount-- > 0) {
            String name = IOUtil.readUTF((DataInput)dataStream);
            result2 = JSQualifiedNameImpl.create(name, result2);
        }
        return result2;
    }

    @Nullable
    public JSQualifiedNameImpl withoutInnermostComponent(@Nullable String innermostNameToRemove) {
        SmartList components = new SmartList();
        JSQualifiedName element = this;
        for (JSQualifiedName parent = element.getParent(); parent != null; parent = parent.getParent()) {
            components.add(element.getName());
            element = parent;
        }
        if (innermostNameToRemove != null && !innermostNameToRemove.equals(element.getName())) {
            return this;
        }
        JSQualifiedNameImpl result2 = null;
        for (int i = components.size() - 1; i >= 0; --i) {
            result2 = JSQualifiedNameImpl.create((String)components.get(i), result2);
        }
        return result2;
    }

    @Override
    @NotNull
    public List<String> toComponents() {
        return JSQualifiedNameImpl.toComponents(this);
    }

    public boolean matches(String ... components) {
        JSQualifiedName current = this;
        for (int i = components.length - 1; i >= 0; --i) {
            if (current == null || !components[i].equals(current.getName())) {
                return false;
            }
            current = current.getParent();
        }
        return true;
    }

    @NotNull
    static List<String> toComponents(JSQualifiedName qName) {
        ArrayList<String> components = new ArrayList<String>();
        for (JSQualifiedName current = qName; current != null; current = current.getParent()) {
            components.add(0, current.getName());
        }
        ArrayList<String> arrayList = components;
        if (arrayList == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public static String getTopmostParent(@NotNull JSQualifiedName qualifiedName) {
        if (qualifiedName == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(16);
        }
        JSQualifiedName parent = qualifiedName;
        while ((parent = (qualifiedName = parent).getParent()) != null) {
        }
        String string = qualifiedName.getName();
        if (string == null) {
            JSQualifiedNameImpl.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static String toString(@Nullable JSQualifiedName name) {
        return name != null ? name.getQualifiedName() : null;
    }

    @TestOnly
    public static void clearNamespaces() {
        NAMESPACES.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 8, 10, 11, 12, 15, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/JSQualifiedNameImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 4: 
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separators";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namepath";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/JSQualifiedNameImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fromQualifiedName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "splitHonorQuotes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "toComponents";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopmostParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromComponents";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromQualifiedName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "splitHonorQuotes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fromNamepath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fromQualifiedNamedElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildProvidedNamespace";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostParent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 8, 10, 11, 12, 15, 17 -> new IllegalStateException(string);
        };
    }
}

