/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports.providers;

import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.imports.JSImportAction;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportCandidatesBase;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.modules.imports.providers.ES6ExistedImportCandidate;
import com.intellij.lang.javascript.modules.imports.providers.ES6ExportedCandidatesProvider;
import com.intellij.lang.javascript.modules.imports.providers.JSCandidatesProcessor;
import com.intellij.lang.javascript.modules.imports.providers.JSImportCandidatesProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.stubs.ES6ImportDeclarationPartIndex;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ExistingImportsCandidatesProvider
extends JSImportCandidatesBase {
    @NotNull
    private final List<VirtualFile> myGlobalTypesDirectories;
    @NotNull
    private final GlobalSearchScope myProjectImportsScope;

    public ES6ExistingImportsCandidatesProvider(@NotNull JSImportPlaceInfo placeInfo) {
        if (placeInfo == null) {
            ES6ExistingImportsCandidatesProvider.$$$reportNull$$$0(0);
        }
        super(placeInfo);
        this.myGlobalTypesDirectories = JSImportAction.getGlobalDirectories();
        this.myProjectImportsScope = ES6ExistingImportsCandidatesProvider.createProjectImportsScope(placeInfo, ES6ExistingImportsCandidatesProvider.getStructureModuleRoot(placeInfo));
    }

    @Override
    public void processCandidates(@NotNull String name, @NotNull JSCandidatesProcessor processor) {
        if (name == null) {
            ES6ExistingImportsCandidatesProvider.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            ES6ExistingImportsCandidatesProvider.$$$reportNull$$$0(2);
        }
        List<JSImportCandidate> existingImports = this.getProjectImports(name);
        existingImports.forEach(processor::processCandidate);
    }

    @Override
    public void collectNames(@NotNull Consumer<String> consumer) {
        if (consumer == null) {
            ES6ExistingImportsCandidatesProvider.$$$reportNull$$$0(3);
        }
        StubIndex.getInstance().processAllKeys(ES6ImportDeclarationPartIndex.KEY, key2 -> {
            consumer.accept((String)key2);
            return true;
        }, this.myProjectImportsScope);
    }

    @NotNull
    private List<JSImportCandidate> getProjectImports(@NotNull String referenceName) {
        PsiElement node;
        Collection elements;
        if (referenceName == null) {
            ES6ExistingImportsCandidatesProvider.$$$reportNull$$$0(4);
        }
        if ((elements = StubIndex.getElements(ES6ImportDeclarationPartIndex.KEY, (Object)referenceName, (Project)(node = this.myPlaceInfo.getPlace()).getProject(), (GlobalSearchScope)this.myProjectImportsScope, ES6ImportExportDeclarationPart.class)).size() == 0) {
            List<JSImportCandidate> list2 = Collections.emptyList();
            if (list2 == null) {
                ES6ExistingImportsCandidatesProvider.$$$reportNull$$$0(5);
            }
            return list2;
        }
        SmartList objects = new SmartList();
        HashSet<Pair<JSImportExportType, String>> visited = new HashSet<Pair<JSImportExportType, String>>();
        boolean acceptsSpecifiersOnly = this.myPlaceInfo.getImportContext() == JSImportPlaceInfo.ImportContext.SPECIFIER;
        boolean acceptsDefaultOnly = this.myPlaceInfo.getImportContext() == JSImportPlaceInfo.ImportContext.BINDING;
        for (ES6ImportExportDeclarationPart part : elements) {
            ES6ImportPsiUtil.ImportExportType type2;
            String text2;
            ES6ImportExportDeclaration declaration = part.getDeclaration();
            boolean isDefault = part instanceof ES6ImportedBinding;
            if ((!isDefault ? acceptsDefaultOnly : acceptsSpecifiersOnly) || (text2 = this.getModuleNameFromDeclaration(declaration, type2 = isDefault ? ES6ImportPsiUtil.ImportExportType.DEFAULT : ES6ImportPsiUtil.ImportExportType.SPECIFIER, visited)) == null) continue;
            ContainerUtil.addIfNotNull((Collection)objects, (Object)this.createImportCandidateForPart(referenceName, part, type2, text2));
        }
        SmartList smartList = objects;
        if (smartList == null) {
            ES6ExistingImportsCandidatesProvider.$$$reportNull$$$0(6);
        }
        return smartList;
    }

    @Contract(value="null,_,_->null")
    private String getModuleNameFromDeclaration(@Nullable ES6ImportExportDeclaration declaration, @NotNull JSImportExportType type2, @NotNull Set<Pair<JSImportExportType, String>> visited) {
        ES6FromClause clause;
        if (type2 == null) {
            ES6ExistingImportsCandidatesProvider.$$$reportNull$$$0(7);
        }
        if (visited == null) {
            ES6ExistingImportsCandidatesProvider.$$$reportNull$$$0(8);
        }
        ES6FromClause eS6FromClause = clause = declaration != null ? declaration.getFromClause() : null;
        if (clause == null) {
            return null;
        }
        String text2 = clause.getReferenceText();
        if (text2 == null) {
            return null;
        }
        String unquoted = StringUtil.unquoteString((String)text2);
        if (!visited.add((Pair<JSImportExportType, String>)Pair.create((Object)type2, (Object)unquoted)) || JSFileReferencesUtil.isRelative(unquoted)) {
            return null;
        }
        Collection<PsiElement> resolvedElements = clause.resolveReferencedElements();
        if (resolvedElements.size() == 0) {
            return null;
        }
        PsiElement item = (PsiElement)ContainerUtil.getFirstItem(resolvedElements);
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)item);
        if (file == null) {
            return null;
        }
        return JSImportAction.isAcceptableForExistingImports(file, this.myGlobalTypesDirectories) ? text2 : null;
    }

    @Nullable
    private JSImportCandidate createImportCandidateForPart(@NotNull String referenceName, @NotNull ES6ImportExportDeclarationPart element, @NotNull JSImportExportType type2, @NotNull String text2) {
        if (referenceName == null) {
            ES6ExistingImportsCandidatesProvider.$$$reportNull$$$0(9);
        }
        if (element == null) {
            ES6ExistingImportsCandidatesProvider.$$$reportNull$$$0(10);
        }
        if (type2 == null) {
            ES6ExistingImportsCandidatesProvider.$$$reportNull$$$0(11);
        }
        if (text2 == null) {
            ES6ExistingImportsCandidatesProvider.$$$reportNull$$$0(12);
        }
        PsiElement node = this.myPlaceInfo.getPlace();
        JSElement jsElement = ES6ExportedCandidatesProvider.expandElementAndFilter((PsiElement)element, this.myPlaceInfo);
        return jsElement != null ? new ES6ExistedImportCandidate(referenceName, jsElement, node, type2, StringUtil.unquoteString((String)text2)) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/imports/providers/ES6ExistingImportsCandidatesProvider";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/imports/providers/ES6ExistingImportsCandidatesProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectImports";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processCandidates";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectNames";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getProjectImports";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getModuleNameFromDeclaration";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createImportCandidateForPart";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }

    public static class MyFactory
    implements JSImportCandidatesProvider.CandidatesFactory {
        @Override
        @Nullable
        public JSImportCandidatesProvider createProvider(@NotNull JSImportPlaceInfo placeInfo) {
            if (placeInfo == null) {
                MyFactory.$$$reportNull$$$0(0);
            }
            return new ES6ExistingImportsCandidatesProvider(placeInfo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeInfo", "com/intellij/lang/javascript/modules/imports/providers/ES6ExistingImportsCandidatesProvider$MyFactory", "createProvider"));
        }
    }
}

