/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports.filter;

import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.filter.ExcludedElementsFilter;
import com.intellij.lang.javascript.modules.imports.filter.JSImportCandidatesFilter;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\tB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/lang/javascript/modules/imports/filter/ExcludedElementsFilter;", "Lcom/intellij/lang/javascript/modules/imports/filter/JSImportCandidatesFilter;", "acceptedCandidates", "", "Lcom/intellij/lang/javascript/modules/imports/JSImportCandidate;", "(Ljava/util/Set;)V", "accept", "", "candidate", "Factory", "intellij.javascript.impl"})
public final class ExcludedElementsFilter
implements JSImportCandidatesFilter {
    @NotNull
    private final Set<JSImportCandidate> acceptedCandidates;

    public ExcludedElementsFilter(@NotNull Set<? extends JSImportCandidate> acceptedCandidates2) {
        Intrinsics.checkNotNullParameter(acceptedCandidates2, (String)"acceptedCandidates");
        this.acceptedCandidates = acceptedCandidates2;
    }

    @Override
    public boolean accept(@NotNull JSImportCandidate candidate) {
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        return this.acceptedCandidates.contains(candidate);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/javascript/modules/imports/filter/ExcludedElementsFilter$Factory;", "Lcom/intellij/lang/javascript/modules/imports/filter/JSImportCandidatesFilter$FilterFactory;", "()V", "createFilter", "Lcom/intellij/lang/javascript/modules/imports/filter/JSImportCandidatesFilter;", "candidates", "", "Lcom/intellij/lang/javascript/modules/imports/JSImportCandidate;", "intellij.javascript.impl"})
    public static final class Factory
    implements JSImportCandidatesFilter.FilterFactory {
        @Override
        @Nullable
        public JSImportCandidatesFilter createFilter(@NotNull List<? extends JSImportCandidate> candidates) {
            Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
            if (candidates.size() <= 1) {
                return null;
            }
            Set acceptedCandidates2 = SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)candidates), (Function1)createFilter.acceptedCandidates.1.INSTANCE));
            if (acceptedCandidates2.isEmpty()) {
                return null;
            }
            return new ExcludedElementsFilter(acceptedCandidates2);
        }
    }
}

