/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.service;

import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.linter.JSNpmLinterState;
import com.intellij.lang.javascript.linter.ServiceInactivityTracker;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.service.ESLintBasedLanguageService;
import com.intellij.lang.javascript.linter.eslint.service.EslintLanguageServiceManager;
import com.intellij.lang.javascript.linter.eslint.service.protocol.ESLintLanguageServiceInitialState;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0014J/\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u0016\"\b\b\u0001\u0010\u0017*\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\u00170\u001a\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/lang/javascript/linter/eslint/service/ESLintLanguageService;", "Lcom/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService;", "Lcom/intellij/lang/javascript/linter/eslint/EslintState;", "project", "Lcom/intellij/openapi/project/Project;", "nodePackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "workingDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/javascript/nodejs/util/NodePackage;Lcom/intellij/openapi/vfs/VirtualFile;)V", "inactivityTracker", "Lcom/intellij/lang/javascript/linter/ServiceInactivityTracker;", "dispose", "", "fillInitialProtocolState", "protocolState", "Lcom/intellij/lang/javascript/linter/eslint/service/protocol/ESLintLanguageServiceInitialState;", "storedState", "getConfigurationClass", "Ljava/lang/Class;", "Lcom/intellij/lang/javascript/linter/eslint/EslintConfiguration;", "useService", "T", "E", "", "computable", "Lcom/intellij/openapi/util/ThrowableComputable;", "(Lcom/intellij/openapi/util/ThrowableComputable;)Ljava/lang/Object;", "intellij.javascript.impl"})
public final class ESLintLanguageService
extends ESLintBasedLanguageService<EslintState> {
    @NotNull
    private final ServiceInactivityTracker inactivityTracker;

    public ESLintLanguageService(final @NotNull Project project, @NotNull NodePackage nodePackage, @NotNull VirtualFile workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)nodePackage, (String)"nodePackage");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        super(project, nodePackage, workingDirectory);
        EslintLanguageServiceManager eslintLanguageServiceManager = EslintLanguageServiceManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)eslintLanguageServiceManager, (String)"getInstance(...)");
        EslintLanguageServiceManager manager = eslintLanguageServiceManager;
        CoroutineScope coroutineScope = manager.getCoroutineScope();
        Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
        this.inactivityTracker = ServiceInactivityTracker.Companion.startTracking(coroutineScope, manager.getInactivityTimeoutMs(), (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                EslintLanguageServiceManager.getInstance(project).terminateInactiveService((JSLanguageServiceBase)this);
            }
        }));
    }

    @Override
    @NotNull
    protected Class<EslintConfiguration> getConfigurationClass() {
        return EslintConfiguration.class;
    }

    @Override
    protected void fillInitialProtocolState(@NotNull ESLintLanguageServiceInitialState protocolState, @NotNull EslintState storedState) {
        Intrinsics.checkNotNullParameter((Object)protocolState, (String)"protocolState");
        Intrinsics.checkNotNullParameter((Object)storedState, (String)"storedState");
        super.fillInitialProtocolState(protocolState, (JSNpmLinterState)storedState);
        protocolState.additionalRootDirectory = LocalFilePath.create(storedState.getAdditionalRulesDirPath());
        protocolState.includeSourceText = Registry.is((String)"eslint.language.service.full.log", (boolean)false);
    }

    public final <T, E extends Throwable> T useService(@NotNull ThrowableComputable<T, E> computable) {
        Intrinsics.checkNotNullParameter(computable, (String)"computable");
        return (T)this.inactivityTracker.useService((Function0)new Function0<T>(computable){
            final /* synthetic */ ThrowableComputable<T, E> $computable;
            {
                this.$computable = $computable;
                super(0);
            }

            public final T invoke() {
                return (T)this.$computable.compute();
            }
        });
    }

    @Override
    public void dispose() {
        this.inactivityTracker.stopTracking();
        super.dispose();
    }
}

