/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.history.LocalHistory;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class JSLinterReformatterTask {
    @NotNull
    protected final Project myProject;
    @NotNull
    private final String myLinterName;
    @NotNull
    private final Collection<? extends VirtualFile> myRoots;
    @NotNull
    private final Runnable myCompleteCallback;
    private final MultiMap<VirtualFile, Pair<@InspectionMessage String, IntentionAction[]>> myProblems;

    public JSLinterReformatterTask(@NotNull Project project, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String linterName, @NotNull Collection<? extends VirtualFile> roots, @NotNull Runnable completeCallback) {
        if (project == null) {
            JSLinterReformatterTask.$$$reportNull$$$0(0);
        }
        if (linterName == null) {
            JSLinterReformatterTask.$$$reportNull$$$0(1);
        }
        if (roots == null) {
            JSLinterReformatterTask.$$$reportNull$$$0(2);
        }
        if (completeCallback == null) {
            JSLinterReformatterTask.$$$reportNull$$$0(3);
        }
        this.myProblems = new MultiMap();
        this.myProject = project;
        this.myLinterName = linterName;
        this.myRoots = roots;
        this.myCompleteCallback = completeCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            JSLinterReformatterTask.$$$reportNull$$$0(4);
        }
        LocalHistory localHistory = LocalHistory.getInstance();
        localHistory.putSystemLabel(this.myProject, JavaScriptBundle.message("javascript.linter.action.fix.problems.name.start", this.myLinterName));
        try {
            for (VirtualFile virtualFile : this.myRoots) {
                if (virtualFile.isDirectory()) continue;
                String parentPath = virtualFile.getParent() == null ? "" : " (" + virtualFile.getParent().getPath() + ")";
                indicator.setText(JavaScriptBundle.message("progress.text.processing", virtualFile.getName(), parentPath));
                this.formatFile(virtualFile);
            }
        }
        catch (Throwable throwable) {
            String message = JavaScriptBundle.message("javascript.linter.action.fix.problems.name.finish", this.myLinterName);
            localHistory.putSystemLabel(this.myProject, message);
            this.myCompleteCallback.run();
            throw throwable;
        }
        String message = JavaScriptBundle.message("javascript.linter.action.fix.problems.name.finish", this.myLinterName);
        localHistory.putSystemLabel(this.myProject, message);
        this.myCompleteCallback.run();
    }

    protected void doOnSuccess() {
        if (!this.myProblems.isEmpty()) {
            new MyNotification(this.myProject, this.myLinterName, this.myProblems).showNotification();
        }
    }

    private void formatFile(VirtualFile file) {
        PsiFile psiFile2 = (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.myProject).findFile(file));
        if (psiFile2 == null) {
            this.error(file, JavaScriptBundle.message("javascript.linter.error.can.not.find.psi.file", file.getPath()), new IntentionAction[0]);
            return;
        }
        Document document2 = (Document)ReadAction.compute(() -> PsiDocumentManager.getInstance((Project)this.myProject).getDocument(psiFile2));
        if (document2 == null) {
            this.error(file, JavaScriptBundle.message("javascript.linter.error.can.not.find.document", psiFile2.getName()), new IntentionAction[0]);
            return;
        }
        this.runLinter(psiFile2, document2);
    }

    protected void error(@NotNull VirtualFile file, @InspectionMessage String error, IntentionAction ... fixes) {
        if (file == null) {
            JSLinterReformatterTask.$$$reportNull$$$0(5);
        }
        this.myProblems.putValue((Object)file, (Object)Pair.create((Object)error, (Object)fixes));
    }

    protected abstract void runLinter(@NotNull PsiFile var1, @NotNull Document var2);

    public Task createTask(boolean modalProgress) {
        if (modalProgress) {
            return new Task.Modal(this.myProject, JavaScriptBundle.message("javascript.linter.progress.reformatting.with", this.myLinterName), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    JSLinterReformatterTask.this.doRun(indicator);
                }

                public void onSuccess() {
                    JSLinterReformatterTask.this.doOnSuccess();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/javascript/linter/eslint/JSLinterReformatterTask$1", "run"));
                }
            };
        }
        return new Task.Backgroundable(this.myProject, JavaScriptBundle.message("javascript.linter.progress.reformatting.with", this.myLinterName), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                JSLinterReformatterTask.this.doRun(indicator);
            }

            public void onSuccess() {
                JSLinterReformatterTask.this.doOnSuccess();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/javascript/linter/eslint/JSLinterReformatterTask$2", "run"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linterName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completeCallback";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/JSLinterReformatterTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doRun";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyNotification {
        private final List<IntentionAction> intentions;
        private final List<VirtualFile> files;
        @NotNull
        private final Project myProject;
        @NotNull
        private final String myLinterName;
        private String myMessage;

        MyNotification(@NotNull Project project, @NotNull String linterName, @NotNull MultiMap<VirtualFile, Pair<String, IntentionAction[]>> problems) {
            if (project == null) {
                MyNotification.$$$reportNull$$$0(0);
            }
            if (linterName == null) {
                MyNotification.$$$reportNull$$$0(1);
            }
            if (problems == null) {
                MyNotification.$$$reportNull$$$0(2);
            }
            this.intentions = new ArrayList<IntentionAction>();
            this.files = new ArrayList<VirtualFile>();
            this.myProject = project;
            this.myLinterName = linterName;
            if (problems.isEmpty()) {
                return;
            }
            this.myMessage = this.fillData(problems);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private String fillData(MultiMap<VirtualFile, Pair<@InspectionMessage String, IntentionAction[]>> problems) {
            @InspectionMessage Function function2 = entry -> {
                @InspectionMessage String path2 = ((VirtualFile)entry.getKey()).getPath();
                HtmlBuilder builder2 = new HtmlBuilder().appendLink("#file" + path2, ((VirtualFile)entry.getKey()).getName()).append(": ");
                boolean withComma = false;
                for (Pair pair : (Collection)entry.getValue()) {
                    if (withComma) {
                        builder2.br();
                    }
                    withComma = true;
                    if (((IntentionAction[])pair.getSecond()).length > 0) {
                        builder2.append((String)pair.getFirst()).append(" ").appendWithSeparators(HtmlChunk.text((String)", "), (Iterable)ContainerUtil.map((Object[])((IntentionAction[])pair.getSecond()), action -> {
                            this.intentions.add((IntentionAction)action);
                            this.files.add((VirtualFile)entry.getKey());
                            return HtmlChunk.link((String)("#action" + (this.intentions.size() - 1)), (String)action.getText());
                        }));
                        continue;
                    }
                    builder2.append((String)pair.getFirst());
                }
                return builder2.toString();
            };
            return StringUtil.join((Collection)problems.entrySet(), (Function)function2, (String)"<br/>");
        }

        public void showNotification() {
            if (this.myMessage == null || this.myMessage.isEmpty()) {
                return;
            }
            JSLinterUtil.NOTIFICATION_GROUP.createNotification(JavaScriptBundle.message("javascript.linter.error.notification.problem.with.reformatting", this.myLinterName, this.myMessage), NotificationType.ERROR).setListener((NotificationListener)new MyNotificationListener()).notify(this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "linterName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "problems";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/linter/eslint/JSLinterReformatterTask$MyNotification";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class MyNotificationListener
        implements NotificationListener {
            private MyNotificationListener() {
            }

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                String description;
                if (notification == null) {
                    MyNotificationListener.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    MyNotificationListener.$$$reportNull$$$0(1);
                }
                if ((description = event.getDescription()) != null && description.startsWith("#file")) {
                    String path2 = description.substring(5);
                    OpenFileAction.openFile((String)path2, (Project)MyNotification.this.myProject);
                } else if (description != null && description.startsWith("#action")) {
                    String number = description.substring(6);
                    try {
                        int idx = Integer.parseInt(number);
                        if (idx >= 0 && idx < MyNotification.this.intentions.size()) {
                            VirtualFile file = MyNotification.this.files.get(idx);
                            PsiFile psiFile2 = null;
                            Editor editor = null;
                            if (file != null && (psiFile2 = PsiManager.getInstance((Project)MyNotification.this.myProject).findFile(file)) != null) {
                                editor = PsiEditorUtil.findEditor((PsiElement)psiFile2);
                            }
                            MyNotification.this.intentions.get(idx).invoke(MyNotification.this.myProject, editor, psiFile2);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/linter/eslint/JSLinterReformatterTask$MyNotification$MyNotificationListener";
                objectArray[2] = "hyperlinkUpdate";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

