/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterAnnotationsBuilder;
import com.intellij.lang.javascript.linter.JSLinterEditSettingsAction;
import com.intellij.lang.javascript.linter.JSLinterErrorBase;
import com.intellij.lang.javascript.linter.JSLinterExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterStandardFixes;
import com.intellij.lang.javascript.linter.JSLinterWithInspectionExternalAnnotator;
import com.intellij.lang.javascript.linter.eslint.ESLintSuppressionUtil;
import com.intellij.lang.javascript.linter.eslint.EsLintExternalRunner;
import com.intellij.lang.javascript.linter.eslint.EsLintFixAction;
import com.intellij.lang.javascript.linter.eslint.EslintConfigurable;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintError;
import com.intellij.lang.javascript.linter.eslint.EslintFixSingleErrorAction;
import com.intellij.lang.javascript.linter.eslint.EslintInspection;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.eslint.service.EslintLanguageServiceManager;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import icons.JavaScriptLanguageIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintExternalAnnotator
extends JSLinterExternalAnnotator<EslintState> {
    private static final EslintExternalAnnotator INSTANCE_FOR_BATCH_INSPECTION = new EslintExternalAnnotator(false);

    @NotNull
    public static EslintExternalAnnotator getInstanceForBatchInspection() {
        EslintExternalAnnotator eslintExternalAnnotator = INSTANCE_FOR_BATCH_INSPECTION;
        if (eslintExternalAnnotator == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(0);
        }
        return eslintExternalAnnotator;
    }

    public EslintExternalAnnotator() {
        this(true);
    }

    public EslintExternalAnnotator(boolean onTheFly) {
        super(onTheFly);
    }

    @Override
    @NotNull
    protected String getSettingsConfigurableID() {
        return "settings.javascript.linters.eslint";
    }

    @Override
    protected Class<EslintConfiguration> getConfigurationClass() {
        return EslintConfiguration.class;
    }

    @Override
    protected Class<EslintInspection> getInspectionClass() {
        return EslintInspection.class;
    }

    @Override
    protected boolean acceptPsiFile(@NotNull PsiFile file) {
        if (file == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(1);
        }
        return EslintUtil.isPossiblyAcceptableFileType(file);
    }

    @Override
    @Nullable
    public JSLinterAnnotationResult annotate(@NotNull JSLinterInput<EslintState> input) {
        if (input == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(2);
        }
        EslintState state = input.getState();
        EslintLanguageServiceManager languageServiceManager = EslintLanguageServiceManager.getInstance(input.getProject());
        return languageServiceManager.useService(input.getVirtualFile(), state.getNodePackageRef(), service2 -> {
            if (service2 == null) {
                return JSLinterAnnotationResult.empty();
            }
            return (JSLinterAnnotationResult)service2.useService(() -> EsLintExternalRunner.highlight(input, service2, this.isOnTheFly()));
        });
    }

    @Override
    public void apply(@NotNull PsiFile file, @Nullable JSLinterAnnotationResult annotationResult, @NotNull AnnotationHolder holder) {
        if (file == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(4);
        }
        if (annotationResult == null) {
            return;
        }
        IntentionAction fixFileAction = new EsLintFixAction().asIntentionAction();
        String toolName = JavaScriptBundle.message("settings.javascript.linters.eslint.configurable.name", new Object[0]);
        Icon icon = JavaScriptLanguageIcons.FileTypes.Eslint;
        EslintExternalAnnotator.apply(file, annotationResult, holder, fixFileAction, toolName, icon, false, null, this.getInspectionClass());
    }

    public static void apply(@NotNull PsiFile file, @NotNull JSLinterAnnotationResult annotationResult, @NotNull AnnotationHolder holder, @NotNull IntentionAction fixFileAction, @NotNull @Nls String toolName, @Nullable Icon icon, boolean editConfig, @Nullable @Nls String editSettingCaption, Class<? extends JSLinterInspection> inspectionClass) {
        Document document2;
        if (file == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(5);
        }
        if (annotationResult == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(7);
        }
        if (fixFileAction == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(8);
        }
        if (toolName == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(9);
        }
        long documentModificationStamp = (document2 = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file)) != null ? document2.getModificationStamp() : -1L;
        EslintConfigurable configurable = new EslintConfigurable(file.getProject(), true);
        JSLinterEditSettingsAction editSettingsAction = new JSLinterEditSettingsAction(configurable, (String)ObjectUtils.coalesce((Object)editSettingCaption, (Object)configurable.getDisplayName()), icon);
        JSLinterStandardFixes fixes = new JSLinterStandardFixes().setEditConfig(editConfig).setEditSettingsAction(editSettingsAction).setShowEditSettings(false).setErrorToIntentionConverter((Convertor<JSLinterErrorBase, List<IntentionAction>>)((Convertor)error -> {
            if (!(error instanceof EslintError)) {
                return ContainerUtil.emptyList();
            }
            EslintError eslintError = (EslintError)error;
            ArrayList<IntentionAction> result2 = new ArrayList<IntentionAction>();
            EslintError.FixInfo fixInfo = eslintError.getFixInfo();
            if (fixInfo != null) {
                if (document2 != null && !holder.isBatchMode()) {
                    result2.add(new EslintFixSingleErrorAction(toolName, file, fixInfo, eslintError.getCode(), documentModificationStamp));
                }
                result2.add(fixFileAction);
            } else if (!eslintError.getSuggestions().isEmpty()) {
                for (EslintError.FixInfo suggestion : eslintError.getSuggestions()) {
                    result2.add(new EslintFixSingleErrorAction(toolName, file, suggestion, eslintError.getCode(), documentModificationStamp));
                }
            } else if (!holder.isBatchMode()) {
                ContainerUtil.addIfNotNull(result2, (Object)ESLintSuppressionUtil.INSTANCE.getSuppressForLineAction(eslintError, documentModificationStamp));
            }
            return result2;
        })).setProblemGroup((Function<? super JSLinterErrorBase, ? extends ProblemGroup>)((Function)error -> {
            if (holder.isBatchMode()) {
                return null;
            }
            if (error instanceof EslintError) {
                SuppressIntentionAction[] intentionActions = ESLintSuppressionUtil.INSTANCE.getSuppressionsForError((EslintError)error, documentModificationStamp);
                return new JSAnnotatorProblemGroup(intentionActions, null);
            }
            return null;
        }));
        new JSLinterAnnotationsBuilder(file, annotationResult, holder, configurable, toolName + ": ", inspectionClass, fixes).setHighlightingGranularity(JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.element).setDefaultFileLevelErrorIcon(icon).apply();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationResult";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixFileAction";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceForBatchInspection";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "acceptPsiFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

