/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterRelatedIntention;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLinterFixAction
extends AnAction {
    @NotNull
    private final Supplier<String> myLinterName;

    public JSLinterFixAction(@NotNull Supplier<String> linterName, @NotNull Supplier<String> description, @Nullable Icon icon) {
        if (linterName == null) {
            JSLinterFixAction.$$$reportNull$$$0(0);
        }
        if (description == null) {
            JSLinterFixAction.$$$reportNull$$$0(1);
        }
        super(JavaScriptBundle.messagePointer("javascript.linter.action.fix.problems.name", linterName.get()), description, icon);
        this.myLinterName = linterName;
    }

    @NotNull
    protected abstract JSLinterConfiguration getConfiguration(@NotNull Project var1);

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            JSLinterFixAction.$$$reportNull$$$0(2);
        }
        boolean enabled = new Helper(e.getDataContext()).enabled();
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            JSLinterFixAction.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            JSLinterFixAction.$$$reportNull$$$0(4);
        }
        Helper helper = new Helper(e.getDataContext());
        this.actionPerformedImpl(helper, true, false);
    }

    public void processFiles(@NotNull Project project, VirtualFile @NotNull [] files2, boolean allowInteractivity, boolean modalProgress) {
        if (project == null) {
            JSLinterFixAction.$$$reportNull$$$0(5);
        }
        if (files2 == null) {
            JSLinterFixAction.$$$reportNull$$$0(6);
        }
        this.actionPerformedImpl(new Helper(project, files2), allowInteractivity, modalProgress);
    }

    public boolean isEnabled(@NotNull Project project, VirtualFile @NotNull [] files2) {
        if (project == null) {
            JSLinterFixAction.$$$reportNull$$$0(7);
        }
        if (files2 == null) {
            JSLinterFixAction.$$$reportNull$$$0(8);
        }
        return new Helper(project, files2).enabled();
    }

    private void actionPerformedImpl(@NotNull Helper helper, boolean allowInteractivity, boolean modalProgress) {
        int result2;
        if (helper == null) {
            JSLinterFixAction.$$$reportNull$$$0(9);
        }
        if (!helper.enabled()) {
            return;
        }
        VirtualFile[] selected = helper.getFiles();
        if (allowInteractivity && (selected.length > 1 || selected.length == 1 && selected[0].isDirectory()) && (result2 = Messages.showOkCancelDialog((Project)helper.getProject(), (String)JavaScriptBundle.message("javascript.linter.action.fix.prompt", this.myLinterName.get()), (String)this.getTemplatePresentation().getText(), (Icon)Messages.getQuestionIcon())) != 0) {
            return;
        }
        Collection<VirtualFile> filesToProcess = helper.getFilesFromScope();
        ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance((Project)helper.getProject()).ensureFilesWritable(filesToProcess);
        if (operationStatus.hasReadonlyFiles()) {
            return;
        }
        this.saveDocumentsIfNeeded();
        Runnable completeCallback = this.needRefreshFilesAfter() ? this.getRefreshFilesCallback(filesToProcess) : EmptyRunnable.getInstance();
        Task task = this.createTask(helper.getProject(), filesToProcess, completeCallback, modalProgress);
        ProgressManager.getInstance().run(task);
    }

    public void saveDocumentsIfNeeded() {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        for (Document document2 : fileDocumentManager.getUnsavedDocuments()) {
            if (!this.shouldSaveBeforeToolInvocation(fileDocumentManager.getFile(document2))) continue;
            fileDocumentManager.saveDocument(document2);
        }
    }

    protected boolean shouldSaveBeforeToolInvocation(@Nullable VirtualFile file) {
        return true;
    }

    protected Runnable getRefreshFilesCallback(@NotNull Collection<VirtualFile> filesToProcess) {
        if (filesToProcess == null) {
            JSLinterFixAction.$$$reportNull$$$0(10);
        }
        List toForceRefresh = ApplicationManager.getApplication().isUnitTestMode() ? filesToProcess : ContainerUtil.filter(filesToProcess, arg_0 -> ((FileDocumentManager)FileDocumentManager.getInstance()).isFileModified(arg_0));
        Collection toRefreshAsync = ContainerUtil.subtract(filesToProcess, toForceRefresh);
        return () -> {
            RefreshSession session = RefreshQueue.getInstance().createSession(false, false, null, ModalityState.nonModal());
            session.addAllFiles(toRefreshAsync);
            session.launch();
            for (VirtualFile file : toForceRefresh) {
                VfsImplUtil.forceSyncRefresh((VirtualFile)file);
            }
        };
    }

    public IntentionAction asIntentionAction() {
        return new JSLinterFixIntentionAction();
    }

    public boolean isFileAccepted(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            JSLinterFixAction.$$$reportNull$$$0(11);
        }
        if (file == null) {
            JSLinterFixAction.$$$reportNull$$$0(12);
        }
        return FileTypeRegistry.getInstance().isFileOfType(file, (FileType)JavaScriptSupportLoader.JAVASCRIPT);
    }

    protected boolean needRefreshFilesAfter() {
        return true;
    }

    protected abstract Task createTask(@NotNull Project var1, @NotNull Collection<? extends VirtualFile> var2, @NotNull Runnable var3, boolean var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linterName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterFixAction";
                break;
            }
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToProcess";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterFixAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processFiles";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformedImpl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRefreshFilesCallback";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isFileAccepted";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private class Helper {
        private final Project myProject;
        private final VirtualFile[] myFiles;

        Helper(DataContext dataContext) {
            this.myProject = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            this.myFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        }

        Helper(@NotNull Project project, VirtualFile[] files2) {
            if (project == null) {
                Helper.$$$reportNull$$$0(0);
            }
            if (files2 == null) {
                Helper.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myFiles = files2;
        }

        public boolean enabled() {
            if (this.myProject == null) {
                return false;
            }
            if (!JSLinterFixAction.this.getConfiguration(this.myProject).isEnabled()) {
                return false;
            }
            if (this.myFiles == null) {
                return false;
            }
            VirtualFileFilter filter = this.getFilter();
            return ContainerUtil.exists((Object[])this.myFiles, arg_0 -> ((VirtualFileFilter)filter).accept(arg_0));
        }

        @NotNull
        private VirtualFileFilter getFilter() {
            GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)this.myProject);
            VirtualFileFilter virtualFileFilter = file -> projectScope.contains(file) && (file.isDirectory() || JSLinterFixAction.this.isFileAccepted(this.myProject, file));
            if (virtualFileFilter == null) {
                Helper.$$$reportNull$$$0(2);
            }
            return virtualFileFilter;
        }

        public Project getProject() {
            return this.myProject;
        }

        public VirtualFile[] getFiles() {
            return this.myFiles;
        }

        @NotNull
        private Collection<VirtualFile> getFilesFromScope() {
            ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
            for (VirtualFile fileOrDir : this.myFiles) {
                VfsUtilCore.iterateChildrenRecursively((VirtualFile)fileOrDir, (VirtualFileFilter)this.getFilter(), file -> {
                    result2.add(file);
                    return true;
                });
            }
            ArrayList<VirtualFile> arrayList = result2;
            if (arrayList == null) {
                Helper.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterFixAction$Helper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterFixAction$Helper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilesFromScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private class JSLinterFixIntentionAction
    extends BaseIntentionAction
    implements PriorityAction,
    JSLinterRelatedIntention {
        private JSLinterFixIntentionAction() {
        }

        @NotNull
        public PriorityAction.Priority getPriority() {
            PriorityAction.Priority priority = PriorityAction.Priority.NORMAL;
            if (priority == null) {
                JSLinterFixIntentionAction.$$$reportNull$$$0(0);
            }
            return priority;
        }

        @NotNull
        public String getText() {
            String string = JavaScriptBundle.message("javascript.linter.action.fix.problems.file.text", JSLinterFixAction.this.myLinterName.get());
            if (string == null) {
                JSLinterFixIntentionAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = StringUtil.notNullize((String)JSLinterFixAction.this.getTemplatePresentation().getText());
            if (string == null) {
                JSLinterFixIntentionAction.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                JSLinterFixIntentionAction.$$$reportNull$$$0(3);
            }
            return file != null && new Helper(project, new VirtualFile[]{file.getVirtualFile()}).enabled();
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                JSLinterFixIntentionAction.$$$reportNull$$$0(4);
            }
            if (file == null) {
                return;
            }
            JSLinterFixAction.this.processFiles(project, new VirtualFile[]{file.getVirtualFile()}, true, ApplicationManager.getApplication().isHeadlessEnvironment());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterFixAction$JSLinterFixIntentionAction";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPriority";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterFixAction$JSLinterFixIntentionAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

