/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.javascript.nodejs.util.NodePackageRefResolver;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.ui.JSLinterConfigFileView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AutodetectLinterPackage {
    public static final NodePackageRef INSTANCE = NodePackageRef.create(JavaScriptBundle.message("js.linters.detect.automatically.caption", new Object[0]));
    private static final Key<NodePackage> TEST_AUTODETECT_KEY = new Key("TEST_AUTODETECT_KEY");

    private AutodetectLinterPackage() {
    }

    public static void setTestAutodetectedPackage(@NotNull Project project, @NotNull NodePackage nodePackage, @NotNull Disposable disposable) {
        if (project == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(0);
        }
        if (nodePackage == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(2);
        }
        project.putUserData(TEST_AUTODETECT_KEY, (Object)nodePackage);
        Disposer.register((Disposable)disposable, () -> project.putUserData(TEST_AUTODETECT_KEY, null));
    }

    @Nullable
    public static NodePackage resolve(@NotNull NodePackageRef nodePackageRef, @NotNull Project project, @NotNull VirtualFile contextFile, @NotNull String packageName, @Nullable Processor<? super VirtualFile> packageJsonHasLinterSpecificConfiguration) {
        if (nodePackageRef == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(3);
        }
        if (project == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(4);
        }
        if (contextFile == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(5);
        }
        if (packageName == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        NodePackage constantPackage = nodePackageRef.getConstantPackage();
        if (constantPackage != null) {
            return constantPackage;
        }
        if (nodePackageRef != INSTANCE) {
            return null;
        }
        NodePackage testValue = (NodePackage)project.getUserData(TEST_AUTODETECT_KEY);
        if (testValue != null) {
            return testValue;
        }
        Ref result2 = new Ref();
        PackageJsonUtil.processUpPackageJsonFiles(project, contextFile, (Processor<? super VirtualFile>)((Processor)packageJsonFile -> {
            VirtualFile installedPackage = AutodetectLinterPackage.findInstalledPackage(project, packageJsonFile, packageName);
            if (installedPackage != null && packageJsonHasLinterSpecificConfiguration != null && packageJsonHasLinterSpecificConfiguration.process(packageJsonFile)) {
                result2.set((Object)new NodePackage(installedPackage.toNioPath()));
                return false;
            }
            if (installedPackage != null && !AutodetectLinterPackage.hasPackageJsonWithDependencyStrictlyAbove(project, packageJsonFile, packageName)) {
                result2.set((Object)new NodePackage(VfsUtilCore.virtualToIoFile((VirtualFile)installedPackage).getAbsolutePath()));
                return false;
            }
            PackageJsonData data = PackageJsonData.getOrCreate(packageJsonFile);
            if (data.isDependencyOfAnyType(packageName)) {
                if (installedPackage != null) {
                    result2.set((Object)new NodePackage(VfsUtilCore.virtualToIoFile((VirtualFile)installedPackage).getAbsolutePath()));
                } else {
                    result2.set((Object)AutodetectLinterPackage.getDefaultNodeModulesLocation(project, packageJsonFile, packageName));
                }
                return false;
            }
            return true;
        }));
        return (NodePackage)result2.get();
    }

    @NotNull
    private static NodePackage getDefaultNodeModulesLocation(@NotNull Project project, @NotNull VirtualFile packageJson2, @NotNull String dependencyName) {
        YarnPnpNodePackage yarnPnpPkg;
        if (project == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(7);
        }
        if (packageJson2 == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(8);
        }
        if (dependencyName == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(9);
        }
        if ((yarnPnpPkg = YarnPnpNodePackage.create(project, packageJson2, dependencyName, true, false)) != null) {
            YarnPnpNodePackage yarnPnpNodePackage = yarnPnpPkg;
            if (yarnPnpNodePackage == null) {
                AutodetectLinterPackage.$$$reportNull$$$0(10);
            }
            return yarnPnpNodePackage;
        }
        File parentDir = VfsUtilCore.virtualToIoFile((VirtualFile)packageJson2.getParent());
        return new NodePackage(new File(new File(parentDir, "node_modules"), dependencyName).getAbsolutePath());
    }

    private static boolean hasPackageJsonWithDependencyStrictlyAbove(@NotNull Project project, @NotNull VirtualFile startPackageJson, @NotNull String packageName) {
        VirtualFile startDir;
        if (project == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(11);
        }
        if (startPackageJson == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(12);
        }
        if (packageName == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(13);
        }
        if ((startDir = startPackageJson.getParent().getParent()) == null) {
            return false;
        }
        Ref foundPackage = new Ref((Object)Boolean.FALSE);
        PackageJsonUtil.processUpPackageJsonFiles(project, startDir, (Processor<? super VirtualFile>)((Processor)packageJsonFile -> {
            PackageJsonData data;
            PackageJsonData packageJsonData = data = packageJsonFile != null ? PackageJsonData.getOrCreate(packageJsonFile) : null;
            if (data != null && data.isDependencyOfAnyType(packageName)) {
                foundPackage.set((Object)Boolean.TRUE);
                return false;
            }
            return true;
        }));
        return (Boolean)foundPackage.get();
    }

    private static VirtualFile findInstalledPackage(@NotNull Project project, @NotNull VirtualFile packageJson2, String packageName) {
        if (project == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(14);
        }
        if (packageJson2 == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(15);
        }
        Ref result2 = new Ref();
        NodeModuleSearchUtil.processUpNodeModulesDirs(project, packageJson2, (Processor<? super VirtualFile>)((Processor)nodeModulesDir -> {
            VirtualFile packageDir = nodeModulesDir.findFileByRelativePath(packageName);
            if (packageDir != null && packageDir.isDirectory() && packageDir.isValid() && PackageJsonUtil.findChildPackageJsonFile(packageDir) != null) {
                result2.set((Object)packageDir);
                return false;
            }
            return true;
        }));
        return (VirtualFile)result2.get();
    }

    @NotNull
    public static NodePackageField createNodePackageField(@NotNull Project project, @NotNull List<String> packageNames, @NotNull JSLinterConfigFileView configFileView) {
        if (project == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(16);
        }
        if (packageNames == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(17);
        }
        if (configFileView == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(18);
        }
        NodePackageDescriptor packageDescriptor = AutodetectLinterPackage.createPackageDescriptor(packageNames);
        NodePackageField packageField = new NodePackageField(project, packageDescriptor, () -> NodeJsInterpreterManager.getInstance(project).getInterpreter(), AutodetectLinterPackage.createNodePackageRefResolver());
        packageField.addPackageRefSelectionListener(AutodetectLinterPackage.createPackageRefSelectionListener(packageField, configFileView));
        NodePackageField nodePackageField = packageField;
        if (nodePackageField == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(19);
        }
        return nodePackageField;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static NodePackageField createNodePackageField(@NotNull List<String> packageNames, @NotNull NodeJsInterpreterField nodeInterpreterField, @NotNull JSLinterConfigFileView configFileView) {
        if (packageNames == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(20);
        }
        if (nodeInterpreterField == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(21);
        }
        if (configFileView == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(22);
        }
        NodePackageDescriptor packageDescriptor = AutodetectLinterPackage.createPackageDescriptor(packageNames);
        NodePackageField packageField = new NodePackageField(nodeInterpreterField, packageDescriptor, null, AutodetectLinterPackage.createNodePackageRefResolver());
        packageField.addPackageRefSelectionListener(AutodetectLinterPackage.createPackageRefSelectionListener(packageField, configFileView));
        NodePackageField nodePackageField = packageField;
        if (nodePackageField == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(23);
        }
        return nodePackageField;
    }

    @NotNull
    private static Consumer<NodePackageRef> createPackageRefSelectionListener(@NotNull NodePackageField packageField, @NotNull JSLinterConfigFileView configFileView) {
        if (packageField == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(24);
        }
        if (configFileView == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(25);
        }
        Consumer consumer = nodePackage -> {
            boolean suppressCustomConfigFileUI = nodePackage == INSTANCE;
            configFileView.setEnabled(packageField.isEnabled() && !suppressCustomConfigFileUI);
            if (suppressCustomConfigFileUI) {
                configFileView.setCustomConfigFileUsed(false);
            } else {
                configFileView.setCustomConfigFileUsed(StringUtil.isNotEmpty((String)configFileView.getCustomConfigFilePath()));
            }
        };
        if (consumer == null) {
            AutodetectLinterPackage.$$$reportNull$$$0(26);
        }
        return consumer;
    }

    @NotNull
    private static NodePackageRefResolver createNodePackageRefResolver() {
        return new NodePackageRefResolver(){

            @Override
            @Nullable
            public NodePackage resolve(@NotNull NodePackageRef ref, @Nullable NodeJsInterpreter interpreter2) {
                NodePackage pkg;
                if (ref == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((pkg = ref.getConstantPackage()) != null) {
                    return pkg;
                }
                return ref == INSTANCE ? new NodePackage("") : null;
            }

            @Override
            public boolean isValidPackage(@NotNull NodePackageRef ref, @Nullable NodePackage pkg, @Nullable NodeJsInterpreter interpreter2) {
                if (ref == null) {
                    1.$$$reportNull$$$0(1);
                }
                return ref == INSTANCE || pkg != null && pkg.isValid();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "ref";
                objectArray2[1] = "com/intellij/lang/javascript/linter/AutodetectLinterPackage$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "resolve";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isValidPackage";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private static NodePackageDescriptor createPackageDescriptor(List<String> packageNames) {
        return new NodePackageDescriptor((List)packageNames){

            @Override
            @NotNull
            public NodePackageRef createPackageRef(@NotNull String text2) {
                if (text2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (StringUtil.equals((CharSequence)INSTANCE.getReferenceName(), (CharSequence)text2)) {
                    NodePackageRef nodePackageRef = INSTANCE;
                    if (nodePackageRef == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return nodePackageRef;
                }
                NodePackageRef nodePackageRef = super.createPackageRef(text2);
                if (nodePackageRef == null) {
                    2.$$$reportNull$$$0(2);
                }
                return nodePackageRef;
            }

            @Override
            @NotNull
            public List<NodePackageRef> listPackageRefs(@NotNull Project project, @Nullable NodeJsInterpreter interpreter2, @Nullable VirtualFile contextFileOrDirectory) {
                if (project == null) {
                    2.$$$reportNull$$$0(3);
                }
                ArrayList<NodePackageRef> refs = new ArrayList<NodePackageRef>();
                refs.add(INSTANCE);
                refs.addAll(super.listPackageRefs(project, interpreter2, contextFileOrDirectory));
                ArrayList<NodePackageRef> arrayList = refs;
                if (arrayList == null) {
                    2.$$$reportNull$$$0(4);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/linter/AutodetectLinterPackage$2";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/linter/AutodetectLinterPackage$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createPackageRef";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "listPackageRefs";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createPackageRef";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "listPackageRefs";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 4 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 19, 23, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePackage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePackageRef";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyName";
                break;
            }
            case 10: 
            case 19: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/AutodetectLinterPackage";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPackageJson";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNames";
                break;
            }
            case 18: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFileView";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeInterpreterField";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/AutodetectLinterPackage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultNodeModulesLocation";
                break;
            }
            case 19: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodePackageField";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackageRefSelectionListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setTestAutodetectedPackage";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultNodeModulesLocation";
                break;
            }
            case 10: 
            case 19: 
            case 23: 
            case 26: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasPackageJsonWithDependencyStrictlyAbove";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findInstalledPackage";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createNodePackageField";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createPackageRefSelectionListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 19, 23, 26 -> new IllegalStateException(string);
        };
    }
}

