/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSImportCandidateWithRewrittenPrefixKind;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSHandlersFactory;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.intentions.TypeScriptConvertAliasToInterfaceIntention;
import com.intellij.lang.javascript.modules.imports.ES6ImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSAddImportExecutor;
import com.intellij.lang.javascript.modules.imports.JSImportExecutorFactory;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParenthesizedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConvertAliasToEnumIntention
extends JavaScriptIntention {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        Object enumMemberName;
        TypeScriptTypeAlias alias;
        if (project == null) {
            TypeScriptConvertAliasToEnumIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            TypeScriptConvertAliasToEnumIntention.$$$reportNull$$$0(1);
        }
        if ((alias = TypeScriptConvertAliasToInterfaceIntention.getAlias(element)) == null) {
            return;
        }
        String aliasName = alias.getName();
        if (aliasName == null) {
            return;
        }
        List<TypeScriptLiteralType> literalTypes = TypeScriptConvertAliasToEnumIntention.getAllStringLiteralTypes(alias.getTypeDeclaration());
        if (literalTypes == null || literalTypes.size() == 0) {
            return;
        }
        HashMap<String, String> literalToEnumFieldName = new HashMap<String, String>(literalTypes.size());
        MultiMap literalToReferences = MultiMap.create();
        StringBuilder enumBody = new StringBuilder("{");
        HashSet<String> knownNames = new HashSet<String>();
        for (TypeScriptLiteralType literalType : literalTypes) {
            JSExpression expression = literalType.getExpression();
            assert (expression instanceof JSLiteralExpression);
            String stringValue = ((JSLiteralExpression)expression).getStringValue();
            assert (stringValue != null);
            String enumPropName = JSNameSuggestionsUtil.generateVariableNameFromExpression(expression, null);
            int n = 0;
            Object finalPropName = enumPropName;
            while (!knownNames.add((String)finalPropName)) {
                finalPropName = enumPropName + ++n;
            }
            literalToEnumFieldName.put(stringValue, (String)finalPropName);
            enumBody.append((String)finalPropName).append(" = ").append(expression.getText()).append(",");
            PsiReference[] references = expression.getReferences();
            if (references.length != 1) {
                return;
            }
            PsiReference reference = references[0];
            if (reference == null) {
                return;
            }
            PsiElement resolve2 = reference.resolve();
            if (resolve2 == null) {
                return;
            }
            Query search = ReferencesSearch.search((PsiElement)resolve2);
            literalToReferences.put((Object)stringValue, search.findAll());
        }
        String enumBodyString = StringUtil.trimEnd((String)enumBody.toString(), (String)",") + "}";
        ASTNode enumNode = JSChangeUtil.createStatementFromTextWithContext("enum " + aliasName + " " + enumBodyString, element);
        TypeScriptConvertAliasToInterfaceIntention.findChildAndReplace(JSStubElementTypes.ATTRIBUTE_LISTS, alias.getNode(), enumNode);
        HashSet<PsiFile> filesToUpdate = new HashSet<PsiFile>();
        HashMap<PsiElement, Object> elementsToReplace = new HashMap<PsiElement, Object>();
        for (Map.Entry entry : literalToReferences.entrySet()) {
            String key2 = (String)entry.getKey();
            enumMemberName = aliasName + "." + (String)literalToEnumFieldName.get(key2);
            for (PsiReference reference : (Collection)entry.getValue()) {
                PsiElement literalToReplace = TypeScriptConvertAliasToEnumIntention.getStringLiteralToReplace(reference.getElement(), element.getContainingFile());
                if (literalToReplace == null) continue;
                filesToUpdate.add(literalToReplace.getContainingFile());
                elementsToReplace.put(literalToReplace, enumMemberName);
            }
        }
        for (Map.Entry entry : elementsToReplace.entrySet()) {
            PsiElement elementToReplace = (PsiElement)entry.getKey();
            enumMemberName = (String)entry.getValue();
            TypeScriptConvertAliasToEnumIntention.insertImportNoType(elementToReplace, alias, aliasName);
            JSChangeUtil.replaceExpression((JSLiteralExpression)elementToReplace, (JSExpression)JSChangeUtil.createExpressionFromText(project, (String)enumMemberName).getPsi());
        }
        for (PsiFile psiFile2 : filesToUpdate) {
            ES6CreateImportUtil.optimizeImports((PsiElement)psiFile2);
        }
        JSChangeUtil.replaceElement(alias, (JSElement)enumNode.getPsi());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static PsiElement getStringLiteralToReplace(@NotNull PsiElement refElement, @NotNull PsiFile previewFile) {
        PsiElement targetElementCandidate;
        if (refElement == null) {
            TypeScriptConvertAliasToEnumIntention.$$$reportNull$$$0(2);
        }
        if (previewFile == null) {
            TypeScriptConvertAliasToEnumIntention.$$$reportNull$$$0(3);
        }
        if (IntentionPreviewUtils.isPreviewElement((PsiElement)previewFile)) {
            if (previewFile.getOriginalFile() != refElement.getContainingFile()) return null;
            targetElementCandidate = PsiTreeUtil.findSameElementInCopy((PsiElement)refElement, (PsiFile)previewFile);
        } else {
            targetElementCandidate = refElement;
        }
        if (!(targetElementCandidate instanceof JSLiteralExpression)) return null;
        if (!((JSLiteralExpression)targetElementCandidate).isStringLiteral()) return null;
        PsiElement psiElement = targetElementCandidate;
        return psiElement;
    }

    private static void insertImportNoType(@NotNull PsiElement place, @NotNull JSQualifiedNamedElement toImport, @NotNull String importedName) {
        List<JSImportExecutorFactory> factories;
        if (place == null) {
            TypeScriptConvertAliasToEnumIntention.$$$reportNull$$$0(4);
        }
        if (toImport == null) {
            TypeScriptConvertAliasToEnumIntention.$$$reportNull$$$0(5);
        }
        if (importedName == null) {
            TypeScriptConvertAliasToEnumIntention.$$$reportNull$$$0(6);
        }
        if ((factories = JSHandlersFactory.forElement(place).createImportFactories(place)).isEmpty()) {
            return;
        }
        JSAddImportExecutor executor = factories.get(0).createExecutor(place);
        ES6ImportCandidate candidate = new ES6ImportCandidate(importedName, (PsiElement)toImport, place);
        executor.createImportOrUpdateExisting(new JSImportCandidateWithRewrittenPrefixKind(candidate, prefixKind -> prefixKind == ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT_TYPE || prefixKind == ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT_TYPE_OR_SIMPLE ? ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT : prefixKind));
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            TypeScriptConvertAliasToEnumIntention.$$$reportNull$$$0(7);
        }
        if (element == null) {
            TypeScriptConvertAliasToEnumIntention.$$$reportNull$$$0(8);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof JSFile) || !DialectDetector.isTypeScript(element)) {
            return false;
        }
        TypeScriptTypeAlias alias = TypeScriptConvertAliasToInterfaceIntention.getAlias(element);
        if (alias == null || alias.getName() == null) {
            return false;
        }
        List<TypeScriptLiteralType> types2 = TypeScriptConvertAliasToEnumIntention.getAllStringLiteralTypes(alias.getTypeDeclaration());
        return types2 != null && types2.size() > 0;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("ts.convert.alias.to.enum.action.family.name", new Object[0]);
        if (string == null) {
            TypeScriptConvertAliasToEnumIntention.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message("ts.convert.alias.to.enum.action.title", new Object[0]);
        if (string == null) {
            TypeScriptConvertAliasToEnumIntention.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    private static List<TypeScriptLiteralType> getAllStringLiteralTypes(@Nullable JSTypeDeclaration declaration) {
        while (declaration instanceof TypeScriptParenthesizedType) {
            declaration = ((TypeScriptParenthesizedType)declaration).getInnerType();
        }
        if (declaration instanceof TypeScriptLiteralType) {
            JSExpression expression = ((TypeScriptLiteralType)declaration).getExpression();
            if (expression instanceof JSLiteralExpression && ((JSLiteralExpression)expression).isStringLiteral()) {
                return ContainerUtil.createMaybeSingletonList((Object)((TypeScriptLiteralType)declaration));
            }
            return null;
        }
        if (!(declaration instanceof TypeScriptUnionOrIntersectionType) || !((TypeScriptUnionOrIntersectionType)declaration).isUnionType()) {
            return null;
        }
        TypeScriptType[] types2 = ((TypeScriptUnionOrIntersectionType)declaration).getTypes();
        ArrayList<TypeScriptLiteralType> allTypes = new ArrayList<TypeScriptLiteralType>();
        for (TypeScriptType type2 : types2) {
            List<TypeScriptLiteralType> literalTypes = TypeScriptConvertAliasToEnumIntention.getAllStringLiteralTypes(type2);
            if (literalTypes == null) {
                return null;
            }
            allTypes.addAll(literalTypes);
        }
        return allTypes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedName";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/TypeScriptConvertAliasToEnumIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/TypeScriptConvertAliasToEnumIntention";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStringLiteralToReplace";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "insertImportNoType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10 -> new IllegalStateException(string);
        };
    }
}

