/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.ES6ConvertModuleExportToExportQuickFix;
import com.intellij.lang.javascript.inspections.ES6ConvertRequireIntoImportInspection;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ConvertModuleExportToExportInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        return new JSElementVisitor(){

            @Override
            public void visitJSAssignmentExpression(@NotNull JSAssignmentExpression assignment) {
                if (assignment == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!DialectDetector.hasFeature((PsiElement)assignment, JSLanguageFeature.EXPORT_DECLARATIONS)) {
                    return;
                }
                List<String> nameParts = ES6ConvertModuleExportToExportInspection.checkAssignmentGetDefinitionReference(assignment);
                if (nameParts == null) {
                    return;
                }
                List<String> exportedNameParts = ES6ConvertModuleExportToExportInspection.isExport(nameParts, false);
                if (exportedNameParts == null) {
                    return;
                }
                String exportedName = exportedNameParts.isEmpty() ? null : exportedNameParts.get(0);
                boolean onlyHighlight = "exports".equals(nameParts.get(0)) && exportedNameParts.isEmpty() || exportedNameParts.size() > 1 || !exportedNameParts.isEmpty() && ("prototype".equals(exportedName) || "constructor".equals(exportedName) || exportedName != null && exportedName.startsWith("["));
                JSExpression expression = assignment.getDefinitionExpression().getExpression();
                assert (expression != null);
                if (onlyHighlight) {
                    holder.registerProblem((PsiElement)expression, JavaScriptBundle.message("js.convert.module.exports.into.es6.export.inspection.text", new Object[0]), new LocalQuickFix[0]);
                } else {
                    holder.registerProblem((PsiElement)expression, JavaScriptBundle.message("js.convert.module.exports.into.es6.export.inspection.text", new Object[0]), new LocalQuickFix[]{new ES6ConvertModuleExportToExportQuickFix(assignment, exportedName)});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportInspection$1", "visitJSAssignmentExpression"));
            }
        };
    }

    static boolean checkContext(@NotNull JSAssignmentExpression assignment) {
        if (assignment == null) {
            ES6ConvertModuleExportToExportInspection.$$$reportNull$$$0(0);
        }
        if (!ES6ConvertRequireIntoImportInspection.checkElementIsOnTopLevel(assignment)) {
            return false;
        }
        PsiElement parent = assignment.getParent();
        return parent instanceof JSSourceElement || parent instanceof JSCommaExpression;
    }

    private static List<String> checkAssignmentGetDefinitionReference(@NotNull JSAssignmentExpression assignment) {
        if (assignment == null) {
            ES6ConvertModuleExportToExportInspection.$$$reportNull$$$0(1);
        }
        if (assignment.getOperationSign() != JSTokenTypes.EQ) {
            return null;
        }
        JSDefinitionExpression definition2 = assignment.getDefinitionExpression();
        if (definition2 == null || definition2.getInitializerOrStub() == null || definition2.getExpression() == null) {
            return null;
        }
        if (!ES6ConvertModuleExportToExportInspection.checkContext(assignment)) {
            return null;
        }
        return JSSymbolUtil.getReferenceParts(definition2.getExpression());
    }

    @Nullable
    static List<String> checkAssignmentToBeExport(@NotNull JSAssignmentExpression assignment) {
        List<String> nameParts;
        if (assignment == null) {
            ES6ConvertModuleExportToExportInspection.$$$reportNull$$$0(2);
        }
        if ((nameParts = ES6ConvertModuleExportToExportInspection.checkAssignmentGetDefinitionReference(assignment)) == null) {
            return null;
        }
        return ES6ConvertModuleExportToExportInspection.isExport(nameParts, true);
    }

    @Nullable
    private static List<String> isExport(@NotNull List<String> nameParts, boolean ignoreShortDefaultExport) {
        if (nameParts == null) {
            ES6ConvertModuleExportToExportInspection.$$$reportNull$$$0(3);
        }
        if ("exports".equals(nameParts.get(0))) {
            return ignoreShortDefaultExport && nameParts.size() == 1 ? null : nameParts.subList(1, nameParts.size());
        }
        if ("module".equals(nameParts.get(0)) && nameParts.size() > 1 && "exports".equals(nameParts.get(1))) {
            return nameParts.subList(2, nameParts.size());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameParts";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAssignmentGetDefinitionReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAssignmentToBeExport";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isExport";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

