/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index.gist;

import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.index.gist.JSStubElementGistProvider;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.impl.JSCachingTypeOwner;
import com.intellij.lang.javascript.psi.impl.JSPropertyImpl;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubElementTypeHolder;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubIndexingUtils;
import com.intellij.lang.javascript.psi.stubs.impl.JSTypeHolderOwner;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeHolderOwnerImpl
extends JSStubElementGistProvider.FlagsOwner
implements JSTypeHolderOwner {
    protected static final BooleanStructureElement IS_TYPE_STRICT_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_TYPE_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_TYPE_FROM_JSDOC_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement REQUIRES_TYPE_CHECKING_FLAG = new BooleanStructureElement();
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(IS_TYPE_STRICT_FLAG, HAS_TYPE_FLAG, IS_TYPE_FROM_JSDOC_FLAG, REQUIRES_TYPE_CHECKING_FLAG);
    @Nullable
    private final JSStubElementTypeHolder myTypeHolder;

    protected JSTypeHolderOwnerImpl(@NotNull JSCachingTypeOwner var, int childFlags, @NotNull Ref<JSStubElementTypeHolder> typeHolderRef) {
        if (var == null) {
            JSTypeHolderOwnerImpl.$$$reportNull$$$0(0);
        }
        if (typeHolderRef == null) {
            JSTypeHolderOwnerImpl.$$$reportNull$$$0(1);
        }
        super(JSTypeHolderOwnerImpl.initFromPsi(var, childFlags, typeHolderRef));
        this.myTypeHolder = (JSStubElementTypeHolder)typeHolderRef.get();
    }

    public JSTypeHolderOwnerImpl(DataInput in) throws IOException {
        super(in);
        this.myTypeHolder = this.readFlag(HAS_TYPE_FLAG) != false ? JSStubElementTypeHolder.fromDataStream(in) : null;
    }

    @Override
    protected void save(DataOutput out) throws IOException {
        super.save(out);
        if (this.readFlag(HAS_TYPE_FLAG).booleanValue()) {
            JSStubElementTypeHolder.serialize(Objects.requireNonNull(this.myTypeHolder), out);
        }
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            JSTypeHolderOwnerImpl.$$$reportNull$$$0(2);
        }
        return flagsStructure;
    }

    private static int initFromPsi(@NotNull JSCachingTypeOwner psi, int flags, @NotNull Ref<JSStubElementTypeHolder> typeHolderRef) {
        if (psi == null) {
            JSTypeHolderOwnerImpl.$$$reportNull$$$0(3);
        }
        if (typeHolderRef == null) {
            JSTypeHolderOwnerImpl.$$$reportNull$$$0(4);
        }
        JSType type2 = JSTypeHolderOwnerImpl.getTypeToSerialize(psi);
        JSStubElementTypeHolder typeHolder = JSStubElementTypeHolder.fromJSType(type2);
        flags = JSTypeHolderOwnerImpl.writeFlag(flags, FLAGS_STRUCTURE, IS_TYPE_STRICT_FLAG, type2 != null && type2.isSourceStrict());
        flags = JSTypeHolderOwnerImpl.writeFlag(flags, FLAGS_STRUCTURE, HAS_TYPE_FLAG, typeHolder != null);
        flags = JSTypeHolderOwnerImpl.writeFlag(flags, FLAGS_STRUCTURE, IS_TYPE_FROM_JSDOC_FLAG, JSStubIndexingUtils.isAstBasedTypeFromJSDoc(type2));
        flags = JSTypeHolderOwnerImpl.writeFlag(flags, FLAGS_STRUCTURE, IS_TYPE_STRICT_FLAG, type2 != null && type2.isSourceStrict());
        flags = JSTypeHolderOwnerImpl.writeFlag(flags, FLAGS_STRUCTURE, REQUIRES_TYPE_CHECKING_FLAG, JSTypeHolderOwnerImpl.calculateRequiresTypeChecking(psi));
        typeHolderRef.set((Object)typeHolder);
        return flags;
    }

    @Override
    @Nullable
    public JSStubElementTypeHolder getJSTypeHolder() {
        return this.myTypeHolder;
    }

    @Nullable
    protected static JSType getTypeToSerialize(@NotNull JSCachingTypeOwner psi) {
        JSTypeDeclarationOwner var;
        PsiElement typeDeclaration;
        if (psi == null) {
            JSTypeHolderOwnerImpl.$$$reportNull$$$0(5);
        }
        if (psi instanceof JSTypeDeclarationOwner && (typeDeclaration = (var = (JSTypeDeclarationOwner)((Object)psi)).getTypeElement()) instanceof JSTypeDeclaration) {
            return null;
        }
        JSType type2 = psi.calculateType();
        return JSStubIndexingUtils.needSerializeType(psi, type2 = JSCachingTypeOwner.unifyPsiAndStubBased(type2, psi)) ? type2 : null;
    }

    private static boolean calculateRequiresTypeChecking(@NotNull JSCachingTypeOwner psi) {
        boolean bl;
        if (psi == null) {
            JSTypeHolderOwnerImpl.$$$reportNull$$$0(6);
        }
        if (psi instanceof JSVariableBaseImpl) {
            JSVariableBaseImpl var = (JSVariableBaseImpl)psi;
            bl = var.calculateRequiresTypeChecking();
        } else {
            JSPropertyImpl prop;
            bl = psi instanceof JSPropertyImpl && (prop = (JSPropertyImpl)psi).calculateRequiresTypeChecking();
        }
        return bl;
    }

    @Nullable
    public JSType getJSType(@NotNull PsiElement variableBase) {
        if (variableBase == null) {
            JSTypeHolderOwnerImpl.$$$reportNull$$$0(7);
        }
        return this.myTypeHolder != null ? this.myTypeHolder.getTypeOrFromSerialized(variableBase, this.readFlag(IS_TYPE_FROM_JSDOC_FLAG), this.readFlag(IS_TYPE_STRICT_FLAG)) : null;
    }

    public boolean requiresTypeChecking() {
        return this.readFlag(REQUIRES_TYPE_CHECKING_FLAG);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeHolderRef";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/gist/JSTypeHolderOwnerImpl";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/gist/JSTypeHolderOwnerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlagsStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "initFromPsi";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTypeToSerialize";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calculateRequiresTypeChecking";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getJSType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

