/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSLexerUtil;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.index.JSIndexPatternBuilder;
import com.intellij.lang.javascript.psi.util.JSDirectiveCommentLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.impl.cache.impl.BaseFilterLexer;
import com.intellij.psi.impl.cache.impl.BaseFilterLexerUtil;
import com.intellij.psi.impl.cache.impl.IdAndToDoScannerBasedOnFilterLexer;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.FileContent;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.NotNull;

final class JSIdAndTodoScanner
implements IdAndToDoScannerBasedOnFilterLexer {
    private static final Key<JSScanContent> SCAN_CONTENT_KEY = Key.create((String)"js.scan.content");
    private static final int MIN_WORD_LENGTH = SystemProperties.getIntProperty((String)"idea.js.literal.word.min.length", (int)4);
    private static final int MAX_WORD_LENGTH = SystemProperties.getIntProperty((String)"idea.js.literal.word.max.length", (int)50);
    @NotNull
    private final DialectOptionHolder myDialectOptionHolder;
    private Object2IntMap<String> myStringLiteralWords;

    private JSIdAndTodoScanner(@NotNull DialectOptionHolder dialectOptionHolder) {
        if (dialectOptionHolder == null) {
            JSIdAndTodoScanner.$$$reportNull$$$0(0);
        }
        this.myDialectOptionHolder = dialectOptionHolder;
    }

    @NotNull
    static Map<String, Integer> calcStringLiteralWords(@NotNull FileContent inputData) {
        if (inputData == null) {
            JSIdAndTodoScanner.$$$reportNull$$$0(1);
        }
        JSScanContent data = JSIdAndTodoScanner.scanContent(inputData);
        data.stringLiteralWordsAccessed = true;
        JSIdAndTodoScanner.clearCacheIfUsed(data, inputData);
        Map<String, Integer> map = data.stringLiteralWords;
        if (map == null) {
            JSIdAndTodoScanner.$$$reportNull$$$0(2);
        }
        return map;
    }

    @NotNull
    static Map<IdIndexEntry, Integer> calcIdEntries(@NotNull FileContent inputData) {
        if (inputData == null) {
            JSIdAndTodoScanner.$$$reportNull$$$0(3);
        }
        JSScanContent data = JSIdAndTodoScanner.scanContent(inputData);
        data.idEntriesAccessed = true;
        JSIdAndTodoScanner.clearCacheIfUsed(data, inputData);
        Map<IdIndexEntry, Integer> map = data.idEntries;
        if (map == null) {
            JSIdAndTodoScanner.$$$reportNull$$$0(4);
        }
        return map;
    }

    private static void clearCacheIfUsed(@NotNull JSScanContent data, @NotNull FileContent inputData) {
        if (data == null) {
            JSIdAndTodoScanner.$$$reportNull$$$0(5);
        }
        if (inputData == null) {
            JSIdAndTodoScanner.$$$reportNull$$$0(6);
        }
        if (data.stringLiteralWordsAccessed && data.idEntriesAccessed) {
            inputData.putUserData(SCAN_CONTENT_KEY, null);
        }
    }

    @NotNull
    private static JSScanContent scanContent(@NotNull FileContent inputData) {
        JSScanContent cached;
        if (inputData == null) {
            JSIdAndTodoScanner.$$$reportNull$$$0(7);
        }
        if ((cached = (JSScanContent)inputData.getUserData(SCAN_CONTENT_KEY)) != null) {
            JSScanContent jSScanContent = cached;
            if (jSScanContent == null) {
                JSIdAndTodoScanner.$$$reportNull$$$0(8);
            }
            return jSScanContent;
        }
        JSIdAndTodoScanner scanner = JSIdAndTodoScanner.createIdAndTodoScanner(inputData);
        Map idEntries = BaseFilterLexerUtil.calcIdEntries((FileContent)inputData, (IdAndToDoScannerBasedOnFilterLexer)scanner);
        Object2IntOpenHashMap wordsMap = scanner.myStringLiteralWords;
        if (wordsMap == null) {
            Logger.getInstance(JSIdAndTodoScanner.class).error("JSFilterLexer.start was not called");
            wordsMap = new Object2IntOpenHashMap();
        }
        JSScanContent result2 = new JSScanContent(idEntries, (Map<String, Integer>)wordsMap);
        inputData.putUserData(SCAN_CONTENT_KEY, (Object)result2);
        JSScanContent jSScanContent = result2;
        if (jSScanContent == null) {
            JSIdAndTodoScanner.$$$reportNull$$$0(9);
        }
        return jSScanContent;
    }

    @NotNull
    static JSIdAndTodoScanner createIdAndTodoScanner(@NotNull FileContent inputData) {
        Project project;
        if (inputData == null) {
            JSIdAndTodoScanner.$$$reportNull$$$0(10);
        }
        JSLanguageDialect dialect = Objects.requireNonNullElse((project = inputData.getProject()) == null ? null : DialectDetector.getLanguageDialect(inputData.getFile(), project), JSLanguageLevel.DEFAULT.getDialect());
        return new JSIdAndTodoScanner(dialect.getOptionHolder());
    }

    @NotNull
    public Lexer createLexer(@NotNull OccurrenceConsumer consumer) {
        if (consumer == null) {
            JSIdAndTodoScanner.$$$reportNull$$$0(11);
        }
        return new JSFilterLexer(this.myDialectOptionHolder, consumer);
    }

    static int getVersion() {
        return 5;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectOptionHolder";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/JSIdAndTodoScanner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/JSIdAndTodoScanner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "calcStringLiteralWords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calcIdEntries";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "scanContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calcStringLiteralWords";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calcIdEntries";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "clearCacheIfUsed";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "scanContent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createIdAndTodoScanner";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createLexer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 8, 9 -> new IllegalStateException(string);
        };
    }

    private static final class JSScanContent {
        @NotNull
        private final Map<IdIndexEntry, Integer> idEntries;
        @NotNull
        private final Map<String, Integer> stringLiteralWords;
        boolean idEntriesAccessed;
        boolean stringLiteralWordsAccessed;

        JSScanContent(@NotNull Map<IdIndexEntry, Integer> idEntries, @NotNull Map<String, Integer> stringLiteralWords) {
            if (idEntries == null) {
                JSScanContent.$$$reportNull$$$0(0);
            }
            if (stringLiteralWords == null) {
                JSScanContent.$$$reportNull$$$0(1);
            }
            this.idEntries = idEntries;
            this.stringLiteralWords = stringLiteralWords;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "idEntries";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stringLiteralWords";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/index/JSIdAndTodoScanner$JSScanContent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class JSFilterLexer
    extends BaseFilterLexer {
        private JSFilterLexer(DialectOptionHolder dialectOptionHolder, OccurrenceConsumer occurrenceConsumer) {
            if (dialectOptionHolder == null) {
                JSFilterLexer.$$$reportNull$$$0(0);
            }
            super((Lexer)new JSDirectiveCommentLexer((Lexer)new JSFlexAdapter(dialectOptionHolder, true)), occurrenceConsumer);
        }

        public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
            if (buffer == null) {
                JSFilterLexer.$$$reportNull$$$0(1);
            }
            JSIdAndTodoScanner.this.myStringLiteralWords = new Object2IntOpenHashMap();
            super.start(buffer, startOffset, endOffset, initialState);
        }

        protected IntPredicate getWordCodePointPredicate() {
            return JSFilterLexer::isJsWordCodePoint;
        }

        public void advance() {
            IElementType tokenType = this.myDelegate.getTokenType();
            if (JSKeywordSets.IDENTIFIER_NAMES.contains(tokenType)) {
                this.addOccurrenceInToken(1);
            } else if (tokenType == JSTokenTypes.XML_TAG_NAME || tokenType == JSTokenTypes.XML_NAME) {
                this.scanWordsInToken(1, false, false);
            } else if (JSTokenTypes.STRING_LITERALS.contains(tokenType) || tokenType == JSTokenTypes.STRING_TEMPLATE_PART) {
                CharSequence charSequence;
                this.scanWordsInToken(12, true, false);
                if ((JSTokenTypes.STRING_LITERALS.contains(tokenType) || tokenType == JSTokenTypes.STRING_TEMPLATE_PART && this.hasNoInterpolations()) && !StringUtil.contains((CharSequence)(charSequence = this.getTokenSequence()), (CharSequence)" ") && charSequence.length() < 4096) {
                    String originalText = charSequence.toString();
                    String text2 = JSStringUtil.replaceUnicodeEscapeSequences(originalText);
                    boolean unicodeFound = !Strings.areSameInstance((String)text2, (String)originalText);
                    List words = StringUtil.getWordIndicesIn((String)text2);
                    for (TextRange word : words) {
                        if (MIN_WORD_LENGTH > word.getLength() || word.getLength() > MAX_WORD_LENGTH) continue;
                        int wordOffset = unicodeFound ? 0 : word.getStartOffset();
                        JSIdAndTodoScanner.this.myStringLiteralWords.putIfAbsent((Object)word.substring(text2), this.getTokenStart() + wordOffset);
                    }
                }
            } else if (JSIndexPatternBuilder.Holder.COMMENTS_FOR_INDEXING.contains(tokenType) && !this.isSourceMapComment(tokenType)) {
                this.scanWordsInToken(2, false, false);
                this.advanceTodoItemCountsInToken();
            } else if (tokenType == JSTokenTypes.XML_ATTR_VALUE) {
                this.scanWordsInToken(24, tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, false);
            } else if (!JSLexerUtil.SKIP_WORDS_SCAN_SET.contains(tokenType)) {
                this.scanWordsInToken(16, false, false);
            }
            this.myDelegate.advance();
        }

        private boolean isSourceMapComment(@NotNull IElementType tokenType) {
            if (tokenType == null) {
                JSFilterLexer.$$$reportNull$$$0(2);
            }
            if (tokenType != JSTokenTypes.END_OF_LINE_COMMENT) {
                return false;
            }
            if (this.getTokenEnd() - this.getTokenStart() < "//# sourceMappingURL=data:application/json;".length()) {
                return false;
            }
            return StringUtil.startsWith((CharSequence)this.getTokenSequence(), (CharSequence)"//# sourceMappingURL=data:application/json;");
        }

        private boolean hasNoInterpolations() {
            int prevOffset = this.getTokenStart() - 1;
            int nextOffset = this.getTokenEnd();
            CharSequence text2 = this.getBufferSequence();
            return prevOffset >= 0 && text2.charAt(prevOffset) == '`' && nextOffset < text2.length() && text2.charAt(nextOffset) == '`';
        }

        private static boolean isJsWordCodePoint(int codePoint) {
            return IdTableBuilding.isWordCodePoint((int)codePoint) || codePoint == 36;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialectOptionHolder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buffer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tokenType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/index/JSIdAndTodoScanner$JSFilterLexer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "start";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSourceMapComment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

