/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.index.FrameworkIndexingHandlerEP;
import com.intellij.lang.javascript.index.FrameworkIndexingHandlers;
import com.intellij.lang.javascript.index.JSIndexContentBuilder;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementCustomProvider;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementProvider;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeInfo;
import com.intellij.lang.javascript.psi.stubs.JSClassStub;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElementStructure;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileStubBuilder;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworkIndexingHandler {
    public static final ExtensionPointName<FrameworkIndexingHandlerEP> EP_NAME = new ExtensionPointName("JavaScript.frameworkIndexingHandler");
    private static final List<FrameworkIndexingHandler> EMPTY_LIST = Collections.emptyList();
    private boolean myJSElementIndexingDataUserStringKeyUniquenessChecked = false;
    private final NotNullLazyValue<Set<@NotNull String>> IMPLICIT_ELEMENT_USER_STRING_KEYS = NotNullLazyValue.createValue(() -> {
        Set<@NotNull String> myKeys = this.computeJSImplicitElementUserStringKeys();
        for (FrameworkIndexingHandler otherHandler : FrameworkIndexingHandler.getIndexingHandlers()) {
            if (this.equals(otherHandler)) continue;
            Set<String> otherKeys = otherHandler.computeJSImplicitElementUserStringKeys();
            for (String otherKey : otherKeys) {
                if (!myKeys.contains(otherKey)) continue;
                Logger.getInstance(FrameworkIndexingHandler.class).error(String.format("%s JSImplicitElement user string is defined in both %s and %s", otherKey, this.getClass().getName(), otherHandler.getClass().getName()));
            }
        }
        return myKeys;
    });

    @NotNull
    public static List<FrameworkIndexingHandler> getIndexingHandlers() {
        List<FrameworkIndexingHandler> list2 = FrameworkIndexingHandlers.getInstance().getHandlers();
        if (list2 == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(0);
        }
        return list2;
    }

    public void processFile(@NotNull JSFile file, @NotNull JSFileCachedData data) {
        if (file == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(1);
        }
        if (data == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(2);
        }
    }

    public void processFile(@NotNull JSFile file, @NotNull JSIndexContentBuilder indexBuilder) {
        if (file == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(3);
        }
        if (indexBuilder == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(4);
        }
    }

    public boolean processProperty(@Nullable String name, @NotNull JSProperty property, @NotNull JSElementIndexingData outData) {
        if (property == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(5);
        }
        if (outData == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(6);
        }
        return true;
    }

    public String @NotNull [] interestedProperties() {
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(7);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @Nullable
    public JSElementIndexingData processAnyProperty(@NotNull JSProperty property, @Nullable JSElementIndexingData outData) {
        if (property == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(8);
        }
        return outData;
    }

    public boolean processCustomElement(@NotNull PsiElement customElement, @NotNull JSIndexContentBuilder builder2) {
        if (customElement == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(9);
        }
        if (builder2 == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(10);
        }
        return true;
    }

    public boolean canProcessCustomElement(@NotNull PsiElement element) {
        if (element == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(11);
        }
        return false;
    }

    public String @NotNull [] implicitProviderMethodNames() {
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(12);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public String @NotNull [] inheritanceMethodNames() {
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(13);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public void processCallExpression(JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        if (outData == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(14);
        }
    }

    public boolean shouldCreateStubForCallExpression(@NotNull ASTNode node) {
        if (node == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(15);
        }
        return false;
    }

    public boolean shouldCreateStubForLiteral(@NotNull ASTNode node) {
        if (node == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(16);
        }
        return false;
    }

    public boolean shouldCreateStubForArrayLiteral(@NotNull ASTNode node) {
        if (node == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(17);
        }
        return false;
    }

    public boolean hasSignificantValue(@NotNull JSLiteralExpression expression) {
        if (expression == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(18);
        }
        return false;
    }

    @Nullable
    public String resolveContextFromProperty(JSObjectLiteralExpression objectLiteralExpression, boolean returnPropertiesNamespace) {
        return null;
    }

    @Nullable
    public JSNamespace findNamespace(@NotNull JSExpression expression, @Nullable Set<PsiElement> visited) {
        if (expression == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(19);
        }
        return null;
    }

    @Nullable
    public JSElementIndexingData processJSDocComment(@NotNull JSDocComment comment, @Nullable JSElementIndexingData outData) {
        if (comment == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(20);
        }
        return outData;
    }

    public JSLiteralImplicitElementProvider createLiteralImplicitElementProvider(@NotNull String calledMethodName) {
        if (calledMethodName == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(21);
        }
        assert (false) : calledMethodName + " not implemented for " + this.getClass();
        return null;
    }

    @Nullable
    public JSLiteralImplicitElementCustomProvider createLiteralImplicitElementCustomProvider() {
        return null;
    }

    @Deprecated(forRemoval=true)
    public boolean addTypeFromResolveResult(JSTypeEvaluator evaluator, PsiElement result2, boolean hasSomeType) {
        return false;
    }

    public boolean addTypeFromResolveResult(@NotNull JSTypeEvaluator evaluator, @NotNull JSEvaluateContext context2, @NotNull PsiElement result2) {
        if (evaluator == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(22);
        }
        if (context2 == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(23);
        }
        if (result2 == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(24);
        }
        return false;
    }

    @NotNull
    public List<String> getMarkers(@NotNull PsiElement elementToIndex) {
        if (elementToIndex == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(25);
        }
        List<String> list2 = Collections.emptyList();
        if (list2 == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(26);
        }
        return list2;
    }

    @Deprecated(forRemoval=true)
    protected int getVersion() {
        FrameworkIndexingHandlerEP bean = (FrameworkIndexingHandlerEP)ContainerUtil.find((Iterable)EP_NAME.getExtensionList(), b -> b.implementationClass.equals(this.getClass().getName()));
        if (bean != null && bean.version != null) {
            return Integer.parseInt(bean.version);
        }
        return 1;
    }

    @Nullable
    public PsiElement findModule(@NotNull PsiElement result2) {
        if (result2 == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(27);
        }
        return null;
    }

    public boolean indexImplicitElement(@NotNull JSImplicitElementStructure element, @Nullable IndexSink sink) {
        if (element == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(28);
        }
        return false;
    }

    public void indexClassStub(@NotNull JSClassStub<?> jsClassStub, @NotNull IndexSink sink) {
        if (jsClassStub == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(29);
        }
        if (sink == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(30);
        }
    }

    @Nullable
    public JSElementIndexingDataImpl processDecorator(@NotNull ES6Decorator decorator, @Nullable JSElementIndexingDataImpl data) {
        if (decorator == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(31);
        }
        return data;
    }

    @Nullable
    public JSElementIndexingDataImpl processClass(@NotNull JSClass jsClass, @Nullable JSElementIndexingDataImpl data) {
        if (jsClass == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(32);
        }
        return data;
    }

    public void addContextType(JSTypeInfo info2, PsiElement context2) {
    }

    public void addContextNames(PsiElement context2, List<String> names) {
    }

    @NotNull
    public static List<FrameworkIndexingHandler> getExtensions(@NotNull ASTNode node) {
        if (node == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(33);
        }
        while (!(node.getElementType() instanceof IFileElementType)) {
            node = node.getTreeParent();
        }
        return FrameworkIndexingHandler.getExtensions(node.getPsi());
    }

    @NotNull
    public static List<FrameworkIndexingHandler> getExtensions(PsiElement element) {
        if (!FrameworkIndexingHandler.allowsHandlers(element)) {
            List<FrameworkIndexingHandler> list2 = EMPTY_LIST;
            if (list2 == null) {
                FrameworkIndexingHandler.$$$reportNull$$$0(34);
            }
            return list2;
        }
        return FrameworkIndexingHandler.getIndexingHandlers();
    }

    public static boolean allowsHandlers(PsiElement element) {
        return element.getContainingFile().getUserData(JSFileStubBuilder.ALLOW_HANDLERS) != Boolean.FALSE;
    }

    @Nullable
    public JSType getExportsInnerAliasType(@NotNull JSQualifiedName referenceName, @NotNull JSTypeSource typeSource) {
        if (referenceName == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(35);
        }
        if (typeSource == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(36);
        }
        return null;
    }

    @NotNull
    public JSType adjustTypeBeforeAdd(@NotNull JSType type2, @NotNull JSEvaluateContext context2) {
        if (type2 == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(37);
        }
        if (context2 == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(38);
        }
        JSType jSType = type2;
        if (jSType == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(39);
        }
        return jSType;
    }

    @Nullable
    protected String getJSElementIndexingDataUserStringKey() {
        return null;
    }

    public final void putUserString(@NotNull JSElementIndexingData indexingData, @NotNull String value) {
        String key2;
        if (indexingData == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(40);
        }
        if (value == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(41);
        }
        if ((key2 = this.getJSElementIndexingDataUserStringKey()) == null) {
            Logger.getInstance(FrameworkIndexingHandler.class).error("getJSElementIndexingDataUserStringKey() must be overridden in " + this.getClass().getName());
        } else {
            if (!this.myJSElementIndexingDataUserStringKeyUniquenessChecked) {
                for (FrameworkIndexingHandler otherHandler : FrameworkIndexingHandler.getIndexingHandlers()) {
                    String otherKey;
                    if (this.equals(otherHandler) || (otherKey = otherHandler.getJSElementIndexingDataUserStringKey()) == null || !key2.equals(otherKey)) continue;
                    Logger.getInstance(FrameworkIndexingHandler.class).error(String.format("%s JSElementIndexingData user string is defined in both %s and %s", key2, this.getClass().getName(), otherHandler.getClass().getName()));
                }
                this.myJSElementIndexingDataUserStringKeyUniquenessChecked = true;
            }
            indexingData.putUserString(key2, value);
        }
    }

    @NotNull
    public final @NotNull Set<@NotNull String> getJSImplicitElementUserStringKeys() {
        Set set = (Set)this.IMPLICIT_ELEMENT_USER_STRING_KEYS.getValue();
        if (set == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(42);
        }
        return set;
    }

    @NotNull
    protected @NotNull Set<@NotNull String> computeJSImplicitElementUserStringKeys() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(43);
        }
        return set;
    }

    public boolean useOnlyCompleteMatch(@NotNull JSType type2, @NotNull JSEvaluateContext evaluateContext) {
        if (type2 == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(44);
        }
        if (evaluateContext == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(45);
        }
        return false;
    }

    public boolean useMoreAccurateTypes(@NotNull PsiElement element) {
        if (element == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(46);
        }
        return false;
    }

    @Nullable
    public String adjustTypeFromJSDoc(@NotNull PsiElement definition2, @Nullable JSDocComment comment, @Nullable String type2) {
        if (definition2 == null) {
            FrameworkIndexingHandler.$$$reportNull$$$0(47);
        }
        return type2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 27, 28, 29, 30, 31, 32, 33, 35, 36, 37, 38, 40, 41, 44, 45, 46, 47 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/FrameworkIndexingHandler";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexBuilder";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outData";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 11: 
            case 28: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calledMethodName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 23: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToIndex";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClassStub";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 37: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexingData";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexingHandlers";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/FrameworkIndexingHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "interestedProperties";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "implicitProviderMethodNames";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "inheritanceMethodNames";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getMarkers";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustTypeBeforeAdd";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSImplicitElementUserStringKeys";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "computeJSImplicitElementUserStringKeys";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processProperty";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processAnyProperty";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processCustomElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canProcessCustomElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processCallExpression";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shouldCreateStubForCallExpression";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "shouldCreateStubForLiteral";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "shouldCreateStubForArrayLiteral";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "hasSignificantValue";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findNamespace";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processJSDocComment";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createLiteralImplicitElementProvider";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromResolveResult";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getMarkers";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "indexImplicitElement";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "indexClassStub";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processDecorator";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processClass";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getExportsInnerAliasType";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "adjustTypeBeforeAdd";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "putUserString";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "useOnlyCompleteMatch";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "useMoreAccurateTypes";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "adjustTypeFromJSDoc";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 27, 28, 29, 30, 31, 32, 33, 35, 36, 37, 38, 40, 41, 44, 45, 46, 47 -> new IllegalArgumentException(string);
        };
    }
}

