/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.google.common.collect.ImmutableSet;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.highlighting.JavaScriptHighlightDescriptor;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.RainbowColorSettingsPage;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import com.intellij.util.PlatformUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JavaScriptColorsAndFontsPage
implements RainbowColorSettingsPage,
DisplayPrioritySortable {
    private static final AttributesDescriptor[] ATTRS;
    private static final Collection<JavaScriptHighlightDescriptor> IGNORED_HIGHLIGHT_DESCRIPTORS;
    @NonNls
    private static final Map<String, TextAttributesKey> ADDITIONAL_HIGHLIGHT_DESCRIPTORS;

    JavaScriptColorsAndFontsPage() {
    }

    @NotNull
    public String getDisplayName() {
        return "JavaScript";
    }

    public Icon getIcon() {
        return JavaScriptSupportLoader.JAVASCRIPT.getIcon();
    }

    public AttributesDescriptor @NotNull [] getAttributeDescriptors() {
        if (ATTRS == null) {
            JavaScriptColorsAndFontsPage.$$$reportNull$$$0(0);
        }
        return ATTRS;
    }

    public ColorDescriptor @NotNull [] getColorDescriptors() {
        if (ColorDescriptor.EMPTY_ARRAY == null) {
            JavaScriptColorsAndFontsPage.$$$reportNull$$$0(1);
        }
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)JavaScriptSupportLoader.JAVASCRIPT, null, null);
        assert (highlighter != null);
        SyntaxHighlighter syntaxHighlighter = highlighter;
        if (syntaxHighlighter == null) {
            JavaScriptColorsAndFontsPage.$$$reportNull$$$0(2);
        }
        return syntaxHighlighter;
    }

    @NotNull
    public String getDemoText() {
        return "function <global_function>globalFunction</global_function>({ <parameter>options</parameter> = {} }) {\n  const { <local_variable>minLength</local_variable> } = <parameter>options</parameter>;\n\n  /**\n   * <doc_tag>@description</doc_tag> Validator\n   * <doc_tag>@param</doc_tag> <doc_type>{string?}</doc_type> <doc_tag_namepath>value</doc_tag_namepath> - parameter description\n   */\n  const <local_function>localFunction</local_function> = <parameter>value</parameter> <function_arrow>=></function_arrow> {\n    let <local_variable>isValid</local_variable> = <parameter>value</parameter>?.<instance_variable>length</instance_variable> >= <local_variable>minLength</local_variable> ?? 3; // line comment\n    /* Block comment */\n    <local_variable>isValid</local_variable> = <local_variable>isValid</local_variable> && (/^\\d.[A-F]+$/i).<instance_method>test</instance_method>(<parameter>value</parameter>);\n    return {\n      <local_variable>isValid</local_variable>,\n    };\n  };\n}\n\n<es6_decorator>@defineElement</es6_decorator>(\"download-button\")\nclass <class_name>DownloadButton</class_name> extends <global_variable>HTMLButtonElement</global_variable> {\n  static <static_field>STATIC_FIELD</static_field> = `<injected_fragment><html_tag><<html_tag_name>span</html_tag_name> <html_attr_name>title</html_attr_name><html_attr_value>=\"HTML injection\"</html_attr_value>></html_tag></injected_fragment><template_literal_placeholder_delimiters>${</template_literal_placeholder_delimiters><global_variable>globalVariable</global_variable><template_literal_placeholder_delimiters>}</template_literal_placeholder_delimiters><injected_fragment><html_tag></<html_tag_name>span</html_tag_name>></html_tag></injected_fragment>`;\n\n  static <keyword>get</keyword> <static_method>observedAttributes</static_method>() {\n    return [ 'data-test' ];\n  }\n\n  <instance_variable>#field</instance_variable> = { <instance_variable>prop</instance_variable>: 1 };\n\n  <instance_method>method</instance_method>() {\n    this.<instance_method>click</instance_method>();\n\n    <label>label</label>:\n      while (true) {\n        break <label>label</label>;\n      }\n  }\n}\n\nexport const <exported_variable>EXPORTED_VARIABLE</exported_variable> = 1;\nexport function <exported_function>exportedFunction</exported_function>() {}\nexport class <exported_class>ExportedClass</exported_class> {}\n\nconst <global_variable>globalVariable</global_variable> = \"chars\\n\\u11\";\n\nfunction JsxComponent() {\n  return <<jsx_client_component>JsxClientComponent</jsx_client_component> />;\n}\n\n<bad_character>W</bad_character>\n";
    }

    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return ADDITIONAL_HIGHLIGHT_DESCRIPTORS;
    }

    public DisplayPriority getPriority() {
        return PlatformUtils.isWebStorm() ? DisplayPriority.KEY_LANGUAGE_SETTINGS : DisplayPriority.LANGUAGE_SETTINGS;
    }

    public boolean isRainbowType(TextAttributesKey type2) {
        return JSHighlighter.JS_PARAMETER.equals((Object)type2) || JSHighlighter.JS_LOCAL_VARIABLE.equals((Object)type2) || JSHighlighter.JS_GLOBAL_VARIABLE.equals((Object)type2);
    }

    @Nullable
    public Language getLanguage() {
        return JavascriptLanguage.INSTANCE;
    }

    static {
        IGNORED_HIGHLIGHT_DESCRIPTORS = ImmutableSet.of((Object)JavaScriptHighlightDescriptor.TYPE_ALIAS, (Object)JavaScriptHighlightDescriptor.MODULE_NAME, (Object)JavaScriptHighlightDescriptor.PRIMITIVE_TYPE, (Object)JavaScriptHighlightDescriptor.INTERFACE);
        ArrayList<AttributesDescriptor> result2 = new ArrayList<AttributesDescriptor>();
        for (JavaScriptHighlightDescriptor value : JavaScriptHighlightDescriptor.values()) {
            if (IGNORED_HIGHLIGHT_DESCRIPTORS.contains(value)) continue;
            result2.add(new AttributesDescriptor(JavaScriptBundle.message(value.getMessageKey(), new Object[0]), value.getOrCreateTextAttributesKey()));
        }
        result2.add(new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.any.color.descriptor.injected.language.fragment", (Object[])new Object[0]), JSHighlighter.JS_INJECTED_LANGUAGE_FRAGMENT));
        ATTRS = result2.toArray(new AttributesDescriptor[0]);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS = new HashMap<String, TextAttributesKey>();
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("bad_character", JSHighlighter.JS_BAD_CHARACTER);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("keyword", JSHighlighter.JS_KEYWORD);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("local_variable", JSHighlighter.JS_LOCAL_VARIABLE);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("global_variable", JSHighlighter.JS_GLOBAL_VARIABLE);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("instance_variable", JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("static_field", JSHighlighter.JS_STATIC_MEMBER_VARIABLE);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("instance_method", JSHighlighter.JS_INSTANCE_MEMBER_FUNCTION);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("static_method", JSHighlighter.JS_STATIC_MEMBER_FUNCTION);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("global_function", JSHighlighter.JS_GLOBAL_FUNCTION);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("local_function", JSHighlighter.JS_LOCAL_FUNCTION);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("parameter", JSHighlighter.JS_PARAMETER);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("class_name", JSHighlighter.JS_CLASS);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("function_arrow", JSHighlighter.FUNCTION_ARROW);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("es6_decorator", JSHighlighter.ES6_DECORATOR);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("label", JSHighlighter.JS_LABEL);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("exported_function", JSHighlighter.JS_EXPORTED_FUNCTION);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("exported_variable", JSHighlighter.JS_EXPORTED_VARIABLE);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("exported_class", JSHighlighter.JS_EXPORTED_CLASS);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("injected_fragment", JSHighlighter.JS_INJECTED_LANGUAGE_FRAGMENT);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("html_tag", XmlHighlighterColors.HTML_TAG);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("html_tag_name", XmlHighlighterColors.HTML_TAG_NAME);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("html_attr_name", XmlHighlighterColors.HTML_ATTRIBUTE_NAME);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("html_attr_value", XmlHighlighterColors.HTML_ATTRIBUTE_VALUE);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("doc_tag", JSHighlighter.JS_DOC_TAG);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("doc_tag_namepath", JSHighlighter.JS_DOC_TAG_NAMEPATH);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("doc_type", JSHighlighter.JS_DOC_TYPE);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("jsx_client_component", JSHighlighter.JSX_CLIENT_COMPONENT);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("template_literal_placeholder_delimiters", JSHighlighter.JS_TEMPLATE_LITERAL_PLACEHOLDER_DELIMITERS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/highlighting/JavaScriptColorsAndFontsPage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDescriptors";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorDescriptors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

