/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.codeInsight.editorActions.TypedHandlerUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.editing.JavaScriptTypedHandler;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class JSBackspaceHandler
extends BackspaceHandlerDelegate {
    private boolean myToDeleteGt;
    private boolean myToDeleteGtInsideJsDoc;

    public void beforeCharDeleted(char c2, @NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            JSBackspaceHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JSBackspaceHandler.$$$reportNull$$$0(1);
        }
        if (c2 != '<' || !(file instanceof JSFile)) {
            this.myToDeleteGt = false;
            this.myToDeleteGtInsideJsDoc = false;
            return;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)file);
        this.myToDeleteGt = holder != null && holder.hasFeature(JSLanguageFeature.GENERICS) && JavaScriptTypedHandler.shouldMatchGenericBraces(editor, true);
        this.myToDeleteGtInsideJsDoc = !this.myToDeleteGt && JavaScriptTypedHandler.isWithinJSDoc(editor, true);
    }

    public boolean charDeleted(char c2, @NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            JSBackspaceHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            JSBackspaceHandler.$$$reportNull$$$0(3);
        }
        if (c2 == '<' && (this.myToDeleteGt || this.myToDeleteGtInsideJsDoc)) {
            int offset = editor.getCaretModel().getOffset();
            CharSequence chars = editor.getDocument().getCharsSequence();
            if (editor.getDocument().getTextLength() <= offset) {
                return false;
            }
            char c1 = chars.charAt(offset);
            if (c1 != '>') {
                return true;
            }
            if (this.myToDeleteGt) {
                TypedHandlerUtil.handleGenericLTDeletion((Editor)editor, (int)offset, (IElementType)JSTokenTypes.LT, (IElementType)JSTokenTypes.GT, (TokenSet)JavaScriptTypedHandler.Holder.INVALID_INSIDE_REFERENCE);
            } else {
                TypedHandlerUtil.handleGenericLTDeletion((Editor)editor, (int)offset, (IElementType)JSDocTokenTypes.DOC_LT, (IElementType)JSDocTokenTypes.DOC_GT, (TokenSet)JavaScriptTypedHandler.Holder.INVALID_INSIDE_JSDOC_GENERIC);
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSBackspaceHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCharDeleted";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "charDeleted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

