/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules.resolver;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.config.JSDirectFileReferenceResolver;
import com.intellij.lang.javascript.config.JSDirectFileReferenceResolverProvider;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSPathResolution;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSFileImportsResolverImpl;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSFileReferenceAltResolver;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSFileReferenceContext;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.typescript.modules.resolver.TypeScriptFileReferenceContext;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolver;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolverImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportsResolverProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSDefaultFileReferenceAltResolver
extends UserDataHolderBase
implements JSFileReferenceAltResolver {
    @NotNull
    private final PsiElement myHost;
    @NotNull
    private final JSFileReferenceContext myReferenceContext;
    @NotNull
    private final String myPath;

    @NotNull
    public static Collection<PsiElement> resolvePsiElements(@NotNull PsiElement host, @NotNull JSFileReferenceContext referenceContext, @NotNull String path2) {
        if (host == null) {
            JSDefaultFileReferenceAltResolver.$$$reportNull$$$0(0);
        }
        if (referenceContext == null) {
            JSDefaultFileReferenceAltResolver.$$$reportNull$$$0(1);
        }
        if (path2 == null) {
            JSDefaultFileReferenceAltResolver.$$$reportNull$$$0(2);
        }
        JSDefaultFileReferenceAltResolver resolver = new JSDefaultFileReferenceAltResolver(host, referenceContext, path2);
        JSPathResolution resolution = resolver.altResolve();
        List list2 = ContainerUtil.createMaybeSingletonList((Object)PsiUtilCore.findFileSystemItem((Project)host.getProject(), (VirtualFile)resolution.resolvedTarget()));
        if (list2 == null) {
            JSDefaultFileReferenceAltResolver.$$$reportNull$$$0(3);
        }
        return list2;
    }

    public JSDefaultFileReferenceAltResolver(@NotNull PsiElement host, @NotNull JSFileReferenceContext referenceContext, @NotNull String path2) {
        if (host == null) {
            JSDefaultFileReferenceAltResolver.$$$reportNull$$$0(4);
        }
        if (referenceContext == null) {
            JSDefaultFileReferenceAltResolver.$$$reportNull$$$0(5);
        }
        if (path2 == null) {
            JSDefaultFileReferenceAltResolver.$$$reportNull$$$0(6);
        }
        this.myHost = host;
        this.myReferenceContext = referenceContext;
        this.myPath = path2;
    }

    @Override
    @Nullable
    public JSPathResolution altResolveWithCache() {
        PsiFile file = this.getOriginalFile();
        if (file == null) {
            return null;
        }
        return (JSPathResolution)CachedValuesManager.getManager((Project)this.myHost.getProject()).getCachedValue((UserDataHolder)this, () -> CachedValueProvider.Result.create((Object)this.altResolve(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency(), VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS}));
    }

    @NotNull
    public JSPathResolution altResolve() {
        VirtualFile virtualFile;
        PsiFile file = this.getOriginalFile();
        VirtualFile virtualFile2 = virtualFile = file == null ? null : file.getVirtualFile();
        if (virtualFile == null) {
            JSPathResolution jSPathResolution = JSPathResolution.EMPTY;
            if (jSPathResolution == null) {
                JSDefaultFileReferenceAltResolver.$$$reportNull$$$0(7);
            }
            return jSPathResolution;
        }
        JSDirectFileReferenceResolver resolverProvider = JSDirectFileReferenceResolverProvider.find(this.myHost, this.myReferenceContext);
        if (resolverProvider != null) {
            JSPathResolution jSPathResolution = resolverProvider.resolveDirectFile(this.myPath, virtualFile);
            if (jSPathResolution == null) {
                JSDefaultFileReferenceAltResolver.$$$reportNull$$$0(8);
            }
            return jSPathResolution;
        }
        JSPathResolution jSPathResolution = DialectDetector.isTypeScript(this.myHost) ? this.calculateForTypeScript(virtualFile) : this.calculateForJavaScript(virtualFile);
        if (jSPathResolution == null) {
            JSDefaultFileReferenceAltResolver.$$$reportNull$$$0(9);
        }
        return jSPathResolution;
    }

    @Nullable
    private PsiFile getOriginalFile() {
        return JSResolveUtil.getOriginalFile(this.myHost);
    }

    @NotNull
    private JSPathResolution calculateForTypeScript(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            JSDefaultFileReferenceAltResolver.$$$reportNull$$$0(10);
        }
        JSDirectFileReferenceResolver resolver = this.getTypeScriptResolver(virtualFile);
        JSPathResolution jSPathResolution = resolver.resolveDirectFile(this.myPath, virtualFile);
        if (jSPathResolution == null) {
            JSDefaultFileReferenceAltResolver.$$$reportNull$$$0(11);
        }
        return jSPathResolution;
    }

    @NotNull
    private JSDirectFileReferenceResolver getTypeScriptResolver(@NotNull VirtualFile virtualFile) {
        TypeScriptFileImportsResolver importsResolver;
        if (virtualFile == null) {
            JSDefaultFileReferenceAltResolver.$$$reportNull$$$0(12);
        }
        if (this.myReferenceContext instanceof TypeScriptFileReferenceContext && (importsResolver = TypeScriptImportsResolverProvider.getResolver(this.myHost.getProject(), this.myReferenceContext, virtualFile)) instanceof JSDirectFileReferenceResolver) {
            JSDirectFileReferenceResolver jSDirectFileReferenceResolver = (JSDirectFileReferenceResolver)((Object)importsResolver);
            if (jSDirectFileReferenceResolver == null) {
                JSDefaultFileReferenceAltResolver.$$$reportNull$$$0(13);
            }
            return jSDirectFileReferenceResolver;
        }
        return new TypeScriptFileImportsResolverImpl(this.myHost.getProject(), this.myReferenceContext, this.myReferenceContext.getImplicitExtensions(), TypeScriptUtil.TYPESCRIPT_FILE_TYPES);
    }

    private JSPathResolution calculateForJavaScript(@NotNull VirtualFile file) {
        if (file == null) {
            JSDefaultFileReferenceAltResolver.$$$reportNull$$$0(14);
        }
        JSFileImportsResolverImpl resolver = new JSFileImportsResolverImpl(this.myHost.getProject(), this.myReferenceContext, this.myReferenceContext.getImplicitExtensions());
        return resolver.resolveDirectFile(this.myPath, file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 8, 9, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceContext";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/modules/resolver/JSDefaultFileReferenceAltResolver";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/modules/resolver/JSDefaultFileReferenceAltResolver";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePsiElements";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "altResolve";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateForTypeScript";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeScriptResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolvePsiElements";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calculateForTypeScript";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTypeScriptResolver";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "calculateForJavaScript";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 8, 9, 11, 13 -> new IllegalStateException(string);
        };
    }
}

