/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathBuilder;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathConfiguration;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathMappings;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitutionImpl;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H$J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J5\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J$\u0010\u001e\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0004J+\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\"\u00a8\u0006#"}, d2={"Lcom/intellij/lang/javascript/frameworks/modules/JSImportMapContributorBase;", "Lcom/intellij/lang/javascript/psi/resolve/JSModuleReferenceContributor;", "()V", "findImportMapFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "host", "Lcom/intellij/psi/PsiElement;", "getAdditionalDescriptors", "", "Lcom/intellij/lang/javascript/modules/imports/JSImportDescriptor;", "configuration", "Lcom/intellij/lang/ecmascript6/psi/impl/JSImportPathConfiguration;", "baseDescriptor", "getAllReferences", "", "Lcom/intellij/psi/PsiReference;", "unquotedEscapedText", "", "offset", "", "provider", "Lcom/intellij/psi/PsiReferenceProvider;", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;ILcom/intellij/psi/PsiReferenceProvider;)[Lcom/intellij/psi/PsiReference;", "isApplicable", "", "parseMap", "Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathMappings;", "Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathSubstitution;", "file", "Lcom/intellij/json/psi/JsonFile;", "readImportMap", "Lkotlin/Pair;", "resolveAsImportMap", "unquotedRefText", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;I)[Lcom/intellij/psi/PsiReference;", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSImportMapContributorBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSImportMapContributorBase.kt\ncom/intellij/lang/javascript/frameworks/modules/JSImportMapContributorBase\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,93:1\n26#2:94\n26#2:95\n26#2:96\n26#2:97\n*S KotlinDebug\n*F\n+ 1 JSImportMapContributorBase.kt\ncom/intellij/lang/javascript/frameworks/modules/JSImportMapContributorBase\n*L\n76#1:94\n77#1:95\n79#1:96\n90#1:97\n*E\n"})
public abstract class JSImportMapContributorBase
implements JSModuleReferenceContributor {
    @Override
    @NotNull
    public PsiReference[] getAllReferences(@NotNull String unquotedEscapedText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        Intrinsics.checkNotNullParameter((Object)unquotedEscapedText, (String)"unquotedEscapedText");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return this.resolveAsImportMap(unquotedEscapedText, host, offset);
    }

    @Override
    @NotNull
    public List<JSImportDescriptor> getAdditionalDescriptors(@NotNull JSImportPathConfiguration configuration, @NotNull JSImportDescriptor baseDescriptor) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)baseDescriptor, (String)"baseDescriptor");
        PsiElement psiElement = configuration.getPlace();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPlace(...)");
        Pair<JSModulePathMappings<JSModulePathSubstitution>, VirtualFile> pair = this.readImportMap(psiElement);
        if (pair == null) {
            return CollectionsKt.emptyList();
        }
        Pair<JSModulePathMappings<JSModulePathSubstitution>, VirtualFile> pair2 = pair;
        JSModulePathMappings pathSubstitutions = (JSModulePathMappings)pair2.component1();
        VirtualFile importMapFile = (VirtualFile)pair2.component2();
        if (pathSubstitutions.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        JSImportPathBuilder jSImportPathBuilder = JSImportPathBuilder.createBuilder(configuration);
        Intrinsics.checkNotNullExpressionValue((Object)jSImportPathBuilder, (String)"createBuilder(...)");
        JSImportPathBuilder builder2 = jSImportPathBuilder;
        List<JSImportDescriptor> list2 = builder2.getMappingsForBaseUrl(importMapFile.getParent(), (JSModulePathMappings<? extends JSModulePathSubstitution>)pathSubstitutions);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getMappingsForBaseUrl(...)");
        return list2;
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return this.findImportMapFile(host) != null;
    }

    @Nullable
    protected abstract VirtualFile findImportMapFile(@NotNull PsiElement var1);

    @Nullable
    protected final Pair<JSModulePathMappings<JSModulePathSubstitution>, VirtualFile> readImportMap(@NotNull PsiElement host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        VirtualFile virtualFile = this.findImportMapFile(host);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile importMapFile = virtualFile;
        VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile((PsiElement)host);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile3 = virtualFile2;
        PsiFile psiFile2 = host.getManager().findFile(importMapFile);
        JsonFile jsonFile = psiFile2 instanceof JsonFile ? (JsonFile)psiFile2 : null;
        if (jsonFile == null) {
            return null;
        }
        JsonFile jsonMap = jsonFile;
        return new Pair(CachedValuesManager.getCachedValue((PsiElement)((PsiElement)jsonMap), () -> JSImportMapContributorBase.readImportMap$lambda$0(this, jsonMap)), (Object)virtualFile3);
    }

    private final JSModulePathMappings<JSModulePathSubstitution> parseMap(JsonFile file) {
        JsonValue topLevelValue = file.getTopLevelValue();
        if (!(topLevelValue instanceof JsonObject)) {
            return JSModulePathMappings.Companion.empty();
        }
        JsonProperty jsonProperty = ((JsonObject)topLevelValue).findProperty("imports");
        if (jsonProperty == null || (jsonProperty = jsonProperty.getValue()) == null) {
            return JSModulePathMappings.Companion.empty();
        }
        JsonProperty importsValue = jsonProperty;
        if (!(importsValue instanceof JsonObject)) {
            return JSModulePathMappings.Companion.empty();
        }
        List result2 = new ArrayList();
        for (JsonProperty jsonProperty2 : ((JsonObject)importsValue).getPropertyList()) {
            String name;
            Intrinsics.checkNotNullExpressionValue((Object)jsonProperty2.getName(), (String)"getName(...)");
            JsonValue jsonValue = jsonProperty2.getValue();
            Object object = jsonValue instanceof JsonStringLiteral ? (JsonStringLiteral)jsonValue : null;
            if (object == null || (object = object.getValue()) == null) continue;
            Object value = object;
            result2.add(new JSModulePathSubstitutionImpl(name, (String)value){

                public boolean canStartWith() {
                    String string = this.getMappedName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMappedName(...)");
                    return StringsKt.endsWith$default((String)string, (String)"/", (boolean)false, (int)2, null);
                }
            });
        }
        return JSModulePathMappings.Companion.build(result2);
    }

    private final PsiReference[] resolveAsImportMap(String unquotedRefText, PsiElement host, int offset) {
        Pair<JSModulePathMappings<JSModulePathSubstitution>, VirtualFile> pair = this.readImportMap(host);
        if (pair == null) {
            boolean $i$f$emptyArray = false;
            return new PsiReference[0];
        }
        Pair<JSModulePathMappings<JSModulePathSubstitution>, VirtualFile> pair2 = pair;
        JSModulePathMappings substitutions = (JSModulePathMappings)pair2.component1();
        VirtualFile importMapFile = (VirtualFile)pair2.component2();
        if (substitutions.isEmpty()) {
            boolean $i$f$emptyArray = false;
            return new PsiReference[0];
        }
        Collection<String> collection = JSPathMappingsUtil.substituteMappings(unquotedRefText, substitutions);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"substituteMappings(...)");
        String string = (String)CollectionsKt.firstOrNull((Iterable)collection);
        if (string == null) {
            boolean $i$f$emptyArray = false;
            return new PsiReference[0];
        }
        String exactPath = string;
        if (!Intrinsics.areEqual((Object)exactPath, (Object)unquotedRefText)) {
            String $i$f$emptyArray = JSPathMappingsUtil.getStringPathRelativeBaseUrlOrSelfIfAbsolute(importMapFile.getParent(), exactPath);
            if ($i$f$emptyArray == null) {
                Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiReference.EMPTY_ARRAY;
            }
            String file = $i$f$emptyArray;
            TextRange textRange2 = TextRange.create((int)offset, (int)(offset + unquotedRefText.length()));
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"create(...)");
            TextRange range = textRange2;
            PsiReference[] psiReferenceArray = new PsiReference[1];
            List list2 = CollectionsKt.listOf((Object)file);
            psiReferenceArray[0] = new JSExactFileReference(host, range, list2){

                public int getWeight() {
                    return JSModuleBaseReference.ModuleTypes.PATH_MAPPING.weight();
                }
            };
            return psiReferenceArray;
        }
        boolean $i$f$emptyArray = false;
        return new PsiReference[0];
    }

    private static final CachedValueProvider.Result readImportMap$lambda$0(JSImportMapContributorBase this$0, JsonFile $jsonMap) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$jsonMap, (String)"$jsonMap");
        Object[] objectArray = new Object[]{$jsonMap};
        return new CachedValueProvider.Result(this$0.parseMap($jsonMap), objectArray);
    }
}

